<?php
namespace Claromentis\Core\Ai\Adapters\Vertex;

$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"] = (@$GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"] ?: array()) + array("_db618ca8e" . "79f97b4dff" . "753ec83794" . "2cf" => base64_decode("cHJvam" . "VjdF9p" . "ZA=="), "_7681c2a2b7e1bdf69c23" . "c6cd64114ad3" => base64_decode("anNvbl9kZWN" . "vZGU="), "_63a6ec2f20440285232bed955be332" . "66" => base64_decode("c3RyZWF" . "tR2VuZX" . "JhdGVDb" . "250ZW50"), "_3e258c4e6163007d" . "8094c39647602e7a" => base64_decode("aGVhZGVycw=" . "="), "_043583fc6e" . "4063be6ec4a" . "31bf951616c" => base64_decode("L3Byb2pl" . "Y3RzLw=="), "_38021ae38952751baca9f63ac2bf723" . "b" => base64_decode("LWFpcGxhdGZvcm0uZ29vZ2xlYXBpcy5jb20" . "vdjE="), "_7c819f403b31525f384e" . "33c0142be9f4" => base64_decode("L3B1Ymxpc" . "2hlcnMvZ2" . "9vZ2xlL21" . "vZGVscy8="), "_1cc5aa2f679" . "b575f82786a7" . "3f0da28f8" => base64_decode("c3Ry" . "ZWFt"), "_86e718deafc5b7c86aa6" . "3799a9e024d0" => base64_decode("aHR0cHM6" . "Ly8="), "_b673c9549489ba1916c266f60" . "dc846a8" => base64_decode("cHJlZGl" . "jdA=="), "_f24852a7b2e" . "8c180d1f7ab2" . "16c8e8222" => base64_decode("QmVhcmV" . "yIA=="), "_bef1236f88db6b34bcb87" . "8fe48142cb6" => base64_decode("aHR0cF9lcnJvcnM" . "="), "_e9181de682eebf636bae051269" . "5b2a95" => base64_decode("QXV0aG9yaXphdGlv" . "bg=="), "_e2cad529b5b2b" . "661032342010c4" . "96554" => base64_decode("L2xvY2F0aW9u" . "cy8="), "_67a3498b1e8fe53ddf3" . "9e400a59bc91f" => base64_decode("cmVnaW9u" . "X25hbWU="), "_29225c3f2cb4b5bb8c" . "dfecad11c6f491" => base64_decode("Og=" . "="), "_8ec8f26c742278f90615f50d68" . "2eea79" => base64_decode("UE" . "9T" . "VA" . "=="), "_6ee75f9f44b14f240" . "fc54f3e19e7084a" => base64_decode("UmVjZWl2ZWQgYW4gdW5leHBlY3RlZCBlcnJvciBmcm9tIHRoZSB" . "zZXJ2ZXI="), "_0cb031e3c" . "d6ff0075d3" . "bccfcfdb99" . "9a6" => base64_decode("LCBjb" . "250ZW" . "50OiA" . "="), "_7215c118ad8698" . "3602db0b431cb9a" . "1e9" => base64_decode("Z2VuZXJh" . "dGVDb250" . "ZW50"), "_47ee521cf79c60b97cda9ecd9c595" . "c95" => base64_decode("U2VydmVyIHJldHVybmVkIGFuIHVuZXhwZWN0ZWQgcmVzcG9uc2UuIEh" . "UVFAgY29kZTog"));
use Claromentis\Core\Ai\Adapters\Vertex\Requests\Image\VertexAiImageRequest;
use Claromentis\Core\Ai\Adapters\Vertex\Requests\Text\VertexAiTextRequest;
use Claromentis\Core\Ai\Adapters\Vertex\Requests\VertexAiClientAuthentication;
use Claromentis\Core\Ai\Adapters\Vertex\Responses\Image\VertexAiGenerateImageResponse;
use Claromentis\Core\Ai\Adapters\Vertex\Responses\Text\VertexAiGenerateTextResponse;
use Claromentis\Core\Ai\Exceptions\AiException;
use Claromentis\Core\Ai\Exceptions\AiInvalidRequestException;
use Claromentis\Core\Ai\Exceptions\AiServerResponseException;
use Claromentis\Core\Ai\Exceptions\VertexAiPromptException;
use Claromentis\Core\Ai\JsonParser;
use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\RequestOptions;
use GuzzleHttp\Stream\StreamInterface;
use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Psr\Log\LoggerInterface;
use Psr\Log\NullLogger;
use Symfony\Component\HttpFoundation\Response;






class VertexAiClient implements LoggerAwareInterface
{
    use LoggerAwareTrait;
    
    
    
    
    
    
    
    
    
    public const ERROR_INVALID_ARGUMENT = Response::HTTP_BAD_REQUEST;
    public const ERROR_UNAUTHENTICATED = Response::HTTP_UNAUTHORIZED;
    public const ERROR_PERMISSION_DENIED = Response::HTTP_FORBIDDEN;
    public const ERROR_NOT_FOUND = Response::HTTP_NOT_FOUND;
    public const ERROR_RESOURCE_EXHAUSTED = Response::HTTP_TOO_MANY_REQUESTS;
    public const ERROR_CANCELLED = 499;
    
    
    public const ERROR_INTERNAL_ERROR = Response::HTTP_INTERNAL_SERVER_ERROR;
    public const ERROR_UNAVAILABLE = Response::HTTP_SERVICE_UNAVAILABLE;
    public const ERROR_DEADLINE_EXCEEDED = Response::HTTP_GATEWAY_TIMEOUT;
    
    
    
    
    private string $projectId;
    
    
    
    
    private string $regionName;
    
    
    
    
    private string $modelName;
    
    
    
    
    private VertexAiClientAuthentication $authentication;
    
    
    
    
    private ClientInterface $client;
    
    
    
    
    
    
    
    
    
    public function __construct(VertexAiClientAuthentication $_961ccc1b377e30c70011809b405b9c07, array $config, LoggerInterface $logger = null, ClientInterface $_2f664bcc4a0a32ffda2885fb12940265 = null)
    {
        $this->projectId = $config[$GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_db618ca8e" . "79f97b4dff" . "753ec83794" . "2cf"]];
        $this->regionName = $config[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_67a3498b1e8fe53ddf39e40" . "0a59bc91f"]];
        $this->authentication = $_961ccc1b377e30c70011809b405b9c07;
        $this->logger = $logger ?? new NullLogger();
        $this->client = $_2f664bcc4a0a32ffda2885fb12940265 ?? new Client();
    }
    
    
    
    
    
    
    
    
    
    
    public function handleGenerateTextRequest(VertexAiTextRequest $request, callable $_5c51b0e4b7267b43adabf8015a8e1cf8 = null)
    {
        
        
        $this->modelName = $request->getModelName();
        $_f4bd77b9d7574792bd46db73586ce19d = $request->serialize();
        if ($request->isStreaming()) {
            $this->generateTextStream($_f4bd77b9d7574792bd46db73586ce19d, $_5c51b0e4b7267b43adabf8015a8e1cf8);
            return;
        }
        return $this->generateText($_f4bd77b9d7574792bd46db73586ce19d);
    }
    
    
    
    
    
    
    
    
    
    public function handleGenerateImageRequest(VertexAiImageRequest $request)
    {
        
        
        
        $this->modelName = $request->getModelName();
        $_f4bd77b9d7574792bd46db73586ce19d = $request->serialize();
        return $this->generateImages($_f4bd77b9d7574792bd46db73586ce19d);
    }
    
    
    
    
    
    
    
    private function generateText(array $data) : VertexAiGenerateTextResponse
    {
        $_3bf6f785d3520dfd17a871d18d745880 = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_7215c118ad86983602db0b43" . "1cb9a1e9"];
        $_c927258f5322288a992c77be40ae0b53 = $this->buildURL($_3bf6f785d3520dfd17a871d18d745880);
        return VertexAiGenerateTextResponse::fromArray($GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_7681c2a2b7e1bdf69c23c6cd64" . "114ad3"]($this->send($_c927258f5322288a992c77be40ae0b53, $data), true), $this->modelName);
    }
    
    
    
    
    
    
    
    private function generateImages(array $data) : VertexAiGenerateImageResponse
    {
        $_3bf6f785d3520dfd17a871d18d745880 = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_b673c9549489ba1916c266" . "f60dc846a8"];
        $_c927258f5322288a992c77be40ae0b53 = $this->buildURL($_3bf6f785d3520dfd17a871d18d745880);
        return VertexAiGenerateImageResponse::fromArray($GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_7681c2a2b7" . "e1bdf69c23c" . "6cd64114ad3"]($this->send($_c927258f5322288a992c77be40ae0b53, $data), true));
    }
    
    
    
    
    
    
    
    public function buildURL(string $_3bf6f785d3520dfd17a871d18d745880) : string
    {
        return $GLOBALS["__65da1b1ec2" . "d6653e8a0ab7" . "848e536215"]["_86e718deafc5b7c" . "86aa63799a9e024d" . "0"] . $this->regionName . $GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_38021ae38952751baca9" . "f63ac2bf723b"] . $GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_043583fc6e4063be6ec" . "4a31bf951616c"] . $this->projectId . $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_e2cad529b5b2b661032342010c49655" . "4"] . $this->regionName . $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_7c819f403b31525" . "f384e33c0142be9f" . "4"] . $this->modelName . ($GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_29225c3f2cb4b5b" . "b8cdfecad11c6f49" . "1"] . $_3bf6f785d3520dfd17a871d18d745880);
    }
    
    
    
    
    
    
    
    
    
    
    
    private function send(string $_c927258f5322288a992c77be40ae0b53, array $data, bool $_1cc5aa2f679b575f82786a73f0da28f8 = false)
    {
        $_fd5a3a643834299cbdadfc3540ba0bcb = $this->client->request($GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_8ec8f26c" . "742278f90" . "615f50d68" . "2eea79"], $_c927258f5322288a992c77be40ae0b53, [RequestOptions::JSON => $data, $GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_1cc5aa2f679b575f" . "82786a73f0da28f8"] => $_1cc5aa2f679b575f82786a73f0da28f8, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e" . "536215"]["_bef1236f88db6b" . "34bcb878fe48142" . "cb6"] => false, $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_3e258c4e6163007" . "d8094c39647602e7" . "a"] => [$GLOBALS["__65da1b1ec2d6653e8a0ab7848e53" . "6215"]["_e9181de682eebf636bae0512" . "695b2a95"] => $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_f24852a7b2e8c180d1f7ab216c8e82" . "22"] . $this->authentication->getAccessToken()]]);
        $this->checkResponse($_fd5a3a643834299cbdadfc3540ba0bcb);
        return $_fd5a3a643834299cbdadfc3540ba0bcb->getBody();
    }
    
    
    
    
    
    
    
    
    private function generateTextStream(array $data, callable $_5c51b0e4b7267b43adabf8015a8e1cf8) : void
    {
        $_3bf6f785d3520dfd17a871d18d745880 = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_63a6ec2f20440285232bed955be3326" . "6"];
        $_c927258f5322288a992c77be40ae0b53 = $this->buildURL($_3bf6f785d3520dfd17a871d18d745880);
        $_1cc5aa2f679b575f82786a73f0da28f8 = $this->send($_c927258f5322288a992c77be40ae0b53, $data, true);
        $_c37f5d387ecde7a206c24852e173b2fe = new JsonParser(function (array $_fd62bc4eaaf7d58dea9bada3e30443b9) use($_5c51b0e4b7267b43adabf8015a8e1cf8) {
            $_5c51b0e4b7267b43adabf8015a8e1cf8(VertexAiGenerateTextResponse::fromArray($_fd62bc4eaaf7d58dea9bada3e30443b9, $this->modelName));
        });
        while (!$_1cc5aa2f679b575f82786a73f0da28f8->eof()) {
            $_c37f5d387ecde7a206c24852e173b2fe->consume($_1cc5aa2f679b575f82786a73f0da28f8->Read(1024));
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    
    private function checkResponse(\Psr\Http\Message\ResponseInterface $_fd5a3a643834299cbdadfc3540ba0bcb)
    {
        switch ($_fd5a3a643834299cbdadfc3540ba0bcb->getStatusCode()) {
            
            
            
            case self::ERROR_UNAUTHENTICATED:
            case self::ERROR_PERMISSION_DENIED:
                throw AiException::invalidCredentials();
            case self::ERROR_INVALID_ARGUMENT:
                throw new AiInvalidRequestException();
            case self::ERROR_NOT_FOUND:
            case self::ERROR_RESOURCE_EXHAUSTED:
            case self::ERROR_CANCELLED:
            case self::ERROR_DEADLINE_EXCEEDED:
            case self::ERROR_INTERNAL_ERROR:
            case self::ERROR_UNAVAILABLE:
                $this->logger->error($GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_47ee521cf79c60b97cda9ec" . "d9c595c95"] . $_fd5a3a643834299cbdadfc3540ba0bcb->getStatusCode() . $GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_0cb031e3cd6ff0" . "075d3bccfcfdb99" . "9a6"] . $_fd5a3a643834299cbdadfc3540ba0bcb->getBody());
                throw new AiServerResponseException($GLOBALS["__65da1b1ec2d6653e8a" . "0ab7848e536215"]["_6ee75f9f44b14" . "f240fc54f3e19e" . "7084a"], $_fd5a3a643834299cbdadfc3540ba0bcb->getStatusCode());
        }
    }
}