// ==============================================================================================

var StdNavigationView = Backbone.View.extend({
	checked_out_collection: null,
	drafts_collection: null,
	trashcan_collection: null,
	docs_list_state: null,

	render: function ()
	{
		//$('#addDocument input[name=fid]').val(this.docs_list_state.get('folder_id'));

		if (this.docs_list_state.get('folder_id') !== null)
			$('#all_docs_link').attr('href', '#list/' + this.docs_list_state.get('folder_id'));
		else
			$('#all_docs_link').attr('href', '#list');

		if (this.checked_out_collection && this.checked_out_collection.is_loaded && this.checked_out_collection.length > 0)
		{
			$('#checked_out_count').text(this.checked_out_collection.length).removeClass('invisible');
		} else
		{
			$('#checked_out_count').addClass('invisible');
		}

		if (this.drafts_collection && this.drafts_collection.is_loaded && this.drafts_collection.length > 0)
		{
			$('#drafts_count').text(this.drafts_collection.length).removeClass('invisible');
		} else
		{
			$('#drafts_count').addClass('invisible');
		}

		if (this.trashcan_collection && this.trashcan_collection.is_loaded && this.trashcan_collection.length > 0)
		{
			$('#trashcan_count').text(this.trashcan_collection.length).removeClass('invisible');
		} else
		{
			$('#trashcan_count').addClass('invisible');
		}
	},

	setDocsListStateModel: function (docs_list_state)
	{
		this.docs_list_state = docs_list_state;
		docs_list_state.bind('change', this.render, this);
	},

	setCheckedOutCollection: function (checked_out)
	{
		this.checked_out_collection = checked_out;
		checked_out.bind('reset', this.render, this);
		checked_out.bind('change', this.render, this);
		checked_out.bind('add', this.render, this);
		checked_out.bind('remove', this.render, this);
	},

	setDraftsCollection: function (drafts)
	{
		this.drafts_collection = drafts;
		drafts.bind('reset', this.render, this);
		drafts.bind('change', this.render, this);
		drafts.bind('add', this.render, this);
		drafts.bind('remove', this.render, this);
	},

	setTrashCanCollection: function (trash_can)
	{
		this.trashcan_collection = trash_can;
		trash_can.bind('reset', this.render, this);
		trash_can.bind('change', this.render, this);
		trash_can.bind('add', this.render, this);
		trash_can.bind('remove', this.render, this);
	}

});