(function() {

	if (!smart_news_list.name) {
		smart_news_list.name="smart_news_list";
	}

	if (!smart_news_list.scrolling) {
		smart_news_list.scrolling = "auto";
	}

	if (!smart_news_list.columns) {
		smart_news_list.columns = 'image,title,channel,owner,date,text';
	}

	if (!smart_news_list.link_target) {
		smart_news_list.link_target = "_blank";
	}

	if (!smart_news_list.page_size) {
		smart_news_list.page_size = 10;
	}

	if (!smart_news_list.text_character_count) {
		smart_news_list.text_character_count = 0;
	}


	// Using an iframe
	if(smart_news_list.use_iframe) {
		// set default width
		if(!smart_news_list.width) {
			smart_news_list.width = '100%';
		}

		// set default width
		if(!smart_news_list.height) {
			smart_news_list.height = '400';
		}

		// default template
		if (!smart_news_list.template) {
	        smart_news_list.template = "news/news_list.html";
		}
	} else {
		// inline element
		// default template
		if (!smart_news_list.template) {
			smart_news_list.template = "news/news_list_dom.html";
		}
	}

	if (!smart_news_list.channels) {
		smart_news_list.channels = 0;
	}

	if (!smart_news_list.tags) {
		smart_news_list.tags = '';
	}

	if (!smart_news_list.css_main_table) {
		smart_news_list.css_main_table = "news-list";
	}

	if (!smart_news_list.css_paging_table) {
		smart_news_list.css_paging_table = "pagination";
	}

	if ((typeof smart_news_list.show_paging == 'undefined') || smart_news_list.show_paging === '') {
		smart_news_list.show_paging = 1;
	}

	if ((typeof smart_news_list.show_subscribed == 'undefined') || smart_news_list.show_subscribed === '') {
		smart_news_list.show_subscribed = (smart_news_list.channels ? 0 : 1);
	}

	if (!smart_news_list.current_page) {
		smart_news_list.current_page = 0;
	}

	if (document.getElementById(smart_news_list.name)) {
		smart_news_list.name = smart_news_list.name + Math.floor(Math.random()*101);
	}

	smart_news_list.uri = "/intranet/news/news_list.php";
	smart_news_list.uri += "?columns=" + smart_news_list.columns;
	smart_news_list.uri += "&name=" + smart_news_list.name;
	smart_news_list.uri += "&link_target=" + smart_news_list.link_target;
	smart_news_list.uri += "&page_size=" + smart_news_list.page_size;
	smart_news_list.uri += "&css_main_table=" + smart_news_list.css_main_table;
	smart_news_list.uri += "&css_paging_table=" + smart_news_list.css_paging_table;
	smart_news_list.uri += "&text_character_count=" + smart_news_list.text_character_count;
	smart_news_list.uri += "&channels=" + smart_news_list.channels;
	smart_news_list.uri += "&tags=" + smart_news_list.tags;
	smart_news_list.uri += "&template=" + smart_news_list.template;
	smart_news_list.uri += "&show_paging=" + smart_news_list.show_paging;
	smart_news_list.uri += "&current_page=" + smart_news_list.current_page;
	smart_news_list.uri += "&show_subscribed=" + smart_news_list.show_subscribed;
	smart_news_list.uri += "&use_iframe=" + (smart_news_list.use_iframe ? "1" : "0");

	// create and attach News container to page
	createNews();

	// create the initial container elements for news
	function createNews() {
		document.write('<div id="'+smart_news_list.name+'" class="smart-news"></div>');

		// render iframe or inline
		if(smart_news_list.use_iframe) {
			renderIframe();
		} else {
			renderInline();
		}
	}

	// render news as an iframs
	function renderIframe() {
		var iframe = document.createElement('iframe');
		iframe.setAttribute('src', smart_news_list.uri);
		iframe.setAttribute('width', smart_news_list.width);
		iframe.setAttribute('height', smart_news_list.height);
		iframe.setAttribute('frameborder', 0);
		iframe.setAttribute('scrolling', smart_news_list.scrolling);
		iframe.setAttribute('name', smart_news_list.name);

		document.getElementById(smart_news_list.name).appendChild(iframe);
	}

	// render news as an inline element (uses ajax)
	function renderInline() {
		// if displaying inline and providing a height
		// render fixed height container with scrollbar
		if(smart_news_list.height) {
			jQuery('#' + smart_news_list.name).css({'max-height' : smart_news_list.height, 'overflow' : 'auto'})
		}

		// initial page load via ajax
		loadPage(smart_news_list.uri, smart_news_list.name);
	}

	// load news via ajax
	function loadPage(url, elem){
		jQuery(document.getElementById(elem)).load(url);
	}

	// ajax request for pagination
	function newsPaging () {
		var smart_news = jQuery(this).parents('.smart-news').attr('id');
		loadPage( jQuery(this).attr('href'), smart_news);
		return false;
	}

	// pagination binding
	jQuery('body').on('click', '.smart-news .pagination a', newsPaging);
})();