# Claromentis Core Change Log

## Unreleased

### Bug fixes

- !1513 BT-4472 Fixed button colour inconsistency on Projects tasks modal
- !1515 BT-4511 BT-4548 Disco 044711 Fixed an issue where breadcrumbs were not clickable in Pages, Comments permalinks, and some other applications
- !1529 HOLS-21 Fixed year selection toggle so it displays under My Requests tab in Holiday Planner
- !1537 BT-4591 Fixed issue where login and guest pages could use the wrong theme

## 9.0.17 - 1st March 2024 

### Improvements

- !1511 UIUX-872 Edit Theme button is now easier to locate
- !1505 BT-4454 Created a new People profile page hook in order to relocate the Badges section

### Bug fixes

- !1510 BT-4500 Fixed People profile overflow issue by wrapping long email addresses and adjusting profile grid columns

### Developer notes

- !1505 BT-4454 Added a new `viewprofile.secondary` page hook to the People profile page for `ClaPlugins`
- Merged upstream improvements and bugfixes from 8.13.41

## 9.0.16 - 8th February 2024

### Improvements

- !1334 NEWS-3 Added a subscribed filter for News Channels

### Bug fixes

- !1506 BT-4499 Removed redundant "Click here to create" link for "Permissions for editing fields" in People admin

### Developer notes

- Merged upstream improvements and bugfixes from 8.13.40

## 9.0.15 - 12th January 2024

### Bug fixes

- !1486 BT-4304 Fixed padding issue within Menu builder

### Developer notes

- Merged upstream improvements and bugfixes from 8.13.39 

## 9.0.14 - 7th December 2023

### Improvements

- !1465 FRAM-783 Added `X-Content-Type-Options` header when downloading files across the system
- !1482 UIUX-862 Improved semantic heading title in Pages breadcrumb

### Bug fixes

- !1489 BT-2831 Fixed time picker alignment issue within Blog
- !1488 BT-3154 Fixed Org Chart preview not displaying

## 9.0.14 - 7th December 2023

### Bug fixes

- !1466 BT-3950 Fixed alignment issue within InfoCapture file form fields
- !1468 BT-4231 Fixed white space gap in CKEditor Text Pages component
- !1470 BT-4328 Fixed drafts dropdown menu display in Documents
- 900ed9c2 FRAM-945 Disco 043552 Fixed inconsistent module installations in cloud environments with data volumes backed by NFS storage
- !1471 BT-4363 Fixed date/time table alignment within Sysadmin
- !1476 BT-4356 Fixed InfoCapture issue where multiple checkbox field with 'Label above input field' incorrectly displayed inputs horizontally
- !1479 Fixed issues with the News index page first article
  - NEWS-10 Reduced max-width of article image to improve display of article description
  - NEWS-11 Removed metadata from article details

### Developer notes

- 900ed9c2 FRAM-945 Disco 043552 Ensured cached writes for `data/config/plugins.json`, not just for reads

## 9.0.13 - 24th November 2023

### Bug fixes

- !1460 EVNT-62 Fixed the date picker field alignment issue when creating new event in Events
- a01a9125 BT-4368 Disco 043662 Fixed fatal invalid template error for Gallery Album Add/Edit page

## 9.0.12 - 10th November 2023

### Improvements

- !1425 LCIP-22 LCIP-23 Core compatibility for Custom Login Handler

### Bug fixes

- !1440 BT-4267 Fixed dropdown arrow placement in Documents
- !1449 BT-3561 Fixed InfoCapture project icon picker grid layout issue

### Developer notes

- Merged upstream improvements and bugfixes from 8.13.36

## 9.0.11 - 27th October 2023

### Improvements

- !1443 IC-123 Disco 043278 Reordered InfoCapture 'View ticket' tabs for improved usability (v9)
- !1456 FRAM-797 Removed Bootstrap 3 upgrader tool

### Bug fixes

- !1438 BT-4173 Disco 042422 Fixed query parsing for values with brackets and colons in people search
- !1445 UIUX-862 Improved semantic heading style in News and Blog
- !1451 BT-4313 Disco 043440 Fixed Room Booking popup appearing behind backdrop
- !1454 BT-4318 Fixed Room Booking popup placement
- !1455 BT-4320 Disco 043468 Fixed browser caching issue in Documents when downloading the latest version of a document

### Developer notes

- Merged upstream improvements and bug fixes from 8.13.35

## 9.0.10 - 18th October 2023

### Bug fixes

- !1439 BT-4157 Fixed help text appearing when full descriptions are added to InfoCapture projects.
- !1421 BT-3975 Improved styling and changed arrows within Gallery under metadata options
- !1416 BT-3979 Fixed alignment issues with the check out menu in Documents
- !1435 BT-4240 Fixed an alignment issue with Calendar popup modal

### Improvements

- !1446 IC-119 Modified download PDF button in Infocapture tickets

### Developer notes

- !1444 Merged upstream changes from 8.13.34
    - Reapplied database migration for FRAM-813 Password recovery refactor
    - Reapplied database migration for FRAM-935 Stats performance improvements

### Developer notes

 - !1425 LCIP-22 adds two backwards-compatible methods to improve the DirectoriesList class:
 	- `GetAllEnabled` will return an array containing the configs of all valid and enabled user directories that are registered
 	- `DirectoriesAreInUse` will return a boolean that is true if there are any valid and enabled user directories

## 9.0.9 - 7th September 2023

### Bug fixes

- !1384 BT-4137 Disco 042165 Fixed HTML formatting issues for multipart messages sent by the native PHP mail driver
  - FRAM-189 Fixed a client-side error that prevented the "Send notification" button from enabling properly in **Admin > System > Labs**
  - Minor design & UX improvements for **Admin > System > Mail**
- !1404 BT-3965 Fixed an alignment issue on people panel in Admin
- !1405 BT-3616 Fixed an alignment issue with the Calendar delete button
- !1406 BT-4132 Fixed Admin tags delete button alignment issue
- !1407 BT-4174 Prevented folder title from a line drop in Documents
- !1408 BT-4197 Disco 042533 Fixed an error in Document Workflow during sending an email
- !1413 BT-4235 Fixed Common holidays table display in Holidays Admin
- !1414 BT-3974 Fixed alignment issue in Admin on mobiles
- !1418 BT-2831 Fixed alignment issue with time picker in Blog
- Merged upstream bug fixes from 8.13.32, 8.13.33

### Developer notes

- !1384 BT-4137 Disco 042165 Fixed the PHP `mail()` driver's support for multipart HTML/plaintext messages
  - Set the default value of `cfg_mail_send_params['sendgrid_host']` to `'default'`
  - Improved mail configuration documentation

## 9.0.8 - 15th August 2023

### Bug fixes

- !1391 BT-4039 Modified side menu icon alignment when clicked
- !1392 BT-4045 Modified calendar label alignment within "Link to this page" option.
- Merged upstream bugfixes from 8.13.31

## 9.0.7 - 24th July 2023

### Improvements

- !1358 DMS-19 Changed the size of the document preview window and added a full-screen preview

### Bug fixes

- !1389 BT-4080 Fixed an error in Holiday planner when user was clicked on the Manager diagram button
- Merged upstream bug fixes from 8.13.30

## 9.0.6 - 18th July 2023

- Merged upstream changes from 8.13.29

### Bug fixes

- !1379 BT-3930 Fixed InfoCapture Multiple select field minimum width issue

## 9.0.5 - 19th June 2023

### Improvements

- !1370 BT-4079 Changed the comments sort order to show the newest comments first in the Blog, News, and Gallery applications

### Bug fixes

- !1356 BT-4040 Design panel: Fixed an error that occurred when some special characters were used in page titles for the Master Design or Themes and limited page titles length to maximum of 255 characters
- !1366 BT-3925 Protected the Core bootstrap process from running more than once per request
- !1367 BT-4034 Fixed navbar search text overflow issue
- !1372 BT-4082 Various button and form field display fixes
  - BT-4077 BT-4070 Fixed browse button alignment Comments document upload
  - BT-4064 IC ticket list advanced search button display improvement
  - BT-4055 Fixed admin tags search buttons display on tablet/mobile devices
  - BT-4054 Updated add/delete tags translation to fix display issue
  - BT-3723 Fixed alignment issue in Admin-Common holidays on mobile devices with buttons
  - BT-3906 Fixed export button alignment in Documents audit log on mobile
  - BT-3622 Fixed issue with delete button on mobile
  - BT-3780 Fixed 'Add rule for this field' button display on mobile

### Developer notes

- !1361 PAGES-42 Added unique `alert-sm` CSS class for small alerts

## 9.0.4 - 10th May 2023

- Merged upstream changes from 8.13.26

### Improvements

- !1318 IC-81 Disco 039205 Added the issue headers to the PDF files generated for InfoCapture issues

### Bug fixes

- !1343 BT-3515 Added Generic icon for non-standard file format in What's New component
- !1346 UIUX-848 Improved Single User/Group/Role/Extranet picker width and alignment styling
- !1337 BT-3978 Fixed design issue for InfoCapture project deletion
- !1331 BT-3944 Fixed dismissible help text for InfoCapture project admin panels
- a99b5629 BT-4037 Fixed export Calendar 'Create URL' display issues

## 9.0.3 - 14th April 2023

### Features

- !1327 BT-3863 Added edit button to the image in people profile page
- Merged forward changes from 8.13.23, 8.13.24, 8.13.25

### Improvements

- !1307 BLOG-8 Improved/updated Blog list layout on Main page
- !1301 BLOG-1 Added a new permission for creating blog channels

### Bug fixes

- !1289 BT-3861 BT-3875 Fixed modal backdrop issue
- !1291 BT-3901 Fix fatal error when requesting emailed details of a calendar event
- !1304 BT-3914 Fixed various form fields display on mobile, tablet and desktop
- 32f79c1f BT-3971 Fix for Documents dashboard and clipboard display
- c77dcfe7 BT-3969 Fix for clipboard copy/move/link overflow issue
- 8a2291e2 BT-3970 Fix for Documents clipboard overflow with long name
- !1329 BT-3903 Design fixes for LDAP panel
- !1340 BT-3934 Restored manage/edit bookmarks on mobile view
- !1344 BT-4005 Restored edit company links on mobile view


## 9.0.2 - 15th February 2023

### Improvements

- !1256 PPL-51 Added telephone and email display types to metadata strings
- !1297 BLOG-3 Added author's avatar for articles
- !1270 HOLS-4 Added a day part attribute to the notifications section for new holiday requests and on the holiday request details page
- 128a8924 Updated list group border colour variable
- !1308 PPL-61 Disabled searching for blocked user in HR mode
- !1310 OC-17 Made Orgchart vertical level display configurable


### Bug fixes

- !1274 BOOTY-616 Further final Core feedback and design fixes
  - BOOTY-619 Fixed issue with random blue background on Login screen which displays when scrolled on Safari
  - BOOTY-620 Updated 'About' page to reflect the structure of the company and technology used
  - BT-3822 Fixed issue with the 'All' checkbox in Documents list hovering on mobiles and tablets
  - BOOTY-621 Fixed issue with vertical alignment of Comments header icon in universal comments widget
  - BT-3839 Fixed issue in admin 'Installed Modules' table so it has a more compact design
  - BT-3767 Fixed issue on admin page where permissions info dropdown doesn't display due to universal breadcrumb change
  - BT-3819 Fixed minor issues with IC notification template 'body' text not wrapping lines correctly when no subject is present
  - BOOTY-622 Issue with IC notifications where 'HTML' and 'Text' input types are swapped round
  - BT-3785 Fixed issue with LDAP search tool code section not displaying correctly
  - BT-3627 Fixed odd alignment of comment enable/disable controls and save button in News admin
  - BOOTY-623 Fixed issue in documents where the checked-out section is touching the drafts section due to lack of margin
  - BT-3658 Fixed issue with user-selector in People admin being too short when re-assigning deleted users items
  - BT-3825 Fixed issue with documents field in Infocapture having lots of random white space and not laying correctly on small devices
  - BT-3859 Fixed issue with 'CommonListAjaxPaging' component being duplicated when users change the sorting of common list tables
  - BT-3864 Fixed incorrect background in the popup when editing selectable users for a multiple-user select field
- 2baa67c7 BT-3915 Fixed IC filter dropdown overflow issue on mobile
- 397441fe BT-3788 Fixed user picker width in Documents advanced search
- 7abedbb3 BT-3928 Fixed Bookmarks and Company links tooltip display

### Merged forward from 8.12.28, 8.13.22

#### Improvements

- !1285 BT-3867 Prevented archived InfoCapture issues from being indexed for Global Search
- !1302 BT-3884 Changed CKEditor table default settings to match Bootstrap style
- eee046d8 Improved theme resilience to incorrectly migrated style data
- !1292 FRAM-869 Updated jQuery UI from 1.12.1 to 1.13.2

#### Bug fixes

- !1278 BT-3815 Added audit logging when users are removed from groups
- PPL-38 People API: Fixed missing metadata values for the currently authenticated user
- !1287 BT-3876 Disco-039923 Fixed a bug where a new added user has not been recorded in audit logs
- !1288 BT-3893 Fixed InfoCapture post-import redirect to new project
- !1290 BT-3574 Fixed duplicated skills on the page `Skill Search`
- !1293 BT-3873 Fixed issue where documents in the docs trashcan could not be permanently deleted
- !1300 BT-3919 OneSignal notification permissions sometimes did not get registered in the Claromentis instance
- !1306 FRAM-161 Fixed duplicate search indexing via CLC
- !1303 FRAM-899 Design admin panel: Improved image validation when updating theme background images, logos, and favicons

#### Developer notes

- !1292 FRAM-869 Added `jquery-ui` as an NPM dependency

## 9.0.1 - 9th January 2023

### Bug fixes

- 4c5fa525 BT-3874 Fixed regression that prevented correct holiday request approval
- !1257 BT-3734 docs trashcan thumbnail view fix
- 4bb93c62 BT-3394 Fix for 'Day type' display issue in Holiday Planner PDF
- !1284 BT-3526 Fixed option `Mark selected as read` in tab Notifications in Communication module
- 18e56e0 BT-3878 Fixed missing invitation lists when changing personal calendar events to standard calendar events

## 9.0.0 - 21st December 2022

### Improvements

- Merged upstream changes from 8.13
- !1223 BT-3530 Updated LDAP new connection panel layout/styling
- !1229 BOOTY-582 Refactored Utilities SCSS file and updated usages across system
  - Replaced utility classes usages with Bootstrap 4 standard utility classes
  - Moved a number of CSS classes no longer needed to a 'deprecated' section to be removed at a later date
  - Moved certain styles out of the file and into more appropriate locations
  - Added comments detailing what utility classes are to be used for
- !1240 FRAM-820 Merged forward mail configuration admin panel in Admin > System > Mail
  - FRAM-865 Added SendGrid driver for sending emails via SendGrid's API
- !1232 BT-3511 Updated Owl Carousel JS slider library to the latest version
- fcfd8cec FRAM-838 Reduced initial News channel permission for "All registered" users to view-only
- d3bff5cf FRAM-838 Ensured that the Seed module installs last
- !1254 BOOTY-607 Updated theme default styling
  - BOOTY-608 Updated default favicon
- !1255 UIUX-782 Added toggle to show/hide password on login page
- !1271 EVNT-11 BT-3832 Added height limit to events overview on calendar so it matches other calendar events

### Bug fixes

- !1260 BOOTY-602 Further final Core feedback and design fixes
  - BOOTY-601 Fixed issue where navbar icons are too small and close together on mobile devices
  - BOOTY-593 Fixed issue with dropbox_dialog when files with overly long file names don't wrap.
  - BOOTY-594 Fixed an issue with notifications dropdown where messages sent without a subject can't be previewed as there is no clickable area
  - BT-3612 Fixed issue where 'Delete' Event button displays instead of 'Edit' button in the Calendar/Event
  - BOOTY-600 Fixed a universal issue with pagination where outlines can be cut off at the bottom when focused on
  - BT-3654 Fixed issue with edit and delete buttons wrap in certain circumstances in InfoCapture statuses tables
  - BT-3656 Fixed issue with InfoCapture status and status group add/edit modals so there titles aren't cut off
  - BT-3645 Corrected issue with IC signature boxes not aligning correctly and having an un-styled button as well as fixing issue with active signature type not being clear
  - BOOTY-605 Added gap between news/blog content and 'open link' button
  - BT-3669 Fixed issue with Role field in holiday detailed view pages overflowing when the Role is very long
  - BOOTY-603 Fixed issue with InfoCapture Status workflow information banner not staying hidden when the page reloads
  - BT-3689 Fixed long API description/help display on mobile
  - BT-3694 Fixed Minor spacing issue between date field and 'Set to current date' checkbox on the contact edit page
  - BT-3698 Updated styling on legacy comments widget
  - BT-3666 Fixed issue with design of tab links on InfoCapture form edit modal
  - BT-3681 Fixed small alignment issue with location 'Link room' button on Calendar add/edit event page  
  - BT-3690 Fixed minor spacing issue with calendar 'view details' modal buttons 
  - BT-3561 Fixed issue with InfoCapture icon picker having old fashioned and badly designed layout
  - BT-3626 Fixed issue in InfoCapture reports tables not scrolling properly and buttons wrapping
  - BT-3619 Fixed issue with 'Notification template' edit page HTML text type not displaying on page load
  - BT-3683 Fixed alignment and sizing issue with HTML form field in InfoCapture
  - BT-3684 Fixed minor issue with long text strings in InfoCapture overflowing outer wrappers on smaller screens
  - BT-3709 Fixed issue with spacing between Module and Type dropdowns on Audit view logs page
  - BT-3708 Fixed issue on multi panel page templates where the application name header section can shrink below the size of the accompanying panel width in some cases
  - BOOTY-610 Added '.hide' and '.hidden' classes into utils CSS file to mitigate display and functionality bugs
  - BT-3665 Fixed display of short user pickers in InfoCapture form create/edit pages
  - BT-3729 Fixed issue with InfoCapture search results table not displaying correctly on mobile devices
  - BT-3728 Fixed issue with less/more buttons not displaying on InfoCapture search page
  - BT-3754 Fixed issue with documents where the multiple upload file name input doesn't hide correctly and overflows it's wrapper
  - BT-3748 Fixed minor issue with mini calendar where table borders can overflow the component and cause an unattractive appearance
  - BT-3817 Fixed issue where edit button has incorrect icon in calendar item view popover in mobile mode
- !1215 BT-2502 Holidays planner module - fixed an issue with PDF file generation
- 7da6d312 BT-3554 Prevented LDAP panel checkmark from resizing on mobile
- !1227 BT-3558 Fixed paths for the document's images in policy PDF
- 4a416b49 BT-3573 Sysadmin notifications templates column display
- !1224 BOOTY-361 More design fixes for Documents
  - BT-3492 Metadata alignment on 'Add new document'
  - BT-3542 Folder picker display on 'Import exported' page
  - BT-3543 Various display issues on 'Import documents from file system'
  - BT-3544 Tablet issues on 'Summary workflow reports'
  - BT-3545 Folder picker display on mobile for reports
  - BT-3546 Documents permissions report breadcrumbs
  - BT-3547 Documents tree filter radio button on mobile
  - BT-3575 Long metadata name overflow on docs admin edit filter
  - BOOTY-585 Made sure all necessary standard font weights are imported and made novelty fonts more distinct in dropdown
- !1233 BOOTY-548 Bug fixes from Codedev internal use
  - BOOTY-549 Fixed issue where the 'More' button doesn't work correctly when a gradient background is used on a menu
  - BOOTY-553 Fixed issue where border radius doesn't apply correctly to the news component
  - BOOTY-565 Fixed vertical alignment of like component on single news article page
  - BOOTY-551 Fixed issue where right-side margin is missing on deleted users comments
  - BOOTY-566 Fixed issue with text overflowing out of wrapper in news single article page
  - BT-3522 Fixed issue in InfoCapture where list/card style can be toggled but it doesn't affect the style of the list items on tablet by design so the toggle has been removed on those screen sizes
  - BOOTY-564 Fixed issue in InfoCapture where projects cards have a fixed height but don't wrap onto the next line
  - BT-3492 Fixed metadata field alignment in Documents
  - BOOTY-556 Fixed inconsistency of 'liked comments' modal so it matches others in the product
  - BOOTY-555 Improved consistency of discuss/comment dialog bar so it's consistent with other areas of the product
  - BOOTY-560 Fixed issue where long words and urls don't wrap onto the next line on the navbar notification dropdown.
  - BOOTY-567 Fixed InfoCapture breadcrumb design when users don't have the rights to view a ticket.
  - BT-3536 Added width to 'company links', 'bookmarks' and 'who's online' navbar dropdowns on desktop view so they look more uniform and can't overflow the viewport
  - BOOTY-562 Set min-width for InfoCapture single User list fields (advanced UI)
  - BOOTY-572 Fixed issue with the 'Day types' key in Holiday not displaying longer types on smaller screens
  - BOOTY-569 Re-instated styling for `<code>` and `<pre>` blocks
  - BOOTY-574 Fixed issue with comments text inputs overflowing their wrappers
  - BOOTY-575 Fixed issue with comments controls covering each other up on smaller devices when used in the Documents module
  - BOOTY-573 Fixed vertical alignment and general styling of InfoCapture flowchart tooltips
  - BOOTY-576 Fixed issue where the Info cursor displays when there isn't a flowchart or history description in InfoCapture
  - BT-3540 Fixed alignment issue with History Diagram in InfoCapture Tickets on smaller viewport/mobile
  - BT-3424 Fixed issue with holiday request history status badges not displaying correctly on PDFs
  - BT-3496 Fixed issue with user export tables having no background when in print mode.
  - BT-3520 Fixed design issue in People module where content can overflow the people profile cards on smaller viewports
  - BOOTY-580 Changed text of 'My profile' item in navbar profile dropdown to be 'Edit my profile'
  - BT-3512 Restructured Holiday Admin Zone and Group side panel so the text forms don't overflow their wrappers
  - BT-3553 Fixed issue with InfoCapture form table mode not being contained in page wrapper on smaller devices when in edit mode
  - BOOTY-581 Fixed gap between blog channel and first blog article in list
  - BT-3528 Made app menu wider and icons bigger to accommodate wider fonts and longer menu item names
  - BOOTY-583 Fixed issue where login page background gradients are broken into sections on smaller displays 
  - BOOTY-587 Updated design of 'mention' popover in comments so they're in keeping with the new Claromentis design
  - BT-3513 Fixed issue on calendar 'View event' page where description links can overflow the wrapper in certain unique situations
  - BT-3521 Fixed issue with metadata vertical mode not working correctly and causing Knowledgebase 'Related info' to be squashed
  - BOOTY-550 Made unread notifications more prominent
  - BOOTY-590 Fixed issue where Metadata repeatable urls inputs wrap onto the next line when they shouldn't and moved the 'add new' to below the current input
- !1243 BOOTY-591 Fixed standard font display in breadcrumbs and buttons with icons and text
  - Improved themes list display
- !1246 BOOTY-361 Documents admin fixes
  - BT-3596 Made tables responsive on docs details
  - BT-3597 BT-3643 Fixed breadcrumbs docs details forms
  - Improved docs list display in admin
- 14a1ba82 Fixed SQLite adapter removing columns when `$db->AlterColumn()` was used only to change that column's type
- 040938e6 BT-3713 Fixed URL encoding and type errors when handling return URLs via "Admin to App" and "App to Admin" components
- 508532c7 Fixed canonical system URL check breaking when running CLC search indexing commands
- !1241 BOOTY-599 Set date picker and time picker widths
- 4103370bfa BT-3711 long filename fix for dropbox dialog
- 4103370bfa BT-3711 Fixed the display of long filenames for dropbox dialog
- 9a84105e BT-3351 Fixed issue where file can't be added to or previewed on InfoCapture notes when they can be marked as private
- !1258 BT-3719 Fixed unpacking `.zip` and `.rar` files in Documents when the filesystem abstraction is enabled
- f726f267 BT-3756 Fixed issue where UI for adding back hidden modules/applications is missing after upgrade
- !1262 BOOTY-617 Replaced `hidden` CSS class usages with `d-none`
- 4ef39144 BT-3792 Fixed inability to reset common holidays back to their default day type
- 634f21bc BT-3796 Fixed extraneous whitespace triggering quirks mode when editing Document Workflows statuses
- Fixed login credentials emails always containing "your password has not changed" when sending them while editing a user account from the People admin panel
- 16221eef Fixed Documents general configuration admin panel not saving configuration properly
- !1264 BOOTY-615 Use standard 'mobile' breadcrumb behaviour in Documents
- !1267 BT-3557 Fixed some incompatibilities with Bootstrap 4

### Breaking changes

- !1232 BT-3511 Updated Owl Carousel JS library which includes a name change (owl-carousel 1.0.0 to owl.carousel 2.3.4)
- Changed default SQLite database file path from `<DATA_DIR>/<CLARO_DB_NAME>` to `<DATA_DIR>/<CLARO_DB_NAME>.sqlite`

### Developer notes

- a1b4303c ce733840 FRAM-838 Implemented a way to retrieve all persisted application menu items, regardless of whether they're registered
  - Changed signature of `Claromentis\Menu\Infobar\MenuItemRepository::get()`
- 96521d49 Refactored boot-time canonical system URL redirects to an event listener
- 16d17d66 BT-3796 Quietened `AdminToApp` warnings when an application menu item is not found

## 9.0.0-rc4 - 5th August 2022

### Improvements

- !1211 BOOTY-546 Minor design improvement to Org chart cards so more can fit in the viewport at once as well as some very minor usability improvements
- 89c9ebdc BOOTY-544 Hid unneeded 'link' radio button in menu builder which no longer has functionality since the removal of Publish
- BOOTY-500 Updated pages component IDs so they use the new class structure
 - ebd2815a BOOTY-507 News component
 - 210b77e8 BOOTY-506 Blog component
 - 401da1a7 BOOTY-509 Absence Requests component
 - 25bf545d BOOTY-528 Gallery component
 - 21301b45 BOOTY-518 Calendar Events component
 - dbc30f43 BOOTY-531 Mini Calendar component
 - 85cd3740 BOOTY-537 What's New component
 - 71324211 BOOTY-538 Who's Out component
- 8d6ef6ec Added container classes to edit theme panel for improved wide mode experience

### Bug fixes

- b9cb5bc1 e9e99a82 FRAM-416 Fixed fatal error in custom localization migration (introduced by 11f64a84)
- !1207 FRAM-848 create column `last_background_sync` in table `cln_calendar` if it does not exist

## 9.0.0-rc3 - 15th July 2022

### Bug fixes

- 44b77258 d90e6dbd BT-3428 Fixed CKFinder config script relying on global APPDATA config variable

### Developer notes

- Removed `run_composer` task from `prepare_code.xml`; prevented redundant dependency bundling
- Minimized noisy stack traces from XDebug on the command-line
- Implemented `--ignore-change-logs` option for the `clc release` command

## 9.0.0-rc2 - 30th June 2022

### Improvements

- Merged upstream changes from 8.13
- d611139a Improved design for News List Component when the News application is not available

### Bug fixes

- 56efdb14 BOOTY-362 BT-3440 Added missing 'ionicons' require to people pop up so the ionicon icons display properly.

### Breaking changes

- FRAM-771 Removed `ClaApplication::LoadConfig()`

### Developer notes

- Added `bcmath` as a required PHP extension
- FRAM-657 Added `css_class` attribute to the `icon` (`Claromentis\Core\UI\Icon`) UI component
- a2954aa3 Updated `Claromentis\Core\Component\MessageComponent` to show errors more pleasantly

## 9.0.0-rc - 17th June 2022

### Improvements

- dd8d240c BOOTY-440 Updated Bootstrap from 4.6.0 to 4.6.1
- a2d1b311 Updated server checks in **Admin > System > Labs > Check Server Configuration**
- !1184 FRAM-648 Disabled Publish application
- !1191 FRAM-647 Removed legacy Announcements feature from News
- !1191 FRAM-163 Improved performance of Trash Can queries
- !1193 FRAM-649 Removed Surveys (legacy) application

### Bug fixes

- 4b43ac2f BT-3401 Fixed minor bug with space between pagination and 'Delete selected' in news on mobile devices.
- 9c60794f BOOTY-499 Fixed bug with main menu submenu items not inheriting the correct color when in side menu mode.
- efd63182 BOOTY-372 BT-3334 Fixed issue with browse/add files in IC notes not working.
- ff6d73b4 939d8c1b 0f34d5a7 BOOTY-448 BT-3394 Fixed issues with design of the downloadable 'My Holiday' PDF after upgrade from Bootstrap 3 to Bootstrap 4
- f19fe816 BOOTY-366 Fixed some small outstanding design issues with layout and design in People module including updating people CSS entries to use CSS variables
- !1179 BT-3343 Fixed display of colour picker popup when appearing on right hand of the screen on small window widths
- 15ff2eb0 FRAM-416 Fixed custom localisation separation migration breaking when the filesystem abstraction was enabled
- !1184 FRAM-648 Fixed stack overflow and missing styles for menu component (`ClaMenu`) used in Compliance, Documents, Room Booking
- !1190 d1ae64fa Fixed deep cross-domain template localization phrase references
- d1ae64fa Fixed repeated application menu error logs when visiting the System admin panel

### Breaking changes

- !1184 FRAM-648 Prevented access to the Publish application, removed Publish plugin
- !1184 FRAM-765 Removed Documents, Forum, and News Smart Objects
- !1191 FRAM-647 Removed News Announcements, along with all related code and data
- !1193 FRAM-649 Removed Survey (legacy) application and constants `AGGREGATION_SURVEY` and `AGGREGATION_SURVEY_VOTE`

### Developer notes

- !1184 FRAM-648 Added `Claromentis\Core\Plugin\Api::remove()` method for removing plugins
- !1184 FRAM-648 Added `Claromentis\Setup\SetupFacade::plugins()` for accessing the Plugin API from migrations
- 81e3ed28 FRAM-515 Retroactively implemented backwards-compatibility for `css_class` icon definitions for Module Admin Panels and Menu Items
- !1190 Localization errors are now logged instead of being `echo`ed

## 9.0.0-beta6 - 28th April 2022

- dac16319 9c3bf688 Improved Claromentis version introspection for **Admin > System > General**

## 9.0.0-beta5 - 26th April 2022

### Improvements

- 7df609ae BT-3355 Added overflow scroll to edit notifications localisation on mobile

### Bug fixes

- 5d8ca8c8 ce94d129 0b5fbca1 aef24e86 BOOTY-369 Design and implementation fixes for Holiday Planner and Holiday Approval component
  - Refactored and improved efficiency of CSS, removed unused code
  - Fixed status badges to display colours that are more appropriate to the message in the badge
  - Small spacing fixes to the 'Absence request' component
- f4d3e6b7 BT-3349 Fixed issue with app page template mobile menus being too thin on mobile for 'Full width' Theme designs
- e84bf3c0 BOOTY-366 Fixes design issues with People Advanced Search
- 8306ea0d BOOTY-372 Fixes to several tables on InfoCapture when viewed on mobile.
- d4325823 BOOTY-472 BT-3353 Fixed InfoCapture mobile table bug
- d4325823 BOOTY-376 small design improvement to notification menu on smaller devices

### Developer notes

- !1173 FRAM-479 Updated Gulp from version 3.9.1 to version 4.0.2

## 9.0.0-beta4 - 11th April 2022

### Improvements

- c35e0d6f Added Claromentis version introspection to **Admin > System > General**

### Bug fixes
- !1180 BOOTY-479 | BOOTY-480, BOOTY-481, BOOTY-483, BOOTY-484, BOOTY-485 Fixed design bugs which were identified on Codedev staging
- 303ca87b Fixed type errors during interactive installations that create a new MySQL database
- 3389d9a4 FRAM-509 Disabled standard output logging for CLI environments
- !1172 FRAM-810 Fixed error when fetching mails from IMAP server
- c7c5203d FRAM-641 Updated asset cache clearing background task to remove files from the correct path
- !1176 FRAM-828 Fixed backwards-incompatible change for SMTP mail configuration parameter; changed from `user` back to `username`
- !572 !1176 BT-659 Disco 026016 Fixed "Edit user info" page errors when attempting to display unknown user fields

### Developer notes

- !1176 FRAM-707 FRAM-150 Refactored `clc notification:test` to use the new Notification API
- b74317c6 FRAM-452 Updated web/lib autoloader from PSR-0 to classmap
- b74317c6 Updated Composer dependencies

## 9.0.0-beta3 - 18th March 2022

### Bug fixes

- 29e1f54f BT-3113 BOOTY-361 Fixed issue with words in Documents metadata descriptions breaking at random positions
- c155d016 BOOTY-475 Small mobile fixes to metadata after QA
- 3cfee028 BT-3247 BOOTY-372 Fixed issue with alert wrapping onto same line as input on Infocapture project properties page
- 79551eb9 BOOTY-376 PRJ-604 Fixed issue with `cla-breadcrumbs` and standard breadcrumbs being inconsistent with each other as well as an issue with `cla-breadcrumbs` being cut off even when they're very short

## 9.0.0-beta2 - 2nd March 2022

### Improvements

- !1123 BOOTY-456 InfoCapture themes usability improvements
- !1123 BT-457 Removed HTML comments from InfoCapture form theme style code and improved form theme usability
- !1146 BOOTY-466 Updated app template colours for improved accessibility
- BOOTY-467 Increased width of collapsible right side panel
- BOOTY-463 Updated Component Library package to version 0.3.8 (includes improvements to `<cla-menu>`)
- BOOTY-309 Improved sysadmin panel styling
- !1142 BOOTY-468 Design panel design improvements and functionality expansion
- d68470ce BOOTY-367 Improved the efficiency and reliability of pop up centring code after feedback.

### Bug fixes

- !1145 FRAM-815 Fixed issues when initializing sessions with an invalid license
  - Fixed fatal error from the 'System Locked' page
  - Fixed two-factor authentication not initializing properly
- 26ff91a9 BT-3184 Disabled standard out logging for Windows
- !1150 BT-3171 Fixes for config editor display
- 1334622f BOOTY-367 Fixed some small bugs with the calendar 'add event' page after QA

### Breaking changes

- 4525f540 `SchemaFile::BuildNew()` now explicitly requires an instance of `DAL\Schema\SchemaDb` as its first argument

### Developer notes

- f940bf35 `ext-ldap` is now an optional platform dependency instead of a required platform dependency
- Removed `web/intranet/helpdesk`. Old directory that has redirected to InfoCapture since 2016.
- fa2c2990 Fixed SQLite column alterations failing to retain existing column descriptions when a new column description is omitted
- 4525f540 Fixed schema files failing to build during releases due to `global $db` pollution

## 9.0.0-beta - 20th January 2022

### New features

- !1110 FRAM-152 Enabled filesystem abstraction by default
- !1135 FRAM-796 Implemented `CLARO_LOG_LEVEL` environment variable

### Improvements

- !1110 FRAM-641 Migrated appdata from `application/web/appdata` and `data/cdn_mirror` to `data/appdata`
- !1134 FRAM-483 Implemented support for AWS S3 mounts for the Filesystem abstraction
- !1135 FRAM-345 FRAM-98 FRAM-509 FRAM-796 Container improvements

### Bug fixes

- !1110 FRAM-795 Fixed SQLite connections failing when the filesystem abstraction was enabled

### Breaking changes

- !1110 FRAM-152 FRAM-641 FRAM-795 Enabled filesystem abstraction by default
  - `cfg_cdn_type` now defaults to `'filesystem'` instead of `'local'`
  - `CLARO_FS_ENABLED` now defaults to `true` instead of `false`
  - `DATA_DIR` now defaults to `claromentis://data`, which directs to `../data` by default
  - `APPDATA` now defaults to `../data/appdata`
  - Removed `data`, `local_data` and `web/appdata` directories from the codebase
    - `/appdata/people/no_photo.jpg` has been removed and should no longer be used as a default user profile photo URL. Use `\Claromentis\People\UrlGenerator` methods instead, or if you must use a static URL, then use `/intranet/people/images/no_photo.jpg`.
  - Removed global variable `$APPDATA`; use `$config->get('APPDATA')` instead
  - Added method `Claromentis\Core\Config\WritableConfig::setMany()` for setting many configuration variables at once
  - Added type hints to properties and methods of the following classes:
    - `Claromentis\Admin\Sysadmin\Controller\RestConfigController`
    - `Claromentis\Core\Assets\AssetsPathGenerator`
    - `Claromentis\Core\Assets\Storage\NativeStorage`
    - `Claromentis\Core\Config\ConfigFactory`
    - `Claromentis\Core\Config\ConfigRegistry`
    - `Claromentis\Core\Config\LayeredConfig`
    - `Claromentis\Core\DAL\SQLite\SQLiteDb`
    - `Claromentis\Core\Setup\Task\Configure`
    - `Claromentis\Core\Util\FilesystemUtil`
  - Renamed `Claromentis\Core\Filesystem\GetPublicUrlLocalPlugin` to `Claromentis\Core\Filesystem\GetUrlLocalPlugin`
  - Renamed `Claromentis\Core\Services::GetFileUtils()` to `Claromentis\Core\Services::GetFilesystemUtil()`
  - Renamed the filesystem abstraction's stream wrapper protocol from `'claro-data'` to `'claromentis'`
  - `Claromentis\Core\Filesystem\Filesystem::IsDir()` now only returns `true` for existing directories, instead of any path that _can_ be a directory
  - Deprecated `Claromentis\Core\Filesystem\UseCase\GetLocalPath`; use `Claromentis\Core\Util\FilesystemUtil::getLocalPath()` instead
  - Removed `Claromentis\Core\Filesystem\UseCase\GetLocalPathStatically`; use `Claromentis\Core\Util\FilesystemUtil::getLocalPath()` instead
- !1110 FRAM-652 Deprecation
  - Removed unused config variables `cfg_diagram_data_providers` and `cfg_diagrams`
  - Removed `cfg_rest_applications`: REST applications provided via configuration are **no longer supported**
- !1133 FRAM-49 `Config` and `WritableConfig` interfaces now explicitly extend the `ArrayAccess` interface

### Developer notes

- !1110 FRAM-152 Enabled filesystem abstraction by default
  - Added method `SetupFacade::getFilesystem()` for retrieving the Filesystem during migrations
  - Added method `SetupFacade::getLogger()` for direct access to the migrations logger, allowing you to use different log levels
  - `APPDATA` and `DATA_DIR` now default to `'claromentis://public'` and `'claromentis://data'` respectively, in order for legacy code to utilise the filesystem abstraction's stream wrapper
  - Introduced `UnresolvableParameterException` as a distinct exception when the Claromentis application's automatic dependency injection fails to resolve a parameter argument.
- !1110 FRAM-641 Migrated appdata from `web/appdata` to `data/appdata`
  - Appdata is now served exclusively by Claromentis' appdata front-controller by default, unless configured otherwise using an HTTP server
  - Assets cache has been moved from `web/appdata/assets_cache` to `web/assets/cache`
- !1133 FRAM-49 Updated `Config` and `WritableConfig` interfaces to explicitly extend the `ArrayAccess` interface
- !1134 FRAM-483 Filesystem abstraction
  - `CLARO_FS_MOUNTS`, `CLARO_FS_PATHS` config variables can be used to configure AWS S3 as the data volume
  - See the [Filesystem configuration documentation](docs/technical/configuration/filesystem.md#aws-s3-mounts) for more information.
- !1135 FRAM-345 Container improvements
  - FRAM-98 Exception-safe module registration
  - FRAM-509 Standard output logging
  - FRAM-796 Implemented `CLARO_LOG_LEVEL` environment variable; sets `$cfg_log_level['_default']`

## 9.0.0-alpha5 - 11th January 2022

### Improvements

- Allowed `clc release:*` commands to run Phing from `vendor_core`

### Bug fixes

- !1120 FRAM-150 FRAM-802 Improved error handling for mail fetching
- !1119 BT-3085 Fixed documents preview on smaller devices screens
- 29905e0a BT-3143 Fixed IMAP mail fetching trying to read from mailboxes marked with the `"/Noselect"` attribute
- !1125 BT-3122 Fixed system error in documents reports page
- !1128 BT-3140 Fixed system error in admin configuration page
- c16737df BT-3082 Fixed fatal error when accessing Room Booking
- !1127 BT-3134 Fixed system error when user is trying download CSV file in Documents Reports (Number and location of folders, documents and records by specific access control markings)
- !1132 BT-3136 Fixed PHP notice (undefined PHPSESSID) at the top of the page in the documents module
- !1129 BT-3142 Fixed orgchart nav / controls display on small screens and at wider breakpoints
  - Fixed generic display of buttons in the app toolbar at the smallest supported device width(360px)
- !1124 BOOTY-361 BT-3121 BT-3127 BT-3133 BT-3145 Fixed Documents design issues
- Fixed redefinition of constants `E_CLA_STANDARD` and `E_CLA_COMPAT` in some cases

### Developer notes

- !1121 BOOTY-442 Front-end documentation for extending Bootstrap and code style guide
- Updated Core's PHP version to check to PHP >=7.4.0
- FRAM-100 Added `phing/phing` development dependency to temporarily aid releases until `clc release:*` commands are ported

## 9.0.0-alpha4 - 24th November 2021

### Bug fixes

- BT-3032 Fixed Select2 picker width at smallest supported device width
- !1115 BT-3085 Fixed Documents preview iFrame height on small devices
- 36bb43e3 FRAM-538 Fixed CLC's MySQL database permission checks
- 36bb43e3 Fixed CLC script using `realpath -s`; `-s` is not available on Alpine Linux.

### Developer notes

- !1115 FRAM-427 Moved documents style assets into Webpack

## 9.0.0-alpha3 - 12th November 2021

### Improvements

- !1021 BOOTY-258 BOOTY-271 BOOTY-272 BOOTY-312 BOOTY-313 BOOTY-358 Various UI Improvements after internal feedback
  - Focus on username field in login form on page load
  - Swapped out all edit icons for better alternative
  - Added improved keyboard navigation on Applications menu
  - Improved focus styling on Applications & Admin Applications menu
  - Improved stylesheet file structure
- !1044 DS-89 Updated component library to version 0.3.1
- 1851fb22 FRAM-429 BT-2566 Separated configuration for the Forum application
- !1079 Updated Ionicons package to v5.5.3
- 7c9c8117 BT-2501 Enabled InfoCapture Issue PDF generation by default
- 8e6b6f40 BOOTY-440 Updated popper.js node package
- !1111 BOOTY-348 Added `client-css-*` CSS classes to elements for client customisation

### Bug fixes

- !1027 BOOTY-246 Keyboard tabbing through app menu on Calendar app
- !1030 BOOTY-246 Fixed app menu divider issues
- !1028 BOOTY-380 Design panel Functionality and file structure fixes
- !1069 BOOTY-363 Gallery bugfixes for Claromentis 9
- !1057 BOOTY-360 Forum bugfixes for Claromentis 9
- !1095 BOOTY-430 Fixed long breadcrumbs in Claromentis 9
- !1102 BOOTY-437 Fix for app menu keyboard tab navigation not working after jQuery upgrade
- !1103 FRAM-710 Fixed issue where the appropriate resolution theme background image was not being used
- !1105 BOOTY-438 Fixed single and multiple user picker display on smaller screens
- 8e6b6f40 BT-2764 Made datepicker appear over navbar when its orientation is on top
- BOOTY-361 Documents bugfixes for Claromentis 9
  - !1112 BT-2964 Fixed Metadata layout when viewing Document Details

### Breaking changes

- !1112 FRAM-652 BT-2964 Removed global `MetaDataDialog` constants `EDITABLE` and `NOT_EDITABLE`. Use `MetaDataDialog::EDITABLE` and `MetaDataDialog::NOT_EDITABLE` instead.

### Developer notes

- !1112 FRAM-652 BT-2964 Deprecated global `MetaDataDialog` constants `FILL` and `NOT_FILL`, use `MetaDataDialog::FILL` and `MetaDataDialog::NOT_FILL` instead

## 9.0.0-alpha2 - 24th May 2021

### Improvements

- !1010 FRAM-667 Updated default admin panel icon from Glyphicon to SVG
- !1011 BOOTY-264 BOOTY-266 BOOTY-267 Documents UI Refresh updates after feedback

### Bug fixes

- BOOTY-241 Test server issues
  - 76fb788e Fixed first news item not displaying on the news index page
  - 6b85890c Fixed undefined index notices in Documents
  - 7e54979a Fixed Documents preview and InfoCapture Issue attachment preview/download

### Breaking changes

- !1010 FRAM-667 Refactored admin panel list
  - `Claromentis\Core\Admin\AdminPanelSimpleAcl` interface
    - Added parameter and return value type hints for `GetSimpleAcl()` and `SetSimpleAcl()` methods
    - Added missing `SetAclRepository()` method that was missing from an assumption made in `PanelsList`
  - `Claromentis\Core\Admin\PanelsList` service
    - Constructor signature changes: parameter typehints and a new `IconInterface $defaultIcon` required parameter
    - Added parameter and return type hints to `GetOne()` and `GetAll()` methods
  - `Claromentis\Core\Admin\SimpleAclTrait`
    - Added parameter and return value type hints in accordance with `AdminPanelSimpleAcl`

### Developer notes

- !1010 FRAM-667 Refactored admin panel list
  - Improved type safety
  - Source of truth for the default admin panel icon
  - You can now customise the default admin panel icon by extending `PanelsList` and using its `setDefaultIcon()` method

## 9.0.0-alpha - 11th May 2021

### New features

- !927 FRAM-24 UI Refresh
  - Updated the Claromentis UI using Bootstrap 4
  - BOOTY-82 Included Ionicons icon library
  - BOOTY-69 Implemented new page layout for Design tool
  - BOOTY-70 Implemented rich responsive preview for Design tool
  - BOOTY-124 Updated Bootstrap CSS framework from v3.4.x to v4.6.0
  - !881 FRAM-515 Introduced a brand-new suite of bespoke application icons

### Improvements

- !850 Separated Configuration for the following built-in Modules:
  - Blog
  - Calendar
  - Documents
  - Gallery
  - !948 FRAM-654 Holiday Planner
  - Infocapture
  - News
  - Orgchart
  - Room Booking
- !860 FRAM-512 Removed integration for MS Exchange web access in Calendar.
- !858 FRAM-511 Removed duplicate Configuration for *First day of the week*. This can now only be configured via *Admin, System, Date and Time*.
- !863 FRAM-519 Config *Show permissions flags in the documents list next to each document/folder* (`interfaceDebug`) can no longer be configured via the Documents Module.
- !800 FRAM-416 Separated Localization Providers for pre-packaged Core Modules
- !659 FRAM-150 Emails can now be sent and received via more secure connections (TLS 1.2)
- !934 FRAM-601 Better feedback when failing to send a test notification
- !1002 BOOTY-275 BOOTY-278 InfoCapture UI Refresh updates
  - Removed InfoCapture project 'Options' card from mobile view
  - Improved InfoCapture notfication templates / Thank you UI
- !1009 BOOTY-308 BOOTY-239 BOOTY-354 Design Panel UI Refresh updates after feedback

### Bug fixes

- !853 FRAM-507 Config defaults for modules will now be loaded properly in migrations
- !1001 BOOTY-281 Improved styling of InfoCapture edit thank you page
- !1006 BOOTY-353 Fixed blog template issues after merge forward from v8.x

### Breaking changes

Claromentis Core 9.0.0 is a major version bump. As such, there are _many_ breaking changes.

Please refer to the [Claromentis 9.0 migration guide](docs/guides/9.0-migration.md) for module compatibility guidance.

- !503 FRAM-49 Refactored Claromentis Core bootstrap and configuration process
  - Renamed the `core.webroot` service to `core.web_path`
  - FRAM-117 Refactored and streamlined the configuration system and processes
    - **Core configuration variables are no longer defined as global variables**
    - Removed `Claromentis\Core\Config\CombinedConfig` in favour of `Claromentis\Core\Config\LayeredConfig`
      - `CombinedConfig` is still _aliased_ to `LayeredConfig` to cover the majority of backwards compatibility issues, but this class alias **will be removed** in a later minor version
      - Please use the `Claromentis\Core\Config\Config` or `Claromentis\Core\Config\WritableConfig` interfaces for your typehints instead
    - Removed `local_config` service; bootstrap & config refactoring has rendered it redundant
    - Removed `Claromentis\Core\Config\UseCase\GetAllConfigDomains` in favour of using `ConfigRegistry` directly
    - Removed deprecated method `SetupFacade::GetConfigEditor()`
    - Removed `Dotenv\Dotenv` constructor dependency from `Claromentis\Core\Setup\Task\Configure` constructor
    - Renamed `Claromentis\Core\Config\ConfigUpdateEvent` to `Claromentis\Core\Config\Events\ConfigUpdateEvent`
    - Renamed `Claromentis\Core\Config\Subscriber\ConfigEvents` to `Claromentis\Core\Config\ConfigEvents`
    - Renamed `Claromentis\Core\Application\ControllerResolverServiceProvider` to `Claromentis\Core\Application\ControllerServiceProvider`
    - Added type hints to all methods of `Claromentis\Core\Config\Config` and `Claromentis\Core\Config\WritableConfig` interfaces
    - Core service providers should now use `$app->extend('config', ...)` to derive default Core config values during bootstrap
  - FRAM-121 Service providers and plugins defined in `$cfg_app_services` and `$cfg_cla_plugins` global variables are **no longer loaded or supported**
- !800 FRAM-416 Localization domain separation
  - `\Claromentis\Core\Localization\Localization`:
    - `GetPhrase`:
      - Renamed to `getTranslation`.
      - Added `string` return type.
    - `GetProviderForKey`:
      - Renamed to `getProviderForKey`.
      - Added `\Claromentis\Core\Localization\LocalizationProviderInterface` return type.
      - Added `string` parameter type.
  - `\Claromentis\Core\Localization\GettextProvider`: Removed.
  - `\Claromentis\Core\Localization\LocalizationProviderInterface`
    - `getDomain`: Added.
    - `GetPhrase`:
      - Renamed to `getTranslation`.
      - Added `string` parameter types.
    - `GetTemplaterPhrases`:
      - Renamed to `getTemplaterPhrases`.
      - Added `string` parameter types.
      - Added `array` return type.
    - `KeyExist`:
      - Renamed to `hasKey`.
      - Added `string` parameter types.
      - Added `bool` return type.
    - `GetDataHash`:
      - Renamed to `getDataHash`.
      - Added `string` parameter type.
      - Added `?string` return type.
- !822 FRAM-467:
  - `\Claromentis\Core\Localization\Localization`:
    - Updated constructor signature.
- !850 FRAM-429 Configuration bundle separation
  - [See the 9.0 migration guide](docs/guides/9.0-migration.md#configuration--localization)
- !881 FRAM-515 SVG support for Application Icons
  - `\Claromentis\Menu\Infobar\InfobarItemsRepository`:
    - Renamed to `\Claromentis\Menu\Infobar\MenuItemRepository`.
    - Constructor signature changed.
  - `\Claromentis\Menu\Infobar\ApplicationsListItems`:
    - Constructor signature changed.
    - `GetItems`: Removed.
  - `\Claromentis\Core\Admin\AdminPanel`:
    - `GetCssClass`: Removed.
    - `getIcon`: Added.
    - `setIcon`: Added.
- !659 FRAM-150 Webmail application has been deprecated and removed
- !973 BOOTY-259 DataTable decorators `Icon` and `IconLink` now default to expecting Ionicon icon names instead of Glyphicons

### Developer notes

- !503 FRAM-49 Refactored Claromentis Core bootstrap and configuration process
  - FRAM-117 Refactored and streamlined the configuration system and processes
  - FRAM-117 Core service providers must now change config using `$app->extend`
  - FRAM-118 Refactored Behat-specific config code to its own service provider
  - FRAM-119 Moved file includes into `composer.json`'s autoload configuration
  - FRAM-120 Moved ad-hoc service definitions into dedicated service providers
  - FRAM-121 Refactored application registration into a `ModuleServiceProvider`
  - FRAM-123 Moved notification sending and stat logger into service providers
  - FRAM-124 Moved error & exception handlers into dedicated service providers
  - FRAM-125 Consolidated Composer autoloader calls into a dedicated Core file
  - Our `composer.json` now contains all required and suggested PHP extensions
  - PhpStorm project code style settings have been updated to PSR-12 with tabs
  - Removed `LUCENE_DATA_DIR` config variable, it hasn't been in use for years
  - Deprecated the `CM_USR_BROWSER_AGENT` constant; use `gpc::getBrowserType()`
  - Implemented `EventDispatcherAwareInterface` and `EventDispatcherAwareTrait`
  - Any output produced by PHP config files will now be captured and discarded
- !655 FRAM-388 The MySQLi driver now uses prepared statements instead of performing in-memory parameter substitution
- !884 FRAM-561 Added `\Claromentis\Core\Exception\ExceptionMessageTrait`
- !860 FRAM-512 SVG support for Application Icons
  - Removed page `/intranet/calendar/exchange.php`
  - Removed config `cfg_exchange_web_access_url`.
- !800 FRAM-416:
  - `\Claromentis\Core\Localization\Localization::__construct`: Added optional 3rd parameter `?LoggerInterface $logger = null`.
  - The "common" localization domain is now checked in the event that a Localization Phrase could not be found in the expected Localization Provider.
  - New log "localization".
  - Separated Localization Providers for the following Localization Domains:
    - *blog*
    - *calendar*
    - *communication*
    - *design*
    - *documents*
    - *gallery*
    - *mail*
    - *mailgun*
    - *menu*
    - *news*
    - *oauth2*
    - *orgchart*
    - *panels*
    - *people*
    - *publish*
    - *rooms*
    - *search*
    - *stat*
    - *whatsnew*
  - All Localization Providers are now only dependent on themselves or the *common* Localization Provider.
- !822 FRAM-467 Implemented `clc localization:resolve` command to assist in resolving Localization File conflicts and continuous migration of phrases from 8.x
  - Please note, UTF-8 support is still not great on Windows, it is best to use this command in terminals that properly support it
- !659 FRAM-150 Emails are now sent and received via up-to-date libraries
  - `ClaMailMessage` is now deprecated but will still work as before
  - PEAR Mail library has been removed
  - To send emails directly, use the `\Claromentis\Core\Mail\Api` service
  - Related to this, the webmail application has been removed
- !881 FRAM-515 SVG support for Application Icons
  - `\Claromentis\Menu\Infobar\ApplicationsListItems` is now the canonical public API for working with menus and menu items
- !927 FRAM-24 UI Refresh
  - All files in `web/interface_default/css` have been moved to more appropriate paths
  - Updated the file structure for **Core and Core module** assets and templates
    - `assets/css` and `assets/js` are now the canonical source directories for stylesheets and JavaScript source code
    - `web/assets` is now the canonical build target for Core assets (JavaScript, CSS)
    - `web/interface_default/<module>/assets/css` for module source SCSS/CSS
    -  Templates have been better organised in `web/interface_default` overall and per-module
  - Updated the file structure for **separate module** assets and templates (e.g. `assets`, `buttons`, `pages`)
    - `web/intranet/<module>/assets` for source assets (JavaScript, CSS, images)
    - `web/intranet/<module>/build` for asset builds (images do not currently move)
  - `web/interface_default/common/layouts` base Templater template layouts are more flexible and responsive
  - Some modules have had their admin panels changed to use side navigation for consistency (`admin_with_info_panel.html`)
  - `ExtraCss` now only outputs CSS variables for use elsewhere in the product, and all styling rules within have been relocated or removed appropriately
  - !973 BOOTY-259 Updated DataTable decorators `Icon` and `IconLink` to support Ionicons and SVGs, as well as Glyphicons.
- FRAM-345 Containerisation
  - FRAM-478 Docker images for Claromentis
    - 08dffbd8 Implemented on-demand creation of the Templater cache directory
    - 3e34db69 Implemented on-demand creation of the localization cache directory
- !974 FRAM-686 Implemented user entity retrieval via `SecurityContext::getUserEntity()`

## 8.13.41 - 1st March 2024

### Improvements

 - !1474 LCIP-26 SSO/directory users who are blocked in Claromentis can now be unblocked and synced on login without having to wait for a full user directory sync

### Bug fixes

- !1434 BT-4245 Disco 042830 Disco 043221 Fixed Bootstrap accordion links not working in CKEditor content
- !1502 BT-4470 Disco 044234 Fixed an issue where People search keywords only worked at the end of the search query
- !1502 PPL-61 Back-ported fix for blocked user searches in HR mode
- 45815bce !1507 PPL-74 Fixed minor intermittent warning when updating user data from People admin

### Developer Notes

- !1471 LCIP-26 Implemented a new Login status called `SYNC_USER`, which the SSO Login Handler can return to indicate that a blocked user account should be unblocked and synced with the directory they belong to

## 8.13.40 - 6th February 2024

<!-- !1503 BT-4476 Please reapply this migration for merged forward releases -->

### Improvements

- !1473 PPL-74 Disco 043552 Improved audit logging for user profile fields and photo updates
- !1492 IC-128 Disco 043841 Implemented audit logging for InfoCapture issue draft actions
- !1503 BT-4476 Disco 044155 Improved InfoCapture issue list performance by adding database indexes

### Bug fixes

- !1504 EVNT-68 Resolved a bug preventing line breaks from being retained when pasting content into the BBCode text editor.
- !1498 BT-4457 Disco 044176 Fixed an issue where published articles with the "Send notification to all users with view rights" option selected and an empty Short Summary field failed to trigger system notifications.
- !1459 Fixed various issues with calendar ICS file exports
    - BT-4325 Fix fatal error when the export includes sequences or Events module events 
    - BT-4242 BT-4310 Disco 043047 Disco 042799 Fix ICS validation issues that caused problems for some versions of Microsoft Outlook

### Developer notes
- !1496 FRAM-947 Improved CI/CD pipeline performance (backported from v10)
- !1459 Claromentis calendar exports now pass the iCalendar validation tool at https://icalendar.org/validator.html
    - Re-enabled `VTIMEZONE` components for events in `.ics` file exports from calendar
    - Fixed a small issue with signed offsets in `VTIMEZONE` components when the offset is 0


## 8.13.39 - 11th January 2024

### Improvements

- !1458 PPL-60 Updated the People API to restrict which profile fields are available to guest users

### Bug fixes

- !1493 IC-129 Updated InfoCapture's client-side form validation to allow Financial Fields to accept 1 or 2 decimal places
- !1480 BT-4409 Fixed issue with being unsubscribed from news channels when using the My Settings page
- !1485 BT-4426 Disco 043954 Reorder skills results to higher in the top result
- !1491 BT-4412 IC User list field - updated default text to be consistent once checkbox with label `Show "Please select..." as default` is selected

## 8.13.38 - 6th December 2023

### Bug fixes

- !1477 FRAM-360 Fixed array index bug for Google Cloud Storage and AWS S3 CDN adapters

## 8.13.37 - 1st December 2023

<!-- !1448 FRAM-934 PLEASE REAPPLY PEOPLE INDEX MIGRATIONS for Claromentis 9 after merging forward -->

### Improvements

- !1469 DMS-21 Added `.potx` to the list of allowed document preview formats
- !1448 FRAM-934 Disco 043117 Improved performance of the online users list
- !1448 FRAM-934 People REST API can now be used to filter online or offline users with `/api/people/v2/users?online=1` or `/api/people/v2/users/online=0`
- !1429 FRAM-360 Disco 042608 Added support for CDN Signed URLs (Google Cloud Storage, AWS S3) to improve content privacy

### Bug fixes

- !1464 BT-4314 Disco 043280 Fixed issue downloading an InfoCapture report as .csv when field types had changed
- !1453 BT-4136 Fixed database errors caused by long audit log messages when updating config values
- 4fdd2ecb FRAM-945 Disco 043552 Fixed inconsistent module installations in cloud environments with data volumes backed by NFS storage

### Developer notes

- 4fdd2ecb FRAM-945 Disco 043552 Ensured cached writes for `data/config/plugins.json`, not just for reads

## 8.13.36 - 10th November 2023

### Bug fixes

- !1437 BT-4285 Disco 042975 Added indexes to improve loading time for Open items page component
- !1462 BT-4354 Fixed issue where missing directory IDs in the login directory dropdown menu prevented login for some users
- !1461 LCIP-21 Fixed environment config values not being available during module installation

## 8.13.35 - 27th October 2023

### Improvements

- !1442 IC-123 Disco 043278 Reordered InfoCapture 'View ticket' tabs for improved usability

### Bug fixes

- !1452 PPL-73 BT-4173 Disco 042422 Backported People Advanced Search query parser fixes

## 8.13.34 - 12th October 2023

### Improvements

- !1410 FRAM-935 Disco 040396 Disco 042001 Improved Statistics application performance 
- !1411 FRAM-933 Improved performance on login page when the system has a large number of users. 
  - Directories are no longer hidden on the login page dropdown if they have no users.
- !1419 BT-3975 Improved styling and changed arrows within Gallery under metadata options
- !959 UIUX-354 Added InfoCapture template expression for displaying an issues notes starting with the most recent

### Bug fixes

- !1415 BT-4247 Disco 042821 Fixed issues affecting linked room bookings in calendar events
  - Prevented SQL errors when no event for the room booking is found
  - Details for the linked room booking are now displayed correctly when viewing the event
- !1420 BT-4004 Fixed input element alignment issue within Bookmarks
- !1422 IC-120 Added missing localisation in IC edit form
- !1423 BT-4226 Fixed "Permission denied" filesystem error when downloading PDFs from InfoCapture issues
- !1430 BT-4242 Disco 42799 Disco 43047 Fixed exported calendar events to use matching timezone and times
- !1433 BT-4272 Disco 42819 Disco 42940 Fixed issue where fields in the LDAP config form could not be mapped
- !1436 BT-4289 Replaced custom Room Booking popup code with generic popup code

### Developer notes

- !1410 FRAM-935 Implemented `clc seed:stats` command for generating random Statistics application data

## 8.13.33 - 7th September 2023

### Bug fixes

- c1b42f721b Fixed an error that prevented mini calendar component from displaying

## 8.13.32 - 5th September 2023

### Bug fixes

- !1402 BT-4203 Reduced number of displayed pages in Communication notifications pagination
- !1399 BT-4168 Implemented contrasting text colour for events in the calendar

### Developer notes

- 5328fc74 BT-4210 Tweaked the way the user search index is remapped and reindexed when changing profile fields

## 8.13.31 - 9th August 2023

### Improvements

- !1398 BT-4205 removed the email field check when provisioning SSO users on first login
- !1397 COM-13 Disco 042561 Improved the Communications email notification footer 

### Bug fixes

- !1385 BT-1637 News articles and blog posts now remove comments and comment attachments when deleted
- !1393 BT-4131 Disco 041540 Fixed behaviour of LDAP attribute mapping when empty
- !1396 BT-4199 Disco 41902 Holiday Planner fixed the issue with Egypt/Cairo DST timezone causing duplicate months
- !1395 BT-4159 Disco 042239 Claromentis Admin user will correctly show account status when edited

## 8.13.30 - 20th July 2023

### Bug fixes

- !1380 SRCH-13 Disco 040448 Fixed People advanced search results for exact matches with the "Extranet", "Username", or "Email" fields
- !1380 BT-4158 Fixed reindexing users for search when changing their extranets in the Extranet admin panel
- !1380 BT-4153 Fixed a design issue with the "username" field in People advanced search
- !1382 BT-4062 Removed the Skype buttons from the user's profile pages
- !1388 BT-4170 Disco 042382 Fixed an InfoCapture issue when checking triggers with multiple field conditions
- !1390 BT-4172 Fixed an issue processing IC notifications that used deleted triggers

### Breaking changes

- !1380 SRCH-13 BT-4155 Added method `AdvancedQueryBuilderInterface::MatchTerm()` to expose wildcard queries for matching fields that contain an exact search term
- !1382 BT-4062 Removed the legacy `PeopleSkypeMeButton` Templater component from the codebase

## 8.13.29 - 14th July 2023

### Improvements

- !1298 IC-99 InfoCapture: Improved trigger processing performance
- !1376 BT-4042 Improved performance when loading large number of groups in the People application

### Bug fixes

- !1374 BT-4107 Fixed a bug where a deleted group could cause InfoCapture notifications to be sent to the wrong users
- !1378 BT-3930 Fixed InfoCapture Multiple select field minimum width issue

### Developer notes

- !1351 BT-3985 Added new method `ICStatusGroup::GetAllMembers()` for loading the members of multiple InfoCapture Status Groups
- !1376 BT-4042 Changed the signatures of the `AdminListController::ShowGroupsSubtree()` and `AdminListController::ShowGroupsSutreeWrap()` methods
- !1359 EVNT-5 Added a new option for disabling link truncation for several `ClaText` methods and the BBCode parser
- !1377 FRAM-917 Added the `__debugInfo()` function and `$sensitive_data` property to the `Claromentis\Core\DAL\DB` class to be able to hide sensitive data from being returned by debug statements
- !1374 BT-4107 Fixed ACL's `UsersReader::GetUserIds()` method treating deleted `Group[+]` entries as "no filter", unintentionally returning all users in the system

## 8.13.28 - 16th June 2023

### Bug fixes

- 77e349a4 FRAM-909 Fixed further issues with the CLC Release command incorrectly processing some cleanup lines

## 8.13.27 - 14th June 2023

### Improvements

- !1341 DMS-18 Disco 039781 Changed the "Subject line" text in the Documents workflow notification email to "Document Workflow Notification" and added localization for it
- !1347 IC-112 Minor performance improvement when rendering issue lists for InfoCapture projects that use plugins
- !1338 BT-3972 Ensured that SSO user provisioning is recorded in the audit log

### Bug fixes

- !1336 BT-3478 Fixed a bug that caused the back button not to be displayed on the People Admin panel
- !1357 BT-4013 Disabled importing events to Internet Calendars in the Calendar application
- !1353 BT-3997 BT-4020 Disco 041152 Removed the `Reply-To` header from system emails and changed the sender of "New News article" notifications to "system" instead of the article author
- !1362 BT-4026 Disco 041324 CSV users import: fixed a bug where existing users did not receive generated passwords via email
- !1369 BT-3499 Disco 040901 Fixed incorrect visibility permissions for InfoCapture Projects that use plugins
- d36f3ce2 Fixed minor issues with CLC's release command when matching unreleased change log headings
- !1371 BT-4106 Fixed issue where a new user logging in via SSO with directory provisioning could result in duplicate accounts being created
- !1365 FRAM-909 Fixed the CLC Release command incorrectly processing some clean-up lines

### Developer notes

- !1338 BT-3972 Added event dispatching to `CreateSSOUser` use case to ensure the creation of SSO users is audit logged
- !1347 IC-112 Optimized `\ICIssuesListProvider::GetPermissionsFilters()` to only call InfoCapture plugins for issue list permission filters when the authenticated user has permission to view the respective project
- !1364 FRAM-915 MSSQL: Fixed new columns not applying their default values to existing rows during database migrations

## 8.13.26 - 5th May 2023

### Improvements

- !1352 BT-4201 Added ability to provision a new SSO user and attach them to a configured LDAP directory and sync them on initial login

### Bug fixes

- !1314 CAL-3 Fixed missing time zone data in Calendar's ICS files in emails and exports
- !1342 FRAM-903 Added a new configuration option to enable/disable autocomplete for login fields
- !1348 BT-3960 Fixed creating or editing calendars multiple times by disabling form submissions after the first submission
- !1349 BT-4023 Fixed background image inheritance regression for Themes
- !1350 BT-3980 Fixed PHP's `memory_limit` configuration being used for CKFinder's front-end file upload size limit, `uploadMaxSize`, when it was less than PHP's `upload_max_filesize` and `post_max_size` configurations
- !1355 BT-3963 Changed the default timezone for guest users to be the same as the system's timezone
- !1350 BT-3980 Fixed the CKFinder file upload file size limit not matching server configurations

### Developer notes

- !1314 CAL-3 Added the time zone specifiers to the `DTSTART` and `DTEND` attributes in Calendar's ICS files
- !1350 BT-3980 Fixed PHP's `memory_limit` configuration being used for CKFinder's front-end file upload size limit, `uploadMaxSize`, when it was less than PHP's `upload_max_filesize` and `post_max_size` configurations
- 274bcd4c FRAM-100 SDB1371 `clc release` no longer increments the major schema version for minor application releases
  - Reverts 080860e6 and brings our release process in line with [semantic versioning](https://semver.org/)
- bcdf4721 Disabled Composer plugins by default, unless specified in `composer.json`
  - Fixes upstream CI failures for [Claromentis](https://gitlab.com/claromentis/product/claromentis) (e.g. `composer phpunit`, `composer phpcs`) when adding its own Composer plugins that Core doesn't know about
- !1352 BT-4201 Also required a change in the LoginHandler module, see Loginhandler MR !33 for the changes

## 8.13.25 - 14th April 2023

### Bug fixes

- d7414d71 BT-3874 Disco 041008 Fixed regression that prevented correct holiday request approval

## 8.13.24 - 12th April 2023

### Improvements

- !1315 IC-100 InfoCapture: Added support for "Mailbox format" addresses for the "From" address for email notifications, e.g. `Name <name@example.com>`

### Bug fixes

- !1305 BT-3865 Fixed issue where if a document component failed to save, a document database record would still be created and left in a state where it could not be edited or deleted
- !1330 BT-3976 Disco 040953 Disco 041084 Fixed file not found error when uploading logos to the design admin panel
- !1321 BT-3962 Fixed issue where default Claromentis fields could not be mapped to AD fields in LDAP config
- !1316 FRAM-898 Updated some some older bundled libraries in favour of npm versions

### Developer notes

- !1323 Improved migration logging, added SQLite database check
  - Updated roll-up migrations to use the `notice` log level, instead of `info`
  - Deprecated method `Claromentis\Setup\Db\Migrations\MigrationsBase::Log()`
  - Added database check for SQLite database driver (filesystem permission checks)
  - Ensured database checks run for all SQL Server drivers (Native Client `mssql_nc`, ODBC `mssql_odbc`, Sybase `mssql_sybase`)
- !1316 FRAM-898 Removed outdated Backbone and Underscore libraries from /web/intranet/js/ and SlickGrid from /web/lib/slickgrid.
  - These are now available via Core's NPM dependencies
  - `'backbone'` and `'slickgrid'` can both be `require()`d from front-end code
  - Underscore is already part of `vendor.js`, available on most pages

## 8.13.23 - 8th March 2023

### Improvements

- !580 FRAM-339 Added push notifications option to the test notification utility
- !1296 BLOG-2 Added a like component for blogs
- !1317 EVNT-57 Improved error handling when Calendar event HTTP requests fail
- !1312 FRAM-897 Updated JQuery validation library

### Bug fixes

- !1311 BT-3843 Fixed script injection issue in role and group pickers
- !1319 BT-3938 Fixed PHP notices shown when search recommendations in admin had partial data

### Developer notes

- !580 FRAM-339 Added push notifications to the test notification utility
  - The function of actually sending OneSignal messages has been moved to a new `OnesignalClient` class
  - `OnesignalSubscriber::SendPush()` has been removed
- !1317 EVNT-57 Implemented default error handler for `jQuery.ajax()` requests

## 8.13.22 - 7th February 2023

### Improvements

- !1285 BT-3867 Prevented archived InfoCapture issues from being indexed for Global Search
- !1302 BT-3884 Changed CKEditor table default settings to match Bootstrap style
- eee046d8 Improved theme resilience to incorrectly migrated style data

### Bug fixes

- !1278 BT-3815 Added audit logging when users are removed from groups
- PPL-38 People API: Fixed missing metadata values for the currently authenticated user
- !1287 BT-3876 Disco-039923 Fixed a bug where a new added user has not been recorded in audit logs
- !1288 BT-3893 Fixed InfoCapture post-import redirect to new project
- !1290 BT-3574 Fixed duplicated skills on the page `Skill Search`
- !1293 BT-3873 Fixed issue where documents in the docs trashcan could not be permanently deleted
- !1300 BT-3919 OneSignal notification permissions sometimes did not get registered in the Claromentis instance
- !1306 FRAM-161 Fixed duplicate search indexing via CLC

### Merged forward from 8.12.28

#### Improvements

- !1292 FRAM-869 Updated jQuery UI from 1.12.1 to 1.13.2

#### Bug fixes

- !1303 FRAM-899 Design admin panel: Improved image validation when updating theme background images, logos, and favicons

#### Developer notes

- !1292 FRAM-869 Added `jquery-ui` as an NPM dependency

## 8.13.21 - 10th January 2023

### Merged forward from 8.12.27

#### Bug fixes

- RD-41 FRAM-867 Fixed unescaped comments throughout the system

#### Developer notes

- Updated Composer configuration and `composer.lock` for Claromentis pipelines

## 8.13.20 - 10th January 2023

### Improvements

- !1063 UIUX-761 News article summaries are now included in the `content` field of News RSS feeds
- RD-41 Excluded the value of the raw user directory configuration variable, `cfg_users_directories`, from the configuration editor

### Bug fixes

- !1279 BT-3811 Fixed error growl message "Location is too long" in Internet calendar when location field is longer than 255 characters
- !1280 Disco 038997 Fixed double-encoding of string metadata fields in search results when used as one of the top three user profile fields
- faf67219 BT-3593 Fixed regression that prevented some Select2 dropdowns from initializing correctly, such as the guest selector when creating a Calendar Event
- 79d8bf9f Back-ported fix for SQLite adapter removing columns when column alteration was used only to change a column's type
- !1261 IC-80 Fixed JavaScript errors in InfoCapture external form
- !1282 BT-3862 Hide an additional field with user profile image on the page `Edit User Profile`
- !1266 BT-3733 Fixed an issue where changes to unified permissions were not correctly propagated to inheriting objects, causing menu trees to become unmodifiable
- 85b4475d Prevented failed theme background image migrations from causing fatal errors
- eb4f835a BT-3868 Fixed warnings in Global Search caused by InfoCapture issues that have no indexed content
- !1243 DAM-1 Allow generation of thumbnails from PDFs files

### Developer notes

- 85b4475d Improved return type safety for `Claromentis\Design\Style\InheritableStyle::GetBackgrounds()` and `Claromentis\Design\Style\Option::GetBackgrounds()`

## 8.13.19 - 14th December 2022

### Bug fixes

- !1275 BT-3853 Disco 39819 Fixed fatal error that could happen when editing an issue with a prefixed ID

## 8.13.18 - 8th December 2022

### Improvements

-  9f924671 Documents' permission flags option is now only configurable via the front-end when developer mode is enabled
- !1249 IC-76 Implemented support for "multiple user list" and "multiple select" fields as searchable in InfoCapture advanced search

### Bug fixes

- !1259 BT-3741 Fixed issue when deleted documents are not displayed in the trash can
- !1265 BT-3795 Fixed inability to approve holiday request cancellation when their quota usage is reduced to 0 by common holidays
- Emailing a user log-in details from Admin user profile edit always reported "your password has not changed"
- !1263 BT-3794 Disco 039520 Log and clear unexpected InfoCapture form data errors when saving InfoCapture issues

## 8.13.17 - 10th November 2022

### Improvements

- !1228 PPL-24 Disco 032415 Disco 039066 Implemented support for random password generation and credential emails for users imported from CSV files
- !1239 NEWS-1 Added article summaries to News notifications
- !1245 BT-1984 The allowed length for URLs in legacy publish menus has been increased to 1024 characters(bytes) in length from 255
- ae334085 Improved error logging for failures when creating SSO users
- 5b8d3589 Added `CLARO_DB_OPTIONS` environment variable for configuring `cfg_db_extra_options` using JSON
- !1252 PPL-52 Implemented minor performance improvement for user directory sync when blocking users
- !1214 IC-70 Implemented migration to remove InfoCapture issues without form data, improved error handling when creating issues

### Bug fixes

- !1236 BT-3595 Disco 038890 Fixed a potential system error in the Room Booking Locations admin panel
- !1242 BT-3618 Fixed broken image URLs in News RSS Feed
- !1238 BT-3593 Fixed element focus on the search field of Select2 components ([select2/select2#5993](https://github.com/select2/select2/issues/5993))
- !1244 FRAM-860 Disco 038995 Fixed XSS vulnerability in folder tree component
- !1221 BT-3476 Disco 038130 Fixed rewriting previously mapped AD attributes when the fetch button has been clicked
- !1253 BT-3606 Fixed edge case when sanitising HTML
- !1214 IC-70 Fixed InfoCapture creating issues without form data when database errors occur

### Developer notes

- 5b8d3589 Wrote [database configuration documentation](docs/technical/configuration/database.md)

### Merged forward from 8.11.26, 8.12.25

#### Bug fixes

- !1213 BT-3486 Disco 37920 Fixed issue where InfoCapture timers that had fired in the past were not reset when the timer threshold was changed. Also fixed edge-case issue where timer triggers that should fire while saving a ticket did not do so due to outdated timer data.

#### Developer notes

- !1213 BT-3486 Disco 37920 A small refactor was included to move the InfoCapture timer trigger code from the global `apply_assigning_to_issue()` function, into `ICIssueProcessor::ApplyAllTriggers()`. Usages in Core were updated, and the original function was deprecated but otherwise left as-is in case some existing code relies on it.

## 8.13.16 - 5th October 2022

### Improvements

- !1231 BT-3473 Clarified that InfoCapture notifications to specified email addresses will use CC
- !1230 BT-3550 Implemented displaying end dates for multi-day events in the Calendar component

### Bug fixes

- f7323828 FRAM-600 Fixed edge-case theme style migration error from !1217 for when theme background URLs are empty strings
- fcc47a4b FRAM-72 BT-3505 Fixed InfoCapture plugin error messages not displaying properly in some cases
- !1234 BT-3571 Fixed issue with News 'Submit news' and 'Save as draft' buttons so they are disabled on click and disallow multiple submissions of an article
- !1222 BT-3265 Disco 036171 Fixed new InfoCapture issues trigger status-change actions before being submitted

### Merged forward from 8.11.26, 8.12.25

#### Bug fixes

- !1213 BT-3486 Disco 37920 Fixed issue where InfoCapture timers that had fired in the past were not reset when the timer threshold was changed. Also fixed edge-case issue where timer triggers that should fire while saving a ticket did not do so due to outdated timer data.

#### Developer notes

- !1213 BT-3486 Disco 37920 A small refactor was included to move the InfoCapture timer trigger code from the global `apply_assigning_to_issue()` function, into `ICIssueProcessor::ApplyAllTriggers()`. Usages in Core were updated, and the original function was deprecated but otherwise left as-is in case some existing code relies on it.

## 8.13.15 - 9th September 2022

- !1226 BT-3500 Implemented audit logging for InfoCapture project creation and update failures
- Removed legacy "Sending email" from System audit log categories

### Bug fixes

- !1209 BT-3425 Fixed duplicate key errors when importing InfoCapture projects from files
- !1208 BT-3361 Fixed filtering for "Date no year" user profile fields in People application
- !1220 BT-3541 Disco 038491 Fixed an issue where certain Document workflows could cause errors in the background task
- !1219 BT-3538 Fixed an issue where syncing from LDAP groups containing certain characters would fail
- !1217 FRAM-600 Fixed theme style migration losing theme background images when upgrading from legacy versions of Core
- !1226 BT-3500 Fixed database errors when creating InfoCapture projects with names longer than the 160 character limit
- !1225 BT-3555 Fixed unescaped text in Blog notifications
- cf6e5e15 BT-3563 Fixed unescaped text for the "Submitter" and "Assigned To" fields of InfoCapture issue lists
- 8434736f Fixed an edge-case error when failing to send InfoCapture notification emails to guest addresses (caused by df789000)

### Developer notes

- !1110 FRAM-152 Back-ported `SetupFacade::getLogger()` from 9.0 for direct access to the migrations logger, allowing developers to use different log levels from migration scripts

## 8.13.14 - 25th July 2022

### Improvements

- 2bd4f0ad Back-ported updated server checks in **Admin > System > Labs > Check Server Configuration** from 8.13 (a2d1b311)
- a3ee2588 Tweaked Google Documents picker to log authentication errors
- !1204 FRAM-600 Improved logging for the theme style migration
- !1206 FRAM-847 Implemented support for SQL Server High Availability connection parameters for the MSSQL Native Client database adapter
  - Set `cfg_db_extra_options['mssql_application_intent']` to `'ReadWrite'` or `'ReadOnly'` to set the `ApplicationIntent` connection parameter
  - Set `cfg_db_extra_options['mssql_multi_subnet_failover']` to `'Yes'` or `'No'` to set the `MultiSubnetFailover` connection parameter
  - Set `cfg_db_extra_options['mssql_transparent_ip_resolution']` to `'Enabled'` or `'False'` to set the `TransparentNetworkIPResolution` connection parameter
- !1138 FRAM-813 RD-31 Password recovery changes to not expose invalid email addresses or directory users

### Bug fixes

- !1200 CAL-2 Updated navbar clock URL to show the current day in the Calendar application
- !1202 BT-3452 Fixed regression that prevented selecting a default calendar
- !1199 BT-3435 Disco 037631 Fixed InfoCapture issue where bulk updating tickets resulted caused their last updated date to be set to their creation date
- !1201 BT-3270 Show "Public" access to theme on themes list
- !1205 FRAM-845 Updated Google Picker integration for Google Document Links
- !1164 BT-2980 The IC report prefilter for user fields was not working with the "Myself" option.
- !1167 BT-2824 People advanced search extranet select caused a JavaScript error

### Developer notes

- bb2098c2 Fixed class autoload errors for `QueryInsert` and `QueryUpdate` classes when using `FBSection` in migrations
- Fixed and updated CODEOWNERS rules for directories, added rules for CI/CD related files in the codebase
- Minimized noisy stack traces from XDebug on the command-line
- !1138 FRAM-813 RD-31 Moved password recovery data from per-user metadata and User methods to its own table and repository

### Merged forward from 8.11.25, 8.12.24

#### Bug fixes
- !1203 BT-3363 Fixed an issue where users created via LDAP sync were not receiving the correct default notification settings

#### Developer notes

- !1203 BT-3363 did not introduce a breaking change, but any custom LDAP plugins that either completely override `UpdateExternalUser` or subclass it and replace the `CreateNewUser` method will need to be updated to include the notification settings fix.


## 8.13.13 - 30th June 2022

### Improvements

- !1189 CAL-1 Implemented automatic synchronization for internet calendars

### Bug fixes

- !1197 BT-3410 BT-3411 Fixed sorting by assignee and reporter on the InfoCapture tickets list
- 82e7ced5 BT-3082 Back-ported fix for fatal error when accessing Room Booking with the latest version of JPGraph
- !1198 FRAM-795 Back-ported fix for the filesystem abstraction preventing SQLite connections
  - 4525f540 Back-ported fix for schema files failing to build during releases due to global `$db` pollution
  - fa2c2990 Back-ported fix for SQLite column alterations failing to retain existing column descriptions when a new column description is omitted

### Developer notes

- !1189 CAL-1 Added system config variable `$cfg_calendar_hours_between_sync` - number of hours between each calendar synchronization
- Replaced `CLARO_ENV_MODE` with `CLARO_ENV` in .env files at valid file paths; migration for Tech Ops
- Suppressed logging usage of deprecated environment variables

### Merged forward from 8.10.27, 8.11.24, 8.12.23

#### Improvements
- !1186 FRAM-800 wkhtmltopdf 0.12.6 compatibility for Holiday Planner and InfoCapture PDF export features

#### Developer note
- !1186 RD-31 Fixed SSRF vulnerability

## 8.13.12 - 16th June 2022

### Improvements

- !1194 FRAM-62 Improved support information in **Admin > System > General**
- !1187 BT-3376 Disco 037088 Added ability to provide formatting of dates without year to be synced from user directories

### Bug fixes

- b82b32fe BT-3415 Fixed encoding issue for permission picker autocomplete suggestions

### Developer notes

- !1187 BT-3376 The interface `UserDateProviderInterface` has changed and now requires a new method to be implemented `GetDateNoYearFormat` which dictates the formatting of dates without years.

## 8.13.11 - 6th June 2022

### Merged forward from 8.10.26, 8.11.22, 8.12.22

#### Bug fixes

- !1192 BT-3405 Documents compatibility with Chrome 102

## 8.13.10 - 31st May 2022

### Bug fixes

- !1174 FRAM-640 Module dependencies were not being saved.
- 5fbddbf5 BT-3328 Improved localisations on menu builder form
- 5a74645d Fixed browsers auto-filling passwords when editing user profiles
- 4d661a0d Fixed browsers auto-filling passwords when changing the current user's password
- !1181 BT-3303 Disco 036452 Fixed double-encoding issues for permission pickers and user/group/role (SUGRE) pickers
- 612d8765 BT-3364 Disco 037043 Fixed debug logging breaking partial file sending, e.g. video files in Documents
- !1188 BT-3390 disco 037224 disco 037131 Fixed issue where SSO users could end up not attached to an extranet if an error was encountered on first login

### Developer notes

- 5070d952 FRAM-100 Added missing inherent `NullLogger` to `MigrationFiles` setup task, which would cause errors for custom module releases
- f60787e2 Replaced PSR-0 `web/lib/` Composer autoloader configuration with class map

## 8.13.9 - 4th May 2022

### Improvements

- !1183 PPL-44 BT-3264 In a user's My Settings page, the "Change Password" section is now called "Authentication" and shows a suitable message if a user's account password is managed via a directory

### Bug fixes

- !1182 BT-3348 Fixed issue where LDAP users could become blocked during a sync if their sAMAccountName was changed in AD
- !1178 BT-3309 Added localisation for hardcoded phrases in IC notification
- 9ba22e39 Back-ported tooling fixes from Claromentis 9
  - 36bb43e3 FRAM-538 Fixed CLC's MySQL database permission checks
  - 36bb43e3 Fixed CLC script using `realpath -s`; `-s` is not available on Alpine Linux

### Developer notes

- 38a07961 FRAM-100 `clc release`: Added logging for the number of commits since previous releases
- 862a9188 FRAM-100 `clc release`: Fixed sorting of pre-release versions when finding previous versions

## 8.13.8 - 8th April 2022

### Bug fixes

- Re-release to ensure that file cleanup will be performed correctly

### Developer notes

- b100e3bc FRAM-829 Fixed `clc release` command finding previous versions from the latest tag instead of the most significant version tag
- 4eacffcf FRAM-830 Fixed `clc release` command not generating a new schema file when the schema version has been incremented
- 73f3cb2d FRAM-831 Fixed legacy `clc release:major` and `clc release:minor` commands not capturing input values

## 8.13.7 - 7th April 2022

### Bug fixes

- !1175 BT-3323 Added equipment back into room booking diagram, but with a limit of 200 total items to prevent errors

### Merged forward from 8.12.20

#### Improvements

- 65b6b20a Updated map of known file extensions and MIME types (`$arExtensions`)
- !627 BT-967 Deleted user group attaches any child groups to its parent instead of changing them to a root-level group
- !1170 PPL-13 PPL-45 Allowed filtering users by `user_code` and `language` fields via People API v2
- !1159 BT-3237 Using the design change link to automatically set a theme and redirect now allows redirects to a Pages page

#### Bug fixes

- !1137 BT-3113 Fixed issue with words breaking in random places in document description.
- !1168 BT-3278 Gallery: Placeholder images are now shown if resized versions fail to be created
- !1161 BT-2167 Fixed issue with behaviour of some fields when editing Infocapture forms
- !1163 BT-3272 Updated the default list of permitted upload files. The list can also now be edited in the config editor.
- !572 !1176 BT-659 Disco 026016 Fixed "Edit user info" page errors when attempting to display unknown user fields

#### Developer notes

- !1168 BT-3278 `ImageFiles->GetImageFilePath()` may now return `null` instead of a path string if an error was encountered when finding or attempting to generate `_large`, `_medium`, `_small` or `_thumb` versions of Gallery images. Usages have been updated in Core. Your code should handle `null` return values accordingly, either by showing a placeholder image or an error message.
- !1159 BT-3237 Added `ThemeAndLangController->IsScriptUrlAllowed()` and `ThemeAndLangController->GetWhitelistedPaths()`
  to allow us to define whitelisted top-level redirect paths more easily and possibly auto-add all module paths at some point
- !1166 FRAM-100 Implemented `clc release` command for application releases - supersedes `clc release:major` and `clc release:minor`

## 8.13.6 - 8th March 2022

- 5207f6f9 Fixed CDN database cache issue that prevented theme assets migrating properly
- 5207f6f9 Fixed Core cleanup tasks using the wrong base path

## 8.13.5 - 3rd March 2022

### Bug fixes

- !1151 BT-3203 Fixed error in room booking caused by large numbers of bookable objects
- !1153 IC-72 Fixed incorrect plugin status messages for InfoCapture Projects that did not have a plugin set
- !1153 IC-72 Fixed inappropriate form and data modification exceptions for InfoCapture plugins caused by caching from IC-69

### Developer notes

- The fix for BT-3203 involved removing equipment and services from the availability diagram in services. Should these need to be added back in future, there's only a couple of lines that need to be changed which can be found in commit d725f73d03d2907a67a0f394bc1b8c19372e57fa
- !1174 FRAM-640 The framework supported blocking modules where a dependent module was disabled/uninstalled but this info was not written to plugins.json for new module installs.

### Merged forward from 8.12.19, 8.11.21

#### Improvements

- !1126 BT-2983 Documents: Some types of document links from OneDrive/Sharepoint now will be viewable in document previews

#### Bug fixes

- !1149 BT-2421 Fixed an issue where user names were not included in Holiday Planner audit logs
- !1148 BT-3163 Removed CKEditor's spell checker feature to avoid crashes
- !1155 BT-3174 Fixed certain InfoCapture user profile links breaking when project codenames were used
- !1160 BT-3213 Deleting a room booking could throw a "Wrong integer" error
- !1157 BT-3207 Fixed issue where some events were not displayed on the calendar day view due to timezone differences
- !1158 BT-2999 Fixed InfoCapture issues being assignable to blocked users
- !1154 BT-3170 Back-ported fix from 8.13 for error when creating Calendar events with attendance selected
- !1154 BT-3170 Back-ported fix from 8.13 for on-the-fly contact creation when creating Calendar events with guests

#### Breaking changes

- !1158 BT-2999 InfoCapture permission checks that used plugin `GetUsersWithAllRights()` calls used to include blocked users from roles, since 8.12.0. This regression has been fixed, but custom plugins should be checked for any dependence upon this behaviour.

#### Developer notes

- afe2851dd Updated PHP version checks in the System admin panel to check for PHP 7.4.0+

## 8.13.4 - 26th January 2022

### Bug fixes

- !1140 BT-3170 Fixed error when creating Calendar events with attendance selected
- !1140 BT-3170 Fixed on-the-fly contact creation when creating Calendar events with guests
- !1143 BT-3175 The homepage set in the global design settings was being ignored

### Merged forward from 8.9.24, 8.10.25, 8.11.20, 8.12.18

#### Bug fixes

- !1136 FRAM-812 RD-31 Fixed open redirect from login page

## 8.13.3 - 13th January 2022

### Improvements

- !1117 IC-69 Improved performance for InfoCapture plugins
  - Implemented caching for InfoCapture plugin instantiation
  - Optimised loading field condition sets for InfoCapture projects

### Merged forward from 8.9.23, 8.10.24, 8.11.19, 8.12.17

#### Improvements

- 1c6737e5 FRAM-811 Updated Bugtracker URL to use HTTPS (`cfg_error_reporting_url`)

#### Bug fixes

- !1100 FRAM-778 Exported design themes no longer include paths for background images
- !1132 BT-3136 Back-ported fix for undefined index error on Documents homepage and Documents detail pages
- !1130 FRAM-808 RD-31 Improved uploaded file validation in comments system

### Merged forward from 8.9.23

#### Improvements

- 1c6737e5 FRAM-811 Updated Bugtracker URL to use HTTPS (`cfg_error_reporting_url`)

## 8.13.2 - 15th December 2021

### Bug fixes

- 2369becc 56f318ab PPL-43 BT-2441 Disco 035547 Fixed fatal error when creating SSO users

## 8.13.1 - 9th December 2021

### Merged forward from 8.9.22, 8.10.23, 8.11.18, 8.12.16

#### Bug fixes

- !1107 DISCO-034847 Fixed issue with errors being hidden when generating a PDF for an Infocapture ticket fails
- !1114 BT-3078 DISCO-035077 Fixed missing pagination on Blog listings
- !1116 BT-3080 Fixed error when searching for documents via tags
- !1118 BT-3081 DISCO-035016 Fixed bug in room booking that prevented bookings being approved when localisation was French
- !1122 FRAM-803 RD-31 Fixed config editor issue

#### Developer notes

- d9224056 FRAM-652 Deprecated global constants `JOIN_TYPE_INNER` and `JOIN_TYPE_LEFT_OUTER`. Use `DAL\Db::JOIN_TYPE_INNER` and `DAL\Db::JOIN_TYPE_LEFT_OUTER` instead.

## 8.13.0 - 9th November 2021

### New features

- !1043 FRAM-717 Added `CLARO_SYSTEM_NAME` and `CLARO_SYSTEM_EMAIL` environment variables

### Improvements

- !1025 DS-90 Updated Component Library from 0.2.2 to 0.2.4
- !1043 FRAM-717 Added `CLARO_ENV` as the canonical "environment" environment variable, deprecated `CLARO_ENV_MODE`
- !1065 FRAM-402 Updated NPM dependencies
- !1092 FRAM-718 Updated jQuery from 3.4.1 to 3.6.0, jQuery Migrate from 3.1.0 to 3.3.2, and FullCalendar from 3.0.1 to 3.10.2
- !986 FRAM-600 Improved tidy up of temporary assets when updating Theme's styles.
- !1096 FRAM-452 FRAM-548 Enabled optimized Composer autoloader for production builds

### Breaking changes

- d517b238 FRAM-712 Changed default Elasticsearch version configuration to 7.x
- !986 FRAM-600:
  - Deleted class `\Claromentis\Design\Model\StyleAssetBackground`.
  - Deleted class `\Claromentis\Design\Model\StyleAssetFavicon`.
  - Updated constructor signature for `\Claromentis\Design\Repository\ThemeRepository`.
  - Remove method `\Claromentis\Design\Repository\ThemeRepository::SetCdn`.
  - Remove method `\Claromentis\Design\Repository\ThemeRepository::SetAcl`.
  - Remove method `\Claromentis\Design\Repository\ThemeRepository::SetStorageFactory`.
  - Updated method signature `\Claromentis\Design\View\StyleDialog::UploadLogo`.
  - Updated method signature `\Claromentis\Design\View\StyleDialog::UploadBackground`.
  - Updated method signature `\Claromentis\Design\View\StyleDialog::UploadFavicon`.
  - Updated constructor signature for `\Claromentis\Design\ThemeStyle`.
  - Updated constructor signature for `\Claromentis\Design\ThemeStyleNoPages`.
- !1096 FRAM-452 FRAM-548 Removed all JPGraph classes and other library code from `web/lib/jpgraph`. **Do not use JPGraph**, use HighCharts or another front-end graph library instead.
- !1096 FRAM-658 Removed unused `web/intranet/diagram` code
- !841 FRAM-493 `\Claromentis\Core\REST\RestExceptionListener::__construct`: Signature changed.

### Developer notes

- aa77b11d 2cd2766c Updated all Composer dependencies to their latest versions
- d38fde66 Deprecated `ICRoleBrowser`, please use the `IcAcl` supplied by the `HDProject` object instead
- 2406f7bd Deprecated `$audit_structure` global variable, please use the `ApplicationAuditConfig` interface instead
- !974 FRAM-686 \[Back-ported from v9.0\] Implemented user entity retrieval via `SecurityContext::getUserEntity()`
- !1015 FRAM-625 Added composer dependency `webmozart/assert`
- !1017 FRAM-734 Introduced utility method for generating `DateTimeInterface`s from incomplete `ISO 8601` date strings
- !1029 FRAM-740 Introduced utility service for localizing units of time.
- !1026 FRAM-738 `null` default values for boolean database columns are now supported.
- !1037 FRAM-742 Introduced utility method for converting `\DateInterval`s into [ISO 8601 duration](https://en.wikipedia.org/wiki/ISO_8601#Durations) strings.
- !1043 FRAM-717 Environment variable improvements
  - `CLARO_ENV_MODE` environment variable deprecated in favour of `CLARO_ENV`
  - `CLARO_ENV`/`CLARO_ENV_MODE` now support values `"DEV"` and `"DEVELOPER"` case-insensitively
  - Added support for `CLARO_SYSTEM_NAME` and `CLARO_SYSTEM_EMAIL` environment variables
    - These are **not** written to `.env` after fresh installation
  - Improved documentation for environment variables and configuration
  - Warnings will be logged to the `system` log when deprecated environment variables are in use
  - The default system name is now "Claromentis Digital Workplace"
  - The default system email is now "noreply@claromentis.com"
- !1051 FRAM-756 Added [myclabs/deep-copy](https://github.com/myclabs/DeepCopy) dependency.
- !986 FRAM-600 Refactored theme asset storage
  - Refactored Style asset storage to no longer use CDN urls.
  - Style assets are now indexed by colloquial resolutions for easier filtering and identification.
- !1092 FRAM-718 Asset build improvements
  - Introduced support for production asset builds using `clc assets:build -p` (`webpack -p`)
  - Deprecated `clc assets:watch` in favour of `clc assets:build -w`; it will be removed in 9.0
- 61f12237 52f65d51 8a2b0a72 ddd2207e 002fe26d FRAM-766 Added GitLab CODEOWNERS file (`.gitlab/CODEOWNERS`) to enforce code review for important paths in the codebase
- !1096 FRAM-452 FRAM-548 Added [amenadiel/jpgraph](https://github.com/HuasoFoundries/jpgraph) Composer dependency, JPGraph's Composer-friendly and PSR-friendly cousin, to replace `web/lib/jpgraph`.
- d96152c1 Ensured that /intranet/rest endpoints can generate routed URLs

## 8.12.28 - 7th February 2023

### Improvements

- !1292 FRAM-869 Updated jQuery UI from 1.12.1 to 1.13.2

### Bug fixes

- !1303 FRAM-899 Design admin panel: Improved image validation when updating theme background images, logos, and favicons

### Developer notes

- !1292 FRAM-869 Added `jquery-ui` as an NPM dependency

## 8.12.27 - 10th January 2023

### Bug fixes

- RD-41 FRAM-867 Fixed unescaped comments throughout the system

### Developer notes

- Updated Composer configuration and `composer.lock` for Claromentis pipelines

## 8.12.26 - 7th December 2022

### Merged forward from 8.11.27

#### Bug fixes

- !1269 RD-40 Added fix for appdata path validation vulnerability

#### Improvements

- !1251 FRAM-859 Upgraded AngularJS library to version 1.8.3

#### Developer notes

- !1251 FRAM-859 As well as upgrading AngularJS, the common `angular-resource`, `angular-route` and `angular-sanitize` directives were added to the `cla_angular` webpack bundle for use by modules without having to install their own version
  The upgrade from 1.7.9 should be backwards compatible if any module was missed

## 8.12.25 - 28th September 2022

### Merged forward from 8.11.26

#### Bug fixes

- !1213 BT-3486 Disco 37920 Fixed issue where InfoCapture timers that had fired in the past were not reset when the timer threshold was changed. Also fixed edge-case issue where timer triggers that should fire while saving a ticket did not do so due to outdated timer data.

#### Developer notes

- !1213 BT-3486 Disco 37920 A small refactor was included to move the InfoCapture timer trigger code from the global `apply_assigning_to_issue()` function, into `ICIssueProcessor::ApplyAllTriggers()`. Usages in Core were updated, and the original function was deprecated but otherwise left as-is in case some existing code relies on it.

## 8.12.24 - 25th July 2022

### Merged forward from 8.11.25

#### Bug fixes
- !1203 BT-3363 Fixed an issue where users created via LDAP sync were not receiving the correct default notification settings

#### Developer notes

- !1203 BT-3363 did not introduce a breaking change, but any custom LDAP plugins that either completely override `UpdateExternalUser` or subclass it and replace the `CreateNewUser` method will need to be updated to include the notification settings fix.

## 8.12.23 - 29th June 2022

### Merged forward from 8.11.24, 8.10.27

#### Improvements
- !1186 FRAM-800 wkhtmltopdf 0.12.6 compatibility for Holiday Planner and InfoCapture PDF export features

#### Developer note
- !1186 RD-31 Fixed SSRF vulnerability

## 8.12.22 - 6th June 2022

### Merged forward from 8.10.26, 8.11.22

#### Bug fixes

- !1192 BT-3405 Documents compatibility with Chrome 102

## 8.12.21 - 8th April 2022

### Bug fixes

- Re-release to ensured that 8.12.20 file cleanup will be performed correctly

### Developer notes

- b100e3bc FRAM-829 Fixed `clc release` command finding previous versions from the latest tag instead of the most significant version tag
- 4eacffcf FRAM-830 Fixed `clc release` command not generating a new schema file when the schema version has been incremented
- 73f3cb2d FRAM-831 Fixed legacy `clc release:major` and `clc release:minor` commands not capturing input values

## 8.12.20 - 7th April 2022

### Improvements

- 65b6b20a Updated map of known file extensions and MIME types (`$arExtensions`)
- !627 BT-967 Deleted user group attaches any child groups to its parent instead of changing them to a root-level group
- !1170 PPL-13 PPL-45 Allowed filtering users by `user_code` and `language` fields via People API v2
- !1159 BT-3237 Using the design change link to automatically set a theme and redirect now allows redirects to a Pages page
- !1137 BT-3113 Fixed issue with words breaking in random places in document description.
- !1168 BT-3278 Gallery: Placeholder images are now shown if resized versions fail to be created
- !1161 BT-2167 Fixed issue with behaviour of some fields when editing Infocapture forms
- !1163 BT-3272 Updated the default list of permitted upload files. The list can also now be edited in the config editor.
- !572 !1176 BT-659 Disco 026016 Fixed "Edit user info" page errors when attempting to display unknown user fields

### Developer notes

- !1168 BT-3278 `ImageFiles->GetImageFilePath()` may now return `null` instead of a path string if an error was encountered when finding or attempting to generate `_large`, `_medium`, `_small` or `_thumb` versions of Gallery images. Usages have been updated in Core. Your code should handle `null` return values accordingly, either by showing a placeholder image or an error message.
- !1159 BT-3237 Added `ThemeAndLangController->IsScriptUrlAllowed()` and `ThemeAndLangController->GetWhitelistedPaths()`
    to allow us to define whitelisted top-level redirect paths more easily and possibly auto-add all module paths at some point
- !1166 FRAM-100 Implemented `clc release` command for application releases - supersedes `clc release:major` and `clc release:minor`

## 8.12.19 - 3rd March 2022

### Bug fixes

- !1149 BT-2421 Fixed an issue where user names were not included in Holiday Planner audit logs
- !1148 BT-3163 Removed CKEditor's spell checker feature to avoid crashes
- !1155 BT-3174 Fixed certain InfoCapture user profile links breaking when project codenames were used
- !1160 BT-3213 Deleting a room booking could throw a "Wrong integer" error
- !1157 BT-3207 Fixed issue where some events were not displayed on the calendar day view due to timezone differences
- !1158 BT-2999 Fixed InfoCapture issues being assignable to blocked users

### Breaking changes

- !1158 BT-2999 InfoCapture permission checks that used plugin `GetUsersWithAllRights()` calls used to include blocked users from roles, since 8.12.0. This regression has been fixed, but custom plugins should be checked for any dependence upon this behaviour.

### Merged forward from 8.11.21

#### Improvements
- !1126 BT-2983 Documents: Some types of document links from OneDrive/Sharepoint now will be viewable in document previews

#### Bug fixes

- !1154 BT-3170 Back-ported fix from 8.13 for error when creating Calendar events with attendance selected
- !1154 BT-3170 Back-ported fix from 8.13 for on-the-fly contact creation when creating Calendar events with guests

#### Developer notes

- afe2851dd Updated PHP version checks in the System admin panel to check for PHP 7.4.0+

## 8.12.18 - 26th January 2022

### Merged forward from 8.9.24, 8.10.25, 8.11.20

#### Bug fixes

- !1136 FRAM-812 RD-31 Fixed open redirect from login page

## 8.12.17 - 13th January 2022

### Merged forward from 8.9.23, 8.10.24, 8.11.19

#### Improvements

- 1c6737e5 FRAM-811 Updated Bugtracker URL to use HTTPS (`cfg_error_reporting_url`)

#### Bug fixes

- !1100 FRAM-778 Exported design themes no longer include paths for background images
- !1132 BT-3136 Back-ported fix for undefined index error on Documents homepage and Documents detail pages
- !1130 FRAM-808 RD-31 Improved uploaded file validation in comments system

## 8.12.16 - 9th December 2021

### Merged forward from 8.9.22, 8.10.23, 8.11.18

#### Bug fixes

- !1107 DISCO-034847 Fixed issue with errors being hidden when generating a PDF for an Infocapture ticket fails
- !1114 BT-3078 DISCO-035077 Fixed missing pagination on Blog listings
- !1116 BT-3080 Fixed error when searching for documents via tags
- !1118 BT-3081 DISCO-035016 Fixed bug in room booking that prevented bookings being approved when localisation was French
- !1122 FRAM-803 RD-31 Fixed config editor issue

#### Developer notes

- d9224056 FRAM-652 Deprecated global constants `JOIN_TYPE_INNER` and `JOIN_TYPE_LEFT_OUTER`. Use `DAL\Db::JOIN_TYPE_INNER` and `DAL\Db::JOIN_TYPE_LEFT_OUTER` instead.

## 8.12.15 - 4th November 2021

### Merged forward from 8.11.17

#### Bug fixes

- !1106 BT-3006 BT-3008 Fixed two issues where metadata could not be displayed for gallery albums and images
  - Added an endpoint which returns image metadata rendered as HTML
- !1106 BT-2992 Fixed indentation on repeatable metadata when displayed on a page.
- !1108 BT-3063 DISCO-034864 Fixed issue where csv files were being downloaded with .php filename extensions in Internet Explorer

#### Developer notes

- !1106 Soft break. Changed the signatures of two methods in the `ImageAlbum` class. Callers of these methods in core were updated.
  - `GetTagGroupsAsHTML`: Added `$args` and `$datasources` to the start of the method signature.
  - `GetTagsAsHTML`: Added `$args` and `$datasources` to the start of the method signature.

## 8.12.14 - 5th October 2021

### Merged forward from 8.11.16

#### Bug fixes

- !1097 BT-2894 BT-2895 BT-2916 Fixed array index errors in holiday planner reports
- !1098 BT-2920 Fixed array index error when importing calendar events with ICS files
- c127b863fa FRAM-782 Changed some text references from "LDAP" to "user directory" as we now support services other than just LDAP.
- !1101 BT-2956 Fixed bug where negative amounts in financial InfoCapture fields were failing to validate
- f3b6944b InfoCapture: Minor localization improvements
- 4f5f1b16 Documents: Fixed potential errors when deleting clipboard items

## 8.12.13 - 9th September 2021

### Merged forward from 8.11.15

#### Improvements

- !1064 BT-2432 Increased scope of previous comments improvement from 8.10.21 to include the JavaScript version of comments.

#### Bug fixes

- !1064 BT-2781 Fixed JS error when using comments templater component in some situations.

## 8.12.12 - 6th September 2021

### Bug fixes

- !1073 BT-2806 BT-2825 Disco 033906 Fixed sending InfoCapture issue notifications to users lacking the appropriate permissions

### Developer notes

- !1073 BT-2806 Disco 033906 `IcAcl::GetUsersWithAnyRights(int $rights)` no longer checks for users with any right when `$rights <== 0`
  - This was a bug was introduced by the InfoCapture permissions refactoring for 8.12.0 (!896 BT-2050)
  - **InfoCapture Plugins are expected to behave the same way**; only check the rights that are part of the bitmask given, do not default to checking all rights

### Merged forward from 8.11.14

#### Bug fixes
- !1081 BT-2640 Fixed bug where dropdowns automatically closed when opened on CK editor in IC
- !1072 BT-2827 Fixed text break issue in documents module
- !1082 BT-2520 BT-2527 Orgchart tablet/mobile device fixes

## 8.12.11 - 19th August 2021

### Merged forward from 8.11.13

#### Improvements

- !1033 FRAM-732 Disco 032890 Implemented audit logging when plugins are enabled and disabled

#### Developer notes

- !1033 FRAM-732 FRAM-547 Introduced the Plugin API: `Claromentis\Core\Plugin\Api`
  - Deprecated `Claromentis\Core\Plugin\PluginsRepository::STATUS_*` constants in favour of the new `Claromentis\Core\Plugin\Statuses` class constants
  - Deprecated `ClaApplication` class
  - `plugins.repository` is now registered in `ModulesServiceProvider` instead of `web/intranet/core/bootstrap.php`
  - Soft-break: `ApplicationIsEnabled` use case constructor signature has changed. Soon to be deprecated in 9.x; code outside of Sysadmin should not depend on it.

### Merged forward from 8.10.22

#### Bug fixes

- !1070 BT-2640 DISCO 033539 Fixed SLA timer count down, now it is showing time to next SLA status change instead stop at 0
- !1066 FRAM-759 Fixed intermittent Windows filesystem errors caused by Analogue ORM's (`analogue/orm`) misconfigured usage of the Generated Hydrator (`ocramius/generated-hydrator`) library
- 860b48cc 94208712 Restored missing per-index "Recreate mapping" options in Admin > Search > Reindexing
- da3dee40 Fixed legacy config loading using relative paths to find config files
- !1074 BT-2805 DISCO 33950, DISCO 33952, DISCO 33953 Fixed regression where email addresses inserted via IC expressions were being displayed escaped.

## 8.12.10 - 2nd August 2021

### Merged forward from 8.11.12

#### Bug fixes

- !1062 BT-2650 Liking and unliking an image in Gallery generates Audit Logs.

### Merged forward from 8.10.21

#### Bug fixes

- !1049 BT-2414 DISCO 033310 Fixed unsaved note warning when changing status of an infocapture ticket with notes disabled
- !1046 IC-61 DISCO 033339 DISCO 033401 Fixed duplicate InfoCapture notifications sent to monitoring users by Projects using date-based trigger processing
- !1050 BT-2489 DISCO 033281 Allow strings or other values in an InfoCapture expression to end with a backslash.
- !1050 BT-2567 DISCO 033455 Fixed issue with backslashes being mistakenly removed from Infocapture field default values when derived from user fields.
- !1042 BT-2595 DISCO 033108 Fixed issue with submitting user import page with too many checkboxes checked.
- !1048 PPL-34 Added case insensitive matching when searching Users by Extranet.

## 8.12.9 - 12th July 2021

### Bug fixes

- !1023 BT-2424 Fixed InfoCapture bug that prevented field values from being shown in the issue list when a user did not have view permission for all issues

### Merged forward from 8.11.11

#### Improvements

- !1016 FRAM-161 FRAM-428 Improved search indexing performance using parallelization

### Merged forward from 8.10.20

#### Improvements

- !996 FRAM-715 Audit: Scheduled Audit Log Archiving is now performed in the background task in chunks.

#### Bug fixes

- !1036 BT-2484 DISCO 031117 Document owner in the report now shows correct user (document creator) instead of one who last modified it
- !1045 BT-2498 DISCO 033370 Fixed php error in Infocapture form with public rights when a guest user attempts to submit a ticket

#### Developer notes

- !996 FRAM-715 Implemented `clc audit:archive` command for audit log archival

## 8.12.8 - 18th June 2021

### Improvements merged forward from 8.10.19

- !1032 PPL-27 People API v2 - Authenticated access by default
- Disabled People API v2 guest access by default
- People API v2 guest access is now configurable: Admin > People > Configuration

### Bug fixes merged forward from 8.9.21, 8.10.19

- !1020 IC-44 DISCO 32373 IC trigger timers are no longer reset when a ticket is saved
- b05a5f5f Fixed issue with loginhandler responses and sessions

### Breaking changes merged forward from 8.10.19

- !1032 PPL-27 People API v2 guest access is now opt-in by default

## 8.12.7 - 14th June 2021

### Bug fixes

- !1022 IC-56 Relative Roles' (*Ticket Handler*, *Ticket Submitter*) Rights' are now considered when populating notification templates with ticket data.

### Merged forward from  8.11.9

#### Improvements

- !671 BT-1285 LDAP: User searches of OUs (organisational units) are now paginated to get around the AD server restriction of 1000 results per request. User list searches were also combined into a single search, dramatically reducing the time taken to get lists of AD user accounts.
- 5b2305cd Updated CLC's minimum PHP version constraint from 7.1.0 to 7.4.0

### Merged forward from 8.10.18

#### Bug fixes

- !1019 BT-2419 Disco-32866 Fixed bug where audit log recorded an auto transition every minute when the workflow has been added to the Documents

## 8.12.6 - 28th May 2021

### Merged forward from 8.11.8

#### Bug fixes

- !999 BT-2323 Disco 31912 Disco 32439 InfoCapture: Reloading a form on change no longer causes untouched mandatory fields to be given error highlights
- !1014 BT-2392 Disco 32518 InfoCapture: Added front end validation for numbers longer than DB column length

### Merged forward from 8.10.17

#### Improvements

- !1007 BT-2402 News channels are now listed alphabetically on the admin page "Channels & Templates".
- !961 IC-46 Error that is shown when attempting to set an InfoCapture ticket's handler and status to an invalid combination is now clearer
- !966 CORE-1101
  - Added `round` function to InfoCapture expression language
  - String fields that have their format set to "numeric" or "floating point" are now treated as numbers by default in InfoCapture expressions

#### Bug fixes

- !1004 BT-2394 DISCO 32627 Fixed bug that was overwriting the author of the previous document version when a document was checked in/out
- !798 IC-34 When deleting the earliest version of an InfoCapture form, tickets can no longer be assigned to "the previous version"
- !1005 BT-2396 Fixed permission to view user's thumbnail for card view in the people list
- e5c12271 FRAM-553 Fixed cleanup/prune setup task using all cleanup files during fresh installation via `clc app:upgrade --all` or `clc app:upgrade --recover`
- !987 BT-2334 Editing an IC form with a user picker could show warnings if "Myself" was used
- !1013 BT-2422 Using a Theme with a static Page Title will no longer result in a Bookmark without a name.
- !1012 BT-2392 IC forms - added validation for numbers longer than DB column length
- !1008 BT-2386 DISCO 32177 Fixed InfoCapture SLA timers only updating when the traffic light changes (timers now update whenever the issue is viewed)

## 8.12.5 - 27th April 2021

### Bug fixes

- a7e99e33 Fixed a rare error where some global searches could fail if an application menu item is missing its title

### Merged forward from 8.11.7

#### Bug fixes

- !963 BT-2248 InfoCapture: fixed form reloading on change not working when using a plugin that validates form data
- !990 BT-2349 Disco 32241 Infocapture: Fixed deleted users causing blank entries in "assigned to"/"submitted by" filter inputs
- !992 BT-2356 Disco 32329 InfoCapture: Fixed keyword search not working when a form did not contain at least one text field
- !998 BT-2375 Disco 032434 InfoCapture: Fixed localisation on the import project page
- !997 BT-2367 Disco 32435 InfoCapture: Fixed bug where css class not getting applied to the input field in the infocapture forms

### Merged forward from 8.10.16

#### Improvements

- !733 UIUX-691 Blog Application layout improvements
  - Blog index page now has a better image layout on Desktop and Mobile
  - Blog article now has a better image display and has a lightbox for the main image

#### Bug fixes

- !724 UIUX-438 Typing out a note for an InfoCapture ticket and then attempting to leave the page will now prompt for confirmation, to avoid accidentally losing notes
- !993 BT-2359 Disco 31888 Holiday Planner: A user can no longer edit a holiday request after it has been approved or declined by a manager
- !1000 FRAM-720 Partial migrations are now able to record logs properly
- !994 BT-2305 Design panel: fixed values staying linked to master design after being edited
- c10b812a Disco 32511 Fixed audit log archival leaving the system unusable due to an incorrect current working directory

## 8.12.4 - 9th April 2021

### Merged forward from 8.9.20, 8.10.15, 8.11.6

#### Bug fixes

- !977 BT-2281 Disco 31117 Documents: Fixed an error that occurred when generating reports by review date
- !989 BT-2351 InfoCapture: Inline form validation should no longer be duplicated if the form is reloaded before submitting
- PRJ-392 Added title to app to admin button on mobile.
- !970 PRJ-365 Fixed error displayed when saving repeatable multiselect metadata that uses checkbox input
- !991 BT-2352 InfoCapture: Fixed PHP error caused by multi-select user form field having no users in it
- !969 BT-2257 Comments: Comments from deleted users will now identify them as such, and not provide a link to their profile
- !979 BT-2283 Disco 31939 Fixed a bug preventing login audit logs from including the currently authenticated user
- !981 FRAM-981 Correct background image is displayed at relevant device pixel ratio

## 8.12.3 - 17th March 2021

- ad1d54f5 Fixed a regression that caused an error on the People list page

## 8.12.2 - 16th March 2021

### Merged forward from 8.9.19, 8.10.13, 8.11.4

#### Improvements

- !601 FRAM-361 Indexing health check will show an error if the wrong ES version is configured

#### Bug fixes

- !745 PRJ-150 Fix for error messages not displaying when document deletion is blocked
- !954 BT-2202 Documents: Restored functionality of Folder filtering in Documents Advanced Search
- !971 BT-1486 Rename table header in the admin news channels, because it was misleading
- !972 BT-2278 Fixed InfoCapture issue where notice field types grouped together did not display well.
- !976 BT-2289 Fixed InfoCapture forms not being able to be submitted if they contained a mandatory but non-editable field

## 8.12.1 - 8th March 2021

### Merged forward from 8.11.3

#### Developer notes

- Switched to using Satisfactory (https://packages.claromentis.net) for loading the Flysystem Stream Wrapper library fork to avoid GitHub API request rate limiting

## 8.12.0 - 1st March 2021

### New features

- !896 BT-2050 InfoCapture plugin system for custom development

### Developer notes

- !896 BT-2050 New InfoCapture plugin system becomes available in this version and allows permissions to be overridden in custom InfoCapture plugins

## 8.11.27 - 7th December 2022

### Bug fixes

- !1269 RD-40 Added fix for appdata path validation vulnerability

### Improvements

- !1251 FRAM-859 Upgraded AngularJS library to version 1.8.3 

### Developer notes

- !1251 FRAM-859 As well as upgrading AngularJS, the common `angular-resource`, `angular-route` and `angular-sanitize` directives were added to the `cla_angular` webpack bundle for use by modules without having to install their own version
             The upgrade from 1.7.9 should be backwards compatible if any module was missed

## 8.11.26 - 28th September 2022

### Bug fixes

- !1213 BT-3486 Disco 37920 Fixed issue where InfoCapture timers that had fired in the past were not reset when the timer threshold was changed. Also fixed edge-case issue where timer triggers that should fire while saving a ticket did not do so due to outdated timer data.

### Developer notes

- !1213 BT-3486 Disco 37920 A small refactor was included to move the InfoCapture timer trigger code from the global `apply_assigning_to_issue()` function, into `ICIssueProcessor::ApplyAllTriggers()`. Usages in Core were updated, and the original function was deprecated but otherwise left as-is in case some existing code relies on it.

## 8.11.25 - 25th July 2022

### Bug fixes
- !1203 BT-3363 Fixed an issue where users created via LDAP sync were not receiving the correct default notification settings

### Developer notes

- !1203 BT-3363 did not introduce a breaking change, but any custom LDAP plugins that either completely override `UpdateExternalUser` or subclass it and replace the `CreateNewUser` method will need to be updated to include the notification settings fix.

## 8.11.24 - 29th June 2022

### Merged forward from 8.10.27

#### Improvements
- !1186 FRAM-800 wkhtmltopdf 0.12.6 compatibility for Holiday Planner and InfoCapture PDF export features

#### Developer note
- !1186 RD-31 Fixed SSRF vulnerability

## 8.11.23 - 23rd June 2022

### Bug fixes

- !1196 BT-3419 InfoCapture: Fixed an issue where timers were not being created when the field they were created from was set automatically by a plugin

## 8.11.22 - 6th June 2022

### Merged forward from 8.10.26

#### Bug fixes

- !1192 BT-3405 Documents compatibility with Chrome 102

## 8.11.21 - 3rd March 2022

### Improvements
- !1126 BT-2983 Documents: Some types of document links from OneDrive/Sharepoint now will be viewable in document previews

### Bug fixes

- !1154 BT-3170 Back-ported fix from 8.13 for error when creating Calendar events with attendance selected
- !1154 BT-3170 Back-ported fix from 8.13 for on-the-fly contact creation when creating Calendar events with guests

### Developer notes

- afe2851dd Updated PHP version checks in the System admin panel to check for PHP 7.4.0+

## 8.11.20 - 26th January 2022

### Merged forward from 8.9.24, 8.10.25

#### Bug fixes

- !1136 FRAM-812 RD-31 Fixed open redirect from login page

## 8.11.19 - 13th January 2022

### Bug fixes

- !1100 FRAM-778 Exported design themes no longer include paths for background images
- !1132 BT-3136 Back-ported fix for undefined index error on Documents homepage and Documents detail pages

### Merged forward from 8.9.23, 8.10.24

#### Improvements

- 1c6737e5 FRAM-811 Updated Bugtracker URL to use HTTPS (`cfg_error_reporting_url`)

#### Bug fixes

- !1130 FRAM-808 RD-31 Improved uploaded file validation in comments system



## 8.11.18 - 9th December 2021

### Bug fixes

- !1107 DISCO-034847 Fixed issue with errors being hidden when generating a PDF for an Infocapture ticket fails
- !1114 BT-3078 DISCO-035077 Fixed missing pagination on Blog listings
- !1116 BT-3080 Fixed error when searching for documents via tags
- !1118 BT-3081 DISCO-035016 Fixed bug in room booking that prevented bookings being approved when localisation was French

### Developer notes

- d9224056 FRAM-652 Deprecated global constants `JOIN_TYPE_INNER` and `JOIN_TYPE_LEFT_OUTER`. Use `DAL\Db::JOIN_TYPE_INNER` and `DAL\Db::JOIN_TYPE_LEFT_OUTER` instead.

### Merged forward from 8.9.22, 8.10.23

#### Bug fixes

- !1122 FRAM-803 RD-31 Fixed config editor issue

## 8.11.17 - 4th November 2021

### Bug fixes

- !1106 BT-3006 BT-3008 Fixed two issues where metadata could not be displayed for gallery albums and images
  - Added an endpoint which returns image metadata rendered as HTML
- !1106 BT-2992 Fixed indentation on repeatable metadata when displayed on a page.
- !1108 BT-3063 DISCO-034864 Fixed issue where csv files were being downloaded with .php filename extensions in Internet Explorer

### Developer notes

- !1106 Soft break. Changed the signatures of two methods in the `ImageAlbum` class. Callers of these methods in core were updated.
  - `GetTagGroupsAsHTML`: Added `$args` and `$datasources` to the start of the method signature.
  - `GetTagsAsHTML`: Added `$args` and `$datasources` to the start of the method signature.

## 8.11.16 - 5th October 2021

### Bug fixes

- !1097 BT-2894 BT-2895 BT-2916 Fixed array index errors in holiday planner reports
- !1098 BT-2920 Fixed array index error when importing calendar events with ICS files
- c127b863fa FRAM-782 Changed some text references from "LDAP" to "user directory" as we now support services other than just LDAP.
- !1101 BT-2956 Fixed bug where negative amounts in financial InfoCapture fields were failing to validate
- f3b6944b InfoCapture: Minor localization improvements
- 4f5f1b16 Documents: Fixed potential errors when deleting clipboard items

## 8.11.15 - 9th September 2021

### Improvements

- !1064 BT-2432 Increased scope of previous comments improvement from 8.10.21 to include the JavaScript version of comments.

### Bug fixes

- !1064 BT-2781 Fixed JS error when using comments templater component in some situations.

## 8.11.14 - 6th September 2021

### Improvements
- !1086 BT-2255 Google Drive files can now be added to Documents without those files needing their permissions set to be public

### Bug fixes
- !1081 BT-2640 Fixed bug where dropdowns automatically closed when opened on CK editor in IC
- !1072 BT-2827 Fixed text break issue in documents module
- !1082 BT-2520 BT-2527 Orgchart tablet/mobile device fixes

## 8.11.13 - 19th August 2021

### Improvements

- !1033 FRAM-732 Disco 032890 Implemented audit logging when plugins are enabled and disabled

### Developer notes

- !1033 FRAM-732 FRAM-547 Introduced the Plugin API: `Claromentis\Core\Plugin\Api`
  - Deprecated `Claromentis\Core\Plugin\PluginsRepository::STATUS_*` constants in favour of the new `Claromentis\Core\Plugin\Statuses` class constants
  - Deprecated `ClaApplication` class
  - `plugins.repository` is now registered in `ModulesServiceProvider` instead of `web/intranet/core/bootstrap.php`
  - Soft-break: `ApplicationIsEnabled` use case constructor signature has changed. Soon to be deprecated in 9.x; code outside of Sysadmin should not depend on it.

### Merged forward from 8.10.22

#### Bug fixes

- !1070 BT-2640 DISCO 033539 Fixed SLA timer count down, now it is showing time to next SLA status change instead stop at 0
- !1066 FRAM-759 Fixed intermittent Windows filesystem errors caused by Analogue ORM's (`analogue/orm`) misconfigured usage of the Generated Hydrator (`ocramius/generated-hydrator`) library
- 860b48cc 94208712 Restored missing per-index "Recreate mapping" options in Admin > Search > Reindexing
- da3dee40 Fixed legacy config loading using relative paths to find config files
- !1074 BT-2805 DISCO 33950, DISCO 33952, DISCO 33953 Fixed regression where email addresses inserted via IC expressions were being displayed escaped.

## 8.11.12 - 2nd August 2021

### Bug fixes

- !1062 BT-2650 Liking and unliking an image in Gallery generates Audit Logs.

### Developer notes

- !1052 FRAM-757 Fixed failing Unit Test `\Claromentis\Core\Tests\Audit\AuditTest::testArchiveOldLogsAuditLogWriting`.
- !1059 FRAM-766 Added `.gitlab/CODEOWNERS` in preperation for enforced code reviews of specific codebase paths

### Merged forward from 8.10.21

#### Bug fixes

- !1049 BT-2414 DISCO 033310 Fixed unsaved note warning when changing status of an infocapture ticket with notes disabled
- !1046 IC-61 DISCO 033339 DISCO 033401 Fixed duplicate InfoCapture notifications sent to monitoring users by Projects using date-based trigger processing
- !1050 BT-2489 DISCO 033281 Allow strings or other values in an InfoCapture expression to end with a backslash.
- !1050 BT-2567 DISCO 033455 Fixed issue with backslashes being mistakenly removed from Infocapture field default values when derived from user fields.
- !1042 BT-2595 DISCO 033108 Fixed issue with submitting user import page with too many checkboxes checked.
- !1048 PPL-34 Added case insensitive matching when searching Users by Extranet.

## 8.11.11 - 12th July 2021

### Improvements

- !1016 FRAM-161 FRAM-428 Improved search indexing performance using parallelization

### Developer notes

- !1016 FRAM-161 FRAM-428 Search indexing parallelization
  - Updated Symfony Console from 3.4.44 to 4.4.23
  - Search indexing instructions now run through a single database transaction to more safely support concurrent processing
  - `clc search:index` and `clc search:reindex` now include a `--workers` option to specify the number of parallel indexing processes to run
  - Improved `clc search:reindex` help text
  - Improved debug logging during Documents indexing
  - Removed redundant `types` argument and `--all` option from `clc search:index`

### Merged forward from 8.10.20

#### Improvements

- !996 FRAM-715 Audit: Scheduled Audit Log Archiving is now performed in the background task in chunks.

#### Bug fixes

- !1036 BT-2484 DISCO 031117 Document owner in the report now shows correct user (document creator) instead of one who last modified it
- !1045 BT-2498 DISCO 033370 Fixed php error in Infocapture form with public rights when a guest user attempts to submit a ticket

#### Developer notes

- !996 FRAM-715 Implemented `clc audit:archive` command for audit log archival

## 8.11.10 - 18th June 2021

### Improvements merged forward from 8.10.19

- !1032 PPL-27 People API v2 - Authenticated access by default
  - Disabled People API v2 guest access by default
  - People API v2 guest access is now configurable: Admin > People > Configuration

### Bug fixes merged forward from 8.9.21, 8.10.19

- !1020 IC-44 DISCO 32373 IC trigger timers are no longer reset when a ticket is saved
- b05a5f5f Fixed issue with loginhandler responses and sessions

### Breaking changes merged forward from 8.10.19

- !1032 PPL-27 People API v2 guest access is now opt-in by default

## 8.11.9 - 14th June 2021

### Improvements

- !671 BT-1285 LDAP: User searches of OUs (organisational units) are now paginated to get around the AD server restriction of 1000 results per request. User list searches were also combined into a single search, dramatically reducing the time taken to get lists of AD user accounts.
- 5b2305cd Updated CLC's minimum PHP version constraint from 7.1.0 to 7.4.0

### Merged forward from 8.10.18

#### Bug fixes

- !1019 BT-2419 Disco-32866 Fixed bug where audit log recorded an auto transition every minute when the workflow has been added to the Documents

## 8.11.8 - 28th May 2021

### Bug fixes

- !999 BT-2323 Disco 31912 Disco 32439 InfoCapture: Reloading a form on change no longer causes untouched mandatory fields to be given error highlights
- !1014 BT-2392 Disco 32518 InfoCapture: Added front end validation for numbers longer than DB column length

### Merged forward from 8.10.17

#### Improvements

- !1007 BT-2402 News channels are now listed alphabetically on the admin page "Channels & Templates".
- !961 IC-46 Error that is shown when attempting to set an InfoCapture ticket's handler and status to an invalid combination is now clearer
- !966 CORE-1101
  - Added `round` function to InfoCapture expression language
  - String fields that have their format set to "numeric" or "floating point" are now treated as numbers by default in InfoCapture expressions

#### Bug fixes

- !1004 BT-2394 DISCO 32627 Fixed bug that was overwriting the author of the previous document version when a document was checked in/out
- !798 IC-34 When deleting the earliest version of an InfoCapture form, tickets can no longer be assigned to "the previous version"
- !1005 BT-2396 Fixed permission to view user's thumbnail for card view in the people list
- e5c12271 FRAM-553 Fixed cleanup/prune setup task using all cleanup files during fresh installation via `clc app:upgrade --all` or `clc app:upgrade --recover`
- !987 BT-2334 Editing an IC form with a user picker could show warnings if "Myself" was used
- !1013 BT-2422 Using a Theme with a static Page Title will no longer result in a Bookmark without a name.
- !1012 BT-2392 IC forms - added validation for numbers longer than DB column length
- !1008 BT-2386 DISCO 32177 Fixed InfoCapture SLA timers only updating when the traffic light changes (timers now update whenever the issue is viewed)

## 8.11.7 - 27th April 2021

### Bug fixes

- !963 BT-2248 InfoCapture: fixed form reloading on change not working when using a plugin that validates form data
- !990 BT-2349 Disco 32241 Infocapture: Fixed deleted users causing blank entries in "assigned to"/"submitted by" filter inputs
- !992 BT-2356 Disco 32329 InfoCapture: Fixed keyword search not working when a form did not contain at least one text field
- !998 BT-2375 Disco 032434 InfoCapture: Fixed localisation on the import project page
- !997 BT-2367 Disco 32435 InfoCapture: Fixed bug where css class not getting applied to the input field in the infocapture forms

### Merged forward from 8.10.16

#### Improvements

- !733 UIUX-691 Blog Application layout improvements
  - Blog index page now has a better image layout on Desktop and Mobile
  - Blog article now has a better image display and has a lightbox for the main image

#### Bug fixes

- !724 UIUX-438 Typing out a note for an InfoCapture ticket and then attempting to leave the page will now prompt for confirmation, to avoid accidentally losing notes
- !993 BT-2359 Disco 31888 Holiday Planner: A user can no longer edit a holiday request after it has been approved or declined by a manager
- !1000 FRAM-720 Partial migrations are now able to record logs properly
- !994 BT-2305 Design panel: fixed values staying linked to master design after being edited
- c10b812a Disco 32511 Fixed audit log archival leaving the system unusable due to an incorrect current working directory

## 8.11.6 - 9th April 2021

### Bug fixes

- !977 BT-2281 Disco 31117 Documents: Fixed an error that occurred when generating reports by review date
- !989 BT-2351 InfoCapture: Inline form validation should no longer be duplicated if the form is reloaded before submitting

### Merged forward from 8.9.20, 8.10.15

#### Bug fixes

- PRJ-392 Added title to app to admin button on mobile.
- !970 PRJ-365 Fixed error displayed when saving repeatable multiselect metadata that uses checkbox input
- !991 BT-2352 InfoCapture: Fixed PHP error caused by multi-select user form field having no users in it
- !969 BT-2257 Comments: Comments from deleted users will now identify them as such, and not provide a link to their profile
- !979 BT-2283 Disco 31939 Fixed a bug preventing login audit logs from including the currently authenticated user
- !981 FRAM-981 Correct background image is displayed at relevant device pixel ratio

## 8.11.5 - 17th March 2021

- ad1d54f5 Fixed a regression that caused an error on the People list page

## 8.11.4 - 16th March 2021

### Bug fixes

- !972 BT-2278 Fixed InfoCapture issue where notice field types grouped together did not display well.
- !976 BT-2289 Fixed InfoCapture forms not being able to be submitted if they contained a mandatory but non-editable field

### Merged forward from 8.9.19, 8.10.13

#### Improvements

- !601 FRAM-361 Indexing health check will show an error if the wrong ES version is configured

#### Bug fixes

- !745 PRJ-150 Fix for error messages not displaying when document deletion is blocked
- !954 BT-2202 Documents: Restored functionality of Folder filtering in Documents Advanced Search
- !971 BT-1486 Rename table header in the admin news channels, because it was misleading

## 8.11.3 - 8th March 2021

### Developer notes

- Switched to using Satisfactory (https://packages.claromentis.net) for loading the Flysystem Stream Wrapper library fork to avoid GitHub API request rate limiting

## 8.11.2 - 1st March 2021

### Improvements

- bc0c7100 Updated default config values for archive binary paths on Linux (zip, 7zip)

### Merged forward from 8.9.18, 8.10.12

#### Improvements

- !942 UIUX-745 Publish: Added deprecation notice to Publish
- !906 FRAM-595 Documents: Added Document preview support for the following file extensions:
  - docm
  - dotm
  - dotx
  - ppsm
  - pptm
  - xlsm
  - xltm

#### Bug fixes

- !944 PRJ-216 Role based ACL now works correctly on IE11
- !928 BT-2128 Fixed wording of notifications when publishing news articles
- !962 BT-2243 Community blog channels no longer display a broken image next to the channel name
- !950 BT-2194 Fixed IC import tasks from csv, fails if the file contains incorrect coded characters
- !958 BT-2230 Fixed 'add folder' button in documents not working

## 8.11.1 - 29th January 2021

### Bug fixes

- !939 BT-2179 Changes made to an issue by an InfoCapture plugin now show in the issue history
- !903 BT-2108
  - Exported InfoCapture projects should now have legible filenames, no matter what script or code page is being used
  - Importing an InfoCapture project that contains dangling references to non-existent traffic lights will no longer fail (instead the references will be stripped out)
- !943 BT-2197 Fixed default values initialization for InfoCapture form elements
- !945 BT-2198 DISCO-31386 Fixed backend error in What's new component

### Developer notes

- !946 FRAM-480 Fixed Flysystem Stream Wrapper's PHP 7.4 incompatibility

### Merged forward from 8.9.17, 8.10.11

#### Improvements

- !936 IC-43 InfoCapture: Updated description for Field Conditions applied to date fields
- !937 PPL-4 Added User password reset requesting to the People API

#### Bug fixes

- !940 BT-2180 Fixed division by zero not being handled correctly in InfoCapture field expressions. Also fixed some arithmetic edge cases not being saved exactly as displayed in the form.
- !909 BT-2111 Fixed theme colours not showing as linked to Master Design
- fec25c43 Fixed minor error when sessions expire
- !918 BT-2143 Fixed Holiday Planner Reports displaying an incorrect holiday count for a user with expired carried holiday days
- !932 BT-2170 Fixed InfoCapture search not working when an Elasticsearch 7 host is configured
- !935 BT-2168 Statistics: Date filters on Application Summary page will now display currently filtered dates
- !938 FRAM-643 People: Users created/edited with the People API will no longer generate incorrect passwords
- !947 PPL-6 People: Users can now be created without a password or edited to no longer have a password via the People API

## 8.11.0 - 22nd December 2020

### New features

- !780 IC-26 Inline field validation for InfoCapture forms
- !774 IC-20 InfoCapture issue list now has a "Download as CSV" button

### Improvements

- !323 FRAM-459 Added migration support for SQLite database driver
- !775 FRAM-400 PHP 7.4 compatibility
- !849 IC-35
  - On the InfoCapture project homepage, "Statistics" is now called "Ticket types"
  - There is now a line in the ticket types box for tickets the user is monitoring
  - Added a checkbox to filter the InfoCapture issues list to only those issues the user is monitoring
- !848 UIUX-728 InfoCapture form scrolls to first instance (from top) of invalid form on submit
- !785 IC-27 InfoCapture issues now have a "download all" button on the files tab, which downloads all issue files as a zip archive
- !776 SRCH-1 Search results now correctly prioritise exact matches and matches in an object's title
- !743 BT-1759 DISCO 28373 Improved performance of InfoCapture ticket list
- !913 BT-2139 Made improvements to searching when using Elasticsearch 7, users should now always show in search results for their exact name
- !921 FRAM-621 AWS S3 CDN adapter compatibility with Guzzle 6

### Bug fixes

- !857 BT-2031
  - Fixed error on People admin page caused by PHP 7.4 incompatibility
  - Fixed errors that could occur in People search in edge cases
- !897 BT-2097 PHP 7.4 compatibility fixes
  - Infocapture: Array index error in GetStyleByStyleId method
  - Blog: Variable and array index errors when listing posts by tag
  - News: Array index errors when listing posts by tag
  - Room booking: Array index error on homepage when no locations, rooms or equipment defined
  - Room booking: Array index error when adding new locations in admin area
- !913 BT-2139 Fixed people results not being placed first in the search box dropdown

### Improvements merged forward from 8.9.16, 8.10.10

- !916 FRAM-551 SCH-763 Use CLC for Phing/Composer based installation
- !902 FRAM-592 Implemented dispatching user update events during user directory synchronization

### Bug fixes merged forward from 8.9.16, 8.10.10

- !908 BT-2122 No blog post subscriber notifications were being sent
- !917 BT-1665 [Disco 030850](https://discover.claromentis.com/forms/tickets/view/030850) Fixed bug on firefox, it freezes while adding a comment to the discussion or blog post
- !922 BT-2150 Fixed bug in SUGRE picker when used in JavaScript
- !904 BT-2114 Fixed issues with page refresh when adding/editing multiple Menu Applications in a row.
- !911 BT-2093 Fixed issue with embedding documents with more than one version in comments
- !923 Fixed issue with notices being shown when generating telemetry payloads in the background task

### Breaking changes

- !775 FRAM-400 PHP 7.4 compatibility
  - Claromentis 8.11 is now only compatible with PHP 7.4.x
  - `bin/composer.phar` has been removed in favour of using a globally installed Composer
  - Incompatible and unused legacy libraries have been removed from `web/lib`:
    - `web/lib/PEAR/Spreadsheet`
  - The `leafo/scssphp` 0.x PHP dependency has been replaced with `scssphp/scssphp` 1.x, and its usages updated
  - Renamed method `__Init()` to `_Init()` for classes `UserExtranetArea`, `UserGroup` and `UserRole`
  - The global `$date_format` variable has been removed and should no longer be depended upon
- !823 FRAM-437 `Claromentis\Console\Util\Locator::getComposerPath()` has been removed
- !831 FRAM-54 Updated Guzzle library
  - !832 FRAM-484 Updated AWS SDK library
    - Deployments using AWS S3 requires the `CLARO_CDN_OPTIONS`/`cfg_cdn_options` contain the key `region`, with an associated valid AWS Region
    - AWS S3 default Signing Version changed from `v2` to `v4`
  - !833 FRAM-489 Rackspace CDN adapter has been removed
    - `CLARO_CDN_TYPE`/`cfg_cdn_type` can no longer be set to `"rackspace"`
    - `Claromentis\Core\CDN\RackspaceCloudFiles` has been removed
  - !924 Updated Guzzle usage in telemetry payload dispatch
- !857 BT-2031 The `AbstractQueryBuilder::GetPermFilterForType` is now marked as returning `?array` (instead of `array`)
- !921 FRAM-621 AWS S3 CDN adapter compatibility with Guzzle 6
  - Type hints added to `CDNFactory` methods and properties

### Developer notes

- !323 FRAM-459 `SQLiteDb` now implements `SchemaInterface`, supporting schema installations and migrations
- !775 FRAM-400 PHP 7.4 compatibility
  - PHP compatibility has changed from `>=7.1.0, <7.3` to `7.4.x`
  - All Composer dependencies have been updated with `composer update`
  - All immediately obvious errors have been fixed in Core code and embedded third party libraries - **please keep an eye out for more**
  - You can now type-hint for `Psr\Container\ContainerInterface` and `Pimple\Psr11\Container` to auto-inject an instance of `Claromentis\Core\Application`
  - PHPCS has been added as a developer dependency, run using `composer phpcs`
  - PHPCS has been added to the GitLab CI pipeline configuration to check PHP 7.4 compatibility
    - Warnings and errors will show in CI job logs
    - Errors will cause the pipeline to fail, warnings will not
- !823 FRAM-400 FRAM-437 Global Composer is now used by `clc resolve` and `clc update`
- !823 Changed Composer repository URL from http://packages.claromentis.net/composer/ to https://packages.claromentis.net
- !823 Enforced HTTPS Composer package downloads by removing `"secure-http": false` from `installer/composer.json`
- !831 FRAM-54 Updated Guzzle library
  - `guzzle/guzzle` has now been removed in favour of `guzzlehttp/guzzle`
  - !832 FRAM-484 Updated AWS SDK library
    - Updated Amazon Web Services library `aws/aws-sdk-php` from `2.8.31` to `3.154.4`
    - Added required `CLARO_CDN_OPTIONS`/`cfg_cdn_options` key `region` for AWS S3 CDN configurations
    - Added optional `CLARO_CDN_OPTIONS`/`cfg_cdn_options` keys `version` and `signature` for AWS S3 CDN configurations
- !743 BT-1759 `ICIssuesListProvider` has been substantially re-written to use the Claromentis query builder

## 8.10.27 - 29th June 2022

### Improvements
- !1186 FRAM-800 wkhtmltopdf 0.12.6 compatibility for Holiday Planner and InfoCapture PDF export features

### Developer note
- !1186 RD-31 Fixed SSRF vulnerability

## 8.10.26 - 6th June 2022

### Bug fixes

- !1192 BT-3405 Documents compatibility with Chrome 102

## 8.10.25 - 26th January 2022

### Merged forward from 8.9.24

#### Bug fixes

- !1136 FRAM-812 RD-31 Fixed open redirect from login page

## 8.10.24 - 13th January 2022

### Merged forward from 8.9.23

#### Improvements

- 1c6737e5 FRAM-811 Updated Bugtracker URL to use HTTPS (`cfg_error_reporting_url`)

#### Bug fixes

- !1130 FRAM-808 RD-31 Improved uploaded file validation in comments system

## 8.10.23 - 9th December 2021

### Merged forward from 8.9.22

#### Bug fixes

- !1122 FRAM-803 RD-31 Fixed config editor issue

## 8.10.22 - 18th August 2021

### Bug fixes
- !1070 BT-2640 DISCO 033539 Fixed SLA timer count down, now it is showing time to next SLA status change instead stop at 0
- !1066 FRAM-759 Fixed intermittent Windows filesystem errors caused by Analogue ORM's (`analogue/orm`) misconfigured usage of the Generated Hydrator (`ocramius/generated-hydrator`) library
- 860b48cc 94208712 Restored missing per-index "Recreate mapping" options in Admin > Search > Reindexing
- da3dee40 Fixed legacy config loading using relative paths to find config files
- !1072 BT-2827 Fixed text break issue in documents module
- !1074 BT-2805 DISCO 33950, DISCO 33952, DISCO 33953 Fixed regression where email addresses inserted via IC expressions were being displayed escaped.

## 8.10.21 - 2nd August 2021

### Bug fixes

- !1049 BT-2414 DISCO 033310 Fixed unsaved note warning when changing status of an infocapture ticket with notes disabled
- !1046 IC-61 DISCO 033339 DISCO 033401 Fixed duplicate InfoCapture notifications sent to monitoring users by Projects using date-based trigger processing
- !1050 BT-2489 DISCO 033281 Allow strings or other values in an InfoCapture expression to end with a backslash.
- !1050 BT-2567 DISCO 033455 Fixed issue with backslashes being mistakenly removed from Infocapture field default values when derived from user fields.
- !1042 BT-2595 DISCO 033108 Fixed issue with submitting user import page with too many checkboxes checked.
- !1048 PPL-34 Added case insensitive matching when searching Users by Extranet.

### Developer notes

- !1048 PPL-34 Updated ElasticSearch 7.x index creation to add a 'lowercase' normalizer to fields converted from type '
  string' to 'keyword', to allow case insensitive matching. To take affect **this change requires indexes to be remapped.**

## 8.10.20 - 12th July 2021

### Improvements

- !996 FRAM-715 Audit: Scheduled Audit Log Archiving is now performed in the background task in chunks.
- !1018 BT-2432 Comments show a more subtle message if there are authentication problems due to a session ending
- !1018 BT-2432 Mini-calendar component will now show the content of public calendars when viewed by a guest instead of a blank tile

### Bug fixes

- !1036 BT-2484 DISCO 031117 Document owner in the report now shows correct user (document creator) instead of one who last modified it
- !1045 BT-2498 DISCO 033370 Fixed php error in Infocapture form with public rights when a guest user attempts to submit a ticket

### Breaking changes

- !996 FRAM-715:
  - Removed class `\Claromentis\Core\Audit\Exception\AuditLogArchivingFailed`.
  - Updated signature for class `\Claromentis\Core\Audit\Repository`.
  - Renamed method `\Claromentis\Core\Audit\Repository::RowExists` to `AuditTimeRowExists`.

### Deprecations

- !1041 FRAM-689 Added deprecation notices to the Webmail homepage and admin panel

### Developer notes

- ac189551 FRAM-400 Back-ported PHP 7.4 compatibility fix for `OnesignalSubscriber` for developer convenience
- !996 FRAM-715 Implemented `clc audit:archive` command for audit log archival

## 8.10.19 - 18th June 2021

### Improvements

- !1032 PPL-27 People API v2 - Authenticated access by default
  - Disabled People API v2 guest access by default
  - People API v2 guest access is now configurable: Admin > People > Configuration

### Bug fixes

- !1020 IC-44 DISCO 32373 IC trigger timers are no longer reset when a ticket is saved

### Breaking changes

- !1032 PPL-27 People API v2 guest access is now opt-in by default

### Bug fixes merged forward from 8.9.21

- b05a5f5f Fixed issue with loginhandler responses and sessions

## 8.10.18 - 14th June 2021

### Bug fixes

- !1019 BT-2419 Disco-32866 Fixed bug where audit log recorded an auto transition every minute when the workflow has been added to the Documents
- !1031 BT-2464 Enabling *In-System* notifications alongside scheduled emails no longer stops the scheduled emails from being sent

## 8.10.17 - 28th May 2021

### Improvements

- !1007 BT-2402 News channels are now listed alphabetically on the admin page "Channels & Templates".
- !961 IC-46 Error that is shown when attempting to set an InfoCapture ticket's handler and status to an invalid combination is now clearer
- !966 CORE-1101
  - Added `round` function to InfoCapture expression language
  - String fields that have their format set to "numeric" or "floating point" are now treated as numbers by default in InfoCapture expressions

### Bug fixes

- !1004 BT-2394 DISCO 32627 Fixed bug that was overwriting the author of the previous document version when a document was checked in/out
- !798 IC-34 When deleting the earliest version of an InfoCapture form, tickets can no longer be assigned to "the previous version"
- !1005 BT-2396 Fixed permission to view user's thumbnail for card view in the people list
- e5c12271 FRAM-553 Fixed cleanup/prune setup task using all cleanup files during fresh installation via `clc app:upgrade --all` or `clc app:upgrade --recover`
- !987 BT-2334 Editing an IC form with a user picker could show warnings if "Myself" was used
- !1013 BT-2422 Using a Theme with a static Page Title will no longer result in a Bookmark without a name.
- !1012 BT-2392 IC forms - added validation for numbers longer than DB column length
- !1008 BT-2386 DISCO 32177 Fixed InfoCapture SLA timers only updating when the traffic light changes (timers now update whenever the issue is viewed)

### Soft Breaking Changes

- !1013 Templater Component core_page_title's return value has changed to include HTML tags.

## 8.10.16 - 27th April 2021

### Improvements

- !733 UIUX-691 Blog Application layout improvements
  - Blog index page now has a better image layout on Desktop and Mobile
  - Blog article now has a better image display and has a lightbox for the main image

### Bug fixes

- !724 UIUX-438 Typing out a note for an InfoCapture ticket and then attempting to leave the page will now prompt for confirmation, to avoid accidentally losing notes
- !993 BT-2359 Disco 31888 Holiday Planner: A user can no longer edit a holiday request after it has been approved or declined by a manager
- !1000 FRAM-720 Partial migrations are now able to record logs properly
- !994 BT-2305 Design panel: fixed values staying linked to master design after being edited
- c10b812a Disco 32511 Fixed audit log archival leaving the system unusable due to an incorrect current working directory

## 8.10.15 - 9th April 2021

### Bug fixes

- !980 PRJ-392 Added title to app to admin button on mobile.
- !970 PRJ-365 Fixed error displayed when saving repeatable multiselect metadata that uses checkbox input
- !991 BT-2352 InfoCapture: Fixed PHP error caused by multi-select user form field having no users in it

### Merged forward from 8.9.20

#### Bug fixes

- !969 BT-2257 Comments: Comments from deleted users will now identify them as such, and not provide a link to their profile
- !979 BT-2283 Disco 31939 Fixed a bug preventing login audit logs from including the currently authenticated user
- !981 FRAM-981 Correct background image is displayed at relevant device pixel ratio

## 8.10.14 - 17th March 2021

- ad1d54f5 Fixed a regression that caused an error on the People list page

## 8.10.13 - 16th March 2021

### Bug fixes

- !745 PRJ-150 Fix for error message not displaying when document deletion is blocked

### Merged forward from 8.9.19

#### Improvements

- !601 FRAM-361 Indexing health check will show an error if the wrong ES version is configured

#### Bug fixes

- !954 BT-2202 Documents: Restored functionality of Folder filtering in Documents Advanced Search
- !971 BT-1486 Rename table header in the admin news channels, because it was misleading

## 8.10.12 - 1st March 2021

### Improvements

- !965 PRJ-176 Error shown when viewing deleted comments permalink is now clearer

### Bug fixes

- !958 BT-2230 Fixed 'add folder' button in documents not working

### Developer notes

- !951 PRJ-360 The timezone can now be set after the request has terminated. This means that we can now send emails when daemonised.
- !952 PRJ-347 Refactored Analogue ACL query permission check into its own service (so that it can be used outside of the ORM)

### Merged forward from 8.9.18

#### Improvements

- !942 UIUX-745 Publish: Added deprecation notice to Publish
- !906 FRAM-595 Documents: Added Document preview support for the following file extensions:
  - docm
  - dotm
  - dotx
  - ppsm
  - pptm
  - xlsm
  - xltm

#### Bug fixes

- !944 PRJ-216 Role based ACL now works correctly on IE11
- !928 BT-2128 Fixed wording of notifications when publishing news articles
- !962 BT-2243 Community blog channels no longer display a broken image next to the channel name
- !950 BT-2194 Fixed IC import tasks from csv, fails if the file contains incorrect coded characters

## 8.10.11 - 29th January 2021

### Bug fixes

- !940 BT-2180 Fixed division by zero not being handled correctly in InfoCapture field expressions. Also fixed some arithmetic edge cases not being saved exactly as displayed in the form.
- !909 BT-2111 Fixed theme colours not showing as linked to Master Design
- fec25c43 Fixed minor error when sessions expire

### Developer notes

- fec25c43 Fixed invalid property access notice in `People\RenderSubscriber::onTwigPreRender()` when sessions expire

### Merged forward from 8.9.17

#### Improvements

- !936 IC-43 InfoCapture: Updated description for Field Conditions applied to date fields
- !937 PPL-4 Added User password reset requesting to the People API

#### Bug fixes

- !918 BT-2143 Fixed Holiday Planner Reports displaying an incorrect holiday count for a user with expired carried holiday days
- !932 BT-2170 Fixed InfoCapture search not working when an Elasticsearch 7 host is configured
- !935 BT-2168 Statistics: Date filters on Application Summary page will now display currently filtered dates
- !938 FRAM-643 People: Users created/edited with the People API will no longer generate incorrect passwords
- !947 PPL-6 People: Users can now be created without a password or edited to no longer have a password via the People API

## 8.10.10 - 22nd December 2020

### Improvements

- !916 FRAM-551 SCH-763 Use CLC for Phing/Composer based installation

### Improvements merged forward from 8.9.16

- !902 FRAM-592 Implemented dispatching user update events during user directory synchronization

### Bug fixes

- !908 BT-2122 No blog post subscriber notifications were being sent
- !917 BT-1665 [Disco 030850](https://discover.claromentis.com/forms/tickets/view/030850) Fixed bug on firefox, it freezes while adding a comment to the discussion or blog post
- !922 BT-2150 Fixed bug in SUGRE picker when used in JavaScript

### Bug fixes merged forward from 8.9.16

- !904 BT-2114 Fixed issues with page refresh when adding/editing multiple Menu Applications in a row.
- !911 BT-2093 Fixed issue with embedding documents with more than one version in comments
- !923 Fixed issue with notices being shown when generating telemetry payloads in the background task

### Developer notes

- !916 FRAM-551 SCH-763 `phing install` now forwards to CLC in all cases

### Breaking changes

- !916 FRAM-551 SCH-763 `web/intranet/common/config.php` is no longer required to exist for Phing/Composer-based installations or upgrades to succeed
- !922 BT-2150 `SugreUtility::DecodeOutput()` input format changed slightly to reflect what the AngularJS SUGRE picker JS format is and commented to clarify its use

## 8.10.9 - 27th November 2020

### Bug fixes merged forward from 8.9.15

- !864 FRAM-394 Fixed a potential XSS vulnerability in many locations
- Removed debug code that was causing errors in comments

## 8.10.8 - 25th November 2020

### Bug fixes

- !880 Role-based ACL
  - PRJ-263 Saving a role via RoleRepository::Save() did not clear the cache causing subsequent loads to contain old data
  - "New role" dialog perms picker did not reset and could show old data
- !892 BT-2078 Themes whose assets are missing after upgrading to `8.10.5` have been restored
- !888 BT-2051 Fixed last modified fields in documents advanced search
- !899 BT-1976 Fixed console error caused when an InfoCapture form with an HTML input reloaded due to a field change

### Improvements
- !885 UIUX-75 Added sort options to gallery main list

### Developer notes

- !880 Role-based ACL
  - Improvements in `RoleRepository` to use `ACL` instead of `Permissions` internally
  - Improvements to be more consistent with data contained in `RoleDialogData` after `Load()` and `Update()`

### Merged forward from 8.9.14, 8.8.21, 8.7.22

#### Improvement

- !890 Changing the themes of other users will now take effect immediately, instead of requiring them to re-login

#### Bug fixes

- !890 BT-2078 Themes whose assets are missing after upgrading to `8.8.19` have been restored
- !900 BT-2090 Fixed XSS vulnerability

#### Breaking changes

- !890 `ActiveTheme` constructor parameters have changed in order and quantity

## 8.10.7 - 9th November 2020

### Improvements

- !746 BT-1781 DISCO 28379 Improved performance of site statistics page

### Bug fixes

- !846 BT-2020 Fixed user metadata values not being displayed in user card list

### Bug fixes merged forward from 8.9.13

- !873 FRAM-522 FRAM-501 Back-ported Analogue regression fix
- !879 BT-2063 Documents: Fixed errors generating notifications when checking-in Documents where the initial version had been deleted.

## 8.10.6 - 19th October 2020

### Bug fixes

- !862 BT-2033 Editing a user field to give it "special" or "advanced" field permissions will now prevent it from being searched by global search

### Merged forward from 8.9.12, 8.8.20, 8.7.21

#### Bug fixes

- FRAM-520 Fixed appdata regression

## 8.10.5 - 16th October 2020

### Bug fixes

- !843 BT-2016 Fixed people advanced search mentioning fields that were not used in the query string
- !844 CORE-1090 Push notifications on iOS are now compatible with two-factor authentication
- !866 BT-1957 Themes created from VIs can no longer have invalid Theme Codes.

### Merged forward from 8.8.19, 8.7.20

#### Bug fixes

- FRAM-520 Fixed appdata vulnerability

## 8.10.4 - 1st October 2020

### Bug Fixes

- !825 BT-1982 long links now wrap to the next line in calendar events quick view
- !826 BT-1844 Fixed InfoCapture financial fields not accepting empty or calculated default values
- !828 BT-1980 Fixed users import not importing user's language correctly

### Merged forward from 8.9.10, 8.8.18

#### Improvements

- !719 !810 UIUX-689 Restored the 'Add Event' button to Calendar's application menu
- !778 FRAM-410 Implemented cache busting for JavaScript assets loaded via RequireJS
- !819 FRAM-477 Added Greek Translation for Localization Phrase "forms.section_saved".
- !820 BT-1965 Infocapture: Improved reports generation speed.
- !777 BT-1885 Added support for mapping dates from LDAP to claromentis datetime and date without year metadata types.
- !829 BT-2009 Improved layout and content of default document upload notifications

#### Bug fixes

- !791 BT-1796 Disco 028398, 029263 Added missing authentication check for Documents URL redirects
- !810 BT-1939 BT-1718 Fixed unintentional deletion of non-repeating Calendar events when creating an event under specific circumstances
- !793 BT-1907 InfoCapture SLA traffic light changes are now always logged as being done by "no user"
- !817 PRJ-207 People API should no longer return a 500 error when using an MSSQL database
- !791 BT-1796 Disco 028398, 029263 Added missing authentication check for Documents URL redirects
- !807 FRAM-454 File clean-ups will now be run when upgrading with `clc app:upgrade`.
- !808 BT-1935 Menu builder: Fixed the link to a Menu Item's edit page on a Menu Item's Permissions page.
- !811 BT-1951 The names of the "latest note" InfoCapture template placeholders have been corrected
- !805 BT-1950 Entering "00:00" as the end time for an InfoCapture SLA day will now be treated as meaning the end of that day (instead of the beginning)
- !815 BT-1959 Fixed split multi-byte characters that prevented text and address metadata fields from being saved
- !821 BT-1975 Entering values that are too long into the add/edit menu item form no longer causes an error
- !827 BT-1861 Users who subscribed to a news channel, and then removed from channel permissions will not get notification
- !828 BT-1980 Fixed importing users from CSV not working when the CSV contained a language column
- !812 BT-1908 Fixed InfoCapture notifications not displaying names of the submitter/assignee in some cases

## 8.10.3 - 9th September 2020

### Improvements

- !790 UIUX-696 existing calendar events can no longer be edited from the preview modal, and links in the description are clickable

### Bug fixes

- !813 BT-1956 Fixed issues with document links caused by framework incompatibilities
- !818 BT-1958 Fixed broken search button in documents

## 8.10.2 - 1st September 2020

### Bug fixes

- !794 BT-1918 Fixed display of news cover image on Safari (mobile/tablet)

### Merged forward from 8.9.9

#### Bug fixes

- !796 BT-1922 Fixed traffic light-based field condition sets not being imported correctly in InfoCapture
- !803 BT-1929 [Disco 029243](https://discover.claromentis.com/forms/tickets/view/029243) Localised "No upcoming events" phrase for the Calendar Events component
- !802 BT-1890 [Disco 029168](https://discover.claromentis.com/forms/tickets/view/029168) Fixed LinkedIn button in user's profile
- f638a6ea BT-1939 BT-1718 Removed 'Add Event' button from Calendar's application menu

#### Developer notes

- !759 CORE-1084 Updating or deleting calendar event sequences now dispatches a calendar event modified/deleted event

## 8.10.1 - 18th August 2020

### Improvements

- !722 UIUX-681 UIUX-682 News Pages component image improvements.
- !732 UIUX-685 News can now contain both Content and a Link simultaneously
- !730 CORE-1079 Added manager card to the user profile page, above the direct reports card

### Breaking Changes

- !722 UIUX-681 UIUX-682 `\Claromentis\News\UI\PagesNewsList`:
  - Updated constructor input signature.
  - Removed constant `MAX_NEWS_TABS`.

## 8.10.0 - 18th August 2020

### New features

- !360 FRAM-283 Added preview UI for notification template editor and improved UX of the editor
- !394 DS-8 FRAM-61 Twig templating
- !603 UIUX-181 Upgraded the Mini calendar component, so you can navigate through months
- !681 PRJ-75 Twig template for application page layouts: `common/layouts/app_page.html.twig`

### Improvements

- !500 FRAM-79 People user lists are now served via Elasticsearch, to improve site performance and availability
- !640 FRAM-366 The config editor now shows values which have been overwritten by runtime calculated values
- !486 CORE-959 Infocapture field labels and field options can now be given a value
  in the form `@{localisation.key|default}`. This will display the localised phrase pointed
  to by the localisation key. If the localisation key does not exist, the default text will
  be displayed instead.
- !667 CORE-1067 Users will now always appear at the top of the search suggestions list
- !612 UIUX-632 OrgChart UI improvement and bugs
    - Removed mouse zoom on OrgCharts and added zoom controls to improve UX
    - Decreased sensitivity of zoom in/out
    - OrgChart displays vertically after 3 levels
    - Fixed issue where excluding users field was cut off
    - Fixed issue in browsers where OrgChart was too large to be excluded
- !718 Improved performance for loading and counting comment replies
- !670 BT-1275 InfoCapture field formulae containing syntax errors will now cause growl errors instead of JavaScript console errors
- !711 UIUX-683 News Application layout improvements
    - Add/Edit news "Abstract" renamed to "Short Summary" and now has help text
    - News index page now has a better image layout on Desktop and Mobile
    - News article now has a better image display and has a lightbox for the main image

### Bug fixes

- !697 BT-438 the heading above InfoCapture Projects in the search suggestions dropdown no longer reads "unknown"
- !716 BT-1600 Blog channel subscribers will now be notified when a new blog post is published
- !723 BT-1636 Update component library to 0.2.2 which contains fix for <cla-picker> input in IE11
- !670 BT-1275 InfoCapture field formulae will no longer fail to be evaluated if a field they refer to contains an apostraphe
- !740 BT-1708 Fix for display of portrait images in news app
- !752 BT-1804 Fixed an error that was caused by deleting a user profile field from the metadata admin area
- !772 Fixed an error with role-based ACL that could incorrectly filter roles for a user

### Breaking changes

- !394 DS-8 FRAM-61 Twig templating
  - The automatically injected `\Twig_Environment` service is no longer the notifications Twig environment, but the new fully-featured Twig templating environment
  - Templater no longer leaves templates half-rendered if an exception occurs during rendering
  - Templater now strips the `arguments` attribute from all tags
- !697 BT-438 `AGGREGATION_IC_PROJECT` is now 154, changed from 117
- !654 FRAM-369
  - Removed jQuery-UI CSS.
  - Moved jQuery-UI JavaScript.
- !653 FRAM-367
  - Globally available jQuery updated from 2.1.3 to 3.4.1.
    - jQuery properties `.context` and `.selector` have been removed and are not covered by the migrator.
  - Removed `web/intranet/js/jquery.js`.
  - Removed `web/intranet/js/jquery.min.js`.
  - Removed `web/lib/flexpaper/js/jquery.min.js`.
  - Moved `web/intranet/js/jquery.min.1.7.2.js` to `web/lib/slickgrid/lib/jquery.min.1.7.2.js`.
  - Removed `web/intranet/js/bootstrap/bootstrap.min.js`.
  - Removed `web/intranet/js/bootstrap/bootstrap.js`.
- !670 BT-1275 InfoCapture field formulae containing circular references will now evaluate to a blank field instead of iterating through the loop an few times and then stopping
- !656 FRAM-368 Migration from AngularJS `1.4` to `1.7`
  - https://docs.angularjs.org/guide/migration#migrate1.4to1.5
  - https://docs.angularjs.org/guide/migration#migrate1.5to1.6
    - Specific concerns for usage of deprecated `$http.success()` and `$http.error()` methods.
  - https://docs.angularjs.org/guide/migration#migrate1.6to1.7
    - Specific concerns for usage of deprecated `$resource.success()` and `$resource.error()` methods.
- !762 BT-1712 Change to jQueryUI tab handling
  - This now always uses the ID of the target elements when altering the URL. Previously other selectors could be specified in the tab href but as far as I can see we have only used ID selectors (href="#tabName").

### Developer notes

- !394 DS-8 FRAM-61 Twig templating - [Read the documentation](docs/technical/framework/twig.md) for more details
  - Twig templates can be used to render controller responses using `Claromentis\Core\Http\TwigTemplaterResponse` or `Claromentis\Core\Http\TwigResponse`
  - Twig components can be defined by extending `Claromentis\Core\Twig\TwigComponent`
  - Templater components and Twig components can be used in Templater templates and Twig templates
  - Templater components and Twig components now support automatic constructor dependency injection
  - Templater now supports a new `<twig/>` tag for including Twig templates
  - Templater template rendering exceptions will now no longer cause half-rendered pages to remain in the output buffer
  - Templater now supports the `'force_recompile'` option for debugging
  - Twig global variables, functions and extensions can be provided by extending the `twig.globals`, `twig.functions` and `twig.extensions` services
  - Twig templates can be previewed in developer mode at `/twig/{template}` or `/twig/hybrid/{template}`
  - Twig templates can be previewed using the 'twig_test' component in Templater templates and Twig templates
  - The `CssLoader` component now accepts array-literals for its `src` attribute
  - PRJ-136 Implemented mobile device detection for Twig
    - The `is_mobile()` and `is_tablet()` functions are now globally available in Twig templates rendered by Claromentis
- !640 FRAM-366 The config editor now shows values which have been overwritten by runtime calculated values
- !631 BT-816 When an IC issue appears in search suggestions, it will display a snippet of the issue body if it contains relevant text
- !684 Updated the Claromentis Design System to version 0.2.0
- !486 CORE-959 Getting the name of an infocapture project should now be done with `GetName()` instead of `GetHDValue('name')`. `GetName()` runs the name through `lmsg_str()`, allowing it to be localised.
- !500 FRAM-79 People user lists are now served via Elasticsearch, to improve site performance and availability
- !654 FRAM-369 Updated jQuery-UI library from `1.11.4` to `1.12.1`
- !653 FRAM-367 Updated jQuery from v2.1.3 to 3.4.1
  - Implemented jQuery 3 Migrator. jQuery 3 incompatibilities will be logged in the console in Developer Mode.
  - Removed usage of several instances of older jQuery versions; isolated library dependencies in each library's directory.
- !656 FRAM-368 Updated AngularJS from `1.4.14` to `1.7.9`
- !718 Added `idx_parent_id` and `idx_aggregation_object_id_parent_id` to the `discussions` table for Comments performance improvements
- The infocapture expression parser is generated by kmyacc and must not be edited directly. The parser definition is stored in `web/infocapture/parser/expressions.phpy`. In arder to generate a new parser after changing the definition, first install kmyacc from https://github.com/moriyoshi/kmyacc-forked, then run `php web/infocapture/parser/generate_parser.php`. The parser class will automatically be copied to the correct place.
- PRJ-55 Added option to role-based ACL to hide the user picker from roles
- PRJ-55 Implemented `Claromentis\Core\Log\Util::LogThrowable`, a utility method for logging throwables

## 8.9.24 - 26th January 2022

### Bug fixes

- !1136 FRAM-812 RD-31 Fixed open redirect from login page

## 8.9.23 - 13th January 2022

### Improvements

- 1c6737e5 FRAM-811 Updated Bugtracker URL to use HTTPS (`cfg_error_reporting_url`)

### Bug fixes

- !1130 FRAM-808 RD-31 Improved uploaded file validation in comments system

## 8.9.22 - 9th December 2021

### Bug fixes

- !1122 FRAM-803 RD-31 Fixed config editor issue

## 8.9.21 - 18th June 2021

### Bug fixes

- b05a5f5f Fixed issue with login handler responses and sessions

## 8.9.20 - 9th April 2021

### Bug fixes

- !969 BT-2257 Comments: Comments from deleted users will now identify them as such, and not provide a link to their profile
- !979 BT-2283 Disco 31939 Fixed a bug preventing login audit logs from including the currently authenticated user
- !981 FRAM-981 Correct background image is displayed at relevant device pixel ratio

## 8.9.19 - 16th March 2021

### Improvements

- !601 FRAM-361 Indexing health check will show an error if the wrong ES version is configured

### Bug fixes

- !954 BT-2202 Documents: Restored functionality of Folder filtering in Documents Advanced Search
- !971 BT-1486 Rename table header in the admin news channels, because it was misleading

### Developer notes

- !954 BT-2202 Added functionality for search to provide matching filters via `\Claromentis\Search\Parameters`

## 8.9.18 - 1st March 2021

### Improvements

- !942 UIUX-745 Publish: Added deprecation notice to Publish
- !906 FRAM-595 Documents: Added Document preview support for the following file extensions:
  - docm
  - dotm
  - dotx
  - ppsm
  - pptm
  - xlsm
  - xltm

### Bug fixes

- !944 PRJ-216 Role based ACL now works correctly on IE11
- !928 BT-2128 Fixed wording of notifications when publishing news articles
- !962 BT-2243 Community blog channels no longer display a broken image next to the channel name
- !950 BT-2194 Fixed IC import tasks from csv, fails if the file contains incorrect coded characters

### Developer notes

- !931 IC-42 Events are now dispatched when adding/editing notes to an InfoCapture issue. Events can be used to modify the note or stop the action altogether.
- !953 BT-2176 BT-2177 Audit: Refactored audit log archiving
- 302c61e0 FRAM-455 Fixed appdata front controller not loading parent directory .env files

## 8.9.17 - 29th January 2021

### Improvements

- !936 IC-43 InfoCapture: Updated description for Field Conditions applied to date fields
- !937 PPL-4 Added User password reset requesting to the People API

### Bug fixes

- !918 BT-2143 Fixed Holiday Planner Reports displaying an incorrect holiday count for a user with expired carried holiday days
- !932 BT-2170 Fixed InfoCapture search not working when an Elasticsearch 7 host is configured
- !935 BT-2168 Statistics: Date filters on Application Summary page will now display currently filtered dates
- !938 FRAM-643 People: Users created/edited with the People API will no longer generate incorrect passwords
- !947 PPL-6 People: Users can now be created without a password or edited to no longer have a password via the People API

### Developer notes

- !941 BT-2178 Fixed `UserRepository::getIdByUsername()` always returning 1
- Documentation improved for `Claromentis\People\Event\*` classes, including `AddUserEvent`, `UpdateUserEvent` and `DeleteUserEvent`

## 8.9.16 - 22nd December 2020

### Improvements

- !902 FRAM-592 Implemented dispatching user update events during user directory synchronization

### Bug fixes

- !904 BT-2114 Fixed issues with page refresh when adding/editing multiple Menu Applications in a row.
- !911 BT-2093 Fixed issue with embedding documents with more than one version in comments
- !923 Fixed issue with notices being shown when generating telemetry payloads in the background task

### Developer notes

- !902 FRAM-592 `PeopleEventType::PRE_UPDATE_USER` and `PeopleEventType::UPDATE_USER` events now dispatch as instances of `UpdateUserEvent` whenever an LDAP user is synchronized

## 8.9.15 - 27th November 2020

### Bug fixes

- !864 FRAM-394 Fixed a potential XSS vulnerability in many locations
- Removed debug code that was causing errors in comments

## 8.9.14 - 25th November 2020

### Improvements

- !878 BT-2055 Added comments index to help Discuss list speed

### Bug fixes

- !887 BT-2021 Custom Localization will no longer override built-in Localizations if empty
- !891 BT-2078 Themes whose assets are missing after upgrading to `8.9.11` have been restored
- !898 BT-2100 Fixed error on global search page that sometimes occurred when policies appeared in search results

### Merged forward from 8.8.21, 8.7.22

#### Improvement

- !890 Changing the themes of other users will now take effect immediately, instead of requiring them to re-login

#### Bug fixes

- !890 BT-2078 Themes whose assets are missing after upgrading to `8.8.19` have been restored
- !900 BT-2090 Fixed XSS vulnerability

#### Breaking changes

- !890 `ActiveTheme` constructor parameters have changed in order and quantity

## 8.9.13 - 9th November 2020

### Bug fixes

- !873 FRAM-522 FRAM-501 Back-ported Analogue regression fix
- !879 BT-2063 Documents: Fixed errors generating notifications when checking-in Documents where the initial version had been deleted.
- !883 BT-2065 Fixed notification sent when a document was deleted not containing the name of the document

## 8.9.12 - 19th October 2020

### Merged forward from 8.8.20, 8.7.21

#### Bug fixes

- FRAM-520 Fixed appdata regression

## 8.9.11 - 16th October 2020

### Bug fixes

- !852 BT-1999 Fixed localisation in crop image component
- !837 BT-1783 Fixed editing a news article sending a notification about an article being added
- !859 BT-2038 Links to old-style user org charts will now redirect to the orgchart module
- !865 BT-1957 Themes created from VIs can no longer have invalid Theme Codes.

### Developer notes

- !837 BT-1783 The template `news.news_control.news` has been updated. Non-english versions will need to be re-translated.

## 8.9.10 - 1st October 2020

### Improvements

- !719 !810 UIUX-689 Restored the 'Add Event' button to Calendar's application menu

### Bug fixes

- !791 BT-1796 Disco 028398, 029263 Added missing authentication check for Documents URL redirects
- !810 BT-1939 BT-1718 Fixed unintentional deletion of non-repeating Calendar events when creating an event under specific circumstances
- !793 BT-1907 InfoCapture SLA traffic light changes are now always logged as being done by "no user"
- !817 PRJ-207 People API should no longer return a 500 error when using an MSSQL database

### Breaking changes

- !810 BT-1939 BT-1718 `DatePeriodDialog::InitDefaultDateForm()` no longer changes the time of the date given, only of the date it creates itself when no date is given

### Developer notes

- !793 BT-1907 `HDIssue::UpdateTrafficLight` is now only ever called from the background task (by `process_hd_traffic_lights`)

### Merged forward from 8.8.18

#### Improvements

- !778 FRAM-410 Implemented cache busting for JavaScript assets loaded via RequireJS
- !819 FRAM-477 Added Greek Translation for Localization Phrase "forms.section_saved".
- !820 BT-1965 Infocapture: Improved reports generation speed.
- !777 BT-1885 Added support for mapping dates from LDAP to claromentis datetime and date without year metadata types.
- !829 BT-2009 Improved layout and content of default document upload notifications

#### Bug fixes

- !791 BT-1796 Disco 028398, 029263 Added missing authentication check for Documents URL redirects
- !807 FRAM-454 File clean-ups will now be run when upgrading with `clc app:upgrade`.
- !808 BT-1935 Menu builder: Fixed the link to a Menu Item's edit page on a Menu Item's Permissions page.
- !811 BT-1951 The names of the "latest note" InfoCapture template placeholders have been corrected
- !805 BT-1950 Entering "00:00" as the end time for an InfoCapture SLA day will now be treated as meaning the end of that day (instead of the beginning)
- !815 BT-1959 Fixed split multi-byte characters that prevented text and address metadata fields from being saved
- !821 BT-1975 Entering values that are too long into the add/edit menu item form no longer causes an error
- !827 BT-1861 Users who subscribed to a news channel, and then removed from channel permissions will not get notification
- !828 BT-1980 Fixed importing users from CSV not working when the CSV contained a language column
- !812 BT-1908 Fixed InfoCapture notifications not displaying names of the submitter/assignee in some cases

## 8.9.9 - 1st September 2020

### Bug fixes

- !796 BT-1922 Fixed traffic light-based field condition sets not being imported correctly in InfoCapture
- !803 BT-1929 [Disco 029243](https://discover.claromentis.com/forms/tickets/view/029243) Localised "No upcoming events" phrase for the Calendar Events component
- !802 BT-1890 [Disco 029168](https://discover.claromentis.com/forms/tickets/view/029168) Fixed LinkedIn button in user's profile
- f638a6ea BT-1939 BT-1718 Removed 'Add Event' button from Calendar's application menu

### Developer notes

- !759 CORE-1084 Updating or deleting calendar event sequences now dispatches a calendar event modified/deleted event

## 8.9.8 - 17th August 2020

### Bug fixes

- !788 BT-1909 Fixed vulnerability when displaying object names in the audit log
- !795 BT-1894 Fixed the "preview" modal for InfoCapture notes

### Bug fixes merged forward from 8.8.16, 8.7.19, 8.7.18

- !784 BT-1897 "Ticket handler" and "status" columns no longer show in InfoCapture issue list if they are not used by the project
- !782 BT-448 Fixed empty growl messages in absence requests component
- !786 BT-1896 [Disco 029201](https://discover.claromentis.com/forms/tickets/view/029201) Fixed InfoCapture issue private files being accessible to any user if the "Submitter of ticket" or "Handler" roles were given "Private notes and files" rights
- !735 BT-1651 Fixed digest emails not being sent when the digest was set per-module
- !797 BT-1921 Fixed XSS vulnerability
- !663 BT-332 fixed Issue with drag&drop in Zones and groups
- !611 BT-453 Adding a new user profile field no longer causes a database error when using MSSQL
- !787 BT-1909 Fixed XSS vulnerability

## 8.9.7 - 4th August 2020

### New features - Polls & Surveys release

- !763 CORE-1051 Renamed the Survey's admin panel from 'Surveys' to 'Surveys (legacy)'

### Improvements

- !765 CORE-1050 Added notice to Surveys Admin panel about new Polls & Surveys app
- !738 UIUX-702 The who's out component now allows filtering by groups and roles
- !719 UIUX-689 Added 'Add Event' button to calendar main navigation

### Bug fixes

- !751 BT-1795 People API validator for metadata will now return correct message and valid dates with more digits than expected
- !754 BT-1793 Fixed typo in admin panel tooltip (disco 028678)
- !756 BT-1090 Fixed users in subgroups sometimes not being considered members of the group tree if they did not have permission to see the parent group
- !792 BT-1882 Date-based triggers will now correctly start SLA timers if used to automatically change a ticket's status

#### Merged forward from 8.8.15

- !747 DISCO 28407 Fixed InfoCapture projects fetching each other's mail

## 8.9.6 - 25th June 2020

### Improvements

- !729 UIUX-675 Calendar: System Calendar Events are now capable of providing direct links

#### Merged forward from 8.8.14

- BT-1749 Added further detail to exception message in the event that the File Upload Directory has been deleted.
- !611 BT-453 Adding a new user profile field no longer causes a database error when using MSSQL
- MA-51 Fixed Document PDF previews in the Claromentis Android App
- !744 BT-1758 Infocapture: Mail body can now be left unmapped to form field.
- !750 BT-1791 Fixed "Wrong issue ID" error when editing InfoCapture issue notes and downloading issue files

### Bug fixes

- !742 BT-1703 Documents folders set to be excluded from "what's new" are now properly excluded

### Developer notes

- !742 BT-1703 Any class that extends `AbstractQueryBuilder` is now required to implement the `GetEsVersion` method

#### Merged forward from 8.8.14

- Added `--prefer-dist` option flag to the Composer command run by `clc resolve`, `clc update` and `clc update-all`
- !744 BT-1758 Added logging when receiving mail.
- !744 BT-1758 Infocapture: Added logging when converting mail to tickets.

## 8.9.5 - 8th June 2020

### Bug fixes

- 0103d112 BT-1709 Fixed "Redis is disabled" error when using the image crop tool

### Improvements

- !728 BT-1618 Audit entries for InfoCapture issues now link to the issue, and the message includes the ID of the project the issue was from

## 8.9.4 - 2nd June 2020

### Bug fixes

- !734 BT-1666 fixed search suggestions showing "unknown" instead of "InfoCapture projects" (back-ported fix from 8.10)
- !736 BT-1432 fixed growl error appearing when a user comments on a gallery image that they do not own

### Merged forward from 8.8.13

- !698 BT-1466 Fixed drag-and-drop image uploads failing with Redis enabled
- !709 BT-1564 Infocapture issue tabs URLs being temporarily invalid for some projects while loading
- !714 BT-1570 Updated comments library to delete comment attachments when deleting comments by their associated object.
- !717 BT-1623 A `Comment`'s `Reply Count` will now correct whenever a Reply is created, edited or deleted.
- !726 BT-1642 fixed adding localisation keys not working when using IE11

### Developer notes

- !734 Fixed a bug in `UserScope` that caused `WhereInAcl` to filter out all users without a role if the ACL contained at least one role (even if they matched a group/extranet/etc. in the ACL)

### Improvements

- !737 BT-1685 for preventing mistakes with new polls&surveys page components, renamed old ones (added suffix (legacy))

## 8.9.3 - 15th May 2020

### Bug fixes

- !715 BT-1569 Title of legacy announcements component has been changed back to simply "Announcements"
- !700 BT-1426 Update component library to 0.1.40 which contains fix for <cla-picker> input in IE11

#### Merged forward from 8.7.17 & 8.8.12

- Fixed multi-byte character set error on MySQL when saving InfoCapture issues
- !717 BT-1623 Fixed incorrect comment reply counts whenever a reply is created, edited or deleted
- !721 BT-1634 Removed extra slashes from heredoc email template. Fix will prevent to display email header in email body
- !725 BT-1641 Fixed some user pickers and permission dialogs incorrectly selecting all users, instead of only those that were selected

### Developer notes

#### Merged forward from 8.7.17 & 8.8.12

- !586 SDB-698 Implemented configurable object storage (database connections) for ActiveRecord objects
- !725 BT-1641 Fixed incorrect list of Users being returned when `User Account Status` is filtered by in `\Claromentis\Core\Acl\UsersReader::GetUserIds`

## 8.9.2 - 5th May 2020

### Bug fixes

- Fixed Elasticsearch host configuration defaulting to empty instead of `'localhost'`
- !708 BT-1559 Fixed daily summary and cumulative charts in InfoCapture statistic

### Bug fixes merged forward from 8.7.16 and 8.8.12

- !691 BT-600 A user who has been forced to change their password on next login can now choose to logout instead of changing their password
- !692 BT-1423 Fixed error when cancelling editing document
- !694 BT-192 A holiday booked for the first day of a holiday planner year will now show in the "my requests" tab, as intended.
- !695 BT-1487 Fixed sticky pin still showing on news page component after expiring
- !699 BT-1482 InfoCapture "note added" triggers are no longer activated when a note is edited
- !702 BT-578 Fixed problem where empty AD attributes were mappable on LDAP configuration form
- !702 BT-578 Undefined fields can no longer be added in LDAP configuration form
- !707 BT-1560 Fixed session persistence and IP binding issues
- !706 BT-1525 Fixed location error too long for calendar event
- !696 BT-1495 Disco 027181 Fixed double-encoded metadata in the People card list view
- !701 BT-1462 Power Users can now see Disabled Users.
- !705 BT-1333 Disco 027462 Fixed issue with random permission for a new role in IC project

## 8.9.1 - 6th April 2020

### Improvements

Merged forward from 8.7.15

- !687 UIUX-678 Added CSS Classes to Infocapture Project Options & Statistics panels

### Bug fixes

- Fixed further search indexing problems for InfoCapture Issue that occurred when the Issues lacked any form data

Merged forward from 8.7.15

- !632 BT-577 Prevent empty metadata fields being included in LDAP sync
- !677 BT-1329 Fixed breadcrumb text not localized when changing password
- !680 Removed HR Permissions dependency from Roles library
- !685 BT-1415 Disco 27496 Fixed user list pagination links being broken when searching for groups and subgroups
- SCH-241 Fixed a fatal error that could occur when importing system data via sysadmin
- IC-23 Added missing translation keys and Russian localisations in Infocapture
- !689 BT-1271 Set common holidays table to use background styling instead of images

### Developer notes

- !660 FRAM-122 Updated Zend Diactoros 1.8.6 to Laminas Diactoros 2.2.1

## 8.9.0 - 18th March 2020

### New features

- !557 UIUX-635 Created horizontal form styled config dialog template, implemented template in sysadmin background services.
    - replaced config dialog radios with web components
- !252 FRAM-104 People API Version 2
  - A new version of the People API has been implemented, allowing consumers to create, read, update and delete Users, Roles, Groups and Extranets
  - See developer documentation for more information: https://developer.claromentis.com
- !410 CORE-801 Functionality added to Statistics that allows modules to provide statistical data for inclusion in the statistics module.
- !429 ASD-170 Implemented new `clc data:export` and `clc data:import` commands to replace the old data export/import pages
- !541 UIUX-621 added new `app_with_left_panel.html`, `app_with_right_panel.html`, `app_with_both_panels.html` & `standard_app_page.html`  templates for improved usability on mobile devices.
- !490 !525 CORE-960 Added support for Elasticsearch 7
- !540 !550 !563 !577 !578 !646 !649 !674 Updated the Claromentis Design System to version 0.1.38
  - Claromentis Design System components are now available globally
  - Style reference page has been updated to demonstrate new components with all available documentation
- !540 UIUX-596 UIUX-597 Created a progress bar datatable decorator
- !587 CORE-1040 Added auditing of likes and unlikes in news and gallery
- !678 CORE-1052 CORE-1049 Old announcements section in news admin area has been marked as deprecated

### Improvements

- !476 The list of admin panels is now located at `/admin/`. The old URL redirects to the new one.
- !460 CKEditor config can now be customised by modules
- !353 FRAM-287 Renamed "Heartbeat monitor" to "Background task" in the admin panel to reflect how it is normally referred to.
- !507 FRAM-140 user lists in people front-end and admin area are now routed pages instead of scripts
- !442 ASD-97 License checks are no longer made when running the background task
- !445 CORE-624 User-to-user messages now appear in global search
- !491 CORE-975 Wrapped InfoCapture project import in a transaction, so imports will now either succeed entirely or do nothing  
- FRAM-309 Sessions are no longer bound to IP by default
- !566 FRAM-338 Implemented Filesystem abstraction support for serving local appdata
- !564 TY-12 User Picker's will only show appropriate Permission Group Types under the browse option when limited.
- !561 BT-859 Power users who cannot edit a user will no longer see editable form controls when viewing the user in the admin area
- !583 FRAM-354 FRAM-325 New environment variables added for mail sending and image resizing
- !584 FRAM-355 The search help page and help modal have been removed
- !569 UIUX-648 Internal messages icon and application control consistency improvements.
- !590 Updated styling of Blog Post and News Article pages
- !588 FRAM-331 Highcharts library upgraded to the latest version.
- !423 CORE-708 Gallery albums and images can now be found using global search
- !533 FRAM-288 Added default mobile app details to the well_known endpoints for Universal links in iOS and Android
- !399 CORE-776 BT-770 Added permissions for statistics in InfoCapture. Now, only users who have this permission can see statistics.
- !644 UIUX-406 Limited the size of extranet logo across all devices
- !652 UIUX-In Communication, Start Conversation is now renamed to Forward and some UI Improvements.

### Bug fixes

- !559 UIUX-639 Removed margin from names in Who's Out group by day type
- !519 BT-681 Remove hover transition causing rendering bugs on IE11
- !544 FRAM-318 Fixed healthcheck endpoint not being available if Redis is disabled
- !252 BT-954 Fixed extranet filters preventing power users from seeing users they have permission to view in People Admin
- !581 Fixed SQLite driver issue caused by a bug in PHP 7.2.24
- !598 CORE-701 Fixed updated Gallery album names not showing properly in the gallery list component
- !252 License checks will now take into account server variables to discover the current port number
- !609 BT-898 BT-899 Power users without permission to edit a user can now change their extranet area if they have appropriate permissions
- !618 BT-273 Fixed InfoCapture list filters being reset; added "back to list" button when viewing and editing InfoCapture issues.
- !619 BT-1011 Added missing localization for news images (drag & drop form)
- Fixed InfoCapture Issue search indexing getting stuck if issues lack form data
- !674 BT-1301 Fixed Calendar pages conflicting with the Design System
- !620 BT-797 Fixed issue with the IC status table overflowing out of desktop screen
- !637 BT-1067 Fixed issue where archive news images dont resize properly

### Breaking changes

- !399 CORE-776 InfoCapture Statistics Button Permissions
  - Added column `hd_project.view_stats_rights`
- !490 !525 CORE-960 Added support for Elasticsearch 7
  - Child permissions are no longer supported for search objects
  - Search object attachments must now be in a field called 'attachments'
  - Every search object type is now in its own index
- !447 FRAM-97 Removed `GetUrlGCSPlugin` class, `GetUrlAdapterPlugin` is now used instead
- !524 FRAM-293 Exposed DataTable filter data for Data Sources
  - Added interface methods:
      - `Claromentis\Core\DataTable\Contract\Parameters::GetFilters()`
      - `Claromentis\Core\DataTable\Contract\TableFilter::GetFilters()`
  - Added class methods:
      - `Claromentis\Core\DataTable\TableParams::GetFilters()`
      - `Claromentis\Core\DataTable\ColumnFilterCollection::GetFilters()`
- !566 FRAM-338 Implemented Filesystem abstraction support for serving local appdata
  - `Claromentis\Core\TextUtil\ClaText::ProcessAvailableLocalization()` has been moved to `Claromentis\Core\Localization\Lmsg::ProcessAvailableLocalisation()`
  - `Claromentis\Core\TextUtil\ClaText` constructor no longer requires an instance of `Lmsg`
  - `Claromentis\Core\Http\HttpUtil` constructor no longer requires an instance of `NotificationManager`
      - Notifications are no longer sent when using `HttpUtil::HttpRedirect`
- !353 FRAM-287 The healthcheck REST API (not yet used) has had its "heartbeat" key changed to "background_task"
- !564 TY-12 Moved Templater Component class `\Claromentis\Core\Widget\SUGREPicker` to `\Claromentis\Core\Widget\Sugre\SUGREPicker`.
- !598 FRAM-72 `ClaCache::C_SHORT` caches no longer use memcache; they are no longer unintentionally persisted across multiple requests
- !242 FRAM-104 The `rest.formatter` service is now an instance of `\Claromentis\Core\REST\RestFormatter` instead of the now-deprecated `\RestFormat`

### Developer notes

- !447 FRAM-97 Replaced GCS flysystem adaptor with one that is better maintained
  - Changed from `"cedricziel/flysystem-gcs": "^2.0"` to `"superbalist/flysystem-google-storage": "^7.2"`
- !540 UIUX-596 UIUX-597 Allowed all `<cla-*>` HTML elements to retain their `name` attributes in Templater templates
- !524 FRAM-293 Exposed DataTable filter data for Data Sources
- !252 FRAM-104 People API
  - Changed REST route default versions to use sub-requests instead of remounting routes
  - Fixed `Claromentis\Core\REST\RestExceptionListener` failing to build a JSON response if exception traces were cyclical
  - The following classes are now **deprecated**:
      - `RestFormat` - use the new (compatible) `Claromentis\Core\REST\RestFormatter` instead (`rest.formatter` service has been updated accordingly)
      - `User` - use `Claromentis\People\Entity\User` instead, where possible
      - `UserExtranetArea` - use `Claromentis\People\Service\UserExtranetService` or `Claromentis\People\Repository\ExtranetRepository` instead
      - `UserGroup` - use `Claromentis\People\Service\UserGroupService` or `Claromentis\People\Repository\GroupRepository` instead
      - `UserRole` - use `Claromentis\People\Service\UserRoleService` or `Claromentis\People\Repository\RoleRepository` instead
      - `UsersAdmin` - use `Claromentis\People\PeopleAcl` instead
      - `UserFieldsConfig` and `UserFieldsConfigAdmin` - use `Claromentis\People\UsersFieldsConfigService` instead
      - `UserFieldsPermissions` and `UserFieldsPermissionsAdmin` - use `Claromentis\People\UserFieldsAcl` instead, where possible
      - `UsersHierarchy` - use `Claromentis\People\UsersHierarchyService` instead
  - The following constants are now **deprecated**:
      - `USER_ACCOUNT_STATUS_ACTIVE`  - use `Claromentis\People\Entity\User::STATUS_ACTIVE` instead
      - `USER_ACCOUNT_STATUS_BLOCKED` - use `Claromentis\People\Entity\User::STATUS_INACTIVE` instead
      - `AGGREGATION_USER` - use `Claromentis\People\Entity\User::AGGREGATION` instead
      - `AUDIT_SUCCESS` - use `Claromentis\Core\Audit\Audit::AUDIT_SUCCESS` instead
      - `AUDIT_FAILURE` - use `Claromentis\Core\Audit\Audit::AUDIT_FAILURE` instead
      - All `PERM_OCLASS_*` constants - use `Claromentis\Core\Acl\PermOClass` constants instead
  - The following functions are now **deprecated**:
      - `get_available_languages()` - use `Claromentis\Core\Localization\LanguageList::GetAvailableLanguages()`
      - `get_builtin_languages()` - use `Claromentis\Core\Localization\LanguageList::GetBuiltinLanguages()`
      - `get_custom_languages()` - use `Claromentis\Core\Localization\LanguageList::GetCustomLanguages()`
      - `write_custom_langs()` - use `Claromentis\Core\Localization\LanguageList::WriteCustomLanguages()`
  - The `Claromentis\Core\Audit\Audit` service now has `Success()` and `Failure()` methods that can be used in place of `Audit::Store()` without needing to provide a type constant
  - Added `Claromentis\Core\Http\StatusCode::IM_A_TEAPOT` constant
  - Added globally available `whereKeywords($columns, $keywords, $boolean)` macro to all Analogue ORM Mappers for simple keyword searches
  - Introduced `Claromentis\Core\ORM\Mapper` decorator for use with Analogue ORM
  - Introduced `Claromentis\Core\ORM\EntityMap` for use with Analogue ORM
      - Fixes SQL (Column cannot be null) errors when detaching hasMany related entities by allowing default foreign key values to be set per-map
  - Introduced several more useful methods to `Claromentis\Core\ORM\Repository`
  - `Claromentis\Core\Security\SecurityContext` methods `GetUserId()`, `GetSudoUserId()` and `GetExtranetAreaId()` now return integers only, instead of strings or integers
- FRAM-309 Sessions are no longer bound to IP by default: `$cfg_bind_session_to_ip` now defaults to `false`
- !484 FRAM-284 Refactored code around `@{localisation.key|default}` syntax
- !542 FRAM-189 Added a test notification ability to labs and CLC
- !583 FRAM-354 FRAM-325 New environment variables added for mail sending and image resizing
  - `CLARO_MAIL_SEND_DRIVER` maps to `cfg_mail_send_driver`
  - `CLARO_MAIL_SEND_PARAMS` maps to `cfg_mail_send_params` as JSON
  - `CLARO_IMAGE_RESIZE_METHOD` maps to `image_resize_method`
- !598 FRAM-72 `ClaCache::C_SHORT` caches no longer use memcache; they are no longer unintentionally persisted across multiple requests
- !622 BT-1030 Fixed bug when sending test email notifications to Users.
- !635 Added support for autoloading `Claromentis\Custom\{Application}\Kernel` from `web/custom/{application}/kernel`
- !645 Setting `max_guest_perms` to `0` on a `CommonPermsDialog` now correctly prevents "Public" from being selectable.

## 8.8.21 - 25th November 2020

### Improvement

- !890 Changing the themes of other users will now take effect immediately, instead of requiring them to re-login

### Bug fixes

- !854 BT-1235 InfoCapture timers are now included as part of .xml export/import files
- !890 BT-2078 Themes whose assets are missing after upgrading to `8.8.19` have been restored

### Breaking changes

- !890 `ActiveTheme` constructor parameters have changed in order and quantity

### Bug fixes merged forward from 8.7.22
- !900 BT-2090 Fixed XSS vulnerability

## 8.8.20 - 19th October 2020

### Merged forward from 8.7.21

#### Bug fixes

- FRAM-520 Fixed appdata regression

## 8.8.19 - 16th October 2020

### Improvements

- !835 FRAM-481 Existing `.env` configuration is now retained when installing Core

### Bug fixes

- !842 BT-2015 Fixed tags not being able to be renamed to change capitalisation
- !838 BT-1997 [DISCO 029811](https://discover.claromentis.com/forms/tickets/view/029811) Fixed validation in IC now financial field will accept value 0
- !847 FRAM-498 Fixed logger service error during initial installations
- !851 BT-2030 Role-based ACL role management could remove the wrong entry when removing entries
- !836 BT-1957 Themes created from VIs can no longer have invalid Theme Codes.

### Developer Notes

- !847 FRAM-498 Added mitigation for unavailability of `$g_application` during installation via Phing.
- !854 BT-1235 New IC XML export version 12 file to add timer support. This is backwards and forwards compatible with version 11.

### Breaking changes

- !851 BT-2030 Changed constructor arguments for `Acl/RoleBased/RoleRepository.php`

### Merged forward from 8.7.20

#### Bug fixes

- FRAM-520 Fixed appdata vulnerability

## 8.8.18 - 1st October 2020

### Improvements

- !778 FRAM-410 Implemented cache busting for JavaScript assets loaded via RequireJS
- !819 FRAM-477 Added Greek Translation for Localization Phrase "forms.section_saved".
- !820 BT-1965 Infocapture: Improved reports generation speed.
- !777 BT-1885 Added support for mapping dates from LDAP to claromentis datetime and date without year metadata types.
- !829 BT-2009 Improved layout and content of default document upload notifications

### Bug fixes

- !791 BT-1796 Disco 028398, 029263 Added missing authentication check for Documents URL redirects
- !807 FRAM-454 File clean-ups will now be run when upgrading with `clc app:upgrade`.
- !808 BT-1935 Menu builder: Fixed the link to a Menu Item's edit page on a Menu Item's Permissions page.
- !811 BT-1951 The names of the "latest note" InfoCapture template placeholders have been corrected
- !805 BT-1950 Entering "00:00" as the end time for an InfoCapture SLA day will now be treated as meaning the end of that day (instead of the beginning)
- !815 BT-1959 Fixed split multi-byte characters that prevented text and address metadata fields from being saved
- !821 BT-1975 Entering values that are too long into the add/edit menu item form no longer causes an error
- !827 BT-1861 Users who subscribed to a news channel, and then removed from channel permissions will not get notification
- !828 BT-1980 Fixed importing users from CSV not working when the CSV contained a language column
- !812 BT-1908 Fixed InfoCapture notifications not displaying names of the submitter/assignee in some cases

### Developer notes

- !816 FRAM-470 Implemented file logging for database queries and errors
  - Added `database` logger
  - `error` log level: Logs all database query errors during execution, parsing or binding
  - `debug` log level: Logs all database queries made via the DAL
- !819 FRAM-477 Removed Localization Phrase "lt forms_section.saved" due to lack of use/incorrect delimiters.

### Breaking changes

- !778 FRAM-410 `src/js/lib/requirejs/require.min.js` has been removed in favour of an NPM-installed version of RequireJS

### Developer notes

- !778 FRAM-410 RequireJS has been updated from 2.3.3 to 2.3.6
- !816 FRAM-470 Implemented file logging for database queries and errors
  - Added `database` logger
  - `error` log level: Logs all database query errors during execution, parsing or binding
  - `debug` log level: Logs all database queries made via the DAL
- !819 FRAM-477 Removed Localization Phrase "lt forms_section.saved" due to lack of use/incorrect delimiters.
- !824 BT-1987 AWS exceptions are no longer used in InfoCapture or OrgChart.
- !830 FRAM-455 Implemented loading  .env files from the application directory's parent directory

## 8.8.17 - 1st September 2020

### Bug fixes

- !801 BT-1931 Files attached when editing an existing private note in InfoCapture are now correctly marked as private
- !804 BT-1873 [Disco 029082](https://discover.claromentis.com/forms/changes/view/029082) Added missing Spanish localisations
- !806 BT-1952 Infocapture Reports will no longer fail due to certain Symnames on the Project's Form's Inputs.

### Developer notes
- !806 BT-1952 Infocapture Reports reporting on Fields with the following Symnames will no longer fail:
  - reporter
  - assigned
  - created
  - last_modified
  - status
  - archived

## 8.8.16 - 17th August 2020

### Bug fixes

- !784 BT-1897 "Ticket handler" and "status" columns no longer show in InfoCapture issue list if they are not used by the project
- !782 BT-448 Fixed empty growl messages in absence requests component
- !786 BT-1896 [Disco 029201](https://discover.claromentis.com/forms/tickets/view/029201) Fixed InfoCapture issue private files being accessible to any user if the "Submitter of ticket" or "Handler" roles were given "Private notes and files" rights
- !735 BT-1651 Fixed digest emails not being sent when the digest was set per-module

### Bug fixes merged forward from 8.7.18, 8.7.19

- !797 BT-1921 Fixed XSS vulnerability
- !663 BT-332 fixed Issue with drag&drop in Zones and groups
- !611 BT-453 Adding a new user profile field no longer causes a database error when using MSSQL
- !787 BT-1909 Fixed XSS vulnerability

## 8.8.15 - 4th August 2020

### Improvements

- !760 BT-1838 Expanded Trigger Rule description to mention the behaviour of Rules *Condition was* and *Condition was not*.
- !767 BT-1843 The message shown in the news component when there is no news to display is now localised
- !720 IC-21 (Infocapture) Added a User Acknowledgement Barrier to the Symbolic Name field when modifying an Infocapture Form.
- !755 FRAM-395 Infocapture: Speed improvements for CSV import and export
- !773 PMSW-25 Whitespace is now stripped on numeric fields for configs using ConfigDialog (`\Claromentis\Core\Config\ConfigDialog`).

### Bug fixes

- !747 DISCO 28407 Fixed InfoCapture projects fetching each other's mail
- !731 FRAM-387 Search terms containing HTML are now escaped properly in the search suggestions dialog
- !756 BT-1090 Fixed users in subgroups sometimes not being considered members of the group tree if they did not have permission to see the parent group
- !757 BT-1840 - News article creation/edit link help text localisation changed
- !749 BT-1780 Disco-27324 Fixed issue with dates being set blank for LDAP users
- !769 BT-1846 (Infocapture) Fixed PHP Warning when entering a duplicate Form Field Symname.
- !771 BT-1849 Having empty cells in the "id" column of a csv will no longer cause user importing to fail
- !766 BT-1399 - Using a temporary table with SQL Server could cause an error
- !761 BT-1839 When a user selects a location on the "my settings" page, it will be correctly displayed on subsequent visits to the "my settings" page
- !764 BT-1786 "System events" in the calendar, such as absences and events from the events module:
  - correctly show as not having a reminder by default
  - can be set to have no reminder if a reminder is set
  - can have their reminder set from the event details page

### Breaking changes

- !761 BT-1839 The `usr_timezone` metadata value may now contain a (user-specified) location name instead of a time zone

### Developer notes

- !761 BT-1839 The `usr_timezone` metadata value may now contain a (user-specified) location name instead of a time zone. The `DateClaTimeZone::FindUserTZID` method will still always return a timezone ID.

## 8.8.14 - 25th June 2020

### Bug fixes

- MA-51 Fixed Document PDF previews in the Claromentis Android App
- !744 BT-1758 Infocapture: Mail body can now be left unmapped to form field.
- !750 BT-1791 Fixed "Wrong issue ID" error when editing InfoCapture issue notes and downloading issue files

#### Merged forward

- !611 BT-453 Adding a new user profile field no longer causes a database error when using MSSQL

### Improvements

- BT-1749 Added further detail to exception message in the event that the File Upload Directory has been deleted.

### Developer notes

- Added `--prefer-dist` option flag to the Composer command run by `clc resolve`, `clc update` and `clc update-all`
- !744 BT-1758 Added logging when receiving mail.
- !744 BT-1758 Infocapture: Added logging when converting mail to tickets.

## 8.8.13 - 2nd June 2020

### Bug fixes

- !698 BT-1466 Fixed drag-and-drop image uploads failing with Redis enabled
- !709 BT-1564 Infocapture issue tabs URLs being temporarily invalid for some projects while loading
- !714 BT-1570 Updated comments library to delete comment attachments when deleting comments by their associated object.
- !717 BT-1623 A `Comment`'s `Reply Count` will now correct whenever a Reply is created, edited or deleted.
- !726 BT-1642 fixed adding localisation keys not working when using IE11

## 8.8.12 - 15th May 2020

### Bug fixes

- Fixed multi-byte character set error on MySQL when saving InfoCapture issues
- !703 BT-1548 Fixed logged errors caused by missing session handler methods
- !710 BT-1527 Fixed most recent note options in sidebar not working when editing an InfoCapture notification template
- !712 BT-1549 InfoCapture: Blocked Users will no longer be removed from Form Input selection when editing a Ticket
- !717 BT-1623 Fixed incorrect comment reply counts whenever a reply is created, edited or deleted
- !721 BT-1634 Removed extra slashes from heredoc email template. Fix will prevent to display email header in email body
- !725 BT-1641 Fixed some user pickers and permission dialogs incorrectly selecting all users, instead of only those that were selected

### Developer notes

- !586 SDB-698 Implemented configurable object storage (database connections) for ActiveRecord objects
- !725 BT-1641 Fixed incorrect list of Users being returned when `User Account Status` is filtered by in `\Claromentis\Core\Acl\UsersReader::GetUserIds`

## 8.8.11 - 4th May 2020

### Bug fixes

- !691 BT-600 A user who has been forced to change their password on next login can now choose to logout instead of changing their password
- !692 BT-1423 Fixed error when cancelling editing document
- !694 BT-192 A holiday booked for the first day of a holiday planner year will now show in the "my requests" tab, as intended.
- !695 BT-1487 Fixed sticky pin still showing on news page component after expiring
- !699 BT-1482 InfoCapture "note added" triggers are no longer activated when a note is edited
- !702 BT-578 Fixed problem where empty AD attributes were mappable on LDAP configuration form
- !702 BT-578 Undefined fields can no longer be added in LDAP configuration form
- !707 BT-1560 Fixed session persistence and IP binding issues
- !706 BT-1525 Fixed location error too long for calendar event

### Bugfixes merged forward from 8.7.16

- !696 BT-1495 Disco 027181 Fixed double-encoded metadata in the People card list view
- !701 BT-1462 Power Users can now see Disabled Users.
- !705 BT-1333 Disco 027462 Fixed issue with random permission for a new role in IC project

## 8.8.10 - 6th April 2020

### Improvements

Merged forward from 8.7.15

- !687 UIUX-678 Added CSS Classes to Infocapture Project Options & Statistics panels

### Bug fixes

Merged forward from 8.7.15

- !632 BT-577 Prevent empty metadata fields being included in LDAP sync
- !677 BT-1329 Fixed breadcrumb text not localized when changing password
- !680 Removed HR Permissions dependency from Roles library
- !685 BT-1415 Disco 27496 Fixed user list pagination links being broken when searching for groups and subgroups
- SCH-241 Fixed a fatal error that could occur when importing system data via sysadmin
- IC-23 Added missing translation keys and Russian localisations in Infocapture
- !689 BT-1271 Set common holidays table to use background styling instead of images

## 8.8.9 - 3rd March 2020

### Bug fixes

- !658 BT-1176 Fixed fatal error occurring when processing large strings to escape or add links.
- !666 BT-1283 (disco-027041) Table Room booking changed order to the scheduled booking time rather than when booking was made.

## 8.8.8 - 3rd February 2020

### Bug fixes

- !634 UIUX-660 Removed code which causes odd page layouts on mobile

## 8.8.7 - 9th January 2020

### Bug fixes

- !615 BT-856 Image lightbox for Discuss and DMSV Component fits better in the preview window.
- !597 FRAM-365 Adding SSO user accounts where an LDAP server is not yet configured will no longer fail. The user will be created as a local account instead.
- !668 BT-697 the attendees list for a calendar event will now show even if the current user was not invited to the event

### Improvements

- !638 Cherry-picked core Uzbek translations from version 8.9.

## 8.8.6 - 3rd December 2019

- Merged forward changes from 8.6.13, 8.7.11

### Bug fixes

- !574 BT-922 Fixed Post button alignment on small screens in the Discuss comments component by replacing it with a Send icon.
- !575 BT-788 Fixed **Embedded Plural** Localizations no longer formatting correctly on **Lmsg** Service.
- !585 UIUX-532 Made 'pinned' icons visible when a news article is pinned to top.
- !604 UIUX-660 Padding improvement on mobile devices.

### Improvements

- CORE-1036 Added Hungarian localisation

### Developer Notes

- !575 Added **Lmsg** Unit Tests.

## 8.8.5 - 5th November 2019

### Bug fixes
 - Merged forward bugfixes from 8.2.21, 8.3.19, 8.4.18, 8.5.18, 8.6.12, 8.7.10

## 8.8.4 - 18th October 2019

### Bug fixes

- !547 BT-844
  - Subscribers are no longer notified when unpublished news is added. They are instead notified when the publish date is reached.
  - Users who are not channel moderators can no longer view unpublished, unapproved or draft news if they happen to have the URL.  

## 8.8.3 - 7th October 2019

### Improvements

- Updated Claromentis Design System from 0.0.37 to 0.0.40

### Bug fixes

- !536 BT-783 Fixed issue where IC field expressions were not handled correctly in emails
- !528 UIUX-612 Theme title on design utility page is now center-aligned
- !528 UIUX-608 Document marker title field is now aligned and page background is no longer displayed in marker preview
- !519 BT-681 Remove hover transition causing rendering bugs on IE11

## 8.8.2 - 18th September 2019

### Bug fixes

- !526 BT-662 Fixed bug that caused clearing the cache to delete all DAM assets

## 8.8.1 - 4th September 2019

### Improvements

- Updated Claromentis Design System to 0.0.35

### Bug fixes

- Fixed error when clearing caches from the Labs admin panel

## 8.8.0 - 6th August 2019

### New features

- !366 ASD-92 Implemented a `/healthcheck/v0` endpoint, and a `clc check:health` command
- !411 UIUX-26 Added support for Claromentis Design System Web Components

### Improvements

- !397 UIUX-138 Navigation and search improvements to News
- !342 CORE-208 Added InfoCapture template variables for showing the latest note, and conditionally showing the latest note if it is public
- !370 Split Guest Access & Login Themes configuration into separate tabs and improved behaviour
- !432 Added support for new style licenses
- !370 UIUX-410 Split Guest Access & Login Themes configuration into separate tabs and improved behaviour
- !387 ASD-106 Assets cache is now shared between machines in a load-balanced installation
- !438 UIUX-245 Who's out component styling toggles (badge and modern mode)

### Bug fixes

- !489 CORE-962 fix comments not loading when user can manage albums
- !383 CORE-755 Fixed Symfony version incompatibility that was preventing the installer from working
- !403 CORE-817 Fixed trailing slashes not being redirected due to Symfony updates
- !456 CORE-866 Fixed missing files resulting in inability to delete comments due to error_reporting.
- !453 Fixed HTTP status code for non-existent REST routes (changed to 404 instead of 500)
- !480 CORE-867 Fixed password minimum length localisation in password policy error message
- !485 BT-536 Fixed bug that prevented localization cache from being cleared

### Breaking changes

- !381 CORE-205
  - Removed `Psr7Bridge\Psr7ControllerResolver` (superseded by `Psr7Bridge\Psr7ArgumentResolver`)
  - (CORE-205) Several Symfony components have been updated from their v2.x versions to their v4.x equivalents
  - Several Symfony components have been updated from their v2.x versions to their v4.x equivalents
- !366 ASD-92
  - `ApplicationRegistry::getSchemaVersion()` will now strip the "custom/" prefix off a module name (if present) before checking the version
  - `ApplicationRegistry::getAllCodes()` will now return custom module codes without "custom/" prefix, and will not return duplicate results for custom modules
  - The error handler used when running a REST route has changed
  - If a variable is fetched from DBvar with `$enable_cache = false`, then it will not be stored in the cache
  - `$app['admin.panels_list']` will be null if the database cannot be contacted, or core is not installed
- !387 ASD-106
  - `Claromentis\Admin\Sysadmin\CacheClearer` now takes a pair of path generators instead of the config bundle
  - `FilesystemInterface` now has a `ListContentsInfo` method, for listing the contents of a folder with extra details
- !403 CORE-817 The router now uses a custom `RedirectableUrlMatcher` instead of the standard `UrlMatcher`
- !431 CORE-8 Updated PHPUnit from v4.6.10 to v7.5.12
  - The PHPUnit test case class is now `\PHPUnit\Framework\TestCase` instead of `\PHPUnit_Framework_TestCase`
  - The `setExpectedException()` has been replaced by `expectException()`, `expectExceptionMessage()` and `expectExceptionCode()`
- !429 (ASD-170) the old data import/export pages have been removed. The new command line import/export should be used instead

### Developer notes

- !381 CORE-205 Updated Silex to the latest version (v2.3.0)
- !431 CORE-8 Updated PHPUnit from v4.6.10 to v7.5.12
- !209 CORE-382 New services - lots of new injectable classes to help structure code and aid in unit testing:
  - Injectable service `RequestData` supersedes the most used static methods from `gpc`
  - Injectable service `HttpUtils` supersedes the global functions in http_functions.php (`httpRedirect()`, `http_send_file()`, etc)
  - Injectable service `Lmsg` supersedes the global function `lmsg()`
  - Injectable service `DbVarService` supersedes the static class `DBVar`
  - Injectable service `ClaText` supersedes the static methods from `ClaText`
  - Injectable service `License` supersedes the global functions in `license_functions.php`
  - Injectable service `FilesystemUtil` supersedes some of it's own static methods
  - Injectable services for `UserGroup`, `UserRole` and `UserExtranetArea` to supersedes the static functions from those classes
  - Injectable factory `QueryFactory` to avoid instantiating `Query`, `QueryHelper`, `QueryUpdate` and `QueryInsert` directly
  - Injectable factory `DateFactory` to avoid instantiating Date, `DateDay` and `DateNoYear` directly
  - Injectable factory `LicenseFactory` to avoid instantiating `License` directly
  - Injectable factory `ResponseFactory` to avoid instantiating controller responses (`TemplaterCallResponse`, `JsonPrettyResponse`, etc) directly
  - Injectable factory `InfocaptureFactory` to avoid instantiating `FBField` directly (more to come later on)
  - New InfoCapture constants class `FormUtils` to try and start cutting down how many are in `constants.php`
  - New variable `$g_application['front_controller_mode']` to find out how the current request was routed (constants in `Core\ApplicationMode`)
- `clc test:run` and `clc test:watch` should now run correctly on Windows, with a couple of new options available:
  - `--filter=TestCaseName` can be used to filter test cases
  - `--isolate` can be used to run PHPUnit with process isolation (slower)
- !409 Fixed misleading InfoCapture constant names
  - `HD_PERM_REPORT` has been renamed to `HD_PERM_SUBMIT`
  - `HD_PERM_STATISTICS` has been renamed to `HD_PERM_REPORTS`
  - Original constant names are still available but marked as deprecated
- Added "page_top.banner" hook in `page_top.html` for rendering custom banner notifications
- !411 UIUX-26 Claromentis Design System can be included on a page using `require(['design_system']);` in JavaScript

## 8.7.22 - 25th November 2020

### Bug fixes
- BT-2090 Fixed XSS vulnerability

## 8.7.21 - 19th October 2020

### Bug fixes

- FRAM-520 Fixed appdata regression

## 8.7.20 - 16th October 2020

### Bug fixes

- FRAM-520 Fixed appdata vulnerability


## 8.7.19 - 17th August 2020

### Bug fixes

- !797 BT-1921 Fixed XSS vulnerability

## 8.7.18 - 14th August 2020

### Bug fixes

#### Merged forward from 8.6.15

- !663 BT-332 fixed Issue with drag&drop in Zones and groups
- !611 BT-453 Adding a new user profile field no longer causes a database error when using MSSQL
- !787 BT-1909 Fixed XSS vulnerability

## 8.7.17 - 14th May 2020

### Bug fixes

- !725 BT-1641 Fixed some user pickers and permission dialogs incorrectly selecting all users, instead of only those that were selected

### Developer notes

- !725 BT-1641 Fixed incorrect list of Users being returned when `User Account Status` is filtered by in `\Claromentis\Core\Acl\UsersReader::GetUserIds`

## 8.7.16 - 4th May 2020

### Bug fixes

- !696 BT-1495 Disco 027181 Fixed double-encoded metadata in the People card list view
- !701 BT-1462 Power Users can now see Disabled Users
- !705 BT-1333 Disco 027462 Fixed issue with random permission for a new role in IC project

## 8.7.15 - 2nd April 2020

### Improvements

- !687 UIUX-678 Added CSS Classes to Infocapture Project Options & Statistics panels

### Bug fixes

- !632 BT-577 Prevent empty metadata fields being included in LDAP sync
- !677 BT-1329 Fixed breadcrumb text not localized when changing password
- !680 Removed HR Permissions dependency from Roles library
- !685 BT-1415 Disco 27496 Fixed user list pagination links being broken when searching for groups and subgroups
- SCH-241 Fixed a fatal error that could occur when importing system data via sysadmin
- IC-23 Added missing translation keys and Russian localisations in Infocapture
- !689 BT-1271 Set common holidays table to use background styling instead of images
- !688 BT-1413 Fixed Documents' Detailed Report error when filtering for Users with no owned Documents.

## 8.7.14 - 3rd March 2020

### Bug fixes

- !676 BT-1295 Fixed comment reply duplicates
- !675 BT-1272 Fixed survey thank you text displaying default value
- !552 BT-708 Fixed support for LDAP groups using primaryGroupID on users to denote membership
- BT-1085 Fixed intermittent JavaScript errors when loading DataTables
- !665 BT-1251 dynamic changes can now use date-based triggers
- !661 BT-1118 Fixed Tags Templater Component's "Show All" option not working for >40 Tags.
- !664 BT-1117 Documents Tag indexing will now be updated when Tags are changed.
- !672 BT-1282 what's new component now loads properly if it is below the fold on IE11
- Fixed "full name" script injection in user lists

## 8.7.13 - 3rd February 2020

### Bug fixes

- !641 BT-643 in InfoCapture, inputting a non-numeric value into a financial form field will no longer cause a PHP error
- !624 BT-858 Fixed users remaining logged in when they are blocked or deleted
- !642 BT-1027 Unset status fields no longer cause an error when submitting InfoCapture tickets.
- !626 BT-1015 Disco 026291 Fixed InfoCapture email notifications using relative URLs for user profiles instead of absolute URLs
- !648 BT-1144 View effective permissions popup could give an error if an invalid group ID is used as Group+
- !621 BT-476 Implemented creation of CKFinder uploads directories if they do not exist, before failing with a "directory not found" error
- !647 BT-1096 Fixed doubled "User's Added" and "User's Updated" statistics being returned/audited when importing Users from CSV.
- !650 BT-1170 Documents export "only latest versions" checkbox was not being used.
- !651 BT-1161
    - Updating Users via the User CSV Import will now correctly follow the intended Active/Blocked state as defined.
    - Fixed incorrect warning when saving a new User as Blocked. Updated User's that cannot be saved as Active due to License Limits will now display a warning.

## 8.7.12 - 9th January 2020

### Bug fixes

- !606 BT-1000 In InfoCapture, a form field that is set to be editable but not visible
 will no longer show when editing an issue
- !630 BT-1045 Fixed PHP error when saving restricted IP Ranges.
- !633 BT-222 Dates contained in notification subjects will now be correctly displayed in a digest email
- !523 BT-710 Added a length constraint to Infocapture status titles
- !617 BT-980 Fix for user picker display in Infocapture projects. Updated Select2 library from 4.0.3 to 4.0.12

### Developer notes

- `clc test:run` and `clc test:watch` now run correctly on Windows and Node 10.x

## 8.7.11 - 3rd December 2019

- Changes merged forward from 8.6.13

### Improvements

- !576 FRAM-321 Increased default file size limit for animated GIFs from 2MB to 6MB
- !602 UIUX-574 The sorting of calendars in the list of calendars can now be set to
either "alphabetical" or "date created", and the sort direction can be set

### Bug fixes

- !570 BT-587 Deleting a past calendar event no longer sends notifications
- !576 BT-820 FRAM-273 FRAM-321 Fixed performance issues with crop tool uploads and GIF processing
- !591 BT-522 Users who set their notification method to "none" will now see other user's messages in communication chat
- !570 BT-587 Deleting a past calendar event no longer sends notifications
- !582 BT-462 All Google docs now show a preview when the user is logged in to Google
- SDB-680 Fixed a potential issue with predictive search on Linux systems

### Developer notes

- !576 FRAM-321 Increased `$cfg_image_animated_gif_max_size` from 2MB to 6MB
- !576 BT-820 FRAM-321 Introduced `$cfg_image_animated_gif_max_input_dimensions` and `$cfg_image_animated_gif_max_output_dimensions` (both defaulting to 1280)
  to improve ImageMagick performance when processing large GIFs
- Fixed `clc module:list` incorrectly reporting schema mismatches

## 8.7.10 - 5th November 2019

### Bug fixes

- !553 FRAM-322 Fixed OneSignal notifications sending without a launch URL
- !549 CORE-1009 Show error message when trying to move files to root folder
- !558 BT-862 Fixed group tree permission checks for Buttons and other modules that use the ORM
- !511 BT-642 FRAM-299 Fixed environment variables loading inconsistently from .env files in multi-threaded environments (Apache)
- Merged bugfixes forward from 8.2.21, 8.3.19, 8.4.18, 8.5.18, 8.6.12

### Developer notes

- !558 BT-862 Fixed group tree permission checks in AclScope

## 8.7.9 - 17th October 2019

### Improvements

- !520 CORE-973 Added Component Categories:
    - Calendar, Occasions & Events
    - Documents & Policies
    - Infocapture
    - Learning & Knowledge Base
    - News & Announcements
    - People, Communication & Social
    - Photos, Videos & Text
- !520 CORE-973 Added Component `Absence Requests` to Category `People, Communication & Social`.
- !520 CORE-973 Added Component `Announcements` to Category `News & Announcements`.
- !520 CORE-973 Added Component `Blog` to Categories `News & Announcements`, `People, Communication & Social` and `Learning & Knowledge Base`.
- !520 CORE-973 Added Component `Calendar Events` to Category `Calendar, Occasions & Events`.
- !520 CORE-973 Added Component `Gallery list` to Category `Photos, Videos & Text`.
- !520 CORE-973 Added Component `Mini Calendar` to Category `Calendar, Occasions & Events`.
- !520 CORE-973 Added Component `News` to Category `News & Announcements`.
- !520 CORE-973 Added Component `Polls` to Category `People, Communication & Social`.
- !520 CORE-973 Added Component `Surveys` to Category `People, Communication & Social`.
- !520 CORE-973 Added Component `What's new` to Category `News & Announcements`.
- !520 CORE-973 Added Component `Who's out` to Categories `Calendar, Occasions & Events` and `People, Communication & Social`.
- !520 CORE-974 Added Localized Titles to the following Components:
    - Absence Requests
    - Blog
    - Calendar Events
    - Gallery list
    - News
    - Polls
    - Surveys
    - Who's out

## 8.7.8 - 4th October 2019

### Bug fixes

 -!527 (BT-748) (Disco 024940) Fixed Document Preview failing to rename files in IE 11.
- !510 (Disco 025052) Disabled file upload buttons for Communication messages.
- !513 (UIUX-439) Disabled send button on Communication modal once it's been clicked.
- !538 (BT-787) Fixed bug that prevented a user unsetting the InfoCapture workflow for a role.

## 8.7.7 - 3rd September 2019

### Bug fixes

- !492 (BT-382) Fixed disabled "Post" button when submitting comments
- !498 (BT-568) Fixed bug - user can't edit holiday request
- !475 (FRAM-77) Fixed remote CDN configurations if an abstracted data directory is configured
- !505 (UIUX-560) Added rounded corners to images in gallery and blog components.
- !506 (UIUX-571) Small change to deal with odd button placement on Firefox.
- !515 (BT-632) Fixed broken links in calendar events component
- !516 (BT-676) Replaced non-array usages of count() and sizeof() in InfoCapture.

## 8.7.6 - 31st July 2019

### Bug fixes

- c79ff503 Fixed logger error occurring when acquiring database locks during installation
- !470 (CORE-943) Fixed performance issues with Communication Conversations that had a large number of participants
    - Conversations with more than 50 participants have been migrated to notifications
    - The full conversation participant list is now loaded on demand to improve performance
- !443 (CORE-880) Fixed image upload dialog issues when selecting from Documents
- !404 (CORE-818) Fixed PHP 7.2 countable compatibility errors for the Survey List component
- !481 (CORE-926) Fixed PHP 7.2 countable compatibility errors for the User Profile dialog
- !482 (CORE-913) Fixed PHP 7.2 countable compatibility errors for the InfoCapture Reports creation page
- !463 (BT-494) Fixed bug in `ProjectValueUpdateSubscriber` that was causing InfoCapture project imports and exports to fail
- !480 CORE-867 Fixed password minimum length in localisation for error when password is not strong enough

### Breaking changes

- !470 (CORE-943) `MessagesTrait::GetParticipantSummaryTemplateData` now requires a message ID, to facilitate XHR loading of the participant list

### Developer notes

- !443 (CORE-880) Ensured that `FilesystemCDN::Delete()` behaves as `CDNInterface::Delete()` prescribes;
  it no longer throws an exception if a file doesn't exist at the given path

## 8.7.5 - 8th July 2019

### Bug fixes

- !471 (BT-479) Fixed hybrid link error for News Article search results
- !457 (CORE-920) Fixed bug in `ColorUtil` that could cause a fatal error if a theme contained an invalid colour

## 8.7.4 - 4th July 2019

### Improvements

- !386 (CORE-136) Fixed InfoCapture status colour display issues
- !277 (CORE-77) Added audit logging for most Project actions in InfoCapture, including:
  - Changing a project's status
  - Changing the available ticket statuses
  - Changing the project's codename
  - Changing the project permissions
  - Changing field condition sets
  - Changing triggers
  - Changing project workflows
  - Changing field permissions/visibility
  - Changing SLA rules and work hours
  - Changing dynamic fields
  - Changing who gets notifications and why
  - Changing the layout of the ticket list
- !359 (CORE-415) Improved notification preferences UX to include Push Notification option
- !415 (UIUX-338) Added thumbnail mode to gallery component
- !402 (UIUX-228) Added Gradient color picker for Nav and Menu headers
- !439 (UIUX-486) Fix for issue with Navbar tooltips sticking after mouseoff
- !452 (BT-458) Fixed Infocapture bug where the 'leave page' prompt displays when an edit is saved.

### Bug fixes

- !436 (UIUX-505) Resolved layout isses with Greetings Component when ICDashboard Project List was added to the page
- !369 UIUX-407 Fixed issues when displaying metadata images on People profiles
- !382 (CORE-751) Cover images for newly-created orgcharts now save correctly
- !382 (CORE-770) Image crop tool now consistently works on load-balanced systems
- !420 (CORE-840) Fixed exception in InfoCapture when status is not assigned a colour.
- !417 (CORE-835) Fixed PHP 7.2 compatibility problem when deleting remaining ticket colour in Admin > InfoCapture > General List Options.
- !427 (UIUX-498) Fixed 'More' button appearing on page load in the Main menu when it is not required.
- !424 (CORE-848) Fixed session ID not being correctly regenerated on log out
- !435 (CORE-821) Fixed PHP 7.2 compatibility warning when changing a Gallery Album's cover image
- !446 (DISCO-024496) Fixed console error while checking out document
- (CORE-824) Fixed PHP 7.2 compatibility warnings when using News search

### Breaking changes

- !277 Changed FBField::InitFromRow() to be a publicly accessible method, for repository use
- !359 (CORE-415) The notification methods in `users` and `im_notification_methods` are now a bitmask instead of a sequential number.
- !424 (CORE-848) `LogoutController` no longer uses builtin session controllers directly
- !382 (CORE-770) Changed default `CLARO_REDIS_MODE` from `'MASTER'` to `'NONE'`, so that Redis is completely disabled by default (a connection attempt will not be made)

### Developer notes

- !386 (CORE-136) Refactored `ExtraCss` colour methods to new `ColorUtil` class
- !359 (CORE-415) `SendEvent` is now deprecated. If you need to filter or take action on messages, use `SendAllEvent` to
  act on the whole batch. Altering the recipient info list on `core.pre_message_all_send` will be picked up by the notification system.
- !444 Removed override of `SessionStorage::setSessionSaveHandler`
- Added a PHPDoc annotation sort order to Core's PhpStorm code style settings

## 8.7.3 - 30th May 2019

### Bug fixes

- Fixed an issue with missing localization keys in Russian translation
- Fixed incorrect locale in Russian translation

## 8.7.2 - 30th May 2019

### Bug fixes

- !392 (CORE-743) Fixed missing in-system notification option in Reset Notifications

### Improvements

- !413 (UIUX-350) Added alert when leaving Infocapture ticket submission form

## 8.7.1 - 9 May 2019

- Merged forward bug fixes and improvements from 8.2.18, 8.3.14, 8.4.12, 8.5.10, 8.6.5.

## 8.7.0 - 26 Apr 2019

### New Features

- !306 Filesystem abstraction - data directory can now be set to a GCS bucket **(EXPERIMENTAL)**
- !290 Admin scripts - Admins can now add their own script inside the head tags, after body tag start and before the end of the body tag.
- !293 People HR user list - Users with HR access can now view blocked users in frontend people list.
- !283 Progressive Collapse Menu - When a system has many menu items, extra menu items are now collapsed with 'More' button appear to reveal.
- !240 (CORE-5) Appdata - Stateless deployment support
- !330 Layout fixes to all of the core components to deal with new slimmer wrappers added by the 6-grid pages branch and improvements to uniform styling of empty components messages.
- !313 Custom localisation is now editable and persistent
  - Custom languages can now be edited from the system admin panel, and will be persisted through upgrades
  - Notification templates and the digest email template can now be edited from the system admin panel
  - The digest email template is now a Twig template
- !317 CKEditor config can now be edited from the system admin panel, and will be persisted through upgrades
- !351 Communication has been updated for a more chat-like experience

### Improvements

- Merged forward bug fixes and improvements from 8.2.17, 8.3.13, 8.4.11, 8.5.9, 8.6.4.
- !322 Improved Gallery List component to add extra sort option which order the album list by which album had the most recent upload. (CORE-130)
- !296 All session handling is now done through the session object
- !319 (UIUX-17) Default home page option in theme editor changed from 'As set in VI' to 'Main'. If Main does not exist the first in the list is used.
- !273 Infocapture notifications are now logged
- !315 (UIUX-94) Calendar event popups are now placed in the center of the browser window
- !326 Redesigned scrollable submenus
- !328 The license can now be set from an environment variable
- !314 Enabled support for team drives in Google document picker.
- !313 Custom localisation, languages, and twig templates are now stored in the data volume
- !317 CKEditor config is now stored in the data volume
- !334 Google documents indexing API failures now reports to the system log once on first failure state and thereafter once each day instead of reporting it every minute.
- !371 (CORE-693) Compatibility fixes for PHP 7.1 and 7.2

### Bug fixes

- !303 (CORE-138) Fixed problem in menu builder item form that generated an erroneous URL
- !341 (CORE-398) Fixed a PHP compatibility warning that could appear on user profiles
- !313 Digest emails now show module names
- !344 (CORE-377) Added a user-friendly error message when attempting to preview a theme if its homepage is a page the user does not have permission to view
- !304 (CORE-231) Guests were being shown the master theme instead of the guest theme if no session cookie was set
- !367 (UIUX-403) Resolved an issue with an underline effect on hover being incorrectly applied to some elements
- !380 (CORE-749) Removed option to set default background when editing theme
- !385 (CORE-762) Fixed console error on webmail admin panel
- !379 (CORE-746) Fixed PHP compatibility issues with InfoCapture Statistics
- !372 (ASD-115) Fixed mail sending when the Filesystem abstraction is configured

### Breaking Changes

- Custom languages will now default to using English pluralisation rules. Previously they used plural forms for all numbers.
- !240 (CORE-5) Appdata - Stateless deployment support
  - `Claromentis\Core\Assets\AssetsConcatenator` constructor signature has changed
  - `Claromentis\Core\CDN\Local` constructor signature has changed
  - `web/intranet/common/get_appdata.php` has been removed, and has been superseded by `fc/appdata.php`
- !331 (CORE-18) Ported core installation from Phing tasks
  - Core installation no longer creates `web/intranet/common/config.php`
  - Installing with an SQLite database does not yet work correctly
- `MySettingsController` and `ThemeSelectDialog` now accepts a `ThemeStyleInterface` instead of a `callable`
- !313 the digest template is now in Twig format
- !339 `DbInterface::GetQueryBuilder()` is a newly introduced method
- !306 `Claromentis\Core\Imager\DriverImageMagick` now must be passed a fallback driver when instantiated (although it can be null), and also an instance of `GetLocalPath`, so that it can translate data-volume paths to local paths. For the second one `$app[GetLocalPath::class]` should be used.
- !351 Added column `imessages.conversation_id`
- !351 `IMessage::Send()` has a new optional `$date_sent` parameter
- Changed all default filesystem character set configurations from ISO-8859-1 to UTF-8
- Changed PHP compatibility constraint to ">=7.1.0 <=7.3". PHP 7.0 is no longer supported.

### Developer notes

- !307 Added new Behat steps to perform some simple API tests and introduced some People API tests (CORE-118)
- !332 Added test:run and test:watch to CLC to run/watch PHPUnit tests for individual modules and parts of Core.
- !306 Filesystem abstraction
  - `CLARO_FS_MOUNTS` and `CLARO_FS_PATHS` config variables can be used to configure GCS as the data volume
  - `$cfg_cdn_type = 'filesystem';` and `$DATA_DIR = 'claro-data://data';` should be configured for this to work
  - See documentation for more information
- !240 (CORE-5) Appdata - Stateless deployment support
  - Allowed the `$APPDATA` config variable to be set by the `CLARO_APPDATA` environment variable for stateless
    deployments that are using Local CDN configs
  - Added support for nginx `X-Accel-Redirect` headers to let nginx serve appdata files
      - `CLARO_ACCEL_REDIRECT` config variable enables this
      - `CLARO_ACCEL_REDIRECT_PREFIX` gives an optional prefix for the internal path to use
      - See https://www.nginx.com/resources/wiki/start/topics/examples/xsendfile/ for more information
- !347 Implemented locking for Claromentis install, upgrade and uninstall commands
- !331 (CORE-18) Ported core installation from Phing tasks to the Symfony Console command
  - Implemented support for loading environment variables from a `.env` file in the application root
  - New `Configure` setup task that encapsulates setting up configuration prior to installs
      - Utilises Symfony Console's question prompting
      - Works non-interactively with environment variables using the `--no-interaction` command-line option
      - Writes environment config to a `.env` file when used interactively
      - Writes application config to `data/config/core.json`
      - Config is **no longer written to `config.php`**
  - (CORE-20) Restored cache-clearing when installing or upgrading modules
  - General improvements to existing caching and setup code
  - Implemented installation lock acquisition to prevent conflicts between multiple instances
- !339 Decoupled `QueryBuilder` from the global database instance
  - `QueryBuilder` can now be given a database instance to use
  - `DbInterface::GetQueryBuilder($str)` has been introduced to get a QueryBuilder for that database instance

## 8.6.15 - 14th August 2020

### Bug fixes

- !663 BT-332 fixed Issue with drag&drop in Zones and groups
- !611 BT-453 Adding a new user profile field no longer causes a database error when using MSSQL
- !787 BT-1909 Fixed XSS vulnerability

## 8.6.14 - 9th January 2020

### Improvements

- !610 BT-447 Fixed password generator not following password config
- !579 FRAM-337 Push notifications on iOS now cause the red notification bubble to appear

### Bug fixes

- !599 BT-961 Disco 026275 "Keep me logged in" feature had issues when a new session was started with guest access enabled
- !608 BT-502 Image Uploading will now work consistently on Load Balanced systems.
- !595 BT-579 Disco 026049 Fixed LDAP attribute mappings being removed then re-fetched in the LDAP admin panel.
- !613 BT-925 Calendar notification emails about edited events will now contain a copy of the event after it was been modified, instead of before.
- !614 BT-745
  - Images can be uploaded to be used in InfoCapture project descriptions, section headings, and notices
  - There is no longer an option to "upload" a link when editing an InfoCapture issue with an HTML field
- !625 BT-1037 Pages Text component options closed early when trying to format tables.
- !616 BT-411 Searches made anonymously will no longer be given as Recent Searches recommendations.

## 8.6.13 - 3rd December 2019

### Bug fixes

- !562 UIUX-643 Fixed display issues with InfoCapture's advanced UI user picker
- !551 BT-920 Document Creator field label now displays Owner to be consistent with Document admin panel.
- !568 BT-853 giving a best bet, search term or search suggestion a name with HTML tags in it can no longer
 cause script execution or affect page formatting
- !573 BT-788 Fixed **Embedded Plural** Localizations no longer formatting correctly.
- !592 BT-434 Triggers created from field condition sets now default to sending email notifications, as intended
- !594 BT-981 DISCO-26204 Saving a document with a long title, or which has had metadata added, will no longer cause a system error

### Developer notes

- !594 BT-981 the server platform and user agents string in the bug dump are now deliberately
 truncated to 32 chars. This is to prevent an error in mantis when the bug is reported.

## 8.6.12 - 5th November 2019

### Improvements

- !407 CORE-775 Predictive search and global search now show user-defined best bets and search term suggestions

### Bug fixes

- Back-ported from 8.7.4
  - !446 (Disco 024496, 025906, 025613) Fixed console error while checking out document
- !552 SDB-641 Corrected support for Custom module tests in Behat.
- !551 BT-629 Infocapture create a new project title is now localised
- !565 BT-884 DISCO 25882 custom CSS is now correctly applied to the "edit issue" page in InfoCapture
- Bug fixes merged forward from 8.2.21, 8.3.19, 8.4.18, 8.5.18

## 8.6.11 - 17th October 2019

### Bug fixes

- !545 BT-837 (Disco 25629) Fixed issue where the OU group filter allowed non-matching groups to be created if their DNs were exactly the same length as the OU filter DN

## 8.6.10 - 4th October 2019

### Bug fixes

- !529 CORE-993 Added user picker localization for share button & communication
- !396 CORE-720 Fixed date picker validation
- !494 CORE-963 Disco 24496 Fixed PHP 7.1 warnings in InfoCapture if rights were saved as NULL
- !497 CORE-825 BT-590 Fixed errors that could occur when authenticating with Google for Google Documents Indexing in the Documents admin panel.

### Developer notes

- !497 CORE-825 Fixed missing return statement in `GlobalSearchController::ProcessResultArray()`
- !497 BT-590 Implemented clearing the Google Documents API access token if refreshing it causes an authentication error

## 8.6.9 - 3rd September 2019

### Features

- !508 (FRAM-156) Added a CLC command to regenerate the system UUID (`clc regenerate-uuid`)

### Improvements

- !448 CORE-952 Added German translations including Select 2 localizations
- !440 CORE-882 An unregister endpoint has been added to the OneSignal API

### Bug fixes

- !478 (UIUX-484) Removed background image from metadata file upload iframe
- !480 CORE-867 Fixed password minimum length in localisation for error when password is not strong enough
- !514 Fixed bug where saving an LDAP user would mistakenly show a license error message
- !477 UIUX-482 Fix for cards - list view. Book marks are easier to hover and click with mouse
- !517 BT-673 Fixed missing Localizations displaying incorrectly when using the User Picker Component.

### Developer notes

- !440 CORE-882 the default version of the OneSignal API is now `v2`
- !517 BT-673 Added JS function `lmsg_key_exist` to mirror the PHP function of the same name.

## 8.6.8 - 25th Jul 2019

### Improvements

- !467 (BT-505) (DISCO-24265) Dates can now be imported from LDAP into a date attribute

### Bug fixes

- !468 (FRAM-50) Environment variables can now be set to be `true` or `false` boolean values, instead of their string equivalents
- !471 (BT-141) Search results for documents are found it shows links for file/containing folder. Containing folder links have pointed to base folder.
- Merged forward bugfixes from 8.3.18, 8.4.16 and 8.5.14

### Breaking Changes

- !468 (FRAM-50) Environment variables can no longer be set to the strings `"true"` or `"false"` (case insensitive)

## 8.6.7 - 3rd Jul 2019

### Improvements

- !425 (CORE-781) Any file type from Google Drive can now be added to documents using the Google picker.

### Bug fixes

- !450 CORE-839 Add PHP session to data passed to document checkout utility.
- !418 CORE-834 Holiday Group managers that are not in that group would cause manager notifications to be sent to the other manager when booking a holiday.
- !395 CORE-836 Fixed setting Content-Length header incorrectly during login and when viewing Pages
- !422 UIUX-491 Document search results did not respect the config setting for download vs show doc info
- !437 CORE-872 Search results with best bets gave an error when filtered by application
- CORE-908 Fixed potential SQL error when loading Holiday Group managers

### Developer notes

- !395 CORE-836
  - The Content-Length header is no longer set for `StreamedResponse`s by `Application`s finish middleware, because the
    content length cannot be known
  - The "Please wait, logging in..." message is no longer `echo`ed by `LoginController` before returning a
    `RedirectResponse` after a successful login

## 8.6.6 - 29th May 2019

### Improvements

- !405 when onesignal is enabled, the onesignal app ID can be retrieved from the `/api/onesignal/info` endpoint
- !362 Added whitelist for Search API result properties

### Improvements

- !405 when onesignal is enabled, the onesignal app ID can be retrieved from the `/api/onesignal/info` endpoint
- !362 Added whitelist for Search API result properties

### Bug fixes

- (disco 24068) Documents: fixed error caused by document object being used when it had failed to be loaded.
- (disco 23458 BT-294) Added Cache-Control setting to non-routed REST endpoints.
- Merged forward bugfixes and improvements from 8.2.18, 8.2.19, 8.3.15, 8.5.16, 8.4.13, 8.4.13, 8.5.11 and 8.5.12

## 8.6.5 - 9 May 2019

### Improvements

- !390 added more logging for InfoCapture notifications
- !361 Added button to "View in Google Docs" for Google Document Links

### Bug fixes

- (BT-318) Added a missing file upload button localisation in comments;

## 8.6.4 - 9 Apr 2019

### Bug fixes

- Merged forward bug fixes and improvements from 8.2.17, 8.3.13, 8.4.11, 8.5.9.

#### Improvements

- !348 Adding option to check out document through Document Check Out Utility desktop application for Mac and Windows.
- Adding Styles dropdown to Text Component in Pages.
- Bugfix in core for ICAutomator attachment error (BT-225).
- Fix iframe overflow on Mobile Safari in iOS (UIUX-437).

### Developer notes

- Setting user passwords has been refactored into a `SetUserPassword` use case in the People application (from 8.2.17)
- Added *.tmpl to .gitattributes

## 8.6.3 - 8 Mar 2019

### Bug fixes

- !355 Removing duplicate push notification when user is set to receive email digest in notification settings.
- !356 Fixed bug that prevented a user's username from being changed (CORE-574)
- Fixed SQL error when dispatching an empty set of push notifications
- !358 (CORE-586, Disco 22958) Holiday Planner - Fixed Zones & Groups diagrams updating improperly due to browser caching
- (CORE-589, Disco 23193) InfoCapture - Fixed default values not persisting for date fields
- Merged forward bug fixes and improvements from 8.3.11, 8.4.9, 8.5.7.

### Improvements

- !350 (CORE-501) User search suggestions box on global search results was not visible.
- !349 (CORE-387) Improved performance of the search indexing queue
- !539 (FRAM-276) Simplified configuration for filesystem abstraction. Abstraction can now be enabled by setting `CLARO_FS_ENABLED` to true

### Breaking changes

- The session in LoginController is now handled via the $app->session object rather than using PHP session functions directly. This change should be seamless but is mentioned here in case there may be edge-case issues with logins (standard or custom).

### Developer notes

- !316 Configuration switching for Behat (CORE-123)
  This change introduces new Behat functionality that allows an alternative Behat-specific config file to be used.
  The config is loaded on top of the existing configuration so overrides existing settings. The Behat config file is optional and one or many config variables can be overridden.
- !349 (CORE-387) Added indexes to the search indexing queue table to improve performance  

## 8.6.2 - 4 Feb 2019

### Bug fixes

- (CORE-289) Removed authentication from Calendar export to allow external access (iCal URL)
- (CORE-373) Comment default and like notifications now use permalink URLs instead of a link to the object.
- Merged forward bug fixes and improvements from 8.3.10, 8.4.8, 8.5.6

### Improvements

- !346 (UIUX-331) Updates to live preview window including draggability, logo hiding and background updates
- !325 (UIUX-256) Implemented a live preview window when editing themes with the design tool
- !301 (UIUX-246) Improved display and visibility of the pin/unpin buttons in Discuss and Projects modules
- !324 Revert/delete buttons now only show in config editor when they are functional
- !338 Added basic filtering to the config editor
- !340 (UIUX-290) Implemented automatically checking the 'Keep me logged in' checkbox for small screen devices

### Breaking changes

### Developer notes

## 8.6.1 - 11 Jan 2019

### Bug fixes

- !309 (CORE-274) Fixed notifications failing to be sent via SMTP.
- !311 Fixed dates displaying incorrectly in push notifications.

### Improvements

### Breaking changes

### Developer notes

- !305 Updated Behat hooks that set up the environment before running a test to check plugins.json against the
db_installed table and flag a warning if there is a difference (CORE-164)
- !309 (CORE-274) More error messages relating to notification emails may be found in error logs due to legacy third party code.
- !318 Cherry-pick CORE-164 Behat set-up validation improvements (CORE-296)
This change introduces some validation when Behat tests are run to check the content of the data/config/plugins.json file against the db_installed database table. If these are different it can cause problems and errors in the page.
When there is a difference between the plugins.json and db_installed Behat will now output some information advising what information is in each and what appears to be installed normally.

## 8.6.0 - 12 Dec 2018

### New features

- !261 Bookmark page - User can now add link to bookmark easily via Add to Bookmark link from the top navigation bar.
- !265 Menu navigation (Disco 22054) - When top level menu doesn't contain URL, it is no longer clickable but still trigger to show sub level menu.
- !262 Current Interface Indicator - Design panel is now showing which interface that user is currently having so that editing incorrect theme can be avoided.
- !213 Hybrid breadrumb - Allows the user to go back to the referring app when a user lands on an article, document or
  user profile. An arrow is displayed to the left of the breadcrumb with the app referral.
- !251 News comments are now configurable  - Visit the Configuration tab in News Admin to change whether comments can
  be made on News Articles.
- !242 Global font setting  - The design panel now offers a selection of fonts to apply across the system for the
  master design and for individual themes.
- !230 User Import/Export with Manager ID - Users can now be imported and exported with manager IDs.
- !228 Search improvements
  - Search suggestions are shown when using the global search field in the navigation bar
  - Search API version 2 - Search API has been improved considerably
  - Global search and search suggestions now use fuzzy matching
- !272 Application menu colour - Added a design panel option for the colour of application menu items.
- !235 Environment variables - Many configuration options can now be set by environment variables.
- !270 OneSignal Push Notification Integration and Universal Links for mobile devices.
- !225 Redis session handling - Claromentis can now be configured to use redis as a session store, in order to
  share sessions between load-balanced servers. Sessions are locked during use, to avoid race conditions.
  All redis modes other than a single server running in "MASTER" mode are experimental, and should not be used on a production server.
- !217 Gravatar can now be used to show profile images for users that do not have one set. See "Admin -> People -> General Configuration" for the options.
- !298 Comment permalinks exposed the object name in the breadcrumb when the user no longer had permission to view the comment (CORE-190)
- !300 Fixed errors when adding a three menu date field to an InfoCapture form (CORE-151)

### Improvements

- !216 Theme image resizing - Logos and background images are now resized once uploaded
- !241 (Disco 021105) Improved which Holiday group managers are sent notifications for Holiday Requests and Cancellations
- !237 Groups and Role based permissions will update more promptly (caching is smarter and less aggressive)
- !247 (Disco 021717) Optimized the User Export page, mitigating unresponsiveness on systems with many Users and Metadata
- !257 (UIUX-47) Ensured that line-breaks in Calendar invite descriptions are maintained in notifications
- !256 Current theme indicator - In a system with multiple themes, there is now a label in the Design Panel's Themes
  list that indicates which theme you are currently using
- !259 (UIUX-81) Added image archive download buttons to Image Gallery album page
- !274 The card shadow option in the design panel has updated to a toggle with an icon, similar to other options
- !258 Color picker has been localised for the design panel and bright colors have been restricted for Primary, Secondary and Link colors
- !288 (UIUX-132) Added ability to change InfoCapture status highlighting.
- !271 Added the concept of module dependencies, so that disabling Tasks does not crash the system if Discuss is installed

### Bug fixes

- !309 (CORE-274) More error messages relating to notification emails may be found in error logs due to legacy third party code
- !276 Password Policy Fix - Strong passwords now need to include one lower,upper,digit and special char, password minimum length can be set from people admin.
- !218 (Disco 021325) Fixed power user permissions not being applied to the User List in People Admin
- !222 (Disco 021322) Fixed pagination and sort issues in the Power Users tab in People Admin
- !239 Calendar's "show conflicts" button now takes into account common and personal holidays
- Fixed system navbar notifications not working correctly in Calendar due to MooTools conflict
- !258 Fixed warnings in the Design Panel that occurred when entering shorthand or invalid hex codes for colors

### Breaking changes

- PHP compatibility has been changed from version `>=7.0.0 <7.1.0` to `>=7.0.0 <7.2.0`
- ORM dependency (Analogue) has been updated from 5.4.2 to 5.6.12 and its integration has been updated accordingly
- !229 DAL interfaces have been defined in `Claromentis\Core\DAL\Interfaces\*`, and the abstract `DAL\Db` implements them
- A new resize type (`'[*]'`) has been added to `Claromentis\Core\Imager\Driver\Driver` that letterboxes with a
  transparent fill
- The `Claromentis\Core\Templater\TemplateRunner` constructor signature has changed from `__construct($app = null)` to
  `__construct(Claromentis\Design\Facade\ActiveTheme $active_theme, $app = null)`
- `cla.ui_strip_message()` in `cla_lib.js` has been renamed to `cla.ui_strip_keys()`
- !270 IMessage::Send now takes an additional parameter, but it defaults to null.
- !270 Sending of messages now occurs in a transaction, so either all recipients recieve it, or none of them do.
- !228 Search API - The default version of the Search API has been changed to 2
- !271 PluginsRepository now manages the concept of dependencies, and any modules with a hard dependency should be updated to declare one (see the Discuss module for details)
- !271 PluginsRepository::GetStatus can now return PluginsRepository::STATUS_BLOCKED (4)
- !225 - the session is now always started when the framework is bootstrapped. This may affect the behaviour of
custom login handlers. Additionally, usage of php native session functions is now deprecated in favour of using
`$g_application->session`.

### Developer notes

- Added Services::I()->config magic property, for getting the core config object without using global variables.
- Deprecated httpRedirect() in http_functions.php. RedirectResponse::httpRedirect() should be used instead.
- Added PhpStorm code style config (`.idea/codeStyles/Project.xml`) - use it (`Ctrl + Alt + L`) to keep your code style
  consistent across the code-base
- Added GitLab merge request description templates (`.gitlab/merge_request_templates/*`) - use these to fill out and
  auto-tag your merge requests
- !226 Transaction support has been implemented for the DAL
- !125 ORM integration has been improved
  - People entities have been initially implemented and mapped (User, Group, Role, Extranet)
  - ACL plugin has been integrated, allowing mapper queries like `->whereCan($context, PERM_EDIT)` and
    `->wherePermission(PERM_CLASS_NEWS, $context, PERM_VIEW)` (`PERM_VIEW` is the default argument for rights)
  - `UserScope` has been applied to the new User mapper available in the `UserRepository`, allowing mapper queries like
    `->whereContext($app->security)` (Extranet visibility filter, active user only),
    `->withPermission(PERM_CLASS_NEWS, $object_id, PERM_VIEW)` (Users with permissions to a specific object) and
    `->whereInAcl($acl)` (match all users in the given ACL)
- !237 Group, Group Tree and Role session caches are now invalidated when these objects are changed
- !237 A new `user_timestamps` table has been added to track when each user last updated their session caches for Groups,
  Group Trees and Roles
- !238 Icon grid - Added an AngularJS directive to show a grid of icons to pick from as an alternative to the existing
  select-based picker
- All application names for admin panels the the application menu have been localized
- `Claromentis\Core\Config\ConfigDialog` now properly displays default values for config options when calling the
  `ShowOption($key)` method
- System fonts can now be set in the design panel, changing the font of nearly every textual item across the system
- News comments can now be toggled via config variable `$cfg_news_show_comments`
- !243 Behat step definitions have been implemented for interacting with date, time, colour and image pickers
  - `I fill in date picker "selector" with relative date "date" using format "format"`
  - `I fill in time picker "selector" with relative time "" using format ""`
  - `I fill in colour picker "selector" with "colour"`
  - `I press "selector" radio button`
- !248 Behat step definitions have been implemented for importing snapshots, running migrations and checking database tables:
  - `I import snapshot file "file name"`
  - `I execute migration using partial "partial name" or roll-up "roll-up name" for application "application code"`
  - `database table "table" should contain: <Table Data>`
  - `database table "table" should not contain: <Table Data>`
  - `database table "table" should contain "count" records`
- Added new method `ClaText::ProcessAvailableLocalisation()` to process localisation strings using the format `@{lmsg_key|default}`
- !260 Added unique index creation to migration interfaces
  - `$db->CreateUniqueIndex($table_name, $index_name, ...$columns)` is now available when writing migrations
