// Multiple group picker

define(['cla_angular', './group_picker.html'], function (angular, template) {
	var moduleName = 'cla.core.group_picker';
	var module = null;
	try {
		module = angular.module(moduleName);
	} catch(err) {
		// named module does not exist, so create one
		module = angular.module(moduleName, []);
	}

	module.directive('claGroupPicker', groupPicker);

	groupPicker.$inject = ['$timeout'];

	function groupPicker($timeout) {
		return {
			link: link,
			restrict: 'E',
			require: '^ngModel',
			//templateUrl: '/intranet/js/angular/cla/group_picker/group_picker.html',
			templateUrl: template,
			scope: {
				ngModel: '=',
				control: '=',
				groups: '='
			}
		};

		function link(scope, iElement, iAttrs, ctrl) {
			scope.id = iAttrs.selectId + '-inner';

			iElement.hide();

			scope.startSelect2 = function (element_id, query_params, placeholder) {
				var el = angular.element('#' + element_id);
				var page_size = 10;
				el.select2({
					placeholder: placeholder,
					minimumInputLength: 1,
					ajax: {
						url: "/intranet/common/group_picker.php?json=1&multi=1"+query_params,
						dataType: 'json',
						data: function (params) {
							return {
								keywords: params.term.trim(), // search term
								page: params.page,
								page_size: page_size,
								st: (params.page-1) * page_size
							};
						},
						processResults: function (data, params) {
							params.page = params.page || 1;

							return {
								results: data.data,
								pagination: {
									more: ((params.page) * page_size) < data.total
								}
							};
						}
					}
				});
			};

			// Angular won't have populated the control/browse ids yet so wait until the current event is finished
			$timeout(function(id, text, element) {
				scope.initSelect2(id, text);
				element.show();
			}, 0, true, scope.id, "Select a group", iElement);

			scope.startSelect2(scope.id, '', "Select a group");

			ctrl.$viewChangeListeners.push(function () {
				scope.$eval(iAttrs.ngChange);
			});

			scope.initSelect2 = function (id, text) {
				var select = angular.element('#' + id);
				select.find('option').remove();

				// Add an entry for the current groups if needed
				for (var i = 0; i < scope.ngModel.length; i++)
				{
					select.append(angular.element('<option>').attr('value', '' + scope.ngModel[i]).text(scope.groups[scope.ngModel[i]]).attr('selected', 'selected'));
				}
                select.on('change', function(){
                    scope.ngModel.length = 0;

                    angular.element(this).find('option:selected').each(function(){
                        var group_id = angular.element(this).val();
                        scope.ngModel.push(group_id);
                    });
                    scope.change();
                });

				scope.startSelect2(scope.id, '', text);
			};

			scope.change = function () {
				var groupIds = scope.ngModel;

				scope.groups = {};
				angular.element.each(groupIds, function(key, value)
				{
					scope.groups[value] = angular.element('#' + scope.id + ' [value="' + value + '"]').text();
				});

				ctrl.$setViewValue(groupIds);
				ctrl.$render();

				$timeout(function(groupIds) {
					ctrl.$setViewValue(groupIds);
					ctrl.$render();
				}, 0, true, groupIds);
			};

			scope.internalControl = scope.control || {};
			scope.internalControl.reset = function()
			{
				// Rebind the model. This shouldn't be needed but it never gets updated once reset otherwise
				ctrl.$setViewValue(scope.ngModel);

				scope.initSelect2(scope.id, "Select a group", true);
			};
		}
	}
});
