define(['jquery'], function($) {
  require("imports-loader?$=jquery!../../../node_modules/owl.carousel/dist/owl.carousel.min.js");
  require ("../../../node_modules/owl.carousel/dist/assets/owl.carousel.css");
  require ("../../../node_modules/owl.carousel/dist/assets/owl.theme.default.css");

  var News = function ($instance) {
    this.$container = $instance.find('.js-tile-body-container');
    this.init();
  };

  News.prototype.init = function() {
    var owl = this.$container.find(".owl-carousel");
    owl.owlCarousel({
      responsive: {},
      autoplay: true,
      autoplaySpeed: 300,
      autoplayHoverPause: true,
      loop: true,
      dots: true,
      dotsSpeed: 400,
      lazyLoad: true,
      lazyLoadEager: 2,
      items:1,
      margin: 0,
      nav: false
    });

	  this.calcDisplaySize();

    var self = this;

	// re-init when Pages starts up
	$('body').on('pages-started', function()
	{
	  self.calcDisplaySize();
	});

	// Listen to Pages events to re-init when a tile is resized
	owl.closest('.js-tile').on('pages-tile-resize', function(event, element)
	{
	  setTimeout(function()
	  {
        var data = owl.data('owl.carousel');
        if (typeof data !== 'undefined')
          data.refresh();

          self.calcDisplaySize();
	  }, 300);
	});
  };

  News.prototype.calcDisplaySize = function() {

    var container = this.$container;
    if (container.length > 0) {
      var fullHeight = container.height();
      container.find('.slider-news-wrapper .owl-item').height(fullHeight);
    }
  };

  return News;
});
