<?php
namespace Claromentis\Console\Util;

$GLOBALS["__dd95d8cc5a6edf7e1aa8b72" . "50942442d"] = (@$GLOBALS["__dd95d8cc5a6ed" . "f7e1aa8b7250942" . "442d"] ?: array()) + array("_3e09962b663b985bf8c260a" . "c2e95edc0" => base64_decode("Y29yZ" . "Q=="), "_1094b976516d8d" . "f54067d448e66e0" . "297" => base64_decode("RGF0YWJ" . "hc2UgaX" . "MgYXZha" . "WxhYmxl"), "_77713ce23683636d0573408c" . "9a0d0ddb" => base64_decode("RGF0YWJhc2UgcGVybWlzc" . "2lvbnMgYXJlIGFkZXF1YX" . "Rl"), "_a70083b91f8d3b0237061e06826958e" . "8" => base64_decode("Q2hlY2tpbmcgZGF0YWJhc2UgYXZhaWxhYmlsaXR5Li4" . "u"), "_7b2ca9a105" . "acfcc088d2c" . "15bfe6458b6" => base64_decode("Q29yZSBpcyBub3Qg" . "aW5zdGFsbGVk"), "_9636e445fbeaa4bbfe5694ed53" . "2de0b1" => base64_decode("RGF0YWJhc2UgcGVybWlzc2lvbnM" . "gaW5zdWZmaWNpZW50"), "_5bcefc1eff68" . "a2aa6ab8f3569" . "9a56d08" => base64_decode("RGF0YWJhc2UgaXMgbm90IGF2" . "YWlsYWJsZTog"), "_9810a2810274128200c" . "b24f15909a3f2" => base64_decode("Q2hlY2tpbmcgZGF0YWJhc2UgcGVybWlzc2lvb" . "nMuLi4="), "_4c93d4c" . "40f7ab1a" . "488c387f" . "7f91a649" . "6" => base64_decode("Q2hlY2tpbmcgaW5zdGFsbGF0a" . "W9uLi4u"));
use Claromentis\Core\Config\Config;
use Claromentis\Core\DAL\DbFactory;
use Claromentis\Setup\Exception\NotInstalledException;
use Claromentis\Setup\Task\DatabaseCheck;
use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Psr\Log\NullLogger;
use RuntimeException;




class InstallationChecker implements LoggerAwareInterface
{
    use LoggerAwareTrait;
    
    
    
    
    protected $config;
    
    
    
    
    protected $factory;
    
    
    
    
    protected $locator;
    
    
    
    
    protected $registry;
    
    
    
    
    
    
    
    
    
    public function __construct(Config $_fd33b1a14db9a1eccfaaa3cb67b5336e, DbFactory $_c8ef295ed962a46e6246480731bf7b99, Locator $_958a49c0e9814c5c29eb8698e3fb6de2, ApplicationRegistry $_decc0934e98116e3ae7588cf6db5d1ae)
    {
        $this->config = $_fd33b1a14db9a1eccfaaa3cb67b5336e;
        $this->factory = $_c8ef295ed962a46e6246480731bf7b99;
        $this->locator = $_958a49c0e9814c5c29eb8698e3fb6de2;
        $this->registry = $_decc0934e98116e3ae7588cf6db5d1ae;
        $this->setLogger(new NullLogger());
    }
    
    
    
    
    
    
    public function isInstalled()
    {
        try {
            $this->logger->info($GLOBALS["__dd95d8cc" . "5a6edf7e1a" . "a8b7250942" . "442d"]["_4c93d4c40f7ab1a488c387f7f91a649" . "6"]);
            $this->verifyInstalled();
        } catch (\Exception $_c35473364fa7a050299058f332ec29c1) {
            return false;
        }
        return true;
    }
    
    
    
    
    
    
    public function checkDatabaseConnection()
    {
        try {
            $this->logger->info($GLOBALS["__dd95d8cc5a6edf7e1aa8" . "b7250942442d"]["_a70083b91f8d3b0237061e068" . "26958e8"]);
            $this->verifyDatabaseConnection();
            $this->logger->debug($GLOBALS["__dd95d8cc5a6edf7e1" . "aa8b7250942442d"]["_1094b976516d8df54067d448e6" . "6e0297"]);
        } catch (\Exception $_c35473364fa7a050299058f332ec29c1) {
            
            
            
            $this->logger->info($GLOBALS["__dd95d8cc5a6edf7e" . "1aa8b7250942442d"]["_5bcefc1eff68a2aa6ab8f" . "35699a56d08"] . $_c35473364fa7a050299058f332ec29c1->getMessage());
            return false;
        }
        return true;
    }
    
    
    
    
    
    
    public function checkDatabasePermissions()
    {
        try {
            $this->logger->info($GLOBALS["__dd95d8cc5a6edf7e1aa8b72509424" . "42d"]["_9810a2810274128200cb24f15909a3f" . "2"]);
            $this->verifyDatabasePermissions();
            $this->logger->debug($GLOBALS["__dd95d8cc5a6" . "edf7e1aa8b725" . "0942442d"]["_77713ce23683636d0573408c9a0" . "d0ddb"]);
        } catch (\Exception $_c35473364fa7a050299058f332ec29c1) {
            
            
            return false;
        }
        return true;
    }
    
    
    
    
    
    
    
    public function verifyInstalled()
    {
        $this->verifyDatabaseConnection();
        $this->verifyDatabasePermissions();
        if (!$this->registry->isInstalled($GLOBALS["__dd95d8cc5a6edf7e1aa8b7" . "250942442d"]["_3e09962b663b985bf8c260ac" . "2e95edc0"])) {
            throw new NotInstalledException($GLOBALS["__dd95d8cc5a6edf" . "7e1aa8b725094244" . "2d"]["_7b2ca9a105acfcc08" . "8d2c15bfe6458b6"]);
        }
    }
    
    
    
    
    
    
    
    public function verifyDatabaseConnection()
    {
        
        
        $_4504853ce5094b088c8bdc3d570a0a5d = $this->getDatabase();
        
        
        $this->registry->setDatabase($_4504853ce5094b088c8bdc3d570a0a5d);
    }
    
    
    
    
    
    
    
    public function verifyDatabasePermissions()
    {
        $_4504853ce5094b088c8bdc3d570a0a5d = $this->getDatabase();
        $_58bc0ced402c33be307fe4d3d5433ed1 = new DatabaseCheck($this->config, $_4504853ce5094b088c8bdc3d570a0a5d);
        $_58bc0ced402c33be307fe4d3d5433ed1->setLogger($this->logger);
        if (!$_58bc0ced402c33be307fe4d3d5433ed1->Check()) {
            foreach ($_58bc0ced402c33be307fe4d3d5433ed1->GetErrors() as $_ba3845cb79c005cf3269af8c83ddbe5e) {
                $this->logger->error($_ba3845cb79c005cf3269af8c83ddbe5e);
            }
            throw new RuntimeException($GLOBALS["__dd95d8cc5a6edf7e1aa8b72" . "50942442d"]["_9636e445fbeaa4bbfe569" . "4ed532de0b1"]);
        }
    }
    
    
    
    
    
    
    
    protected function getDatabase()
    {
        return $this->factory->GetInstanceFromConfig($this->config);
    }
}