@javascript @core @communication
Feature: Verify communication messages table content.

  Background:
    Given I am on a Claromentis site
    And the following people exist:
      | username | password | surname  | firstname | email                | manager  |
      | manager1 | password | Manager1 | Dave1     | manager1@example.com |          |
      | project1 | password | Project1 | Maggie1   | project1@example.com |          |
      | user1    | password | User1    | Bob1      | user1@example.com    | manager1 |
      | user2    | password | User2    | Bob2      | user2@example.com    | manager1 |
      | user3    | password | User3    | Bob3      | user3@example.com    | manager1 |
      | user4    | password | User4    | Bob4      | user4@example.com    | manager1 |
      | user5    | password | User5    | Bob5      | user5@example.com    | project1 |
    And the following "user" messages exist:
      | sender   | receiver    | subject         | date               | message |
      | user1    | user2       | Bananas         | 14:10 Jan 2nd 2019 | Did you know bananas are a herb?               |
      | user2    | user1       | Bananas         | 14:11 Jan 2nd 2019 | Shut. Up.                                      |
      | user1    | user2       | Bananas         | 14:12 Jan 2nd 2019 | It's true.                                     |
      | user2    | user1       | Bananas         | 14:13 Jan 2nd 2019 | [Slams front door]                             |
      | user1    | user2       | Tomatoes        | 14:14 Jan 2nd 2019 | Did you know tomatoes are a fruit?             |
      | admin    | user1,user2 | Login Passwords | 16:08 Jan 3rd 2019 | Please remember to reset your login passwords. |
      | user1    | admin,user2 | Login Passwords | 09:14 Jan 4th 2019 | Remind me why we're doing this again...?       |
      | admin    | user1,user2 | Login Passwords | 09:18 Jan 4th 2019 | Bob2 wrote his password on a post-it and left it on the fridge. |
      | user1    | admin,user2 | Login Passwords | 10:26 Jan 5th 2019 | Great idea! How embarrassing! Haha.            |
      | user2    | user1,admin | Login Passwords | 10:31 Jan 5th 2019 | I swear it wasn't me.                          |
      | admin    | user1,user2 | Login Passwords | 10:33 Jan 5th 2019 | We're resetting password as a precaution.      |
    And the following "user" messages exist:
      | sender   | receiver                | subject          | date                | message |
      | project1 | manager1,user1,user2    | Prototype update | 10:15 Jan 10th 2019 | Hi Dave1. Any news on the Communication prototype?                 |
      | manager1 | project1,user1,user2    |                  | 10:30 Jan 10th 2019 | Yes, one of the Bobs was working on it. I get an update.           |
      | user1    | manager1,project1,user2 |                  | 10:40 Jan 10th 2019 | Just sent it over.                                                 |
      | project1 | manager1,user1,user2    |                  | 11:25 Jan 11th 2019 | Great, thanks. Give me half and hour to look over it.              |
      | project1 | manager1,user1,user2    |                  | 11:50 Jan 11th 2019 | Looks great. Let's look at more options with the team.             |
      | manager1 | project1,user1,user2    |                  | 11:55 Jan 11th 2019 | Good idea.                                                         |
      | user1    | manager1,project1,user2 |                  | 12:00 Jan 11th 2019 | I had another idea about and improvement for the bobbins.          |
      | user1    | manager1,project1,user2 |                  | 12:05 Jan 11th 2019 | https://thisissomething.com                                        |
      | user2    | manager1,project1,user1 |                  | 12:20 Jan 11th 2019 | I was thinking about that too. I've got a slightly different idea. |
      | manager1 | project1,user1,user2    |                  | 12:30 Jan 11th 2019 | Great work guys. Let's discuss in the meeting later.               |

  Scenario: Verify a user can sort the messages by the date.

    Given I login as user "user1" with password "password"
    When I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"
    And I should see in table "#messages":
      | From                                     | Message Preview                                       | Date             |
      | Bob2 User2, Dave1 Manager1 and 1 more    | Great work guys. Let's discuss in the meeting late... | 11-01-2019 12:30 |
      | Bob2 User2 and Claromentis Administrator | We're resetting password as a precaution.             | 05-01-2019 10:33 |
      | Bob2 User2                               | Did you know tomatoes are a fruit?                    | 02-01-2019 14:14 |

    # The default sort order is by date so the first re-sort will reverse the default order.
    When I follow "Date"
    Then I should see in table "#messages":
      | From                                     | Message Preview                                       | Date             |
      | Bob2 User2                               | Did you know tomatoes are a fruit?                    | 02-01-2019 14:14 |
      | Bob2 User2 and Claromentis Administrator | We're resetting password as a precaution.             | 05-01-2019 10:33 |
      | Bob2 User2, Dave1 Manager1 and 1 more    | Great work guys. Let's discuss in the meeting late... | 11-01-2019 12:30 |

    When I follow "Date"
    Then I should see in table "#messages":
      | From                                     | Message Preview                                       | Date             |
      | Bob2 User2, Dave1 Manager1 and 1 more    | Great work guys. Let's discuss in the meeting late... | 11-01-2019 12:30 |
      | Bob2 User2 and Claromentis Administrator | We're resetting password as a precaution.             | 05-01-2019 10:33 |
      | Bob2 User2                               | Did you know tomatoes are a fruit?                    | 02-01-2019 14:14 |

  Scenario: Verify a viewed message is shown as read.

    Given I login as user "user1" with password "password"
    When I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"
    And I should see message preview "Great work guys. Let's discuss in the meeting late..." is shown as "unread"

    When I follow "Great work guys. Let's discuss in the meeting late..."
    And I move backward one page
    And I reload the page
    Then I should see message preview "Great work guys. Let's discuss in the meeting late..." is shown as "read"

  Scenario: Verify a user can mark a message as archived.

    Given I login as user "user1" with password "password"
    When I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"

    When I click element with "//input[@name='selected[]']"
    And I press "Archive Selected"
    And I click element with "#confirm-table-delete" using jQuery
    Then I should see "We're resetting password as a precaution."
    And I should see "Did you know tomatoes are a fruit?"
    And I should see "Your message has been marked as archived"
    But I should not see "Great work guys. Let's discuss in the meeting late..."

  Scenario: Verify a user can mark all messages as archived.

    Given I login as user "user1" with password "password"
    When I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"

    When I press "Archive All"
    And I click element with "#confirm-table-delete" using jQuery
    Then I should see "Your messages have been marked as archived"
    And I should see "No messages found"
    But I should not see "Great work guys. Let's discuss in the meeting late..."
    And I should not see "We're resetting password as a precaution."
    And I should not see "Did you know tomatoes are a fruit?"

  Scenario: Verify a user can search messages matching any of the given search terms.

    Given I login as user "user1" with password "password"
    When I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"

    When I fill in "sq" with "banana password"
    And I fill in "type" with "or"
    And I press "Search"
    # Messages show have either ma matching password or message.
    Then I should see "We're resetting password as a precaution."
    And I should see "[Slams front door]"

    When I press "Reset"
    And I fill in "sq" with "banana"
    And I fill in "type" with "or"
    And I press "Search"
    Then I should see "[Slams front door]"
    But I should not see "We're resetting password as a precaution."

    When I press "Reset"
    And I fill in "sq" with "password"
    And I fill in "type" with "or"
    And I press "Search"
    Then I should see "We're resetting password as a precaution."
    But I should not see "[Slams front door]"

  Scenario: Verify a user can search messages matching all of the given search terms.

    Given I login as user "user1" with password "password"
    When I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"

    When I fill in "sq" with "idea"
    And I press "Search"
    # Messages show have either ma matching password or message.
    Then I should see "I was thinking about that too. I've got a slightly..."
    And I should see "Great idea! How embarrassing! Haha."

    When I press "Reset"
    And I fill in "sq" with "embarrassing idea"
    And I fill in "type" with "and"
    And I press "Search"
    Then I should see "Great idea! How embarrassing! Haha."

    When I press "Reset"
    And I fill in "sq" with "improvement idea"
    And I fill in "type" with "and"
    And I press "Search"
    Then I should see "I had another idea about and improvement for the b..."

  Scenario: Verify the pagination works as expected.

    Given the following "user" messages exist:
      | sender | receiver                | date  | message           |
      | user5  | user1                   | 12:00 | Pagination test 1 |
      | user5  | user2                   | 12:01 | Pagination test 2 |
      | user5  | user3                   | 12:02 | Pagination test 3 |
      | user5  | user4                   | 12:03 | Pagination test 4 |
      | user5  | user1,user2             | 12:04 | Pagination test 5 |
      | user5  | user2,user3             | 12:05 | Pagination test 6 |
      | user5  | user3,user4             | 12:06 | Pagination test 7 |
      | user5  | user1,user2,user3       | 12:07 | Pagination test 8 |
      | user5  | user1,user2,user3,user4 | 12:08 | Pagination test 9 |
    And I set config "communication_messages_per_page" to "2"
    When I login as user "user5" with password "password"
    And I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"

    # There should be five pages to test.
    When I click element with "#pagination-page-5"
    Then I should see "Pagination test 1"
    But I should not see "Pagination test 2"
    And I should not see "Pagination test 3"
    And I should not see "Pagination test 4"
    And I should not see "Pagination test 5"
    And I should not see "Pagination test 6"
    And I should not see "Pagination test 7"
    And I should not see "Pagination test 8"
    And I should not see "Pagination test 9"

    When I click element with "#pagination-page-4"
    Then I should see "Pagination test 2"
    And I should see "Pagination test 3"
    But I should not see "Pagination test 1"
    And I should not see "Pagination test 4"
    And I should not see "Pagination test 5"
    And I should not see "Pagination test 6"
    And I should not see "Pagination test 7"
    And I should not see "Pagination test 8"
    And I should not see "Pagination test 9"

    When I click element with "#pagination-page-3"
    Then I should see "Pagination test 4"
    And I should see "Pagination test 5"
    But I should not see "Pagination test 1"
    And I should not see "Pagination test 2"
    And I should not see "Pagination test 3"
    And I should not see "Pagination test 6"
    And I should not see "Pagination test 7"
    And I should not see "Pagination test 8"
    And I should not see "Pagination test 9"

    When I click element with "#pagination-page-2"
    Then I should see "Pagination test 6"
    And I should see "Pagination test 7"
    But I should not see "Pagination test 1"
    And I should not see "Pagination test 2"
    And I should not see "Pagination test 3"
    And I should not see "Pagination test 4"
    And I should not see "Pagination test 5"
    And I should not see "Pagination test 8"
    And I should not see "Pagination test 9"

    When I click element with "#pagination-page-1"
    Then I should see "Pagination test 8"
    And I should see "Pagination test 9"
    But I should not see "Pagination test 1"
    And I should not see "Pagination test 2"
    And I should not see "Pagination test 3"
    And I should not see "Pagination test 4"
    And I should not see "Pagination test 5"
    And I should not see "Pagination test 6"
    And I should not see "Pagination test 7"

    # Set the pagination back to the normal value so it does not affect subsequent tests.
    When I set config "communication_messages_per_page" to "20"
    And I reload the page
    Then I should see "Pagination test 1"
    And I should see "Pagination test 2"
    And I should see "Pagination test 3"
    And I should see "Pagination test 4"
    And I should see "Pagination test 5"
    And I should see "Pagination test 6"
    And I should see "Pagination test 7"
    And I should see "Pagination test 8"
    And I should see "Pagination test 9"

  Scenario: Verify message participants is the same in messages table and message thread.

    Given the following people exist:
      | username | password | surname  | firstname | email                | manager  |
      | user6    | password | User6    | Bob6      | user6@example.com    | project1 |
      | user7    | password | User7    | Bob7      | user7@example.com    | project1 |
      | user8    | password | User8    | Bob8      | user8@example.com    | project1 |
      | user9    | password | User9    | Bob9      | user9@example.com    | manager1 |
      | user10   | password | User10   | Bob10     | user10@example.com   | manager1 |
    When I login as an admin user
    And I open the modules menu
    And I follow "Communication"
    And I pause for a second
    Then I should see "Messages"

    When I click element with "#compose-message"
    And I wait to see "Compose New Message"
    And I click element with "Browse" to open a window and click the following:
      | Bob1 User1       |
      | Bob2 User2       |
      | Bob3 User3       |
      | Bob4 User4       |
      | Bob5 User5       |
      | Bob6 User6       |
      | Bob7 User7       |
      | Bob8 User8       |
      | Bob9 User9       |
      | Bob10 User10     |
      | Dave1 Manager1   |
      | Maggie1 Project1 |
    And I fill in field "new_message_text" with rich content:
    """
    <p>Testing the limits on my patients?</p>
    """
    And I press "Send"
    Then I should see "Your message was sent"
    And I should see "Bob1" in the ".users" element
    And I should see "Bob2" in the ".users" element
    And I should see "Bob3" in the ".users" element
    And I should see "Bob4" in the ".users" element
    And I should see "Bob5" in the ".users" element
    And I should see "Bob6" in the ".users" element
    And I should see "Bob7" in the ".users" element
    And I should see "Bob8" in the ".users" element
    And I should see "Bob9" in the ".users" element
    And I should see "Bob10" in the ".users" element
    And I should see "Dave1" in the ".users" element
    And I should see "Maggie1" in the ".users" element
    But I should not see "Claromentis Administrator"

    When I am on "intranet/communication/messages.php"
    Then I should see "Bob1 User1, Bob10 User10 and 10 more"
    And I should see "Bob1 User1 and Bob2 User2"

    When I follow "and 10 more"
    And I wait to see "Group message members"
    Then I should see "Bob1 User1"
    And I should see "Bob2 User2"
    And I should see "Bob3 User3"
    And I should see "Bob4 User4"
    And I should see "Bob5 User5"
    And I should see "Bob6 User6"
    And I should see "Bob7 User7"
    And I should see "Bob8 User8"
    And I should see "Bob9 User9"
    And I should see "Bob10 User10"
    And I should see "Dave1 Manager1"
    And I should see "Maggie1 Project1"
    But I should not see "Claromentis Administrator"
