@javascript @core @communication
Feature: Verify communication messages threads.

  Background:
    Given I am on a Claromentis site
    And the following people exist:
      | username | password | surname  | firstname | email                | manager  |
      | manager1 | password | Manager1 | Dave1     | manager1@example.com |          |
      | project1 | password | Project1 | Maggie1   | project1@example.com |          |
      | user1    | password | User1    | Bob1      | user1@example.com    | manager1 |
      | user2    | password | User2    | Bob2      | user2@example.com    | manager1 |
      | user3    | password | User3    | Bob3      | user3@example.com    | manager1 |
      | user4    | password | User4    | Bob4      | user4@example.com    | manager1 |
      | user5    | password | User5    | Bob5      | user5@example.com    | project1 |
    And the following "user" messages exist:
      | sender   | receiver    | subject         | date               | message |
      | user1    | user2       | Bananas         | 14:10 Jan 2nd 2019 | Did you know bananas are a herb?               |
      | user2    | user1       | Bananas         | 14:11 Jan 2nd 2019 | Shut. Up.                                      |
      | user1    | user2       | Bananas         | 14:12 Jan 2nd 2019 | It's true.                                     |
      | user2    | user1       | Bananas         | 14:13 Jan 2nd 2019 | [Slams front door]                             |
      | user1    | user2       | Tomatoes        | 14:14 Jan 2nd 2019 | Did you know tomatoes are a fruit?             |
      | admin    | user1,user2 | Login Passwords | 16:08 Jan 3rd 2019 | Please remember to reset your login passwords. |
      | user1    | admin,user2 | Login Passwords | 09:14 Jan 4th 2019 | Remind me why we're doing this again...?       |
      | admin    | user1,user2 | Login Passwords | 09:18 Jan 4th 2019 | Bob2 wrote his password on a post-it and left it on the fridge. |
      | user1    | admin,user2 | Login Passwords | 10:26 Jan 5th 2019 | Great idea! How embarrassing! Haha.            |
      | user2    | user1,admin | Login Passwords | 10:31 Jan 5th 2019 | I swear it wasn't me.                          |
      | admin    | user1,user2 | Login Passwords | 10:33 Jan 5th 2019 | We're resetting password as a precaution.      |
    And the following "user" messages exist:
      | sender   | receiver                | subject          | date                | message |
      | project1 | manager1,user1,user2    | Prototype update | 10:15 Jan 10th 2019 | Hi Dave1. Any news on the Communication prototype?                 |
      | manager1 | project1,user1,user2    |                  | 10:30 Jan 10th 2019 | Yes, one of the Bobs was working on it. I get an update.           |
      | user1    | manager1,project1,user2 |                  | 10:40 Jan 10th 2019 | Just sent it over.                                                 |
      | project1 | manager1,user1,user2    |                  | 11:25 Jan 11th 2019 | Great, thanks. Give me half and hour to look over it.              |
      | project1 | manager1,user1,user2    |                  | 11:50 Jan 11th 2019 | Looks great. Let's look at more options with the team.             |
      | manager1 | project1,user1,user2    |                  | 11:55 Jan 11th 2019 | Good idea.                                                         |
      | user1    | manager1,project1,user2 |                  | 12:00 Jan 11th 2019 | I had another idea about and improvement for the bobbins.          |
      | user1    | manager1,project1,user2 |                  | 12:05 Jan 11th 2019 | https://thisissomething.com                                        |
      | user2    | manager1,project1,user1 |                  | 12:20 Jan 11th 2019 | I was thinking about that too. I've got a slightly different idea. |
      | manager1 | project1,user1,user2    |                  | 12:30 Jan 11th 2019 | Great work guys. Let's discuss in the meeting later.               |

  @communication-test-data
  Scenario: Verify the messages created in bulk have are correct.

    Given I login as user "user1" with password "password"
    When I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"
    And I should see "Did you know tomatoes are a fruit?"
    And I should see "We're resetting password as a precaution."

    When I follow "Did you know tomatoes are a fruit?"
    And I should see "Bob2" in the ".users" element
    And I should see "Tomatoes"
    And I should see user message thread:
      | name       | subject  | date         | message                            |
      |            | Tomatoes | Jan 2nd 2019 | Did you know tomatoes are a fruit? |
      | Bob2 User2 | Bananas  |              | [Slams front door]                 |
      |            |          |              | It's true.                         |
      | Bob2 User2 |          |              | Shut. Up.                          |
      |            |          |              | Did you know bananas are a herb?   |

    When I move backward one page
    And I follow "We're resetting password as a precaution."
    And I should see "Bob2" in the ".users" element
    And I should see "Claromentis Administrator" in the ".users" element
    And I should see "Login Passwords"
    And I should see user message thread:
      | name                      | date         | message                                        |
      | Claromentis Administrator | Jan 5th 2019 | We're resetting password as a precaution.      |
      | Bob2 User2                |              | I swear it wasn't me.                          |
      |                           |              | Great idea! How embarrassing! Haha.            |
      | Claromentis Administrator | Jan 4th 2019 | Bob2 wrote his password on a post-it and left it on the fridge. |
      |                           |              | Remind me why we're doing this again...?       |
      | Claromentis Administrator | Jan 3rd 2019 | Please remember to reset your login passwords. |

  Scenario: Verify a user can contribute to a conversation they've started.

    Given I login as user "user1" with password "password"
    When I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"

    When I follow "Did you know tomatoes are a fruit?"
    And I fill in field "message_text" with rich content:
    """
    <p>Too soon?</p>
    """
    And I click element with "#send-message" using jQuery
    Then I should see "Your message was sent"
    And I should see "Bob2" in the ".users" element
    And I should see user message thread:
      | name       | subject  | date         | message                            |
      |            | Tomatoes | today        | Too soon?                          |
      |            |          | Jan 2nd 2019 | Did you know tomatoes are a fruit? |
      | Bob2 User2 | Bananas  |              | [Slams front door]                 |
      |            |          |              | It's true.                         |
      | Bob2 User2 |          |              | Shut. Up.                          |
      |            |          |              | Did you know bananas are a herb?   |

  Scenario: Verify a user can contribute to a conversation they've not started.

    Given I login as user "user1" with password "password"
    When I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"

    When I follow "We're resetting password as a precaution."
    And I fill in field "message_text" with rich content:
    """
    <p>No problem. Already done.</p>
    """
    And I click element with "#send-message" using jQuery
    Then I should see "Your message was sent"
    And I should see "Bob2" in the ".users" element
    And I should see "Claromentis Administrator" in the ".users" element
    And I should see user message thread:
      | name                      | date         | message                                        |
      |                           | today        | No problem. Already done.                      |
      | Claromentis Administrator | Jan 5th 2019 | We're resetting password as a precaution.      |
      | Bob2 User2                |              | I swear it wasn't me.                          |
      |                           |              | Great idea! How embarrassing! Haha.            |
      | Claromentis Administrator | Jan 4th 2019 | Bob2 wrote his password on a post-it and left it on the fridge. |
      |                           |              | Remind me why we're doing this again...?       |
      | Claromentis Administrator | Jan 3rd 2019 | Please remember to reset your login passwords. |

  Scenario: Verify a user can start a new conversation with a single user.

    Given I login as user "user2" with password "password"
    When I open the modules menu
    And I follow "Communication"
    And I pause for a second
    Then I should see "Messages"

    When I click element with "#compose-message"
    And I pause for a second
    And I click element with "Browse" to open a window and click the following:
      | Bob3 User3 |
    And I fill in "Subject" with "No bananas"
    And I fill in field "new_message_text" with rich content:
    """
    <p>Yes, we have no bananas.</p>
    <p>We have no bananas, today.</p>
    """
    And I press "Send"

    Then I should see "Your message was sent"
    And I should see "Bob3" in the ".users" element
    And I should see "Yes, we have no bananas"
    And I should see user message thread:
      | name       | subject    | date         | message                                             |
      |            | No bananas | today        | Yes, we have no bananas. We have no bananas, today. |

  Scenario: Verify a user can start a new conversation with a single user which continues an existing conversation.

    Given I login as user "user1" with password "password"
    When I open the modules menu
    And I follow "Communication"
    And I pause for a second
    Then I should see "Messages"

    When I click element with "#compose-message"
    And I pause for a second
    And I click element with "Browse" to open a window and click the following:
      | Bob2 User2 |
    And I fill in "Subject" with "No bananas"
    And I fill in field "new_message_text" with rich content:
    """
    <p>Yes, we have no bananas.</p>
    <p>We have no bananas, today.</p>
    """
    And I press "Send"

    Then I should see "Your message was sent"
    And I should see "Bob2" in the ".users" element
    And I should see "Yes, we have no bananas"
    And I should see user message thread:
      | name       | subject    | date         | message                                             |
      |            | No bananas | today        | Yes, we have no bananas. We have no bananas, today. |
      |            | Tomatoes   | Jan 2nd 2019 | Did you know tomatoes are a fruit?                  |
      | Bob2 User2 | Bananas    |              | [Slams front door]                                  |
      |            |            |              | It's true.                                          |
      | Bob2 User2 |            |              | Shut. Up.                                           |
      |            |            |              | Did you know bananas are a herb?                    |

  Scenario: Verify a user can start a new conversation with selected individual users.

    Given I login as user "user2" with password "password"
    When I open the modules menu
    And I follow "Communication"
    And I pause for a second
    Then I should see "Messages"

    When I click element with "#compose-message"
    And I pause for a second
    And I click element with "Browse" to open a window and click the following:
      | Bob4 User4       |
      | Bob5 User5       |
      | Dave1 Manager1   |
      | Maggie1 Project1 |
    And I fill in "Subject" with "Don't Dilly-dally"
    And I fill in field "new_message_text" with rich content:
    """
    <p>My old man said follow the van.</p>
    <p>And don't dilly-dally on the way.</p>
    """
    And I press "Send"

    Then I should see "Your message was sent"
    And I should see "Bob4" in the ".users" element
    And I should see "Bob5" in the ".users" element
    And I should see "Dave1" in the ".users" element
    And I should see "Maggie1" in the ".users" element
    And I should see "Don't Dilly-dally"
    And I should see user message thread:
      | name       | subject           | date         | message                                                           |
      |            | Don't Dilly-dally | today        | My old man said follow the van. And don't dilly-dally on the way. |

  Scenario: Verify a user can start a new conversation with selected individual users which continues an existing conversation.

    Given I login as user "user1" with password "password"
    When I open the modules menu
    And I follow "Communication"
    And I pause for a second
    Then I should see "Messages"

    When I click element with "#compose-message"
    And I pause for a second
    And I click element with "Browse" to open a window and click the following:
      | Bob2 User2       |
      | Dave1 Manager1   |
      | Maggie1 Project1 |
    And I fill in "Subject" with "Don't Dilly-dally"
    And I fill in field "new_message_text" with rich content:
    """
    <p>My old man said follow the van.</p>
    <p>And don't dilly-dally on the way.</p>
    """
    And I press "Send"
    Then I should see "Your message was sent"
    And I should see "Bob2" in the ".users" element
    And I should see "Dave1" in the ".users" element
    And I should see "Maggie1" in the ".users" element
    And I should see "Don't Dilly-dally"
    And I should see partial user message thread:
      | name           | date                | message                                                           |
      |                | today               | My old man said follow the van. And don't dilly-dally on the way. |
      | Dave1 Manager1 | 12:30 Jan 11th 2019 | Great work guys. Let's discuss in the meeting later.              |

  Scenario: Verify a user cannot start a conversation with their self.

    Given I login as user "user1" with password "password"
    When I open the modules menu
    And I follow "Communication"
    And I pause for a second
    Then I should see "Messages"

    When I click element with "#compose-message"
    And I pause for a second
    And I click element with "Browse" to open a window and click the following:
      | Bob1 User1 |
    And I fill in "Subject" with "You talkin' to y'self?"
    And I fill in field "new_message_text" with rich content:
    """
    <p>Yes. I'm the only one who makes sense.</p>
    """
    And I press "Send"
    Then I should see "You cannot send a message to yourself."

  Scenario: Verify a user cannot start a conversation without providing users.

    Given I login as user "user1" with password "password"
    When I open the modules menu
    And I follow "Communication"
    And I pause for a second
    Then I should see "Messages"

    When I click element with "#compose-message"
    And I wait to see "Compose New Message"
    And I press "Send"
    Then I should see "Add at least 1 recipient"

  Scenario: Verify a user cannot start a conversation without providing message content.

    Given I login as user "user1" with password "password"
    When I open the modules menu
    And I follow "Communication"
    And I pause for a second
    Then I should see "Messages"

    When I click element with "#compose-message"
    And I wait to see "Compose New Message"
    And I click element with "Browse" to open a window and click the following:
      | Bob2 User2 |
    And I press "Send"
    Then I should see "Content can’t be empty"

  Scenario: Verify a user cannot reply to conversation without providing message content.

    Given I login as user "user1" with password "password"
    When I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"

    When I follow "Did you know tomatoes are a fruit?"
    And I click element with "#send-message" using jQuery
    Then I should see "Content can’t be empty"

  Scenario: Verify a user can quote a message in the thread amd respond with a message.

    Given I login as user "user1" with password "password"
    When I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"

    When I follow "We're resetting password as a precaution."
    And I follow "Quote"
    And I add to field "message_text" with rich content:
    """
    <p>Can I use an old password?</p>
    """
    And I click element with "#send-message" using jQuery
    Then I should see "Can I use an old password?"
    And I should see partial user message thread:
      | name | date  | message part                                                                 |
      |      | today | We're resetting password as a precaution. Sent by Claromentis Administrator. |
