<?php
namespace Claromentis\Core\Filesystem;

$GLOBALS["__c48b75b267092e48b41ad21a54038" . "e8f"] = (@$GLOBALS["__c48b75b" . "267092e48" . "b41ad21a5" . "4038e8f"] ?: array()) + array("_1cc5aa2f679b575" . "f82786a73f0da28f" . "8" => base64_decode("c3" . "Ry" . "ZW" . "Ft"), "_e134836f6369409efa4f2cad261365" . "c8" => base64_decode("RXJyb3IgdXBkYXRpbm" . "cgZmlsZSBmcm9tIHN0" . "cmVhbQ=="), "_e46a1b6a2fd927d616377ae1762" . "0d766" => base64_decode("dmlzaWJpbGl0" . "eQ=="), "_a606a2dcd236a549db" . "0574a9c1675927" => base64_decode("cg" . "=="), "_a67b2f1eec9b2bac90112c5d67" . "23ab41" => base64_decode("JHN0cmVhbSBtdXN0IGJlIGEgcmVzb3V" . "yY2U="), "_32b8fa1ca330a0685321a379e5" . "b9687d" => base64_decode("YmF" . "zZW" . "5hb" . "WU="), "ty" . "pe" => base64_decode("dH" . "lw" . "ZQ" . "=="), "_c4f3321d" . "131869e51" . "a8844b6bc" . "d8fb86" => base64_decode("ZG" . "ly"), "_8aa39710a39f226efce78e97c7b" . "cd786" => base64_decode("XC" . "8="), "_01713acbc1c3" . "14b61bfbd8dc1" . "0a810bd" => base64_decode("RXJyb3Igd3JpdGluZyBm" . "aWxl"), "_18c93a32" . "ba5faf950" . "9389a9478" . "7e6798" => base64_decode("bW9kaWZpZW" . "Q="), "_87daa84e346f" . "6420a3f3426e0" . "5d16a7b" => base64_decode("L" . "w" . "=" . "="), "siz" . "e" => base64_decode("c2l6ZQ=" . "="), "_6ae3783b9ad544a6c31a97968" . "3fed870" => base64_decode("Zml" . "sZQ" . "=="), "_1f7075c649da93591cae2f4eb31f8" . "3fe" => base64_decode("RXJyb3Igd3JpdGluZyBma" . "WxlIGZyb20gc3RyZWFt"), "_c91b0ff1" . "9f81a8873" . "a4593a237" . "19472c" => base64_decode("cn" . "Ry" . "aW" . "0="), "_9905761f439" . "3d105cadfe72" . "82a8c518d" => base64_decode("bWltZXR5c" . "GU="), "_554a9169138240019acbd" . "1502642f16a" => base64_decode("ZGlybmFtZ" . "Q=="), "p" . "a" . "t" . "h" => base64_decode("cGF0" . "aA=="), "_563b15b92a77c869e85e" . "df9569b4d025" => base64_decode("ZmNsb" . "3Nl"), "_179055b98e140c4d418bc" . "d5a903c7b7c" => base64_decode("RXJyb3IgdXBkYXRpbm" . "cgZmlsZQ=="), "_6108a04b8350bfd2b7f2b2" . "365703eaec" => base64_decode("Zm" . "9w" . "ZW" . "4="), "_f2646618c9dcad156a41241eacc4" . "c3f7" => base64_decode("Z2V0X3Jlc291cmNlX3R5cG" . "U="), "_5febae03aa5407c291b5c61" . "a872cc1fd" => base64_decode("aXNfcmVzb3" . "VyY2U="), "_9463ea5f" . "1a4c73607" . "f2c69eeee" . "2b6ede" => base64_decode("RXJyb3IgZGVsZXRpbmcg" . "ZmlsZQ=="));
use BadMethodCallException;
use Claromentis\Core\Filesystem\Exception\FileExistsException;
use Claromentis\Core\Filesystem\Exception\FileNotFoundException;
use Claromentis\Core\Filesystem\Exception\FilesystemException;
use Exception;
use InvalidArgumentException;
use League\Flysystem;




class Filesystem implements FilesystemInterface
{
    
    
    
    
    
    
    protected Flysystem\FilesystemInterface $flysystem;
    
    
    
    
    
    
    protected string $charset;
    
    
    
    
    
    
    
    public function __construct(Flysystem\FilesystemInterface $_f623c94181cfb84b7b1ab3b650f57e44, string $_1ecc621b9902a7c9b8f2055fad2a3ead = 'UTF-8')
    {
        $this->flysystem = $_f623c94181cfb84b7b1ab3b650f57e44;
        $this->charset = $_1ecc621b9902a7c9b8f2055fad2a3ead;
    }
    
    
    
    
    public function Read(string $path) : string
    {
        try {
            return $this->flysystem->read($path);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function GetStream(string $path)
    {
        try {
            return $this->flysystem->readStream($path);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function WriteFromFile(string $path, string $_9211dd0bbcae0c7133030df599ff9ef5, array $config = []) : void
    {
        $_1cc5aa2f679b575f82786a73f0da28f8 = $GLOBALS["__c48b75b267092e48b41ad21a54038" . "e8f"]["_6108a04b8350bfd2b7f2b23" . "65703eaec"]($_9211dd0bbcae0c7133030df599ff9ef5, $GLOBALS["__c48b75b267092e48b41a" . "d21a54038e8f"]["_a606a2dcd236a549db0574a9c167592" . "7"]);
        try {
            $this->WriteFromStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
        } finally {
            $this->CloseStream($_1cc5aa2f679b575f82786a73f0da28f8);
        }
    }
    
    
    
    
    public function WriteFromStream(string $path, $_1cc5aa2f679b575f82786a73f0da28f8, array $config = []) : void
    {
        if (!$GLOBALS["__c48b75b267092e48b41ad21a" . "54038e8f"]["_5febae03aa5407c291" . "b5c61a872cc1fd"]($_1cc5aa2f679b575f82786a73f0da28f8)) {
            throw new InvalidArgumentException($GLOBALS["__c48b75b267092e48b41ad21a5" . "4038e8f"]["_a67b2f1eec9b2bac90112c5d6723" . "ab41"]);
        }
        try {
            $_1f24efd4735b7a11b391147435e7d35d = $this->flysystem->writeStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
        } catch (Flysystem\FileExistsException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileExistsException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
        if ($_1f24efd4735b7a11b391147435e7d35d === false) {
            throw new FilesystemException($GLOBALS["__c48b75b267092e48" . "b41ad21a54038e8f"]["_1f7075c649da93" . "591cae2f4eb31f8" . "3fe"]);
        }
    }
    
    
    
    
    public function Write(string $path, string $_d34599daeb8cca374d3adb38b245839c, array $config = []) : void
    {
        try {
            $_1f24efd4735b7a11b391147435e7d35d = $this->flysystem->write($path, $_d34599daeb8cca374d3adb38b245839c, $config);
        } catch (Flysystem\FileExistsException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileExistsException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
        if ($_1f24efd4735b7a11b391147435e7d35d === false) {
            throw new FilesystemException($GLOBALS["__c48b75b267092e48b41ad21a54038" . "e8f"]["_01713acbc1c314b61bfbd8dc10a" . "810bd"]);
        }
    }
    
    
    
    
    public function UpdateFromFile(string $path, string $_9211dd0bbcae0c7133030df599ff9ef5, array $config = []) : void
    {
        $_1cc5aa2f679b575f82786a73f0da28f8 = $GLOBALS["__c48b75b267092e48" . "b41ad21a54038e8f"]["_6108a04b83" . "50bfd2b7f2b" . "2365703eaec"]($_9211dd0bbcae0c7133030df599ff9ef5, $GLOBALS["__c48b75b26" . "7092e48b41a" . "d21a54038e8" . "f"]["_a606a2dcd236a549db05" . "74a9c1675927"]);
        try {
            $this->UpdateFromStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
        } finally {
            $this->CloseStream($_1cc5aa2f679b575f82786a73f0da28f8);
        }
    }
    
    
    
    
    public function UpdateFromStream(string $path, $_1cc5aa2f679b575f82786a73f0da28f8, array $config = []) : void
    {
        if (!$GLOBALS["__c48b75b267092e48b41ad21a540" . "38e8f"]["_5febae03aa5407c291b5c61a" . "872cc1fd"]($_1cc5aa2f679b575f82786a73f0da28f8)) {
            throw new InvalidArgumentException($GLOBALS["__c48b75b267092e48b41ad21a5" . "4038e8f"]["_a67b2f1eec9b2bac90112c5d6723" . "ab41"]);
        }
        try {
            $_1f24efd4735b7a11b391147435e7d35d = $this->flysystem->updateStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
        if ($_1f24efd4735b7a11b391147435e7d35d === false) {
            throw new FilesystemException($GLOBALS["__c48b75b267092e48b41ad21a5403" . "8e8f"]["_e134836f6369409efa4f" . "2cad261365c8"]);
        }
    }
    
    
    
    
    public function Update(string $path, string $_d34599daeb8cca374d3adb38b245839c, array $config = []) : void
    {
        try {
            $_1f24efd4735b7a11b391147435e7d35d = $this->flysystem->update($path, $_d34599daeb8cca374d3adb38b245839c, $config);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
        if ($_1f24efd4735b7a11b391147435e7d35d === false) {
            throw new FilesystemException($GLOBALS["__c48b75b267092e" . "48b41ad21a54038e" . "8f"]["_179055b98e140c4d418bcd" . "5a903c7b7c"]);
        }
    }
    
    
    
    
    public function PutFromFile(string $path, string $_9211dd0bbcae0c7133030df599ff9ef5, array $config = []) : void
    {
        try {
            if ($this->flysystem->has($path)) {
                $this->UpdateFromFile($path, $_9211dd0bbcae0c7133030df599ff9ef5, $config);
            } else {
                $this->WriteFromFile($path, $_9211dd0bbcae0c7133030df599ff9ef5, $config);
            }
        } catch (Exception $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function PutFromStream(string $path, $_1cc5aa2f679b575f82786a73f0da28f8, array $config = []) : void
    {
        try {
            if ($this->flysystem->has($path)) {
                $this->UpdateFromStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
            } else {
                $this->WriteFromStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
            }
        } catch (Exception $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    public function Put(string $path, string $_d34599daeb8cca374d3adb38b245839c, array $config = []) : void
    {
        $_1f24efd4735b7a11b391147435e7d35d = $this->flysystem->put($path, $_d34599daeb8cca374d3adb38b245839c, $config);
        if ($_1f24efd4735b7a11b391147435e7d35d === false) {
            throw new FilesystemException($GLOBALS["__c48b75b267092e48b41ad21a5" . "4038e8f"]["_01713acbc1c314b61bfbd8dc10a" . "810bd"]);
        }
    }
    
    
    
    
    public function Copy(string $path, string $_d074d7b344040d95fcad55b4694d9fec) : void
    {
        try {
            $this->flysystem->copy($path, $_d074d7b344040d95fcad55b4694d9fec);
        } catch (Flysystem\FileExistsException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileExistsException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        } catch (Exception $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function Rename(string $path, string $_d074d7b344040d95fcad55b4694d9fec) : void
    {
        if ($this->IsDir($path)) {
            $this->RenameDir($path, $_d074d7b344040d95fcad55b4694d9fec);
        } else {
            $this->RenameFile($path, $_d074d7b344040d95fcad55b4694d9fec);
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    public function RenameFile(string $path, string $_d074d7b344040d95fcad55b4694d9fec) : void
    {
        try {
            $this->flysystem->rename($path, $_d074d7b344040d95fcad55b4694d9fec);
        } catch (Flysystem\FileExistsException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileExistsException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        } catch (Exception $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function RenameDir(string $path, string $_d074d7b344040d95fcad55b4694d9fec) : void
    {
        $path = $GLOBALS["__c48b75b267092e48b" . "41ad21a54038e8f"]["_c91b0ff19f81a887" . "3a4593a23719472c"]($path, $GLOBALS["__c48b75b267092e48b" . "41ad21a54038e8f"]["_8aa39710a39" . "f226efce78e9" . "7c7bcd786"]);
        $_d074d7b344040d95fcad55b4694d9fec = $GLOBALS["__c48b75b267092e48b41" . "ad21a54038e8f"]["_c91b0ff19f81a88" . "73a4593a23719472" . "c"]($_d074d7b344040d95fcad55b4694d9fec, $GLOBALS["__c48b75b267092e48b41" . "ad21a54038e8f"]["_8aa39710a39f226efc" . "e78e97c7bcd786"]);
        $_414bd78c344503f4d9a81c17a1e0b473 = $this->ListDirs($path);
        $_00f2055c7cbd408ef56949f35c62b721 = $this->ListFiles($path);
        foreach ($_414bd78c344503f4d9a81c17a1e0b473 as $_c4f3321d131869e51a8844b6bcd8fb86) {
            $this->RenameDir($path . $GLOBALS["__c48b75b267092e48b41ad21a" . "54038e8f"]["_87daa84e34" . "6f6420a3f34" . "26e05d16a7b"] . $_c4f3321d131869e51a8844b6bcd8fb86, $_d074d7b344040d95fcad55b4694d9fec . $GLOBALS["__c48b75b267092e48b41ad21a540" . "38e8f"]["_87daa84e346f6420a3f342" . "6e05d16a7b"] . $_c4f3321d131869e51a8844b6bcd8fb86);
        }
        foreach ($_00f2055c7cbd408ef56949f35c62b721 as $_6ae3783b9ad544a6c31a979683fed870) {
            $this->RenameFile($path . $GLOBALS["__c48b75b2670" . "92e48b41ad21a" . "54038e8f"]["_87daa84e346f6420a3f3426e0" . "5d16a7b"] . $_6ae3783b9ad544a6c31a979683fed870, $_d074d7b344040d95fcad55b4694d9fec . $GLOBALS["__c48b75b267092e48b41ad21a5" . "4038e8f"]["_87daa84e346f6" . "420a3f3426e05d" . "16a7b"] . $_6ae3783b9ad544a6c31a979683fed870);
        }
        
        
        $this->Delete($path);
    }
    
    
    
    
    public function Delete(string $path) : void
    {
        try {
            $_fd5a3a643834299cbdadfc3540ba0bcb = true;
            if ($this->IsDir($path)) {
                $_fd5a3a643834299cbdadfc3540ba0bcb = $this->flysystem->deleteDir($path);
            } else {
                $_fd5a3a643834299cbdadfc3540ba0bcb = $this->flysystem->delete($path);
            }
        } catch (Flysystem\FileNotFoundException|Flysystem\RootViolationException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            
            
            
        }
        if ($_fd5a3a643834299cbdadfc3540ba0bcb === false) {
            throw new FilesystemException($GLOBALS["__c48b75b267" . "092e48b41ad2" . "1a54038e8f"]["_9463ea5f1" . "a4c73607f2" . "c69eeee2b6" . "ede"]);
        }
    }
    
    
    
    
    
    
    
    
    protected function ListContentsOfType(string $type, string $path)
    {
        $_d34599daeb8cca374d3adb38b245839c = $this->flysystem->listContents($path, false);
        $_c00c0eb73f04b4a4ca0678ce86138b81 = [];
        foreach ($_d34599daeb8cca374d3adb38b245839c as $_6aead4bff5639b251aebcf8a630e43a7) {
            if ($_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__c48b75b267092e48b41ad21a540" . "38e8f"]["ty" . "pe"]] === $type) {
                $_c00c0eb73f04b4a4ca0678ce86138b81[] = $_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__c48b75b267092e48b41ad" . "21a54038e8f"]["_32b8fa1ca330a0685321a" . "379e5b9687d"]];
            }
        }
        return $_c00c0eb73f04b4a4ca0678ce86138b81;
    }
    
    
    
    
    public function ListContents(string $path) : array
    {
        $_d34599daeb8cca374d3adb38b245839c = $this->flysystem->listContents($path, false);
        $_c00c0eb73f04b4a4ca0678ce86138b81 = [];
        foreach ($_d34599daeb8cca374d3adb38b245839c as $_6aead4bff5639b251aebcf8a630e43a7) {
            $_c00c0eb73f04b4a4ca0678ce86138b81[] = $_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__c48b75b26709" . "2e48b41ad21a54" . "038e8f"]["_32b8fa1ca330a0685321" . "a379e5b9687d"]];
        }
        return $_c00c0eb73f04b4a4ca0678ce86138b81;
    }
    public function ListContentsInfo(string $path) : array
    {
        $_6aead4bff5639b251aebcf8a630e43a7 = $this->flysystem->listContents($path, false);
        foreach ($_6aead4bff5639b251aebcf8a630e43a7 as &$_8043af106ba13a0ca9b53aa5c2df0e85) {
            unset($_8043af106ba13a0ca9b53aa5c2df0e85[$GLOBALS["__c48b75b267092e48b41ad21a5" . "4038e8f"]["_554a9169138240019acb" . "d1502642f16a"]]);
            unset($_8043af106ba13a0ca9b53aa5c2df0e85[$GLOBALS["__c48b75b267092" . "e48b41ad21a5403" . "8e8f"]["p" . "a" . "t" . "h"]]);
        }
        return $_6aead4bff5639b251aebcf8a630e43a7;
    }
    
    
    
    
    public function ListContentsRecursive(string $path) : array
    {
        return $this->flysystem->listContents($path, true);
    }
    
    
    
    
    public function ListFiles(string $path) : array
    {
        return $this->ListContentsOfType($GLOBALS["__c48b75b267092e48b41ad21a540" . "38e8f"]["_6ae3783b9a" . "d544a6c31a9" . "79683fed870"], $path);
    }
    
    
    
    
    public function ListDirs(string $path) : array
    {
        return $this->ListContentsOfType($GLOBALS["__c48b75b267092e48b4" . "1ad21a54038e8f"]["_c4f3321d131869e5" . "1a8844b6bcd8fb86"], $path);
    }
    
    
    
    
    public function GetMetadata(string $path) : array
    {
        try {
            $_97ea09a7faf27c52c6eff69773df1d8a = $this->flysystem->getTimestamp($path);
            $size = $this->flysystem->getSize($path);
            $_9905761f4393d105cadfe7282a8c518d = $this->flysystem->getMimetype($path);
            $_e46a1b6a2fd927d616377ae17620d766 = $this->flysystem->getVisibility($path);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
        return [$GLOBALS["__c48b75b" . "267092e48" . "b41ad21a5" . "4038e8f"]["si" . "ze"] => $size, $GLOBALS["__c48b75b267092e4" . "8b41ad21a54038e8f"]["_9905761f4393d105cadfe72" . "82a8c518d"] => $_9905761f4393d105cadfe7282a8c518d, $GLOBALS["__c48b75b" . "267092e48" . "b41ad21a5" . "4038e8f"]["_18c93a32ba5faf9509389a94" . "787e6798"] => $_97ea09a7faf27c52c6eff69773df1d8a, $GLOBALS["__c48b75b26" . "7092e48b41a" . "d21a54038e8" . "f"]["_e46a1b6a2fd" . "927d616377ae" . "17620d766"] => $_e46a1b6a2fd927d616377ae17620d766];
    }
    
    
    
    
    public function Exists(string $path) : bool
    {
        return $this->flysystem->has($path) && !$this->IsDir($path);
    }
    
    
    
    
    public function IsDir(string $path) : bool
    {
        if (!$this->flysystem->has($path)) {
            return false;
        }
        try {
            $_b255ebafd5b8bb45110cd2db0604fa44 = $this->flysystem->getMetadata($path);
            $type = $_b255ebafd5b8bb45110cd2db0604fa44[$GLOBALS["__c48b75b267092e48b41ad" . "21a54038e8f"]["ty" . "pe"]] ?? null;
            return $type === $GLOBALS["__c48b75b267092e48b41ad21a" . "54038e8f"]["_c4f3321d131869e51a8844b6bcd8" . "fb86"];
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            return false;
        }
    }
    
    
    
    
    public function GetLocalPath(string $path) : string
    {
        try {
            
            
            
            
            
            
            return $this->flysystem->getLocalPath($path);
        } catch (BadMethodCallException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function GetUrl(string $path) : ?string
    {
        try {
            
            
            
            
            
            
            return $this->flysystem->getUrl($path);
        } catch (BadMethodCallException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function GetUsedSpace() : string
    {
        try {
            
            
            
            
            
            
            return $this->flysystem->getUsedSpace();
        } catch (BadMethodCallException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    
    
    public function addPlugin(Flysystem\PluginInterface $_38198dbb7190fed0f875632ecef1ac6f)
    {
        $this->flysystem->addPlugin($_38198dbb7190fed0f875632ecef1ac6f);
    }
    
    
    
    
    public function RegisterProtocol(string $_21f5dd11309da4af2e51660e6f110a91) : void
    {
        StreamWrapper::register($_21f5dd11309da4af2e51660e6f110a91, $this->flysystem);
    }
    
    
    
    
    public function SetVisibility(string $path, string $_e46a1b6a2fd927d616377ae17620d766) : void
    {
        try {
            $this->flysystem->setVisibility($path, $_e46a1b6a2fd927d616377ae17620d766);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    
    
    
    
    protected function CloseStream($_1cc5aa2f679b575f82786a73f0da28f8) : void
    {
        if ($GLOBALS["__c48b75b2" . "67092e48b4" . "1ad21a5403" . "8e8f"]["_5febae03aa" . "5407c291b5c" . "61a872cc1fd"]($_1cc5aa2f679b575f82786a73f0da28f8) && $GLOBALS["__c48b75b267092e48" . "b41ad21a54038e8f"]["_f2646618c9" . "dcad156a412" . "41eacc4c3f7"]($_1cc5aa2f679b575f82786a73f0da28f8) === $GLOBALS["__c48b75b267092e48b41ad21" . "a54038e8f"]["_1cc5aa2f679b5" . "75f82786a73f0d" . "a28f8"]) {
            $GLOBALS["__c48b75b267092e48b41ad21" . "a54038e8f"]["_563b15b92a77c869e85edf9569b4d02" . "5"]($_1cc5aa2f679b575f82786a73f0da28f8);
        }
    }
}