<?php
namespace Claromentis\Core\Localization;

$GLOBALS["__1d214cac" . "1eebfaca50" . "b74c93e0da" . "ec54"] = (@$GLOBALS["__1d214cac1eebfaca50b74c93e0daec" . "54"] ?: array()) + array("_53d43bf1f48959b27c566cc3f5" . "b06681" => base64_decode("UGhyYXNlI" . "Cc="), "_7d9ddc77b5329ea478ce5d43e4" . "615f53" => base64_decode("JyBkb" . "2Vzbi" . "d0IGV" . "4aXN0"));
use Claromentis\Core\Localization\Exception\MissingPhraseException;








class MemoryProvider implements LocalizationProviderInterface
{
    
    
    
    
    protected $files_reader;
    
    
    
    
    protected $app_code;
    
    
    
    
    protected $lm = array();
    
    
    
    
    protected $lt_parsed = array();
    
    
    
    
    
    
    
    public function __construct($_d901b83ea3a884001dad5ede20f9b05e, Files $_00f2055c7cbd408ef56949f35c62b721)
    {
        $this->app_code = $_d901b83ea3a884001dad5ede20f9b05e;
        $this->files_reader = $_00f2055c7cbd408ef56949f35c62b721;
    }
    
    
    public function getTranslation(string $key, string $language)
    {
        $this->CheckLoadMessages($language);
        if (!isset($this->lm[$language][$key])) {
            throw new MissingPhraseException($GLOBALS["__1d214cac1eebfaca50b" . "74c93e0daec54"]["_53d43bf1f489" . "59b27c566cc3f" . "5b06681"] . $key . $GLOBALS["__1d214cac1eebfaca50b74c93" . "e0daec54"]["_7d9ddc77b5329ea478ce5" . "d43e4615f53"]);
        }
        return $this->lm[$language][$key];
    }
    
    
    public function getTemplaterPhrases(string $language) : array
    {
        $this->CheckLoadTemplaterMessages($language);
        return $this->lt_parsed[$language];
    }
    
    
    
    
    
    
    public function CheckLoadMessages($language)
    {
        if (isset($this->lm[$language])) {
            return;
        }
        $this->lm[$language] = [];
        $this->files_reader->ReadLM($this->lm[$language], $this->app_code, $language);
    }
    
    
    
    
    
    
    protected function CheckLoadTemplaterMessages($language)
    {
        if (isset($this->lt_parsed[$language])) {
            return;
        }
        $this->lt_parsed[$language] = array();
        $this->CheckLoadMessages($language);
        $this->files_reader->ReadLT($this->lm[$language], $this->lt_parsed[$language], $this->app_code, $language);
    }
    
    
    public function hasKey(string $key, string $language) : bool
    {
        $this->CheckLoadMessages($language);
        return isset($this->lm[$language][$key]);
    }
    
    
    
    
    public function getDomain() : string
    {
        return (string) $this->app_code;
    }
    
    
    
    
    
    
    
    public function getDataHash(string $language) : ?string
    {
        return $this->files_reader->GetDataHash($this->app_code, $language);
    }
}