(function()
{
    require(['jquery', 'domReady'], function($, domReady) {
        domReady(function() {
            $('form[name="peopleadmin_users"]').on('submit', function(event) {
                var action = $(this).find('input[name="action"]').val();

                // If this isn't the per-user sync options, carry on
                if (action !== 'import_selected')
                    return;

                event.preventDefault();

                // Collate data from all the individual checkboxes
                var add_username = [];
                var use_username = [];
                var delete_user_id = [];
                var sync_groups = [];
                var sync_roles = [];
                var subscribe = [];
                $(this).find('input[type="checkbox"]').each(function(){
                    var name = $(this).prop('name');
                    if ($(this).prop('checked'))
                    {
                        var m;

                        if ((m = /add_username\[(.*)\]/.exec(name)) !== null)
                            add_username.push(m[1].trim());

                        if ((m = /use_username\[(.*)\]/.exec(name)) !== null)
                            use_username.push(m[1].trim());

                        if ((m = /sync_groups\[(\d*)\]/.exec(name)) !== null)
                            sync_groups.push(parseInt(m[1]));

                        if ((m = /sync_roles\[(\d*)\]/.exec(name)) !== null)
                            sync_roles.push(parseInt(m[1]));

                        if ((m = /subscribe\[(\d*)\]/.exec(name)) !== null)
                            subscribe.push(parseInt(m[1]));

                        if (name === 'delete_user_id[]')
                            delete_user_id.push(parseInt($(this).val()));

                    }
                });

                // Build a new form using this one as a template and our collections instead of the original checkboxes
                var token = $(this).find('input[name="csrf_token"]').val();
                var generate_password = $(this).find('input[name="preview_generate_password"]').val();

                var newForm = $($.clone(this));
                newForm.empty();

                newForm.append('<input type="hidden" name="csrf_token" value="' + token + '">');
                newForm.append('<input type="hidden" name="action" value="' + action + '">');

                newForm.append('<input type="hidden" name="add_username" value="' + encodeURIComponent(JSON.stringify(add_username)) + '">');
                newForm.append('<input type="hidden" name="use_username" value="' + encodeURIComponent(JSON.stringify(use_username)) + '">');
                newForm.append('<input type="hidden" name="delete_user_id" value="' + JSON.stringify(delete_user_id) + '">');
                newForm.append('<input type="hidden" name="sync_groups" value="' + JSON.stringify(sync_groups) + '">');
                newForm.append('<input type="hidden" name="sync_roles" value="' + JSON.stringify(sync_roles) + '">');
                newForm.append('<input type="hidden" name="subscribe" value="' + JSON.stringify(subscribe) + '">');
                newForm.append('<input type="hidden" name="generate_password" value="' + generate_password + '">');
                $('body').append(newForm);

                newForm.submit();
            });
        });
    });
}());
