<?php
namespace Claromentis\Menu\Tests\Unit;

$GLOBALS["__bac1b45e9bbe89910e93f7185a8d91c" . "9"] = (@$GLOBALS["__bac1b45e9bbe89910" . "e93f7185a8d91c9"] ?: array()) + array("_354b3b07bdaa4e702886b2fdf9d" . "d11ce" => base64_decode("bmV3X3d" . "pbmRvdw" . "=="), "_60e82eb14c64d29299d" . "f04bef5d54fae" => base64_decode("Z2V" . "0VX" . "Jp"), "_31aba1e5c29106f7c" . "5bd79dad886adde" => base64_decode("b2Zmc2V0" . "R2V0"), "_4d707fab93b" . "ebb00bbe69e8" . "159697c90" => base64_decode(""), "_fc96cbe018f580224" . "b2bd19f6ca5b1af" => base64_decode("Z2V0QXBwbGljYXRpb24" . "="), "u" . "r" . "l" => base64_decode("d" . "X" . "J" . "s"), "_77ca388c" . "9c772f10d" . "f143747e3" . "08c256" => base64_decode("YmVlcw" . "=="), "_cb172b81" . "ef80d647d" . "fc7d94390" . "da7dfd" => base64_decode("X19" . "nZX" . "Q="), "_4f70609f87a80124bc5f3f61cfcee" . "062" => base64_decode("dG9BcnJh" . "eQ=="), "_673a0ee3b3175349e2dfbb7d7ab" . "508d7" => base64_decode("L3NvbWUv" . "cGF0aC8="), "_3e601b2b84d3af9" . "292fd72597f243e0" . "5" => base64_decode("cmVuZGV" . "y"), "_662dd3b" . "8c6bbe73" . "41d7427c" . "14c4e03a" . "7" => base64_decode("d2F" . "ybm" . "luZ" . "w=="), "ti" . "tl" . "e" => base64_decode("dGl0" . "bGU="), "_7b570af0610337" . "ec63f47a88089ae" . "c1e" => base64_decode("c29" . "tZX" . "Roa" . "W5n"), "_57868356275757" . "d92fd8e7fe2fd74" . "b64" => base64_decode("YXBwbGljYXRpb25faW" . "Q="), "_a8525a66ffb31b3" . "59c6bbc55e4408b3" . "a" => base64_decode("Z2V0UGF0" . "aA=="), "_723f68768b826e92" . "cd5c5d8de9837ac2" => base64_decode("dGhlcmUgY" . "W5kIGJhY2" . "sgYWdhaW4" . "="), "_0c7e7fb6a04a1f3e689de5" . "eea4ee0c86" => base64_decode("ZWh" . "o"), "requ" . "est" => base64_decode("cmVxdWV" . "zdA=="));
use Claromentis\Core\Application;
use Claromentis\Menu\Exception\MenuItemException;
use Claromentis\Menu\Exception\MenuItemForbiddenException;
use Claromentis\Menu\Infobar\ApplicationsListItems;
use Claromentis\Menu\Infobar\MenuItemApplication;
use Claromentis\Menu\Infobar\MenuItemFormatter;
use Claromentis\Menu\UI\ApplicationIcon;
use LogicException;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;
use Psr\Http\Message\ServerRequestInterface;
use Psr\Http\Message\UriInterface;
use Psr\Log\LoggerInterface;
use Symfony\Component\EventDispatcher\EventDispatcherInterface;
use Twig\Environment;
class ApplicationIconTest extends TestCase
{
    private ApplicationIcon $applicationIcon;
    
    
    private MockObject $mockApplication;
    
    
    private MockObject $mockApplicationsListItems;
    
    
    private MockObject $mockEnvironment;
    
    
    private MockObject $mockEventDispatcher;
    
    
    private MockObject $mockLogger;
    
    
    private MockObject $mockMenuItemFormatter;
    protected function setUp()
    {
        $this->mockApplicationsListItems = $this->createMock(ApplicationsListItems::class);
        $this->mockMenuItemFormatter = $this->createMock(MenuItemFormatter::class);
        $this->mockLogger = $this->createMock(LoggerInterface::class);
        $this->mockEnvironment = $this->createMock(Environment::class);
        $this->mockEventDispatcher = $this->createMock(EventDispatcherInterface::class);
        $this->applicationIcon = new ApplicationIcon($this->mockApplicationsListItems, $this->mockMenuItemFormatter, $this->mockLogger, $this->mockEnvironment, $this->mockEventDispatcher);
        $this->mockRequest = $this->createMock(ServerRequestInterface::class);
        $_a81a7f89c0089a7d7c2fc2ff72114c4d = $this->createMock(UriInterface::class);
        $_a81a7f89c0089a7d7c2fc2ff72114c4d->method($GLOBALS["__bac1b45e9bbe89910" . "e93f7185a8d91c9"]["_a8525a66ffb31b35" . "9c6bbc55e4408b3a"])->willReturn($GLOBALS["__bac1b45e9" . "bbe89910e93" . "f7185a8d91c" . "9"]["_673a0ee3b3175349e2dfbb7" . "d7ab508d7"]);
        $this->mockRequest->method($GLOBALS["__bac1b45e9bbe89910e9" . "3f7185a8d91c9"]["_60e82eb" . "14c64d29" . "299df04b" . "ef5d54fa" . "e"])->willReturn($_a81a7f89c0089a7d7c2fc2ff72114c4d);
        $this->mockApplication = $this->createMock(Application::class);
        $this->mockApplication->method($GLOBALS["__bac1b45e9bb" . "e89910e93f718" . "5a8d91c9"]["_31aba1e5c29106f" . "7c5bd79dad886add" . "e"])->willReturnMap([[$GLOBALS["__bac1b45e9bbe89910e93f7" . "185a8d91c9"]["requ" . "est"], $this->mockRequest]]);
        $this->mockApplication->method($GLOBALS["__bac1b45e9bbe89910e93f718" . "5a8d91c9"]["_cb172b81ef80d647d" . "fc7d94390da7dfd"])->willReturnCallback(function ($_c241f11ec2591cc626823468234ffaf4) {
            return $this->mockApplication->offsetGet($_c241f11ec2591cc626823468234ffaf4);
        });
    }
    
    
    
    
    
    
    
    
    public function test_Show_noApplication() : void
    {
        $this->mockLogger->expects($this->atLeastOnce())->method($GLOBALS["__bac1b45e9bbe89910e93f7185a8d91c" . "9"]["_662dd3b8c6bbe7341d7427c14c4e0" . "3a7"]);
        $this->assertSame($GLOBALS["__bac1b45e9bbe89910e" . "93f7185a8d91c9"]["_4d707fab93bebb00bbe69e81" . "59697c90"], $this->applicationIcon->Show([], $this->mockApplication));
    }
    
    
    
    
    
    
    
    
    
    public function test_Show_getApplicationMenuItemException() : void
    {
        
        
        $_eca0f699425b0ac1967c9d6c8ecbe236 = $this->createMock(MenuItemException::class);
        $this->mockApplicationsListItems->method($GLOBALS["__bac1b45e9bbe89910e93f7185a" . "8d91c9"]["_fc96cbe018f580224b2" . "bd19f6ca5b1af"])->willThrowException($_eca0f699425b0ac1967c9d6c8ecbe236);
        $this->mockLogger->expects($this->atLeastOnce())->method($GLOBALS["__bac1b45e" . "9bbe89910e" . "93f7185a8d" . "91c9"]["_662dd3b8c6bbe7341d7" . "427c14c4e03a7"]);
        $this->assertSame($GLOBALS["__bac1b45e9bbe89910" . "e93f7185a8d91c9"]["_4d707fab93bebb00bbe69e815969" . "7c90"], $this->applicationIcon->Show([$GLOBALS["__bac1b45e9bbe89910e93f7185a8d91c" . "9"]["_57868356275757d92f" . "d8e7fe2fd74b64"] => $GLOBALS["__bac1b45e9bbe89910e93f7185a8d9" . "1c9"]["_77ca388c9c772" . "f10df143747e30" . "8c256"]], $this->mockApplication));
    }
    
    
    
    
    
    
    
    
    public function test_Show_getApplicationMenuItemForbiddenException() : void
    {
        
        
        $_2c939f94e7c35293c129c58f2121703f = $this->createMock(MenuItemForbiddenException::class);
        $this->mockApplicationsListItems->method($GLOBALS["__bac1b45e9bbe8" . "9910e93f7185a8d" . "91c9"]["_fc96cbe018f" . "580224b2bd19" . "f6ca5b1af"])->willThrowException($_2c939f94e7c35293c129c58f2121703f);
        $this->expectException(LogicException::class);
        $this->applicationIcon->Show([$GLOBALS["__bac1b45e9bbe89" . "910e93f7185a8d91" . "c9"]["_57868356275757d9" . "2fd8e7fe2fd74b64"] => $GLOBALS["__bac1b45e9bbe89910e93f7185" . "a8d91c9"]["_77ca388c9c772f10df143747e308c2" . "56"]], $this->mockApplication);
    }
    
    
    
    
    
    
    
    
    public function test_Show_newWindowOverwriteTrue() : void
    {
        
        
        $_7d7b332b4537da0a168dd6aa3cf82d95 = $this->createMock(MenuItemApplication::class);
        $this->mockApplicationsListItems->method($GLOBALS["__bac1b45e9" . "bbe89910e93" . "f7185a8d91c" . "9"]["_fc96cbe018f580224b2bd1" . "9f6ca5b1af"])->willReturn($_7d7b332b4537da0a168dd6aa3cf82d95);
        $this->mockMenuItemFormatter->method($GLOBALS["__bac1b45e9bbe89910e93" . "f7185a8d91c9"]["_4f70609f87a80124bc5f3f61cfcee06" . "2"])->willReturn([$GLOBALS["__bac1b45e9bbe89910e93f7185a8" . "d91c9"]["u" . "r" . "l"] => $GLOBALS["__bac1b45e9bbe" . "89910e93f7185a" . "8d91c9"]["_7b570af0610337ec63f47a88089a" . "ec1e"], $GLOBALS["__bac1b45e9bbe89910e93f71" . "85a8d91c9"]["_354b3b07bdaa4e702" . "886b2fdf9dd11ce"] => false]);
        $this->mockEnvironment->expects($this->atLeastOnce())->method($GLOBALS["__bac1b45e9bbe89910e93f" . "7185a8d91c9"]["_3e601b2b84d3af9292f" . "d72597f243e05"])->with($this->anything(), $this->callback(function ($_7aeb15d7405498283791b0bf841c940c) {
            return isset($_7aeb15d7405498283791b0bf841c940c[$GLOBALS["__bac1b45e9bbe8" . "9910e93f7185a8d" . "91c9"]["_354b3b07bdaa4e702886b2fdf" . "9dd11ce"]]) && $_7aeb15d7405498283791b0bf841c940c[$GLOBALS["__bac1b45e9bbe89910e93f7185a" . "8d91c9"]["_354b3b07bdaa4e702886b2fd" . "f9dd11ce"]] === true;
        }));
        $this->applicationIcon->Show([$GLOBALS["__bac1b45e9bbe89910e9" . "3f7185a8d91c9"]["_57868356275757d9" . "2fd8e7fe2fd74b64"] => $GLOBALS["__bac1b45e9" . "bbe89910e93" . "f7185a8d91c" . "9"]["_77ca388c9c772f10df143" . "747e308c256"], $GLOBALS["__bac1b45e9bbe89910e93f7185a8" . "d91c9"]["_354b3b07bdaa4e702" . "886b2fdf9dd11ce"] => true], $this->mockApplication);
    }
    
    
    
    
    
    
    
    
    public function test_Show_newWindowOverwriteFalse() : void
    {
        
        
        $_7d7b332b4537da0a168dd6aa3cf82d95 = $this->createMock(MenuItemApplication::class);
        $this->mockApplicationsListItems->method($GLOBALS["__bac1b45e9bbe8991" . "0e93f7185a8d91c9"]["_fc96cbe018f580224b2bd19f6c" . "a5b1af"])->willReturn($_7d7b332b4537da0a168dd6aa3cf82d95);
        $this->mockMenuItemFormatter->method($GLOBALS["__bac1b45e9bbe89910e93f7185a8d91c" . "9"]["_4f70609f87a" . "80124bc5f3f6" . "1cfcee062"])->willReturn([$GLOBALS["__bac1b45e9bbe89910e" . "93f7185a8d91c9"]["u" . "r" . "l"] => $GLOBALS["__bac1b45e9bbe89910e93f7185a8d" . "91c9"]["_7b570af0610337ec63f47a88089a" . "ec1e"], $GLOBALS["__bac1b45e9bbe89910" . "e93f7185a8d91c9"]["_354b3b07bdaa4" . "e702886b2fdf9d" . "d11ce"] => true]);
        $this->mockEnvironment->expects($this->atLeastOnce())->method($GLOBALS["__bac1b45e9bbe89910e93f71" . "85a8d91c9"]["_3e601b2b84d3af9292fd72597f243e" . "05"])->with($this->anything(), $this->callback(function ($_7aeb15d7405498283791b0bf841c940c) {
            return isset($_7aeb15d7405498283791b0bf841c940c[$GLOBALS["__bac1b45e9bbe89910e93f" . "7185a8d91c9"]["_354b3b0" . "7bdaa4e7" . "02886b2f" . "df9dd11c" . "e"]]) && $_7aeb15d7405498283791b0bf841c940c[$GLOBALS["__bac1b45e9bbe89910e9" . "3f7185a8d91c9"]["_354b3b07bd" . "aa4e702886b" . "2fdf9dd11ce"]] === false;
        }));
        $this->applicationIcon->Show([$GLOBALS["__bac1b45e9" . "bbe89910e93" . "f7185a8d91c" . "9"]["_57868356275757d92fd" . "8e7fe2fd74b64"] => $GLOBALS["__bac1b45e9bbe89910e" . "93f7185a8d91c9"]["_77ca388c9c77" . "2f10df143747e" . "308c256"], $GLOBALS["__bac1b45e9bbe89910e93f7185a8d91c" . "9"]["_354b3b07bdaa4e702886" . "b2fdf9dd11ce"] => false], $this->mockApplication);
    }
    
    
    
    
    
    
    
    public function test_Show_titleFalse() : void
    {
        
        
        $_7d7b332b4537da0a168dd6aa3cf82d95 = $this->createMock(MenuItemApplication::class);
        $this->mockApplicationsListItems->method($GLOBALS["__bac1b45e9bbe89910e93f7185a8d9" . "1c9"]["_fc96cbe018f580224b" . "2bd19f6ca5b1af"])->willReturn($_7d7b332b4537da0a168dd6aa3cf82d95);
        $this->mockMenuItemFormatter->method($GLOBALS["__bac1b45e9bbe" . "89910e93f7185a" . "8d91c9"]["_4f70609f87a80124bc5f3f61cfcee06" . "2"])->willReturn([$GLOBALS["__bac1b45e9bbe89910" . "e93f7185a8d91c9"]["tit" . "le"] => $GLOBALS["__bac1b45e9bbe89910e93f7185a8d91c" . "9"]["_723f68768b8" . "26e92cd5c5d8" . "de9837ac2"], $GLOBALS["__bac1b45e9bb" . "e89910e93f718" . "5a8d91c9"]["ur" . "l"] => $GLOBALS["__bac1b45e9bbe89910e9" . "3f7185a8d91c9"]["_0c7e7fb6a04a" . "1f3e689de5eea" . "4ee0c86"]]);
        $this->mockEnvironment->expects($this->atLeastOnce())->method($GLOBALS["__bac1b45e9bbe89910e93f7185a8d" . "91c9"]["_3e601b2b84d3af9292fd72597" . "f243e05"])->with($this->anything(), $this->callback(function ($_7aeb15d7405498283791b0bf841c940c) {
            return isset($_7aeb15d7405498283791b0bf841c940c[$GLOBALS["__bac1b45e9bbe89910e" . "93f7185a8d91c9"]["titl" . "e"]]) && $_7aeb15d7405498283791b0bf841c940c[$GLOBALS["__bac1b45e9bbe89910e93f7185a" . "8d91c9"]["t" . "i" . "t" . "l" . "e"]] === false;
        }));
        $this->applicationIcon->Show([$GLOBALS["__bac1b45e9bbe89910e93f718" . "5a8d91c9"]["_57868356275757d92fd8e7fe2" . "fd74b64"] => $GLOBALS["__bac1b45e9bbe89910e9" . "3f7185a8d91c9"]["_77ca388c" . "9c772f10d" . "f143747e3" . "08c256"], $GLOBALS["__bac1b45e9" . "bbe89910e93" . "f7185a8d91c" . "9"]["tit" . "le"] => false], $this->mockApplication);
    }
}