<?php
namespace Claromentis\Menu\Tests\Unit;

$GLOBALS["__5521440f0e83293a14992" . "7542ce54e6f"] = (@$GLOBALS["__5521440f0" . "e83293a1499" . "27542ce54e6" . "f"] ?: array()) + array("_69d3a14b2db7b" . "4a80d1af049403" . "ebc03" => base64_decode("Z2V0TWF4" . "T3JkZXI="), "_070913b441" . "26cc7a4d6b1" . "bfc06fc2526" => base64_decode("Z2V0Vmlld2Fib" . "GVJZHM="), "_5feede65e7cfe8f0b3d9854c0363d" . "548" => base64_decode("YQ=" . "="), "_58f13aa" . "391f72fb" . "a204fb88" . "78becd50" . "7" => base64_decode("Z2V0SWQ" . "="), "_8b742f9de3e606a5" . "e98c53dfe64336dc" => base64_decode("Y3JlYXRlRGl2a" . "WRlcg=="), "sav" . "e" => base64_decode("c2F2" . "ZQ=="), "_a313073bba42f3" . "bc3bdd3d5c87cdb" . "8be" => base64_decode("R2" . "V0"), "_74e6c647b312810242fc36" . "0c4ae14d72" => base64_decode("Y" . "g" . "=" . "="), "_77ca388c9c772f1" . "0df143747e308c25" . "6" => base64_decode("YmVl" . "cw=="), "_e205d0c99dc5df44286a" . "616830e1fd0e" => base64_decode("Z2" . "V0"));
use Claromentis\Core\Acl\Acl;
use Claromentis\Core\Acl\AclRepository;
use Claromentis\Core\Acl\PermOClass;
use Claromentis\Core\Security\SecurityContext;
use Claromentis\Menu\Exception\MenuItemForbiddenException;
use Claromentis\Menu\Exception\MenuItemNotFoundException;
use Claromentis\Menu\Exception\MenuItemValidationException;
use Claromentis\Menu\Infobar\ApplicationsListItems;
use Claromentis\Menu\Infobar\MenuItemDivider;
use Claromentis\Menu\Infobar\MenuItemFactory;
use Claromentis\Menu\Infobar\MenuItemRepository;
use PHPUnit\Framework\MockObject\MockObject;
use PHPUnit\Framework\TestCase;
use Psr\Log\LoggerInterface;
class ApplicationsListItemsTest extends TestCase
{
    private ApplicationsListItems $applicationsListItems;
    
    
    private MockObject $mockAclRepository;
    
    
    private MockObject $mockMenuItemRepository;
    
    
    private MockObject $mockMenuItemFactory;
    protected function setUp()
    {
        $this->mockMenuItemRepository = $this->createMock(MenuItemRepository::class);
        $this->mockMenuItemFactory = $this->createMock(MenuItemFactory::class);
        $this->mockAclRepository = $this->createMock(AclRepository::class);
        $this->applicationsListItems = new ApplicationsListItems($this->mockMenuItemRepository, $this->mockMenuItemFactory, $this->mockAclRepository, $this->createMock(LoggerInterface::class));
    }
    
    
    
    
    
    
    
    
    public function test_saveNewDivider_menuType() : void
    {
        $_14c10b40fe0e2987f65e1df49353b99e = 2;
        $_e2daa121c94479473021c686e5e64c87 = $this->createMock(MenuItemDivider::class);
        $_e2daa121c94479473021c686e5e64c87->method($GLOBALS["__5521440f0e83293a149927542ce54e" . "6f"]["_58f13aa391f7" . "2fba204fb8878" . "becd507"])->willReturn(5);
        
        
        $_1160c1a7e6e357504146e68eb9f11b65 = $this->createMock(Acl::class);
        $this->mockAclRepository->method($GLOBALS["__5521440f0e83293a14992754" . "2ce54e6f"]["_a313073bba42f3bc3bdd3d5c87c" . "db8be"])->willReturn($_1160c1a7e6e357504146e68eb9f11b65);
        $this->mockMenuItemFactory->expects($this->once())->method($GLOBALS["__5521440f0e83293a149927542ce54e" . "6f"]["_8b742f9de3e606a5e98" . "c53dfe64336dc"])->with($_14c10b40fe0e2987f65e1df49353b99e)->willReturn($_e2daa121c94479473021c686e5e64c87);
        $this->applicationsListItems->saveNewDivider($_14c10b40fe0e2987f65e1df49353b99e);
    }
    
    
    
    
    
    public function test_saveNewDivider_new() : void
    {
        $_e2daa121c94479473021c686e5e64c87 = $this->createMock(MenuItemDivider::class);
        $_e2daa121c94479473021c686e5e64c87->method($GLOBALS["__5521440f0e83293a1" . "49927542ce54e6f"]["_58f13aa391f72fba204fb8878becd50" . "7"])->willReturnOnConsecutiveCalls(5);
        $this->mockMenuItemFactory->method($GLOBALS["__5521440f0e83293a1499275" . "42ce54e6f"]["_8b742f9de3e606a" . "5e98c53dfe64336d" . "c"])->willReturn($_e2daa121c94479473021c686e5e64c87);
        
        
        $_1160c1a7e6e357504146e68eb9f11b65 = $this->createMock(Acl::class);
        $this->mockAclRepository->method($GLOBALS["__5521440" . "f0e83293a" . "149927542" . "ce54e6f"]["_a313073bba42f3bc" . "3bdd3d5c87cdb8be"])->willReturn($_1160c1a7e6e357504146e68eb9f11b65);
        $this->mockMenuItemRepository->expects($this->once())->method($GLOBALS["__5521440f0e83293a14" . "9927542ce54e6f"]["sa" . "ve"]);
        $this->applicationsListItems->saveNewDivider(1);
    }
    
    
    
    
    
    
    
    public function test_saveNewDivider_lastDisplayOrder() : void
    {
        $_b10738fc3d0ad3749dcc6ba41d7d616d = 67;
        $_e2daa121c94479473021c686e5e64c87 = $this->createMock(MenuItemDivider::class);
        $_e2daa121c94479473021c686e5e64c87->method($GLOBALS["__5521440f0e83293a149927542ce54" . "e6f"]["_58f13aa391f72fba" . "204fb8878becd507"])->willReturn(5);
        
        
        $_1160c1a7e6e357504146e68eb9f11b65 = $this->createMock(Acl::class);
        $this->mockAclRepository->method($GLOBALS["__5521440f0e83293a14992754" . "2ce54e6f"]["_a313073bba4" . "2f3bc3bdd3d5" . "c87cdb8be"])->willReturn($_1160c1a7e6e357504146e68eb9f11b65);
        $this->mockMenuItemRepository->method($GLOBALS["__5521440f0" . "e83293a1499" . "27542ce54e6" . "f"]["_69d3a14b2db7b4a" . "80d1af049403ebc0" . "3"])->willReturn($_b10738fc3d0ad3749dcc6ba41d7d616d);
        $this->mockMenuItemFactory->expects($this->once())->method($GLOBALS["__5521440f0e83293a149927542ce54e" . "6f"]["_8b742f9de3e606a5e98c" . "53dfe64336dc"])->with($this->anything(), $this->anything(), $_b10738fc3d0ad3749dcc6ba41d7d616d)->willReturn($_e2daa121c94479473021c686e5e64c87);
        $this->applicationsListItems->saveNewDivider(2);
    }
    
    
    
    
    
    
    
    
    public function test_getApplication_appNotFound() : void
    {
        $this->mockMenuItemRepository->method($GLOBALS["__5521440f0e83293a1499275" . "42ce54e6f"]["_e205d0c99dc5df" . "44286a616830e1f" . "d0e"])->willReturn([]);
        $this->expectException(MenuItemNotFoundException::class);
        $this->applicationsListItems->getApplication($GLOBALS["__5521440f0e83" . "293a149927542c" . "e54e6f"]["_77ca388c9c772f10df143747e30" . "8c256"]);
    }
    
    
    
    
    
    
    
    public function test_getApplication_multipleAppsFound() : void
    {
        $this->mockMenuItemRepository->method($GLOBALS["__5521440f0e" . "83293a149927" . "542ce54e6f"]["_e205d0c99dc5df44286a61" . "6830e1fd0e"])->willReturn([$GLOBALS["__5521440f0e83293a149927542c" . "e54e6f"]["_5feede6" . "5e7cfe8f" . "0b3d9854" . "c0363d54" . "8"], $GLOBALS["__5521440f0" . "e83293a1499" . "27542ce54e6" . "f"]["_74e6c647b312810242fc360c4a" . "e14d72"]]);
        $this->expectException(MenuItemValidationException::class);
        $this->applicationsListItems->getApplication($GLOBALS["__5521440f0e83293a14" . "9927542ce54e6f"]["_77ca388c9c" . "772f10df143" . "747e308c256"]);
    }
    
    
    
    
    
    
    
    
    public function test_getApplication_noPermission() : void
    {
        
        
        $_e84af44769527f1a47a69dfa05dc31d6 = $this->createMock(SecurityContext::class);
        $this->mockMenuItemRepository->method($GLOBALS["__5521440f0e83293a14992" . "7542ce54e6f"]["_e205d0c9" . "9dc5df442" . "86a616830" . "e1fd0e"])->willReturn([657 => $GLOBALS["__5521440f0" . "e83293a1499" . "27542ce54e6" . "f"]["_5feede65e7cfe8f0b3d985" . "4c0363d548"]]);
        $this->mockMenuItemRepository->method($GLOBALS["__5521440f0e" . "83293a149927" . "542ce54e6f"]["_070913b44126cc7a4" . "d6b1bfc06fc2526"])->willReturn([]);
        $this->expectException(MenuItemForbiddenException::class);
        $this->applicationsListItems->getApplication($GLOBALS["__5521440f0e83293a" . "149927542ce54e6f"]["_77ca388" . "c9c772f1" . "0df14374" . "7e308c25" . "6"], $_e84af44769527f1a47a69dfa05dc31d6);
    }
}