<?php
namespace Claromentis\People\Validator;

$GLOBALS["__2240774f4308efd" . "6aef57f6fcf3a97a0"] = (@$GLOBALS["__2240774f4308efd6aef5" . "7f6fcf3a97a0"] ?: array()) + array("_921fbf4c866dff55f6a4c" . "ab0c7be03ff" => base64_decode("bmV3X2" . "V4dHJh" . "bmV0X2" . "lk"), "_f73dab606630b388645c4f7d3fb" . "b13bb" => base64_decode("YXJyYXlf" . "bWVyZ2U="), "_56e057e" . "6e60ee28" . "15b7034e" . "74787474" . "d" => base64_decode("VGhlIFByaW1hcnkgRXh0cmFuZXQgY2Fubm90IGJlIGRlbGV0ZWQ" . "="), "_bd71c3b5c" . "201fc11db8" . "2ed14ce424" . "de5" => base64_decode("aW5fYXJ" . "yYXk="), "_166b84790b560d7028821b9" . "f81140da7" => base64_decode("cmVh" . "ZF9v" . "bmx5"), "_742c76e4cec" . "99feecec4223" . "ee30c1cff" => base64_decode("YXJyYX" . "lfaW50" . "ZXJzZW" . "N0"), "_3485471e3a36e" . "65fb5fc93a4bd9" . "9c347" => base64_decode("cHJpbW" . "FyeQ=="), "na" . "me" => base64_decode("bmFtZ" . "Q=="), "_d706c160e45" . "bf7434fff82a" . "5976f0e19" => base64_decode("YXJyYX" . "lfa2V5" . "cw=="), "_b66252d7bbf" . "361012a6531a" . "8e3a73230" => base64_decode("YXJyYXlfZGlm" . "Zg=="), "_28a01c8e8c6cb665" . "cc83d03df4a6977b" => base64_decode("YWRtaW" . "5faWQ="), "_5e30c4717ced36cff9e93e19a5" . "c576cc" => base64_decode("aXNfc3" . "RyaW5n"), "_4d707fab93bebb00b" . "be69e8159697c90" => base64_decode(""), "_c06c961f3" . "93742ecfd5" . "2b72263ac9" . "470" => base64_decode("aW50dmF" . "s"));
use Claromentis\Core\Localization\Lmsg;
use Claromentis\People\Entity\Extranet;
use Claromentis\People\Exception\NotFoundException;
use Claromentis\People\Exception\ValidationException;
use Claromentis\People\Repository\ExtranetRepository;
use Claromentis\People\Repository\UserRepository;
class ExtranetValidator
{
    const E_MISSING_PROP = 'people.error.extranet_prop_missing';
    const E_INVALID_PROP = 'people.error.extranet_prop_invalid';
    const E_FORBIDDEN_PROP = 'people.error.extranet_prop_forbidden';
    const E_NO_USER = 'people.error.no_user_with_id';
    const E_NAME_NOT_STRING = 'people.error.name_not_string';
    const E_PROP_NOT_INT = 'people.error.prop_not_int';
    const E_PROP_NOT_BOOL = 'people.error.prop_not_bool';
    const E_MOVETO_NOT_EXIST = 'people.error.move_to_not_exist';
    const E_NO_MOVE_TO_SELF = 'people.error.cannot_move_to_self';
    const E_USER_LIST_EMPTY = 'people.error.cannot_move_to_self';
    const E_ID_NOT_INT = 'people.error.ex_id_not_int';
    const E_EX_NOT_FOUND = 'people.error.ex_id_not_found';
    const E_INVALID = 'people.error.extranet_invalid';
    const REQUIRED_PROPS = ['name'];
    const OPTIONAL_PROPS = ['description' => '', 'primary' => false, 'admin_id' => 1, 'read_only' => false];
    const FORBIDDEN_PROPS = ['logo_file' => '', 'default_skin' => 0];
    
    
    
    
    protected $lmsg;
    
    
    
    
    private $repo;
    
    
    
    
    private $user_repo;
    
    
    
    
    
    
    private $errors;
    public function __construct(ExtranetRepository $_8652ba33e6ffeba02459fa9cbb320851, UserRepository $_eeeeb0d673b7b0fd0bdca58b5541c3e0, Lmsg $lmsg)
    {
        $this->repo = $_8652ba33e6ffeba02459fa9cbb320851;
        $this->user_repo = $_eeeeb0d673b7b0fd0bdca58b5541c3e0;
        $this->lmsg = $lmsg;
    }
    
    
    
    
    
    
    
    
    
    
    
    public function Validate($extranet_id, array $_809a58dc73011173c031a53c0b40ef0e) : array
    {
        $this->errors = [];
        if ($extranet_id) {
            $this->JustValidateId($extranet_id);
        } else {
            $this->ValidateRequired($_809a58dc73011173c031a53c0b40ef0e);
        }
        $this->ValidateGiven($_809a58dc73011173c031a53c0b40ef0e);
        $this->CheckErrors();
        $_809a58dc73011173c031a53c0b40ef0e = $this->FillDefaults($_809a58dc73011173c031a53c0b40ef0e);
        return $_809a58dc73011173c031a53c0b40ef0e;
    }
    protected function ValidateRequired(array $_809a58dc73011173c031a53c0b40ef0e)
    {
        $_565d7be99acb0b7627e48da068eebbd6 = self::REQUIRED_PROPS;
        $_57bfe1aba9b3b4c0d83917252d966e54 = $GLOBALS["__2240774f43" . "08efd6aef57f" . "6fcf3a97a0"]["_b66252d7bbf361012a6531a8e3a73" . "230"]($_565d7be99acb0b7627e48da068eebbd6, $GLOBALS["__2240774f4308efd6aef57f6fcf3a97" . "a0"]["_d706c160e45bf7434f" . "ff82a5976f0e19"]($_809a58dc73011173c031a53c0b40ef0e));
        foreach ($_57bfe1aba9b3b4c0d83917252d966e54 as $_1db43cd03f8bd98e220af46d31486c0a) {
            $this->errors[] = ($this->lmsg)(self::E_MISSING_PROP, $_1db43cd03f8bd98e220af46d31486c0a);
        }
    }
    protected function ValidateGiven(array $_809a58dc73011173c031a53c0b40ef0e)
    {
        $_1ac0335a1f605e216d9ffde5545a81e3 = $GLOBALS["__2240774f" . "4308efd6ae" . "f57f6fcf3a" . "97a0"]["_f73dab606630b388645c4f7d" . "3fbb13bb"](self::REQUIRED_PROPS, $GLOBALS["__2240774f4308efd6aef57f6fcf" . "3a97a0"]["_d706c160e45bf74" . "34fff82a5976f0e1" . "9"](self::OPTIONAL_PROPS));
        $_aec8d9f47694b74c797ec564d725be1b = $GLOBALS["__2240774f4308efd6aef" . "57f6fcf3a97a0"]["_742c76e4cec99feecec4" . "223ee30c1cff"]($GLOBALS["__2240774f4308e" . "fd6aef57f6fcf3a" . "97a0"]["_d706c160e45bf74" . "34fff82a5976f0e1" . "9"]($_809a58dc73011173c031a53c0b40ef0e), $GLOBALS["__2240774f4" . "308efd6aef5" . "7f6fcf3a97a" . "0"]["_d706c160e45bf7434fff82a5976f0e1" . "9"](self::FORBIDDEN_PROPS));
        $_8ff8e4bd4ac206f84359062c2ca26a03 = $GLOBALS["__2240774f4308efd6aef57f6fcf3a97" . "a0"]["_b66252d7bbf361012a6531a8e3" . "a73230"]($GLOBALS["__2240774f4308efd6aef57f6" . "fcf3a97a0"]["_d706c160e45bf743" . "4fff82a5976f0e19"]($_809a58dc73011173c031a53c0b40ef0e), $_1ac0335a1f605e216d9ffde5545a81e3);
        foreach ($_aec8d9f47694b74c797ec564d725be1b as $_61236c74c787fc6549ed2a436363da5a) {
            $this->errors[] = ($this->lmsg)(self::E_FORBIDDEN_PROP, $_61236c74c787fc6549ed2a436363da5a);
        }
        foreach ($_8ff8e4bd4ac206f84359062c2ca26a03 as $_53f447bfb52e103171ac7a1e2459fb83) {
            $this->errors[] = ($this->lmsg)(self::E_INVALID_PROP, $_53f447bfb52e103171ac7a1e2459fb83);
        }
        
        
        
        
        if (isset($_809a58dc73011173c031a53c0b40ef0e[$GLOBALS["__2240774f4308" . "efd6aef57f6fcf" . "3a97a0"]["nam" . "e"]]) && (!$GLOBALS["__2240774f4308ef" . "d6aef57f6fcf3a97" . "a0"]["_5e30c4717ced36c" . "ff9e93e19a5c576c" . "c"]($_809a58dc73011173c031a53c0b40ef0e[$GLOBALS["__2240774f4308efd6aef57f6fcf3" . "a97a0"]["nam" . "e"]]) || $_809a58dc73011173c031a53c0b40ef0e[$GLOBALS["__2240774f4308" . "efd6aef57f6fcf" . "3a97a0"]["nam" . "e"]] == $GLOBALS["__2240774" . "f4308efd6" . "aef57f6fc" . "f3a97a0"]["_4d707fa" . "b93bebb0" . "0bbe69e8" . "159697c9" . "0"])) {
            $this->errors[] = ($this->lmsg)(self::E_NAME_NOT_STRING);
        }
        if (isset($_809a58dc73011173c031a53c0b40ef0e[$GLOBALS["__2240774f4308efd6aef57f6fcf" . "3a97a0"]["_28a01c8e8c6cb665cc83d03df4" . "a6977b"]]) && !$_809a58dc73011173c031a53c0b40ef0e[$GLOBALS["__2240774f4308efd6a" . "ef57f6fcf3a97a0"]["_28a01c8" . "e8c6cb66" . "5cc83d03" . "df4a6977" . "b"]] == $GLOBALS["__2240774f" . "4308efd6ae" . "f57f6fcf3a" . "97a0"]["_c06c961f393742ecfd52b722" . "63ac9470"]($_809a58dc73011173c031a53c0b40ef0e[$GLOBALS["__2240774f43" . "08efd6aef57f" . "6fcf3a97a0"]["_28a01c8e8c6" . "cb665cc83d03" . "df4a6977b"]])) {
            $this->errors[] = ($this->lmsg)(self::E_PROP_NOT_INT, $GLOBALS["__2240774f4308efd6aef57f6fcf3a97" . "a0"]["_28a01c8e8c6cb66" . "5cc83d03df4a6977" . "b"]);
        }
        if (isset($_809a58dc73011173c031a53c0b40ef0e[$GLOBALS["__2240774f4308ef" . "d6aef57f6fcf3a97" . "a0"]["_3485471e3a36" . "e65fb5fc93a4b" . "d99c347"]]) && !$GLOBALS["__2240774f4308efd" . "6aef57f6fcf3a97a0"]["_bd71c3b5c201fc11db82ed14" . "ce424de5"]($_809a58dc73011173c031a53c0b40ef0e[$GLOBALS["__2240774f4308efd6aef57f6f" . "cf3a97a0"]["_3485471e3a36e65" . "fb5fc93a4bd99c34" . "7"]], [true, 1, false, 0], true)) {
            $this->errors[] = ($this->lmsg)(self::E_PROP_NOT_BOOL, $GLOBALS["__2240774f4308efd6aef57f6fcf3a97a" . "0"]["_3485471e3a" . "36e65fb5fc9" . "3a4bd99c347"]);
        }
        if (isset($_809a58dc73011173c031a53c0b40ef0e[$GLOBALS["__2240774f4308efd6aef57f6fcf" . "3a97a0"]["_166b84790b560d702" . "8821b9f81140da7"]]) && !$GLOBALS["__2240774f4308efd6aef57f6fcf" . "3a97a0"]["_bd71c3b" . "5c201fc1" . "1db82ed1" . "4ce424de" . "5"]($_809a58dc73011173c031a53c0b40ef0e[$GLOBALS["__2240774f4308efd6aef57f6" . "fcf3a97a0"]["_166b84790b560d7028821b9f8" . "1140da7"]], [true, false, 1, 0], true)) {
            $this->errors[] = ($this->lmsg)(self::E_PROP_NOT_BOOL, $GLOBALS["__2240774f4308efd6" . "aef57f6fcf3a97a0"]["_166b847" . "90b560d7" . "028821b9" . "f81140da" . "7"]);
        }
    }
    protected function FillDefaults(array $_809a58dc73011173c031a53c0b40ef0e) : array
    {
        $_c9a6a047112f57e62ae32e746b3293c7 = $GLOBALS["__2240774f4308efd6aef57f6fcf3a97a" . "0"]["_f73dab606630b388645c4" . "f7d3fbb13bb"](self::OPTIONAL_PROPS, self::FORBIDDEN_PROPS);
        
        
        foreach ($_c9a6a047112f57e62ae32e746b3293c7 as $_c241f11ec2591cc626823468234ffaf4 => $default) {
            if (!isset($_809a58dc73011173c031a53c0b40ef0e[$_c241f11ec2591cc626823468234ffaf4])) {
                $_809a58dc73011173c031a53c0b40ef0e[$_c241f11ec2591cc626823468234ffaf4] = $default;
            }
        }
        return $_809a58dc73011173c031a53c0b40ef0e;
    }
    
    
    
    
    
    
    
    
    
    
    
    public function ValidateDelete($extranet_id, $_921fbf4c866dff55f6a4cab0c7be03ff)
    {
        $this->errors = [];
        $this->JustValidateId($extranet_id);
        $_9a2ef4ae6a5745ffe5fac33c88a222fa = $this->repo->find($extranet_id);
        if ($_9a2ef4ae6a5745ffe5fac33c88a222fa->isPrimary()) {
            $this->errors[] = $GLOBALS["__2240774f4308efd6aef57f" . "6fcf3a97a0"]["_56e057e6e60ee2815b7034e7478" . "7474d"];
        }
        if (isset($_921fbf4c866dff55f6a4cab0c7be03ff)) {
            if (!$GLOBALS["__2240774f4308efd" . "6aef57f6fcf3a97a0"]["_c06c961f393742ecfd" . "52b72263ac9470"]($_921fbf4c866dff55f6a4cab0c7be03ff)) {
                $this->errors[] = ($this->lmsg)(self::E_PROP_NOT_INT, $GLOBALS["__2240774f4308efd6aef57f" . "6fcf3a97a0"]["_921fbf4c866dff55f6a4cab0" . "c7be03ff"]);
            } elseif ((int) $_921fbf4c866dff55f6a4cab0c7be03ff === (int) $extranet_id) {
                $this->errors[] = ($this->lmsg)(self::E_NO_MOVE_TO_SELF);
            } else {
                try {
                    $this->JustValidateId($_921fbf4c866dff55f6a4cab0c7be03ff, $GLOBALS["__2240774" . "f4308efd6" . "aef57f6fc" . "f3a97a0"]["_921fbf4c866dff5" . "5f6a4cab0c7be03f" . "f"]);
                } catch (NotFoundException $e) {
                    $this->errors[] = ($this->lmsg)(self::E_MOVETO_NOT_EXIST, $_921fbf4c866dff55f6a4cab0c7be03ff);
                }
            }
        }
        $this->CheckErrors();
    }
    
    
    
    
    
    
    
    
    
    public function ValidateUserList(int $extranet_id, array $user_ids)
    {
        $this->errors = [];
        $this->JustValidateId($extranet_id);
        if (empty($user_ids)) {
            $this->errors[] = ($this->lmsg)(self::E_USER_LIST_EMPTY);
        }
        $_dd93aa31e86867f12566cbfdd849844b = $this->user_repo->checkIds($user_ids);
        $_962607d828e087086dfede27d603d110 = $GLOBALS["__2240774f4308efd6" . "aef57f6fcf3a97a0"]["_b66252d7bbf361012a6531a8e3a" . "73230"]($user_ids, $_dd93aa31e86867f12566cbfdd849844b);
        foreach ($_962607d828e087086dfede27d603d110 as $_3a5a220e178795c7744dcb9ba61a1bd2) {
            $this->errors[] = ($this->lmsg)(self::E_NO_USER, $_3a5a220e178795c7744dcb9ba61a1bd2);
        }
        $this->CheckErrors();
    }
    
    
    
    
    
    
    
    
    
    
    
    public function ValidateId($extranet_id, string $_d4e80b2d16a3e2ee29002ce34922fd11 = 'extranet id')
    {
        $this->errors = [];
        $this->JustValidateId($extranet_id, $_d4e80b2d16a3e2ee29002ce34922fd11);
        $this->CheckErrors();
    }
    
    
    
    
    
    
    protected function JustValidateId($extranet_id, string $_d4e80b2d16a3e2ee29002ce34922fd11 = 'extranet id')
    {
        if (!$GLOBALS["__2240774f4308efd6aef57f6fc" . "f3a97a0"]["_c06c961f393742ecf" . "d52b72263ac9470"]($extranet_id)) {
            $this->errors[] = ($this->lmsg)(self::E_ID_NOT_INT, $_d4e80b2d16a3e2ee29002ce34922fd11);
        } elseif (!$this->repo->entityExists((int) $extranet_id)) {
            throw new NotFoundException(($this->lmsg)(self::E_EX_NOT_FOUND, $_d4e80b2d16a3e2ee29002ce34922fd11));
        }
    }
    
    
    
    
    protected function CheckErrors()
    {
        if (!empty($this->errors)) {
            $e = new ValidationException(($this->lmsg)(self::E_INVALID));
            $e->validation_errors = $this->errors;
            throw $e;
        }
    }
}