<?php
$_db_migration_to = '26.02';
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_create_config_dir.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */

$data_dir = $migrations->GetDataDir();
$config_path = $data_dir.'/config';
if (!is_dir($config_path))
{
	mkdir($config_path, 0777);
	chmod($config_path, 0777);
}

DB_UPDATE_FILE
);


$migrations->Run('02_move_documents_config.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */

$config = $migrations->GetConfigFull('core');

$cfg_docs_allow_renew = DBVar::Get('cfg_docs_allow_renew', false);
if ($cfg_docs_allow_renew)
	$config->Set('cfg_docs_allow_renew', true);

$cfg_docs_allow_renew = DBVar::Get('cfg_docs_auto_monitoring', false);
if ($cfg_docs_allow_renew)
	$config->Set('cfg_docs_auto_monitoring', true);

$config->Save();

DB_UPDATE_FILE
);


$migrations->Run('03_select_metadata_type.php', <<<'DB_UPDATE_FILE'
<?php
/** @var \Claromentis\Setup\SetupFacade $migrations */
$db = $migrations->GetDb();

$db->query("UPDATE ERMS_metadata_field SET meta_type=int:multiselect
	 WHERE meta_type=int:select AND meta_html_type IN (int:hmselect, int:hmcheckbox)",
           14 /*META_TYPE_MULTISELECT*/, 4 /*META_TYPE_SELECT*/,
           4 /*HTML_COMPONENT_MULT_SELECT*/, 11 /*HTML_COMPONENT_CHECKBOXES*/);

DB_UPDATE_FILE
);


$migrations->Run('05_convert_ic_project_icons.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$ic_project_icon_convert = function ($css_class)
{
	$icons_conversion = array(
	);

	if (isset($icons_conversion[$css_class]))
		$css_class = $icons_conversion[$css_class];
	elseif (substr($css_class, 0, 5) == 'icon-')
		$css_class = 'glyphicons-'.str_replace('_', '-', substr($css_class, 5));

	return $css_class;
};

$res = $db->query("SELECT id, project_icon FROM hd_project WHERE project_icon LIKE like:icon%", 'icon-');
while ($arr = $res->fetchArray())
{
	$new_icon = $ic_project_icon_convert($arr['project_icon']);
	$db->query("UPDATE hd_project SET project_icon=str:new_icon WHERE id=int:id", $new_icon, $arr['id']);
}

DB_UPDATE_FILE
);


$migrations->Run('07_IC_private_files.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

$db->AddColumn('hd_issue_file', 'is_private', 'BOOL NOT_NULL DEFAULT 0');
$db->AddColumn('hd_issue_file', 'note_id', 'INT');

$files = $db->query('SELECT id, filename, date1 FROM hd_issue_file WHERE note_id IS NULL');
while ($file = $files->fetchArray())
{
	$notes = $db->query('SELECT i_n.id, i_n.issue_id, i_n.private_note FROM hd_issue_note i_n JOIN hd_issue i ON i.id = i_n.issue_id WHERE i_n.date1 = int:date AND (i_n.note LIKE %like:filename% OR i_n.note LIKE %like:filename%)', $file['date1'], '"' . $file['filename'] . '"]', '"]' . $file['filename'] . '[/url]');

	$rows = $notes->numRows();
	if ($rows > 0)
	{
		// Set the file to the first message that matches. Usually only one match will be found.
		$note = $notes->fetchArray();
		$db->query('UPDATE hd_issue_file SET note_id = int:note_id, is_private = int:is_private WHERE id = int:id AND issue_id = int:issue_id', $note['id'], $note['private_note'], $file['id'], $note['issue_id']);
	}
}
DB_UPDATE_FILE
);


$migrations->Run('08_simple_acl_admin.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

// simple_acl
$table_descr = array(
	'object_code' => "VARCHAR(255)",
	'user_id'     => "INT NOT_NULL DEFAULT 0",
	'rights'      => "INT NOT_NULL DEFAULT 1",
);

$db->CreateTable('simple_acl', $table_descr, true);
$db->CreateIndex('simple_acl', 'simple_acl_object_code', 'object_code');
$db->CreateIndex('simple_acl', 'simple_acl_user_object', 'user_id', 'object_code');

// delete any dead records
$db->query("DELETE FROM administrators WHERE panelid NOT IN (SELECT id FROM panels)");

// migrate data
$db->query("INSERT INTO simple_acl (object_code, user_id) SELECT p.symname, a.userid FROM panels p, administrators a WHERE a.panelid=p.id");


$panels = [
	'system',
	'docs',
	'people',
	'forum',
	'comms',
	'blog',
	'publish',
	'audit',
	'rb',
	'workflow',
	'holidays',
	'company_links',
	'backup',
	'helpdesk',
	'webmail',
	'surveys',
	'image_gallery',
	'metadata',
	'compliances',
	'calendar',
	'extranet',
	'tags',
	'stat',
	'search',
	'oauth2',
	'menu',
	'design',
];

$db->query("DELETE FROM panels WHERE symname IN in:str:panels", $panels);

$db->DropTable('administrators');

DB_UPDATE_FILE
);


$migrations->Run('09_calendar_export.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

// alter export link table
$db->AddColumn('cln_export_links', 'start_date', "INT_DATE NULL");
$db->AddColumn('cln_export_links', 'end_date', "INT_DATE NULL");

// alter data in table
$db->query("UPDATE cln_export_links SET start_date=0 WHERE start_date IS NULL");
$db->query("UPDATE cln_export_links SET end_date=99999999999999 WHERE end_date IS NULL");
DB_UPDATE_FILE
);


$migrations->Run('10_calendar_export_alter.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations Claromentis\Setup\SetupFacade */
$db = $migrations->GetDb();

// alter data in table
$db->query("UPDATE cln_export_links SET start_date=3, end_date=4");

// alter export link table
$db->AlterColumn('cln_export_links', 'start_date', 'start_date_period', "INT NULL");
$db->AlterColumn('cln_export_links', 'end_date', 'end_date_period', "INT NULL");

DB_UPDATE_FILE
);


$migrations->Run('11_design_admin_enable.php', <<<'DB_UPDATE_FILE'
<?php
/** @var $migrations Claromentis\Setup\SetupFacade */
$admin_panel = $migrations->GetAdminPanelCreator();
$admin_panel->Enable('design');

DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('26.02');
