<?php
namespace Claromentis\Core\Filesystem;

$GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"] = (@$GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"] ?: array()) + array("_1cc5aa2f679b575f82786a73" . "f0da28f8" => base64_decode("c3RyZ" . "WFt"), "_87daa84e346f6420a" . "3f3426e05d16a7b" => base64_decode("Lw" . "=="), "_5febae03aa5407c291b" . "5c61a872cc1fd" => base64_decode("aXNfcmVzb" . "3VyY2U="), "_e46a1b6a2fd927d616377ae17620" . "d766" => base64_decode("dmlzaWJpbGl0eQ=" . "="), "_8aa39710a39f226efce78e97c7bc" . "d786" => base64_decode("XC8" . "="), "_f2646618c9dcad156a41241eacc4" . "c3f7" => base64_decode("Z2V0X3Jlc291c" . "mNlX3R5cGU="), "pat" . "h" => base64_decode("cG" . "F0" . "aA" . "=="), "_a67b2f1e" . "ec9b2bac9" . "0112c5d67" . "23ab41" => base64_decode("JHN0cmVhbSBtdXN" . "0IGJlIGEgcmVzb3" . "VyY2U="), "_e134836f6369409efa4f2cad2" . "61365c8" => base64_decode("RXJyb3IgdXBkYXRpbmcg" . "ZmlsZSBmcm9tIHN0cmVh" . "bQ=="), "_32b8fa1ca330a0685321a379" . "e5b9687d" => base64_decode("YmFzZW5" . "hbWU="), "_6ae3783b9ad544a6c31a9" . "79683fed870" => base64_decode("Zm" . "ls" . "ZQ" . "=="), "_6108a04b8350bfd2b7f2b2365703ea" . "ec" => base64_decode("Zm9w" . "ZW4="), "_179055b98e140c4d418" . "bcd5a903c7b7c" => base64_decode("RXJyb3I" . "gdXBkYX" . "RpbmcgZ" . "mlsZQ=="), "_9463ea5f1a4c73607f2c69" . "eeee2b6ede" => base64_decode("RXJyb3IgZGVsZXRpbmcg" . "ZmlsZQ=="), "_01713acbc1c314" . "b61bfbd8dc10a81" . "0bd" => base64_decode("RXJyb3Igd" . "3JpdGluZy" . "BmaWxl"), "s" . "i" . "z" . "e" => base64_decode("c2l" . "6ZQ" . "=="), "_563b15b92a77" . "c869e85edf956" . "9b4d025" => base64_decode("ZmNs" . "b3Nl"), "_c4f3321d131869e51" . "a8844b6bcd8fb86" => base64_decode("Z" . "G" . "l" . "y"), "_1f7075c649da93591cae2f4" . "eb31f83fe" => base64_decode("RXJyb3Igd3JpdGl" . "uZyBmaWxlIGZyb2" . "0gc3RyZWFt"), "_c91b0ff1" . "9f81a8873" . "a4593a237" . "19472c" => base64_decode("cnRyaW0" . "="), "_a606a2dcd23" . "6a549db0574a" . "9c1675927" => base64_decode("cg=" . "="), "_554a9169138240019" . "acbd1502642f16a" => base64_decode("ZGlybmFtZ" . "Q=="), "ty" . "pe" => base64_decode("dHl" . "wZQ" . "=="), "_18c93a32ba5faf9509389a94787e" . "6798" => base64_decode("bW9kaWZpZW" . "Q="), "_9905761f4393d105cadfe7282" . "a8c518d" => base64_decode("bWltZXR5" . "cGU="));
use BadMethodCallException;
use Claromentis\Core\Filesystem\Exception\FileExistsException;
use Claromentis\Core\Filesystem\Exception\FileNotFoundException;
use Claromentis\Core\Filesystem\Exception\FilesystemException;
use Exception;
use InvalidArgumentException;
use League\Flysystem;




class Filesystem implements FilesystemInterface
{
    
    
    
    
    
    
    protected Flysystem\FilesystemInterface $flysystem;
    
    
    
    
    
    
    protected string $charset;
    
    
    
    
    
    
    
    public function __construct(Flysystem\FilesystemInterface $_f623c94181cfb84b7b1ab3b650f57e44, string $_1ecc621b9902a7c9b8f2055fad2a3ead = 'UTF-8')
    {
        $this->flysystem = $_f623c94181cfb84b7b1ab3b650f57e44;
        $this->charset = $_1ecc621b9902a7c9b8f2055fad2a3ead;
    }
    
    
    
    
    public function Read(string $path) : string
    {
        try {
            return $this->flysystem->read($path);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function GetStream(string $path)
    {
        try {
            return $this->flysystem->readStream($path);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function WriteFromFile(string $path, string $_9211dd0bbcae0c7133030df599ff9ef5, array $config = []) : void
    {
        $_1cc5aa2f679b575f82786a73f0da28f8 = $GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["_6108a04b8350bfd2b7f2" . "b2365703eaec"]($_9211dd0bbcae0c7133030df599ff9ef5, $GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["_a606a2dcd" . "236a549db0" . "574a9c1675" . "927"]);
        try {
            $this->WriteFromStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
        } finally {
            $this->CloseStream($_1cc5aa2f679b575f82786a73f0da28f8);
        }
    }
    
    
    
    
    public function WriteFromStream(string $path, $_1cc5aa2f679b575f82786a73f0da28f8, array $config = []) : void
    {
        if (!$GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_5febae03aa5407" . "c291b5c61a872cc" . "1fd"]($_1cc5aa2f679b575f82786a73f0da28f8)) {
            throw new InvalidArgumentException($GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"]["_a67b2f1eec9b2bac90112c5d6" . "723ab41"]);
        }
        try {
            $_1f24efd4735b7a11b391147435e7d35d = $this->flysystem->writeStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
        } catch (Flysystem\FileExistsException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileExistsException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
        if ($_1f24efd4735b7a11b391147435e7d35d === false) {
            throw new FilesystemException($GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_1f7075c649da93591cae2f4eb31f83" . "fe"]);
        }
    }
    
    
    
    
    public function Write(string $path, string $_d34599daeb8cca374d3adb38b245839c, array $config = []) : void
    {
        try {
            $_1f24efd4735b7a11b391147435e7d35d = $this->flysystem->write($path, $_d34599daeb8cca374d3adb38b245839c, $config);
        } catch (Flysystem\FileExistsException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileExistsException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
        if ($_1f24efd4735b7a11b391147435e7d35d === false) {
            throw new FilesystemException($GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_01713acbc1c314b61bfbd8dc" . "10a810bd"]);
        }
    }
    
    
    
    
    public function UpdateFromFile(string $path, string $_9211dd0bbcae0c7133030df599ff9ef5, array $config = []) : void
    {
        $_1cc5aa2f679b575f82786a73f0da28f8 = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_6108a04b8350bfd2b7f2b23" . "65703eaec"]($_9211dd0bbcae0c7133030df599ff9ef5, $GLOBALS["__65da1b1ec2d6653e8a0a" . "b7848e536215"]["_a606a2dcd236a549db0574a9c1" . "675927"]);
        try {
            $this->UpdateFromStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
        } finally {
            $this->CloseStream($_1cc5aa2f679b575f82786a73f0da28f8);
        }
    }
    
    
    
    
    public function UpdateFromStream(string $path, $_1cc5aa2f679b575f82786a73f0da28f8, array $config = []) : void
    {
        if (!$GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_5febae03aa" . "5407c291b5c" . "61a872cc1fd"]($_1cc5aa2f679b575f82786a73f0da28f8)) {
            throw new InvalidArgumentException($GLOBALS["__65da1b1ec2d6653e8a0ab7848" . "e536215"]["_a67b2f1eec9b2bac90112c5d6" . "723ab41"]);
        }
        try {
            $_1f24efd4735b7a11b391147435e7d35d = $this->flysystem->updateStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
        if ($_1f24efd4735b7a11b391147435e7d35d === false) {
            throw new FilesystemException($GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_e134836" . "f6369409" . "efa4f2ca" . "d261365c" . "8"]);
        }
    }
    
    
    
    
    public function Update(string $path, string $_d34599daeb8cca374d3adb38b245839c, array $config = []) : void
    {
        try {
            $_1f24efd4735b7a11b391147435e7d35d = $this->flysystem->update($path, $_d34599daeb8cca374d3adb38b245839c, $config);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
        if ($_1f24efd4735b7a11b391147435e7d35d === false) {
            throw new FilesystemException($GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_179055b98e140c4d418b" . "cd5a903c7b7c"]);
        }
    }
    
    
    
    
    public function PutFromFile(string $path, string $_9211dd0bbcae0c7133030df599ff9ef5, array $config = []) : void
    {
        try {
            if ($this->flysystem->has($path)) {
                $this->UpdateFromFile($path, $_9211dd0bbcae0c7133030df599ff9ef5, $config);
            } else {
                $this->WriteFromFile($path, $_9211dd0bbcae0c7133030df599ff9ef5, $config);
            }
        } catch (Exception $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function PutFromStream(string $path, $_1cc5aa2f679b575f82786a73f0da28f8, array $config = []) : void
    {
        try {
            if ($this->flysystem->has($path)) {
                $this->UpdateFromStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
            } else {
                $this->WriteFromStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
            }
        } catch (Exception $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    public function Put(string $path, string $_d34599daeb8cca374d3adb38b245839c, array $config = []) : void
    {
        $_1f24efd4735b7a11b391147435e7d35d = $this->flysystem->put($path, $_d34599daeb8cca374d3adb38b245839c, $config);
        if ($_1f24efd4735b7a11b391147435e7d35d === false) {
            throw new FilesystemException($GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_01713acbc1c314b61bf" . "bd8dc10a810bd"]);
        }
    }
    
    
    
    
    public function Copy(string $path, string $_d074d7b344040d95fcad55b4694d9fec) : void
    {
        try {
            $this->flysystem->copy($path, $_d074d7b344040d95fcad55b4694d9fec);
        } catch (Flysystem\FileExistsException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileExistsException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        } catch (Exception $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function Rename(string $path, string $_d074d7b344040d95fcad55b4694d9fec) : void
    {
        if ($this->IsDir($path)) {
            $this->RenameDir($path, $_d074d7b344040d95fcad55b4694d9fec);
        } else {
            $this->RenameFile($path, $_d074d7b344040d95fcad55b4694d9fec);
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    public function RenameFile(string $path, string $_d074d7b344040d95fcad55b4694d9fec) : void
    {
        try {
            $this->flysystem->rename($path, $_d074d7b344040d95fcad55b4694d9fec);
        } catch (Flysystem\FileExistsException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileExistsException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        } catch (Exception $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function RenameDir(string $path, string $_d074d7b344040d95fcad55b4694d9fec) : void
    {
        $path = $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_c91b0ff19f81" . "a8873a4593a23" . "719472c"]($path, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e536" . "215"]["_8aa39710a39f226efce7" . "8e97c7bcd786"]);
        $_d074d7b344040d95fcad55b4694d9fec = $GLOBALS["__65da1b1ec2d6653e8a0ab7848e53621" . "5"]["_c91b0ff19f81a8873a4593a2371947" . "2c"]($_d074d7b344040d95fcad55b4694d9fec, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_8aa39710a39f226efce78e97c7b" . "cd786"]);
        $_414bd78c344503f4d9a81c17a1e0b473 = $this->ListDirs($path);
        $_00f2055c7cbd408ef56949f35c62b721 = $this->ListFiles($path);
        foreach ($_414bd78c344503f4d9a81c17a1e0b473 as $_c4f3321d131869e51a8844b6bcd8fb86) {
            $this->RenameDir($path . $GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_87daa84e3" . "46f6420a3f" . "3426e05d16" . "a7b"] . $_c4f3321d131869e51a8844b6bcd8fb86, $_d074d7b344040d95fcad55b4694d9fec . $GLOBALS["__65da1b1ec2d6653e8a0" . "ab7848e536215"]["_87daa84e346f6420a3f3426e05" . "d16a7b"] . $_c4f3321d131869e51a8844b6bcd8fb86);
        }
        foreach ($_00f2055c7cbd408ef56949f35c62b721 as $_6ae3783b9ad544a6c31a979683fed870) {
            $this->RenameFile($path . $GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["_87daa84e346f6420a3f3426e05d16a" . "7b"] . $_6ae3783b9ad544a6c31a979683fed870, $_d074d7b344040d95fcad55b4694d9fec . $GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_87daa84e346f6420a3f3426" . "e05d16a7b"] . $_6ae3783b9ad544a6c31a979683fed870);
        }
        
        
        $this->Delete($path);
    }
    
    
    
    
    public function Delete(string $path) : void
    {
        try {
            $_fd5a3a643834299cbdadfc3540ba0bcb = true;
            if ($this->IsDir($path)) {
                $_fd5a3a643834299cbdadfc3540ba0bcb = $this->flysystem->deleteDir($path);
            } else {
                $_fd5a3a643834299cbdadfc3540ba0bcb = $this->flysystem->delete($path);
            }
        } catch (Flysystem\FileNotFoundException|Flysystem\RootViolationException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            
            
            
        }
        if ($_fd5a3a643834299cbdadfc3540ba0bcb === false) {
            throw new FilesystemException($GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_9463ea5f1" . "a4c73607f2" . "c69eeee2b6" . "ede"]);
        }
    }
    
    
    
    
    
    
    
    
    protected function ListContentsOfType(string $type, string $path)
    {
        $_d34599daeb8cca374d3adb38b245839c = $this->flysystem->listContents($path, false);
        $_c00c0eb73f04b4a4ca0678ce86138b81 = [];
        foreach ($_d34599daeb8cca374d3adb38b245839c as $_6aead4bff5639b251aebcf8a630e43a7) {
            if ($_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d6653e8a0ab784" . "8e536215"]["t" . "y" . "p" . "e"]] === $type) {
                $_c00c0eb73f04b4a4ca0678ce86138b81[] = $_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_32b8fa1" . "ca330a06" . "85321a37" . "9e5b9687" . "d"]];
            }
        }
        return $_c00c0eb73f04b4a4ca0678ce86138b81;
    }
    
    
    
    
    public function ListContents(string $path) : array
    {
        $_d34599daeb8cca374d3adb38b245839c = $this->flysystem->listContents($path, false);
        $_c00c0eb73f04b4a4ca0678ce86138b81 = [];
        foreach ($_d34599daeb8cca374d3adb38b245839c as $_6aead4bff5639b251aebcf8a630e43a7) {
            $_c00c0eb73f04b4a4ca0678ce86138b81[] = $_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_32b8fa1ca330a0685321a379e5b9687" . "d"]];
        }
        return $_c00c0eb73f04b4a4ca0678ce86138b81;
    }
    public function ListContentsInfo(string $path) : array
    {
        $_6aead4bff5639b251aebcf8a630e43a7 = $this->flysystem->listContents($path, false);
        foreach ($_6aead4bff5639b251aebcf8a630e43a7 as &$_8043af106ba13a0ca9b53aa5c2df0e85) {
            unset($_8043af106ba13a0ca9b53aa5c2df0e85[$GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_554a91691382" . "40019acbd1502" . "642f16a"]]);
            unset($_8043af106ba13a0ca9b53aa5c2df0e85[$GLOBALS["__65da1b1e" . "c2d6653e8a" . "0ab7848e53" . "6215"]["p" . "a" . "t" . "h"]]);
        }
        return $_6aead4bff5639b251aebcf8a630e43a7;
    }
    
    
    
    
    public function ListContentsRecursive(string $path) : array
    {
        return $this->flysystem->listContents($path, true);
    }
    
    
    
    
    public function ListFiles(string $path) : array
    {
        return $this->ListContentsOfType($GLOBALS["__65da1b1ec2d665" . "3e8a0ab7848e5362" . "15"]["_6ae3783b9ad544a6c31a979683fe" . "d870"], $path);
    }
    
    
    
    
    public function ListDirs(string $path) : array
    {
        return $this->ListContentsOfType($GLOBALS["__65da1b1ec2d6653e8a0ab7" . "848e536215"]["_c4f3321d13186" . "9e51a8844b6bcd" . "8fb86"], $path);
    }
    
    
    
    
    public function GetMetadata(string $path) : array
    {
        try {
            $_97ea09a7faf27c52c6eff69773df1d8a = $this->flysystem->getTimestamp($path);
            $size = $this->flysystem->getSize($path);
            $_9905761f4393d105cadfe7282a8c518d = $this->flysystem->getMimetype($path);
            $_e46a1b6a2fd927d616377ae17620d766 = $this->flysystem->getVisibility($path);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
        return [$GLOBALS["__65da1b1ec2d6653" . "e8a0ab7848e536215"]["siz" . "e"] => $size, $GLOBALS["__65da1b1ec2d6" . "653e8a0ab7848e" . "536215"]["_9905761f439" . "3d105cadfe72" . "82a8c518d"] => $_9905761f4393d105cadfe7282a8c518d, $GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"]["_18c93a32ba5faf9509" . "389a94787e6798"] => $_97ea09a7faf27c52c6eff69773df1d8a, $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5" . "36215"]["_e46a1b6a2fd927d616377ae17" . "620d766"] => $_e46a1b6a2fd927d616377ae17620d766];
    }
    
    
    
    
    public function Exists(string $path) : bool
    {
        return $this->flysystem->has($path) && !$this->IsDir($path);
    }
    
    
    
    
    public function IsDir(string $path) : bool
    {
        if (!$this->flysystem->has($path)) {
            return false;
        }
        try {
            $metadata = $this->flysystem->getMetadata($path);
            $type = $metadata[$GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["t" . "y" . "p" . "e"]] ?? null;
            return $type === $GLOBALS["__65da1b1ec2d66" . "53e8a0ab7848e53" . "6215"]["_c4f3321d131869e" . "51a8844b6bcd8fb8" . "6"];
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            return false;
        }
    }
    
    
    
    
    public function GetLocalPath(string $path) : string
    {
        try {
            
            
            
            
            
            
            return $this->flysystem->getLocalPath($path);
        } catch (BadMethodCallException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function GetUrl(string $path) : ?string
    {
        try {
            
            
            
            
            
            
            return $this->flysystem->getUrl($path);
        } catch (BadMethodCallException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function GetUsedSpace() : string
    {
        try {
            
            
            
            
            
            
            return $this->flysystem->getUsedSpace();
        } catch (BadMethodCallException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    
    
    public function addPlugin(Flysystem\PluginInterface $_38198dbb7190fed0f875632ecef1ac6f)
    {
        $this->flysystem->addPlugin($_38198dbb7190fed0f875632ecef1ac6f);
    }
    
    
    
    
    public function RegisterProtocol(string $_21f5dd11309da4af2e51660e6f110a91) : void
    {
        StreamWrapper::register($_21f5dd11309da4af2e51660e6f110a91, $this->flysystem);
    }
    
    
    
    
    public function SetVisibility(string $path, string $_e46a1b6a2fd927d616377ae17620d766) : void
    {
        try {
            $this->flysystem->setVisibility($path, $_e46a1b6a2fd927d616377ae17620d766);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    
    
    
    
    protected function CloseStream($_1cc5aa2f679b575f82786a73f0da28f8) : void
    {
        if ($GLOBALS["__65da1b1ec2d6653e8a0ab" . "7848e536215"]["_5febae03aa5407c291b5c61a872cc" . "1fd"]($_1cc5aa2f679b575f82786a73f0da28f8) && $GLOBALS["__65da1b1ec2d6653e8a0ab7848e5362" . "15"]["_f2646618c9dca" . "d156a41241eacc" . "4c3f7"]($_1cc5aa2f679b575f82786a73f0da28f8) === $GLOBALS["__65da1b1ec" . "2d6653e8a0a" . "b7848e53621" . "5"]["_1cc5aa2f679b575f82786a73f0da28" . "f8"]) {
            $GLOBALS["__65da1b1ec2d6653e8a0ab78" . "48e536215"]["_563b15b92a77c869e85edf9569b4d" . "025"]($_1cc5aa2f679b575f82786a73f0da28f8);
        }
    }
}