<?php
namespace Claromentis\Core\Admin;

$GLOBALS["__65da1b1" . "ec2d6653e" . "8a0ab7848" . "e536215"] = (@$GLOBALS["__65da1b1ec2d" . "6653e8a0ab784" . "8e536215"] ?: array()) + array();
use Claromentis\Core\Acl\Exception\AclException;
use Claromentis\Core\Acl\Simple\SimpleAcl;
use Claromentis\Core\Acl\Simple\SimpleAclRepository;
use Claromentis\Core\Security\SecurityContext;







trait SimpleAclTrait
{
    protected ?SimpleAcl $acl = null;
    protected ?SimpleAclRepository $acl_repo;
    
    
    
    
    public abstract function GetCode();
    public function SetAclRepository(?SimpleAclRepository $acl_repo) : void
    {
        $this->acl_repo = $acl_repo;
    }
    
    
    
    
    public function GetSimpleAcl() : SimpleAcl
    {
        if ($this->acl === null) {
            $this->acl = $this->acl_repo->Get($this->GetCode());
        }
        return $this->acl;
    }
    
    
    
    
    
    public function SetSimpleAcl(SimpleAcl $acl) : void
    {
        $this->acl = $acl;
        $this->acl_repo->Save($acl);
    }
    
    
    
    
    
    public function GetAdmins()
    {
        return $this->GetSimpleAcl()->GetIndividualsList();
    }
    
    
    
    
    
    
    public function IsAccessible(SecurityContext $context)
    {
        try {
            return $this->GetSimpleAcl()->Permits($context->GetUserId());
        } catch (AclException $e) {
            return false;
        }
    }
}