<?php
$_db_migration_to = '23.04'; // 7.2 beta
if (!isset($migrations) || !is_object($migrations))
	die("This file cannot be executed directly");
$migrations->CheckValid($_db_migration_to);
//===========================================================================================



$migrations->Run('01_hd_user_settings.php', <<<'DB_UPDATE_FILE'
<?


// hd_user_settings
$table_descr = array(
	'user_id'          => "INT NULL",
	'project_id'       => "INT NULL",
	'reporter_option'  => "INT NULL",
	'handler_option'   => "INT NULL",
	'new_option'       => "INT NULL",
);

$db->CreateTable('hd_user_settings', $table_descr, true);


$db->AddColumn('hd_project', 'def_notifications', 'INT NOT_NULL DEFAULT 0');
?>

DB_UPDATE_FILE
);


$migrations->Run('02_audit_update_project.php', <<<'DB_UPDATE_FILE'
<?

$db->query("INSERT INTO audit_conf_txt (category, sub_cat, status, rank_value) VALUES ('infocapture', 'update_project', 1, 0)");
?>
DB_UPDATE_FILE
);


$migrations->Run('03_menu_icons.php', <<<'DB_UPDATE_FILE'
<?

$apps = array(
	array('url' => '/intranet/admin', 'class' => 'app-admin'),
	array('url' => '/intranet/audit', 'class' => 'app-auditmanager'),
	array('url' => '/intranet/blog', 'class' => 'app-blog'),
	array('url' => '/intranet/calendar', 'class' => 'app-calendar'),
	array('url' => '/intranet/calendar/tasks', 'class' => 'app-task'),
	array('url' => '/intranet/communication', 'class' => 'app-communication'),
	array('url' => '/intranet/courses', 'class' => 'app-courseplanner'),
	array('url' => '/intranet/crm', 'class' => 'app-crm'),
	array('url' => '/intranet/documents', 'class' => 'app-documents'),
	array('url' => '/intranet/forum', 'class' => 'app-forums'),
	array('url' => '/intranet/gallery', 'class' => 'app-gallery'),
	array('url' => '/intranet/holidays', 'class' => 'app-holidayplanner'),
	array('url' => '/intranet/ideaspace', 'class' => 'app-ideaspace'),
	array('url' => '/intranet/infocapture', 'class' => 'app-infocapture'),
	array('url' => '/intranet/innovate', 'class' => 'app-innovate'),
	array('url' => '/intranet/knowledgebase', 'class' => 'app-knowledgebase'),
	array('url' => '/intranet/lms', 'class' => 'app-lms'),
	array('url' => '/intranet/publish', 'class' => 'app-publish'),
	array('url' => '/intranet/publish/menu_builder', 'class' => 'app-menubuilder'),
	array('url' => '/intranet/news', 'class' => 'app-news'),
	array('url' => '/intranet/people', 'class' => 'app-people'),
	array('url' => '/intranet/policy', 'url' => 'app-policymanager'),
	array('url' => '/intranet/project', 'class' => 'app-project'),
	array('url' => '/intranet/rooms', 'class' => 'app-roombooking'),
	array('url' => '/intranet/mail', 'class' => 'app-mail'),
	array('url' => '/intranet/bookshelf', 'class' => 'app-bookshelf'),
	array('url' => '/intranet/search', 'class' => 'app-search'),
	array('url' => '/intranet/stat', 'class' => 'app-statistics')

);

list($apps_menu_id) = $db->query_row('SELECT id FROM publish_menu WHERE title eq:str:title', 'applications');

if ($apps_menu_id)
{
	foreach($apps as $app)
	{
		$q = new QueryUpdate('publish_menunode', 'menu_id=int:menu_id AND url like like:url%', array('str:css_class' => $app['class']));
		$q->Bind('menu_id', $apps_menu_id);
		$q->Bind('url', $app['url']);
		$db->query($q);
	}
}

?>
DB_UPDATE_FILE
);


//===========================================================================================
$migrations->SetVersion('23.04');
