define(['mootools', 'moment'], function ($$, moment) {

	var ClnEvent = new Class({
		initialize: function(){
			this.full_day = 0;
			this.registered = false;
			this.id = 0;
			this.divs_array = [];
			this.a_bility = 0;
			this.seq_id = 0;
			this.reminder = '';
			this.reminder_default = '-1';
			this.creator_id = document.session_uid;
			this.confirm = 0;
			this.participant = 0;
			this.rb = 0;
			this.description = '';
			this.details_url = null;
		},
		setId: function(id){
			this.id = id;
		},
		setClnId: function(cln_id){
			this.cln_id = cln_id;
		},
		getId: function(){
			return this.id;
		},
		getClnId: function(){
			return this.cln_id;
		},
		setStartDate: function(date){
			this.start = date;
		},
		setEndDate: function(date){
			this.end = date;
		},
		setSeqId: function(id){
			this.seq_id = id;
		},
		setName: function(name){
			this.name = name;
		},
		getName: function(){
			return this.name;
		},
		setDescription: function(description){
			this.description = description;
		},
		getDescription: function(){
			return this.description;
		},
		getDiv: function(){
			if (!$defined(this.div)){
				var viewer = (this.full_day == 1) ? document.full_day_viewer : document.cln_viewer;
				this.div = viewer.getEventPattern();
				this.div.linked_event = this;
			}
			if ($defined(document.calendar_info[this.cln_id]))
			{
				if (this.full_day == 1 || this.days_count > 1 || document.cln_viewer.viewer_mode < 2)
				{
					this.div.setStyle('background-color', document.calendar_info[this.cln_id].color);
					this.div.setStyle('color', document.calendar_info[this.cln_id].text_color);
				} else
				{
					var t_color = document.calendar_info[this.cln_id].color;
					var choose_colors = [t_color, '#e1e1e1'];
					var used_color = cla.colours.getColorByThreshold(t_color, 225, choose_colors);
					this.div.setStyle('color', used_color);
				}

			}
			return this.div;
		},
		getWeekDiv: function(num){
			if (!$defined(this.divs_array[num])){
				var viewer = (this.full_day == 1) ? document.full_day_viewer : document.cln_viewer;
				this.divs_array[num] = viewer.getEventPattern();
				this.divs_array[num].linked_event = this;
				this.divs_array[num].setStyle('background-color', document.calendar_info[this.cln_id].color);
				this.divs_array[num].setStyle('color', document.calendar_info[this.cln_id].text_color);
			}
			return this.divs_array[num];
		},
		getTailDiv: function()	{
			if (!$defined(this.tail_div)){
				this.tail_div = document.cln_viewer.getEventPattern();
				this.tail_div.linked_event = this;
			}
			this.tail_div.setStyle('background-color', document.calendar_info[this.cln_id].color);
			this.tail_div.setStyle('color', document.calendar_info[this.cln_id].text_color);
			return this.tail_div;
		},
		serialize: function(){
			var d = new Date();
			// alert(this.full_day);
			var start_date = this.start.serialize();
			var end_date = this.end.serialize();

			var serialized_event = {
				'transaction_id': d.getTime(),
				'type': this.type,
				'id': this.getId(),
				'seq_id': this.seq_id,
				'name': this.getName(),
				'start_date': start_date,
				'end_date': end_date,
				'cln_id': this.getClnId(),
				'full_day': this.full_day,
				'reminder': this.reminder,
				'a_bility': this.a_bility,
				'confirm': this.confirm,
				'description': this.description,
				'overview': this.overview,
				'editable': this.editable,
				'is_personal': this.is_personal,
				'participant': this.participant,
				'cln_name': this.cln_name,
				'old_cln_id': this.old_cln_id
			};
			return serialized_event;
		},
		getRange: function(){

			if (this.full_day && this.start.formatMoment('HHmm') == '0000'){
				return this.getDateRange();
			}

			return this.getTimeRange();
		},
		getDateRange: function(){

			var day_format_full = cla_locale.date_format_full;
			var day_format_short = cla_locale.date_format_short;

			if(day_format_full.indexOf('dddd') !== -1)
				day_format_full = day_format_full.replace('dddd', 'ddd'); //shorten month to 3 letters

			if(day_format_short.indexOf('dddd') !== -1)
				day_format_short = day_format_short.replace('dddd', 'ddd'); //shorten month to 3 letters

			if(this.start.formatMoment('YYYY') != this.end.formatMoment('YYYY')){
				return this.start.formatMoment(day_format_full)+" - "+ this.end.formatMoment(day_format_full);
			}
			if(this.start.formatMoment('MM') != this.end.formatMoment('MM')){
				return this.start.formatMoment(day_format_short)+" - "+ this.end.formatMoment(day_format_short);
			}
			if(this.start.formatMoment('DD') != this.end.formatMoment('DD')){
				return this.start.formatMoment(day_format_short)+" - "+ this.end.formatMoment(day_format_short);
			}

			return this.start.formatMoment(day_format_short);

		},
		getTimeRange: function () {
			var day_format_full = cla_locale.date_format_full;
			if (this.start.formatMoment('YYYY') == this.end.formatMoment('YYYY') && this.start.formatMoment('YYYY') == moment().year())
				day_format_full = day_format_full.replace('YYYY', '').replace(/^[\- \/.,]+|[\- \/.,]+$/gm, ''); // remove year and trim delimiters

			var date1_day_str = ' ' + this.start.formatMoment(day_format_full);
			var date2_day_str = ' ' + this.end.formatMoment(day_format_full);

			if (this.start.formatMoment('MM') == this.end.formatMoment('MM')
				&& this.start.formatMoment('DD') == this.end.formatMoment('DD')
				&& this.start.formatMoment('YYYY') == this.end.formatMoment('YYYY')) {
				return date2_day_str + ", " + this.start.formatMoment(cla_locale.time_format) + " - " + this.end.formatMoment(cla_locale.time_format);
			}

			return this.start.formatMoment(cla_locale.time_format) + date1_day_str + " - " + this.end.formatMoment(cla_locale.time_format) + date2_day_str;
		},
		hide: function(){
			this.getDiv().setStyle('display', 'none');
			if (this.haveTail()) this.getTailDiv().setStyle('display', 'none');
			this.divs_array.each(function(el){ if($defined(el)) el.setStyle('display', 'none'); });
		},
		destructor: function(){
			//this.getDiv().remove();
		},
		haveTail: function(){
			if (this.full_day == 1 || document.cln_viewer.viewer_mode > 1) return false;
			return (this.start.getDay() != this.end.getDay() && this.end.formatMoment('HHmmss') != '000000');
		},
		isEditPermission: function(){
			var is_creator = (this.creator_id == document.session_uid);
			if ((document.calendar_perms[129][this.cln_id] == 1) || (is_creator && document.calendar_perms[3][this.cln_id] == 1 ) ) {
				return true;
			}else{
				return false;
			}
		},
        getViewDetailsUrl: function () {
		    return this.details_url;
        },
        setViewDetailsUrl: function (url) {
		    if (typeof url === 'string' || url === null) {
                this.details_url = url;
            }
        }
	});

	return ClnEvent;
});
