/**
 * Single checked out document.
 * Essential properties are doc_id, parent_id, title and some other, but also
 * may contain a document object (instance of DocElementModel)
 */
var CheckedOutModel = Backbone.Model.extend({
	defaults: {
		doc_id: 0,
		parent_id: 0,
		title: '',
		description: ''
	},

	urlRoot: '/intranet/rest/documents/checkin/',
	idAttribute: 'doc_id',

	loadFull: function ()
	{
		if (this.has('object'))
			return;
		var doc = new DocElementModel();
		this.set({'object': doc});
		doc.bind('change', function () { this.trigger('change'); }, this);
		doc.url = this.get('URI');
		doc.fetch();
	},

	getFullDocument: function ()
	{
		if (this.has('object'))
		{
			var obj = this.get('object');
			if (obj.is_loaded)
				return obj;
			return null;
		}
		return null;
	}
});

