angular.module('mention', [])
	.directive('claMention', ['$timeout', function ($timeout)
	{

		controller.$inject = ['$scope'];

		return {
			restrict: 'E',

			scope: {},
			bindToController: {
				userId: '@',
				users: '@',
				commentId: '@'
			},
			controllerAs: 'mention',

			/**
			 * Controller
			 */
			controller: controller,

			templateUrl: '/intranet/comments/html/ui/mention.html'
		};

		function controller($scope)
		{
			var ctrl = this;
			ctrl.users = angular.element.parseJSON(ctrl.users);

			ctrl.user = null;
			for (var i = 0; i < ctrl.users.length; i++)
			{
				if (ctrl.users[i].user_id == ctrl.userId)
					ctrl.user = ctrl.users[i];
			}

			$timeout(function(commentId, user)
			{
				if (user.job_title === null)
					user.job_title = '';

				angular.element('.' + commentId + '-' + user.user_id).popover(
					{
						trigger: 'hover',
						html: true,
						title: '',
						content: '<div class="mention-popover-container"><div class="media"><div class="media-left"><img src="' + user.image_url + '" class="mention-popover-pic profile-img"></div><div class="media-body"><div class="mention-popover-info"><strong>' + user.name + '</strong><br><small class="text-muted">' + user.job_title + '</small></div></div></div>'
					});
			}, 0, true, ctrl.commentId, ctrl.user);
		}
	}]);