<?php
namespace Claromentis\Config\Tests\Unit;

$GLOBALS["__7fee1da8e1e99d62585932" . "8ff8e9b798"] = (@$GLOBALS["__7fee1da8e1e99d62585" . "9328ff8e9b798"] ?: array()) + array("_4d707fab93bebb00bbe69e8159" . "697c90" => base64_decode(""), "_a8c494d" . "8a687400" . "d860d064" . "c77d7f21" . "5" => base64_decode("LnRt" . "cA=="), "_666c743b2c0b" . "f8c9253cfb368" . "bb16fbb" => base64_decode("X0ZJTEU" . "="), "_63e4dbd0d3" . "f4838088875" . "3a552891634" => base64_decode("RW52aXJvbm" . "1lbnRzIGFy" . "ZSBpbW11dG" . "FibGU="), "_87daa84e346" . "f6420a3f3426" . "e05d16a7b" => base64_decode("Lw=" . "="), "_f67a7d77bc" . "266c012bc96" . "b81153a32e1" => base64_decode("dW5s" . "aW5r"), "_8e09c580f3951d0a65a8025dbe" . "f26314" => base64_decode("Q0xBUk" . "9f"), "_208892c06a52ff62bba" . "a777060ff5c79" => base64_decode("JF9FTlYgbm90IGRlZmluZ" . "WQsIHNraXBwaW5nIHRlc3" . "RzIHRoYXQgcmVxdWlyZSB" . "pdA=="), "_8a36a84baeffc0085672f" . "9bf9c064f67" => base64_decode("ZmlsZV9wdXRfY29u" . "dGVudHM="), "_b2ed704ac3f8" . "6a8160456dd14" . "c443280" => base64_decode("c3lzX2dldF90ZW1wX2Rpcg=" . "="), "_1fdd8f9b66708" . "8592aae1b98bc2" . "8b864" => base64_decode("cm1k" . "aXI="), "_c61584fc3580dd88e33b6f" . "b5cfbc0325" => base64_decode("bWtkaXI" . "="));
use Claromentis\Core\Config\Environment;
use Claromentis\Core\Util\RandomUtil;
class EnvironmentTest extends \PHPUnit_Framework_TestCase
{
protected static $has_env;
public function __construct(string $name = null, array $data = array(), string $_07d54f9ffc86f5299cb34ee1627e8301 = '')
{
parent::__construct($name, $data, $_07d54f9ffc86f5299cb34ee1627e8301);
}
public static function setUpBeforeClass()
{
static::$has_env = isset($_ENV);
}
protected function setUp()
{
Environment::ResetEnvironment();
}
public function testGettingASetEnvironmentVariable()
{
$_878cefab5f34c46398cf9e4f527fc76b = $this->RandomArrayWithPrefix(5, $GLOBALS["__7fee1da8e1e99d62" . "5859328ff8e9b798"]["_8e09c580f3951d" . "0a65a8025dbef26" . "314"]);
$_54fa8523f2845872533bfb14523f79ed = new Environment($_878cefab5f34c46398cf9e4f527fc76b);
foreach ($_878cefab5f34c46398cf9e4f527fc76b as $key => $value) {
self::assertEquals($value, $_54fa8523f2845872533bfb14523f79ed->Get($key));
}
}
public function testGettingAnEnvironmentVariableWithoutPrefixIsNull()
{
$_878cefab5f34c46398cf9e4f527fc76b = RandomUtil::RandomArray(5);
$_54fa8523f2845872533bfb14523f79ed = new Environment($_878cefab5f34c46398cf9e4f527fc76b);
foreach ($_878cefab5f34c46398cf9e4f527fc76b as $key => $value) {
self::assertNull($_54fa8523f2845872533bfb14523f79ed->Get($key));
}
}
public function testUsingAPrefixWorksAsExpected()
{
$prefix = RandomUtil::RandomString(10);
$_fd6cd118374f31ddb80d1343275189c2 = $this->RandomArrayWithPrefix(5, $prefix);
$_a22bd43e79b7fd9513c938beaf9a2d61 = RandomUtil::RandomArray(5);
$_878cefab5f34c46398cf9e4f527fc76b = $_fd6cd118374f31ddb80d1343275189c2 + $_a22bd43e79b7fd9513c938beaf9a2d61;
$_54fa8523f2845872533bfb14523f79ed = new Environment($_878cefab5f34c46398cf9e4f527fc76b, $prefix);
foreach ($_fd6cd118374f31ddb80d1343275189c2 as $key => $value) {
self::assertEquals($value, $_54fa8523f2845872533bfb14523f79ed->Get($key));
}
foreach ($_a22bd43e79b7fd9513c938beaf9a2d61 as $key => $value) {
self::assertNull($_54fa8523f2845872533bfb14523f79ed->Get($key));
}
}
public function testUsingABlankPrefixWorksAsExpected()
{
$_878cefab5f34c46398cf9e4f527fc76b = RandomUtil::RandomArray(10);
$_54fa8523f2845872533bfb14523f79ed = new Environment($_878cefab5f34c46398cf9e4f527fc76b, $GLOBALS["__7fee1da8e1e99d625859" . "328ff8e9b798"]["_4d707fab93bebb00bbe69e8159697c" . "90"]);
foreach ($_878cefab5f34c46398cf9e4f527fc76b as $key => $value) {
self::assertEquals($value, $_54fa8523f2845872533bfb14523f79ed->Get($key));
}
}
public function testClearingEnvironmentWorks()
{
$this->CheckEnv();
$_878cefab5f34c46398cf9e4f527fc76b = RandomUtil::RandomArray(10);
$_ENV = $_878cefab5f34c46398cf9e4f527fc76b;
Environment::ClearGlobals();
foreach ($_878cefab5f34c46398cf9e4f527fc76b as $key => $value) {
self::assertNull($_ENV[$key] ?? null);
}
}
public function testCreatingFromGlobalsAfterClearingGlobals()
{
$this->CheckEnv();
$_878cefab5f34c46398cf9e4f527fc76b = $this->RandomArrayWithPrefix(10, $GLOBALS["__7fee1da8e1e9" . "9d625859328ff8" . "e9b798"]["_8e09c580f3951d0" . "a65a8025dbef2631" . "4"]);
$_ENV = $_878cefab5f34c46398cf9e4f527fc76b;
Environment::ClearGlobals();
$_54fa8523f2845872533bfb14523f79ed = Environment::CreateFromGlobals();
foreach ($_878cefab5f34c46398cf9e4f527fc76b as $key => $value) {
self::assertEquals($value, $_54fa8523f2845872533bfb14523f79ed->Get($key));
}
}
public function testCreateAndClearWorksAsExpected()
{
$this->CheckEnv();
$_878cefab5f34c46398cf9e4f527fc76b = $this->RandomArrayWithPrefix(10, $GLOBALS["__7fee1da8e1e99d625859328ff8e9b7" . "98"]["_8e09c580f3951d0a65a80" . "25dbef26314"]);
$_ENV = $_878cefab5f34c46398cf9e4f527fc76b;
$_54fa8523f2845872533bfb14523f79ed = Environment::CreateAndClear();
foreach ($_878cefab5f34c46398cf9e4f527fc76b as $key => $value) {
$this->assertNull($_ENV[$key] ?? null);
$this->assertEquals($value, $_54fa8523f2845872533bfb14523f79ed->Get($key));
}
}
public function testGettingAnUnsetEnvironmentVariableIsNull()
{
$_878cefab5f34c46398cf9e4f527fc76b = RandomUtil::RandomArray(5);
$_54fa8523f2845872533bfb14523f79ed = new Environment($_878cefab5f34c46398cf9e4f527fc76b, $GLOBALS["__7fee1da8e1e99d6" . "25859328ff8e9b798"]["_4d707fab" . "93bebb00b" . "be69e8159" . "697c90"]);
$this->assertNull($_54fa8523f2845872533bfb14523f79ed->Get(RandomUtil::RandomString(25)));
}
public function testUsingArrayAccessWorks()
{
$_878cefab5f34c46398cf9e4f527fc76b = RandomUtil::RandomArray(5);
$_54fa8523f2845872533bfb14523f79ed = new Environment($_878cefab5f34c46398cf9e4f527fc76b, $GLOBALS["__7fee1da8e1e9" . "9d625859328ff8" . "e9b798"]["_4d707fab93bebb00bbe69e8159697c" . "90"]);
foreach ($_878cefab5f34c46398cf9e4f527fc76b as $key => $value) {
$this->assertEquals($value, $_54fa8523f2845872533bfb14523f79ed[$key]);
}
$this->assertNull($_54fa8523f2845872533bfb14523f79ed[RandomUtil::RandomString(25)]);
}
public function testSettingAnEnvironmentVariableFails()
{
$_878cefab5f34c46398cf9e4f527fc76b = RandomUtil::RandomArray(1);
$_54fa8523f2845872533bfb14523f79ed = new Environment($_878cefab5f34c46398cf9e4f527fc76b, $GLOBALS["__7fee1da8e1e99d62" . "5859328ff8e9b798"]["_4d707fab93bebb00bbe69e8159" . "697c90"]);
$this->setExpectedException(\LogicException::class, $GLOBALS["__7fee1da8e1e99d625859328ff" . "8e9b798"]["_63e4dbd0d" . "3f48380888" . "753a552891" . "634"]);
foreach ($_878cefab5f34c46398cf9e4f527fc76b as $key => $value) {
$_54fa8523f2845872533bfb14523f79ed[$key] = RandomUtil::RandomString(25);
}
}
public function testUnsettingAnEnvironmentVariableFails()
{
$_878cefab5f34c46398cf9e4f527fc76b = RandomUtil::RandomArray(1);
$_54fa8523f2845872533bfb14523f79ed = new Environment($_878cefab5f34c46398cf9e4f527fc76b, $GLOBALS["__7fee1da8e1e99d6258593" . "28ff8e9b798"]["_4d707fab93bebb00bbe" . "69e8159697c90"]);
$this->setExpectedException(\LogicException::class, $GLOBALS["__7fee1da8e1e99d625859328ff" . "8e9b798"]["_63e4dbd0d3f483808887" . "53a552891634"]);
foreach ($_878cefab5f34c46398cf9e4f527fc76b as $key => $value) {
unset($_54fa8523f2845872533bfb14523f79ed[$key]);
}
}
public function testGettingAFileBasedKey()
{
$_bd6c5af75f2d077802c58e7b8ca0dbe5 = RandomUtil::RandomString(100);
$_201a9d78bb118788803a451b506587df = RandomUtil::RandomString();
$_0ffe47b8d085d3dd889c49a616fabfb1 = $GLOBALS["__7fee1da" . "8e1e99d62" . "5859328ff" . "8e9b798"]["_b2ed704ac3f86a81" . "60456dd14c443280"]();
$_0ffe47b8d085d3dd889c49a616fabfb1 .= $GLOBALS["__7fee1da8e1e99d625859" . "328ff8e9b798"]["_87daa84e346f6420a" . "3f3426e05d16a7b"] . RandomUtil::RandomString(10);
$GLOBALS["__7fee1da8e1e99d625859328ff8e" . "9b798"]["_c61584fc3580dd88e3" . "3b6fb5cfbc0325"]($_0ffe47b8d085d3dd889c49a616fabfb1);
$_095e37c5e2614300a0402b5bbcd7fb8d = RandomUtil::RandomString(10) . $GLOBALS["__7fee1da8e1e99d625859328ff8e9b7" . "98"]["_a8c494d8a687400d86" . "0d064c77d7f215"];
$_93469c9375390f862eebb779f8b740e4 = $_0ffe47b8d085d3dd889c49a616fabfb1 . $GLOBALS["__7fee1da8e1e99d625859328ff8" . "e9b798"]["_87daa84e346f6420a3f342" . "6e05d16a7b"] . $_095e37c5e2614300a0402b5bbcd7fb8d;
$GLOBALS["__7fee1da8e1e99" . "d625859328ff8e9" . "b798"]["_8a36a84baeffc0085672f9" . "bf9c064f67"]($_93469c9375390f862eebb779f8b740e4, $_bd6c5af75f2d077802c58e7b8ca0dbe5);
$_54fa8523f2845872533bfb14523f79ed = new Environment([$_201a9d78bb118788803a451b506587df . $GLOBALS["__7fee1da8e1e99d625859328ff8e9b79" . "8"]["_666c743b2c0bf8c9253cfb" . "368bb16fbb"] => $_93469c9375390f862eebb779f8b740e4], $GLOBALS["__7fee1da8e1e99" . "d625859328ff8e9" . "b798"]["_4d707fab93bebb00" . "bbe69e8159697c90"]);
self::assertEquals($_bd6c5af75f2d077802c58e7b8ca0dbe5, $_54fa8523f2845872533bfb14523f79ed->Get($_201a9d78bb118788803a451b506587df));
$GLOBALS["__7fee1da8" . "e1e99d6258" . "59328ff8e9" . "b798"]["_f67a7d77b" . "c266c012bc" . "96b81153a3" . "2e1"]($_93469c9375390f862eebb779f8b740e4);
$GLOBALS["__7fee1da8e1e99d625859328ff8" . "e9b798"]["_1fdd8f9b667088592aae" . "1b98bc28b864"]($_0ffe47b8d085d3dd889c49a616fabfb1);
}
public static function RandomArrayWithPrefix(int $_827a4ce5f334e525c32838c58787f831, string $prefix)
{
$_5043281dccab7305623dcecfd2fb2b63 = RandomUtil::RandomArray($_827a4ce5f334e525c32838c58787f831);
$_e8180e518b009dc0ea8c578fe193c4ae = [];
foreach ($_5043281dccab7305623dcecfd2fb2b63 as $key => $value) {
$_e8180e518b009dc0ea8c578fe193c4ae[$prefix . $key] = $value;
}
return $_e8180e518b009dc0ea8c578fe193c4ae;
}
protected function CheckEnv()
{
if (!static::$has_env) {
$this->markTestSkipped($GLOBALS["__7fee1da8e1e9" . "9d625859328ff8" . "e9b798"]["_208892c06" . "a52ff62bba" . "a777060ff5" . "c79"]);
}
}
}