/**
 * Manager for views that can be shown in the central part of the documents list page.
 * Views should be created independently and added into this manager. It only controls
 * that only one of them if visible at each moment.
 */
var ViewsManager = new Class({
	views: {},
	curViewName: null,

	addView: function (view_name, view_object)
	{
		this.views[view_name] = view_object;
	},

	show: function (view_name)
	{
		_.each(this.views, function (obj, name) {
				if (name != view_name)
					obj.setVisible(false);
			});

		var cur_view = this.views[view_name];
		if (cur_view)
		{
			this.curViewName = view_name;

			cur_view.setVisible(true);
			if (typeof(cur_view.statusMessage) == 'function')
				cla.setPageTitle(cur_view.statusMessage());
			else if (typeof(cur_view.statusMessage) == 'string')
				cla.setPageTitle(cur_view.statusMessage, false);
		}
		if (typeof navigation != 'undefined')
			navigation.render();
	},

	getActiveView: function ()
	{
		return this.views[this.curViewName];
	},

	setViewMode: function (view_mode)
	{
		this.getActiveView().setViewMode(view_mode);
	}
});


