(function($){
	$(document).ready(function() {

		var preInput = ''; // for communicating between event handlersx
		var paletteHTML = generateHTML(); //cached array of fully printed html for the palettes
		var selection = 0; //default palette selected
		displayDefaultSwatches();

		function fetchPalette() {

			var palettes = [];

						palettes[0] = [
				["FFEBEE","FCE4EC","F3E5F5","EDE7F6","E8EAF6","E3F2FD","E1F5FE","E0F7FA","E0F2F1","E8F5E9","F1F8E9","F9FBE7","FFFDE7","FFF8E1","FFF3E0","FBE9E7","EFEBE9","FAFAFA","ECEFF1"],
				["FFCDD2","F8BBD0","E1BEE7","D1C4E9","C5CAE9","BBDEFB","B3E5FC","B2EBF2","B2DFDB","C8E6C9","DCEDC8","F0F4C3","FFF9C4","FFECB3","FFE0B2","FFCCBC","D7CCC8","F5F5F5","CFD8DC"],
				["EF9A9A","F48FB1","CE93D8","B39DDB","9FA8DA","90CAF9","81D4FA","80DEEA","80CBC4","A5D6A7","C5E1A5","E6EE9C","FFF59D","FFE082","FFCC80","FFAB91","BCAAA4","EEEEEE","B0BEC5"],
				["E57373","F06292","BA68C8","9575CD","7986CB","64B5F6","4FC3F7","4DD0E1","4DB6AC","81C784","AED581","DCE775","FFF176","FFD54F","FFB74D","FF8A65","A1887F","E0E0E0","90A4AE"],
				["EF5350","EC407A","AB47BC","7E57C2","5C6BC0","42A5F5","29B6F6","26C6DA","26A69A","66BB6A","9CCC65","D4E157","FFEE58","FFCA28","FFA726","FF7043","8D6E63","BDBDBD","78909C"],
				["F44336","E91E63","9C27B0","673AB7","3F51B5","2196F3","03A9F4","00BCD4","009688","4CAF50","8BC34A","CDDC39","FFEB3B","FFC107","FF9800","FF5722","795548","9E9E9E","607D8B"],
				["E53935","D81B60","8E24AA","5E35B1","3949AB","1E88E5","039BE5","00ACC1","00897B","43A047","7CB342","C0CA33","FDD835","FFB300","FB8C00","F4511E","6D4C41","757575","546E7A"],
				["D32F2F","C2185B","7B1FA2","512DA8","303F9F","1976D2","0288D1","0097A7","00796B","388E3C","689F38","AFB42B","FBC02D","FFA000","F57C00","E64A19","5D4037","616161","455A64"],
				["C62828","AD1457","6A1B9A","4527A0","283593","1565C0","0277BD","00838F","00695C","2E7D32","558B2F","9E9D24","F9A825","FF8F00","EF6C00","D84315","4E342E","424242","37474F"],
				["B71C1C","880E4F","4A148C","311B92","1A237E","0D47A1","01579B","006064","004D40","1B5E20","33691E","827717","F57F17","FF6F00","E65100","BF360C","3E2723","212121","263238"]
			];

			palettes[1] = [
				"e3e3e7","e5e5e6","ecdfec","e6dfec","dfdfe6","dfe6e6","dfe6df","e8e8e0","f9f2df","f4e9df","ecdfdf","e5e4e2",
				"c7c7cf","cacbcd","d9bfd9","ccbfd9","bfbfcc","bfcccc","bfccbf","d1d1c0","f2e6bf","e9d4bf","d9bfbf","ccc8c5",
				"ababb7","b0b1b4","c69fc6","b39fc6","9f9fb3","9fb3b3","9fb39f","babaa1","ecd99f","ddbe9f","c69f9f","b2ada7",
				"8f8f9f","96979b","b380b3","9980b3","808099","809999","809980","a4a481","e6cc80","d2a980","b38080","99928a",
				"727287","7b7d81","9f609f","80609f","606080","608080","608060","8d8d62","dfbf60","c79360","9f6060","7f766d",
				"56566f","616368","8c408c","66408c","404066","406666","406640","767642","d9b340","bc7d40","8c4040","655b50",
				"3a3a57","46494f","792079","4d2079","20204d","204d4d","204d20","5f5f23","d2a620","b06820","792020","4c3f32",
				"1e1e3f","2c2f36","660066","330066","000033","003333","003300","484803","cc9900","a55200","660000","322415"
			];

			palettes[2] = [
				"f2dfec","ece6f2","dfdff2","e6ecf9","dfecec","e6ece6","f2f2df","fff9df","fceddf","f2dfdf","ece6df","ffffff",
				"e6bfd9","d9cce6","bfbfe6","ccd9f2","bfd9d9","ccd9cc","e6e6bf","fff2bf","f8dabf","e6bfbf","d9ccbf","d8d8d8",
				"d99fc6","c6b3d9","9f9fd9","b3c6ec","9fc6c6","b3c6b3","d9d99f","ffec9f","f5c89f","d99f9f","c6b39f","b6b6b6",
				"cc80b3","b399cc","8080cc","99b3e6","80b3b3","99b399","cccc80","ffe680","f2b580","cc8080","b39980","929292",
				"bf609f","9f80bf","6060bf","809fdf","609f9f","809f80","bfbf60","ffdf60","eea360","bf6060","9f8060","6d6d6d",
				"b3408c","8c66b3","4040b3","668cd9","408c8c","668c66","b3b340","ffd940","eb9040","b34040","8c6640","494949",
				"a62079","794da6","2020a6","4d79d2","207979","4d794d","a6a620","ffd220","e77e20","a62020","794d20","242424",
				"990066","663399","000099","3366CC","006666","336633","999900","FFCC00","E46B00","990000","663300","000000"
			];

			palettes[3] = [
				"fbdbee","ffdfff","f2dfff","ecdfff","dfdff9","e6ecff","dff2f2","dff2df","f2f9df","ffffdf","ffecdf","ffdfdf",
				"ffbfe6","ffbfff","e6bfff","d9bfff","bfbff2","ccd9ff","bfe6e6","bfe6bf","e6f2bf","ffffbf","ffd9bf","ffbfbf",
				"ff9fd9","ff9fff","d99fff","c69fff","9f9fec","b3c6ff","9fd9d9","9fd99f","d9ec9f","ffff9f","ffc69f","ff9f9f",
				"ff80cc","ff80ff","cc80ff","b380ff","8080e6","99b3ff","80cccc","80cc80","cce680","ffff80","ffb380","ff8080",
				"ff60bf","ff60ff","bf60ff","9f60ff","6060df","809fff","60bfbf","60bf60","bfdf60","ffff60","ff9f60","ff6060",
				"ff40b3","ff40ff","b340ff","8c40ff","4040d9","668cff","40b3b3","40b340","b3d940","ffff40","ff8c40","ff4040",
				"ff20a6","ff20ff","a620ff","7920ff","2020d2","4d79ff","20a6a6","20a620","a6d220","ffff20","ff7920","ff2020",
				"ff0099","ff00ff","9900ff","6600ff","0000cc","3366ff","009999","009900","99cc00","ffff00","ff6600","ff0000"
			];

			return palettes;
		}

		function displayDefaultSwatches() {
			$('.kolorPicker').each(function(){
				var self = $(this),
				swatchHTML = generateSwatches();


				if(self.data('swatches')) {
					// only draw default swatches if data-swatches is enabled
					self.after(swatchHTML)
				}
				if(self.data('helper')) {
					self.addClass('kp-has-helper');
					self.after('<label for="' + self.attr('id') + '" class="kp-helper"><span class="glyphicons glyphicons-brush"></span> ' + (lmsg('common.color_picker.pick_colour') != undefined ? lmsg('common.color_picker.pick_colour') : 'Pick a colour..') + '</label>')
				}
				pickColour(self, self.val())
			});
		}

		function generateSwatches() {
			var swatches = ['FF9900','5A7CC2','5B97C1','5AB2C2','5AC269','5AC285','59C29E','5AC2B7','63C259','7CC25A','97C25A','B1C25A','C26959','C1855B','C19E59','C2B75A','C25A64','C2597C','C25A97','C25BAF','6B5AC2','855AC2','9F59C2','B75AC2','6B6B6B','808080','969696','AAAAAA'];
			var wrapper = document.createElement('div');
			wrapper.className = 'swatches clear clearfix';

			for(var i = 0; i < swatches.length; i++) {
				wrapper.innerHTML += '<a class="swatch" id="' + swatches[i] + '" style="background-color:#' + swatches[i] + '"></a>';
			}
			return wrapper;
		}

		function pickColour(input, colour) {
			$(input).val(colour)
			.css({'background-color': colour})
			.css({'color': cla.colours.getContrastYIQ(colour)})
			.change()
			.next()
			.css({'color': cla.colours.getContrastYIQ(colour)});
		}

		function generateHTML() {
			var palettes = fetchPalette(),
			html = [];

			for(var i = 0; i < palettes.length; i++) {
				html[i] = '<div class="kolorpicker-palette">\
				<ul class="palette-select">\
				<li id="0">' + (lmsg('common.color_picker.modern') != undefined ? lmsg('common.color_picker.modern') : 'Modern') + '</li>\
				<li id="1">' + (lmsg('common.color_picker.dark') != undefined ? lmsg('common.color_picker.dark') : 'Dark') + '</li>\
				<li id="2">' + (lmsg('common.color_picker.neutral') != undefined ? lmsg('common.color_picker.neutral') : 'Neutral') + '</li>\
				<li id="3">' + (lmsg('common.color_picker.bright') != undefined ? lmsg('common.color_picker.bright') : 'Bright') + '</li>\
				</ul>\
				</div>\
				<div class="x-close-box">&times;</div>\
				<div class="clear"></div>';
				if (typeof palettes[i][0] !== 'object') {
					for (var k = 0; k < palettes[i].length; k++) {
						html[i] += "<a class='swatch' style='background-color:#" + palettes[i][k] + "' id='" + palettes[i][k] + "'></a>";
					}
				} else
				{
					for (var row = 0; row < palettes[i].length; row++) {
						for (var column = 0; column < palettes[i][row].length; column++) {
							html[i] += "<a class='swatch' style='width: 17px; background-color:#" + palettes[i][row][column] + "' id='" + palettes[i][row][column] + "'></a>";
						}
						html[i] += "<div class=\"clear\"></div>";
					}
				}
			}

			return html;
		}

		function displayPicker(input) {
			var parent = $(input).parent();
			$('input.js-kolor-target').removeClass('js-kolor-target', 'false');
			$(input).addClass('js-kolor-target', 'true');

			if ($(parent).find('div').filter('#kolorPicker').size() === 0) {
				var target = $(input);
				var pos = target.position();
				var off = target.offset();

				$('body').append('<div class="kolorPicker-wrapper" style="z-index: 1100; position: absolute; left: ' + (off.left) + 'px; top: ' + (target.outerHeight() + off.top) + 'px" />');

				$('.kolorPicker-wrapper').append('<div id="kolorPicker" class="kolorPickerContainer"></div>');

				$('#kolorPicker').html(paletteHTML[selection]);

				if (target.hasClass('js-no-white')) {
					$('.kolorPicker-wrapper').addClass('js-no-white');
				} else {
					$('.kolorPicker-wrapper').removeClass('js-no-white');
				}

				$('li[id=' + selection + ']').addClass('kolorpicker-palette-select');

				$('.kolorPicker-wrapper .kolorPicker').focus();
			}

		}

		function cleanPicker() {
			$('.kolorPicker-wrapper').remove();
			$('#kolorPicker').remove();
			$('.kolorPicker').parent().removeAttr('style');
			$('body').off('click.kp');
			$('body').off('keydown');
		}

		$(document).off("click", ".kolorPicker");
		$(document).on("click", ".kolorPicker", function () {
			var elem = $(this);
			elem.css('background-color', elem.val());
			elem.trigger('kolorPickerOpen');

			$('body').off('click.kp');
			$('body').on('click.kp', function (ev) {
				if (!($(ev.target).parents().is(".kolorPicker-wrapper") || $(ev.target).is(".kolorPicker-wrapper"))) {
					elem.trigger('colorPickerClose');
					cleanPicker();
				}
			});
			$('body').off('keydown');
			$('body').on('keydown', function(e) {
				// Close on escape key
				if(e.keyCode === 27) {
					elem.trigger('kolorPickerClose');
					cleanPicker();
				}
			});

			displayPicker(this);
		});

		$(document).on("keyup", ".kolorPicker", function () {

			if ($(this).val().charAt(0) != '#') {
				$(this).val('#' + $(this).val());
			}

			var check = /^#[0-9A-Fa-f]*$/;

			if (!check.test($(this).val())) {
				$(this).val(preInput); // if this value is invalid, restore it to what was valid
			}

			pickColour($(this), $(this).val());

			// call the change event on $(this) if you may have an assumed valid hex code
			if ( ($(this).val().length != preInput.length) && ($(this).val().length ==  7) ) {
				$(this).change();
			}
		});

		$(document).off("keypress", ".kolorPicker");
		$(document).on("keypress", ".kolorPicker", function (e) {

			preInput = $(this).val(); //catch this value for comparison in keyup

			return true;
		});

		$(document).off("click", '.swatch');
		$(document).on("click", '.swatch', function(evt){

			//get handle to input field to propagate update event
			var input = $('input.js-kolor-target');

			//grab from the tile's id
			var color = '#' + $(this).attr('id');

			//unhook ourselves from the page
			cleanPicker();
			pickColour(input, color);
		});

		$(document).off("click", 'ul.palette-select li');
		$(document).on("click", 'ul.palette-select li', function(){
			selection = $(this).attr('id'); //note which palette we selected


			$('#kolorPicker').html(paletteHTML[selection]);
    		$('li[id=' + selection + ']').addClass('kolorpicker-palette-select');


		});

		$(document).off("click", '.x-close-box');
		$(document).on("click", '.x-close-box', function(){
			cleanPicker();
		});

		$(document).on("init", ".kolorPicker", function () {
			pickColour($(this), $(this).val());
		});
	});



	$('.js-no-white').on('change keyup blur',function(){
		// FIND CONTENT OF INPUT BOX

		var pickedColor  = $(this).val();

		// CHECK HOW MANY CHARACTERS ARE IN INPUT - IF 3 CHARACTER ARE ADDED IT TAKE EACH LETTER AND DUPLICATE IT IN ORDER
		// e.g. #f1f converts to #ff11ff

		if ($(this).val().length === 7) {
			var color = pickedColor;
		} else if ($(this).val().length === 4) {

		var hex1 = pickedColor.substr(1,1);
		var hex2 = pickedColor.substr(2,1);
		var hex3 = pickedColor.substr(3,4);

		pickedColor = '#' + hex1 + hex1 + hex2 + hex2 + hex3 + hex3;
		color = pickedColor;

		} else {
			var color = pickedColor;
			$( ".toolbar" ).remove();
		}

		// CONVERTS HEX TO RGB

		var r = parseInt(color.substr(1,2), 16);
		var g = parseInt(color.substr(3,2), 16);
		var b = parseInt(color.substr(5,2), 16);


		function rgbToHsl(r, g, b){
			r /= 255, g /= 255, b /= 255;
			var max = Math.max(r, g, b), min = Math.min(r, g, b);
			var h, s, l = (max + min) / 2;

			if(max == min){
				h = s = 0; // achromatic
			}else{
				var d = max - min;
				s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
				switch(max){
					case r: h = (g - b) / d + (g < b ? 6 : 0); break;
					case g: h = (b - r) / d + 2; break;
					case b: h = (r - g) / d + 4; break;
				}
				h /= 6;
			}

			return [h, s, l];
		}


		// FINDS LIGHTNESS OF HSL

		var lightness = rgbToHsl(r, g, b)[2] * 100;
		lightness = parseInt(lightness);


		// CHECKS WHETHER HSL LIGHTNESS WITHIN INPUT IS LOWER THAN 92 & ADD MESSAGE IF SO
		if (lightness >= 92) {
			$( ".toolbar" ).remove();
			$(this).parent().append("<span class='toolbar'>" + (lmsg('common.color_picker.choose_another_color') != undefined ? lmsg('common.color_picker.choose_another_color') : 'Please choose a darker colour') + "</span>");
		} else {
			$( ".toolbar" ).remove();
		}
	});



})(jQuery);
