@javascript @core @people
Feature: Verify power user permissions can be assigned.

  Background:
	Given I am on a Claromentis site
	When the following people exist:
	  | username   | password | surname    | firstname | email                  |
	  | user1      | password | User1      | Bob1      | user1@example.com      |
	  | user2      | password | User2      | Bob2      | user2@example.com      |
	  | user3      | password | User3      | Bob3      | user3@example.com      |
	  | user4      | password | User4      | Bob4      | user4@example.com      |
	  | user5      | password | User5      | Bob5      | user5@example.com      |
	And the following user roles exist:
	  | title  |
	  | Role 1 |
	And the following users are assigned to these roles:
	  | username | role   |
	  | user2    | Role 1 |
	  | user3    | Role 1 |
	And the following user groups exist:
	  | name    | parent  |
	  | Group 1 |         |
	And the following users are assigned to these groups:
	  | username | group   |
	  | user4    | Group 1 |
	  | user5    | Group 1 |

  Scenario: Check a role and group can be assigned for a power user to manage.

	Given I login as an admin user
	When I am on "/intranet/panels/peopleadmin.php"
	And I follow "Bob1 User1"
	And I follow "Other settings"
	And I follow "Edit power user rights"
	Then I should see "This power user can"
	And I should see "Power Users can manage the following"

	When I check "Add new users"
	And  I check "Add new roles"
	And I check "Add new groups"
	And I set permissions for "Role: Role 1" to the following:
	  | View users                                            | 1 |
	  | Edit/delete users in selected groups/roles/extranet   | 1 |
	  | Assign/unassign users to selected group/role/extranet | 1 |
	  | Edit/delete role/group properties                     | 1 |
	And I press "Save"
	Then I should see "Power user updated"

	When I set permissions for "Group: Group 1" to the following:
	  | View users                                            | 1 |
	And I press "Save"
	Then I should see "Power user updated"
	And I logout
