(function($){
	$(document).ready(function() {
		// User submits a search suggestion
		$('#recommend_request_form').on('submit', submitSuggestion);

		$('body').on('keydown', this, keyCheck);
		$('input').on('focus', unbindKey);
		$('input').on('blur', bindKey);

		$('[data-toggle="toggle"]').on('click', toggleContainer)
	});

	function submitSuggestion() {
		// Submit Users suggestion via xajax.
		if($('#searchSuggestion').val() !== '') {
			// XAJAX function search_request [/intranet/search/xjax/request.php]
			xajax_search_request(xajax.getFormValues('recommend_request_form'));
		}
		return false;
	}

	function focusSearch(e) {
		var term = $('#searchTerm'),
			val = term.val();
		term.val( val + ' ' );
		$('#searchTerm').focus();
	}

	function keyCheck(e){
		if (e.shiftKey && e.altKey && e.ctrlKey && e.metaKey) {
			return false;
		}

		var stroke = String.fromCharCode(e.keyCode);
		if (/[a-zA-Z0-9-_ ]/.test(stroke)) {
			focusSearch(e);
		}
	}

	function unbindKey(){
		// unbinds key logger
		$('body').unbind('keydown');
	}

	function bindKey(){
		$('body').on('keydown', this, keyCheck);
	}

	function toggleContainer(){
		var target = $(this).attr('href');
		$(this).parents('.toggle-container').addClass('hidden');
		$( target ).removeClass('hidden');
		return false;
	}
})(jQuery);