<?php
/**
 * "file" mail driver that dumps all emails to a folder
 */
class Mail_file extends Mail {

    /**
     * Any arguments to pass to the mail() function.
     * @var string
     */
    var $_params = '';

    /**
     * Constructor.
     *
     * Instantiates a new Mail_mail:: object based on the parameters
     * passed in.
     *
     * @param array $params Extra arguments for the mail() function.
     */
    function __construct($params = null)
    {
		$this->_params = $params;

        /* Because the mail() function may pass headers as command
         * line arguments, we can't guarantee the use of the standard
         * "\r\n" separator.  Instead, we use the system's native line
         * separator. */
        if (defined('PHP_EOL')) {
            $this->sep = PHP_EOL;
        } else {
            $this->sep = (strpos(PHP_OS, 'WIN') === false) ? "\n" : "\r\n";
        }
    }

	/**
     * Implements Mail_mail::send() function using php's built-in mail()
     * command.
     *
     * @param mixed $recipients Either a comma-seperated list of recipients
     *              (RFC822 compliant), or an array of recipients,
     *              each RFC822 valid. This may contain recipients not
     *              specified in the headers, for Bcc:, resending
     *              messages, etc.
     *
     * @param array $headers The array of headers to send with the mail, in an
     *              associative array, where the array key is the
     *              header name (ie, 'Subject'), and the array value
     *              is the header value (ie, 'test'). The header
     *              produced from those values would be 'Subject:
     *              test'.
     *
     * @param string $body The full text of the message body, including any
     *               Mime parts, etc.
     *
     * @return mixed Returns true on success, or a PEAR_Error
     *               containing a descriptive error message on
     *               failure.
     *
     * @access public
     */
    function send($recipients, $headers, $body)
    {
        $this->_sanitizeHeaders($headers);

		//$to_field, $body, $headers
		$path = $this->_params['path'];
		if (empty($path))
			return PEAR::raiseError('$cfg_mail_send_params[\'path\'] is empty');

		if (!is_dir($path) || !is_writable($path))
			return PEAR::raiseError("'$path' is not a folder or not writable");

		$prefix = date('Ymd_His');
		for ($i = 20; $i > 0; $i--)
		{
			$filename = $prefix.'_'.rand(1000, 9999).'.eml';
			if (!file_exists($path.'/'.$filename))
				break;
		}
		if ($i == 0)
			$filename = $prefix.'_'.uniqid().'.eml';

		$filename = $path.'/'.$filename;

		$headers['To'] = $recipients;

		$text = '';
		foreach ($headers as $h=>$v)
		{
			$text .= "$h: $v".$this->sep;
		}
		$text .= $this->sep;
		$text .= $body;

		if (!file_put_contents($filename, $text))
			return PEAR::raiseError("Couldn't write the email file '$filename'");
		return true;
    }

}
