function ConverterCtrl($scope) {
  $scope.rules = angular.copy(BootstrapUpgrader.rules);
  $scope.source = (typeof window.src_el !== 'undefined') ? window.src_el.text() : "Paste your Bootstrap2 HTML here\n<a class=\"btn\">Button</a>";

  $scope.result = "";

  $scope.runRules = function() {
    var report = BootstrapUpgrader.perform($scope.source, true);
    $scope.result = report.output;
    for (var i = 0; i < report.results.length; i++) {
      var message = report.results[i] || "No Changes";
      $scope.rules[i].runMessage = message;
      $scope.rules[i].runClass = (message === "No Changes") ? "label-default" : "label-success";
    }
    $scope.hasRun = true;
  };

  $scope.returnResult = function() {
    if (typeof window.src_el !== 'undefined') {
	    window.src_el.val($scope.result);
	    window.close();
    } else {
        alert("Sorry, can't locate parent window. Please use clipboard to copy the contents or \"Result HTML\" box to the publish template.")
    }
  };
}