const puppeteer = require('puppeteer-core');
const dotenv = require('dotenv').config({path: './e2e/.env'});

if (dotenv.error) {
    throw dotenv.error;
}

console.log('Init e2e test is running!');

    (async () => {

        // connect with chrome docker image, it looks like the DNS doesn't work, so I had to use ip address
        const browser = await puppeteer.connect({
            browserURL: dotenv.parsed.CHROME_DOCKER_IP,
        });

        // tests itself..
        const page = await browser.newPage();
        await page.goto(`${dotenv.parsed.URL}/login`);

        // Set screen size
        await page.setViewport({width: 1920, height: 1080});

        // Type into log and password
        await page.type('input.form-control.form-control-login.form-control-login-username', 'admin');
        await page.type('input.form-control.form-control-login.form-control-login-password', 'claromentis');

        await page.screenshot({
            path: `./e2e/screenshots/init_test${Date.now()}.jpg`,
            fullpage: true,
            type: 'jpeg'
        });

        // Wait and click on first result
        const searchResultSelector = 'button#submit';
        await page.waitForSelector(searchResultSelector);
        await page.click(searchResultSelector);

        // Locate the full title with a unique string
        const textSelector = await page.waitForSelector('p.greeting-text.text-muted');
        const fullTitle = await textSelector.evaluate(el => el.textContent);

        await page.screenshot({
            path: `./e2e/screenshots/init_test${Date.now()}.jpg`,
            fullpage: true,
            type: 'jpeg'
        });

        // Print the full title
        console.log('The greeting text is: "%s".', fullTitle);

        await page.close()

        await browser.close();
    })();
