## Integration end-to-end testing

### Env file:

For simplicity and to be later used in CI I have added all configuration variables in the `.env` file. The file contains a few variables:

```dotenv
URL=http://claro90.web.localhost        # URL of claro
CHROME_DOCKER_IP=http://172.16.1.9:9222 # IP address of the docker image with headless chrome (it has to be ip address for some reason DNS names doesn't work)
CHROME_DOCKER_WIDTH=1920                # Browser's window width
CHROME_DOCKER_HEIGHT=1080               # Browser's window height
```

### Puppeteer automation:

The minimal working example which will open the login page and make a screenshot will be:

```js
const puppeteer = require('puppeteer-core');
const dotenv = require('dotenv').config({path: './e2e/.env'});

if (dotenv.error) {
    throw dotenv.error;
}

(async () => {
    const browser = await puppeteer.connect({
        browserURL: dotenv.parsed.CHROME_DOCKER_IP,
    });

    // tests itself..
    const page = await browser.newPage();
    await page.goto(`${dotenv.parsed.URL}/login`);

    // Set screen size
    await page.setViewport({width: 1920, height: 1080});
    
    await page.screenshot({
        path: `./e2e/screenshots/init_test${Date.now()}.jpg`,
        fullpage: true,
        type: 'jpeg'
    });
    
    await page.close()
    await browser.close();
})();
```
### Integrate Puppeteer with Jest testing framework:

Puppeteer is a tool for Chrome automation, however we can easily integrate it with Jest testing framework and get actual integration test (copied generated steps from Chrome recorder!):

```js
    beforeAll(async () => {
        await page.goto(`http://claro90.web.localhost/login`);
    });

    // log in test
    it('should log in to main page', async () => {

        // login
        await page.type('input.form-control.form-control-login.form-control-login-username', dotenv.parsed.USER);
        await page.type('input.form-control.form-control-login.form-control-login-password', dotenv.parsed.PASSWORD);

        // click submit
        const searchResultSelector = 'button#submit';

        await page.waitForSelector(searchResultSelector);
        await page.click(searchResultSelector);

        // get greeting text
        const textSelector = await page.waitForSelector('p.greeting-text.text-muted');
        const fullTitle = await textSelector.evaluate(el => el.textContent);

        // and compare it with actual greeting text
        expect(fullTitle).toContain("Welcome to your new digital workplace!");
    })
```
### How to run tests:

Framework Jest will be looking all files with tests in path: `e2e/**.test.js`, to run test we just call:

```shell
npm run e2e 
```

or

```shell
jest
```
