const dotenv = require('dotenv').config({path: './e2e/.env'});

if (dotenv.error) {
    throw dotenv.error;
}

describe("Claromentis login tests", () => {
    beforeAll(async () => {
        await page.goto(`${dotenv.parsed.URL}/login`);

        // Set screen size
        await page.setViewport({
            width: parseInt(dotenv.parsed.CHROME_DOCKER_WIDTH),
            height: parseInt(dotenv.parsed.CHROME_DOCKER_HEIGHT)
        });
    });

    // log in test
    it('should log in to main page', async () => {
        // Type into log and password
        await page.type('input.form-control.form-control-login.form-control-login-username', dotenv.parsed.USER);
        await page.type('input.form-control.form-control-login.form-control-login-password', dotenv.parsed.PASSWORD);

        // Wait and click on first result
        const searchResultSelector = 'button#submit';

        await page.waitForSelector(searchResultSelector);
        await page.click(searchResultSelector);

        // Locate the full title with a unique string
        const textSelector = await page.waitForSelector('p.greeting-text.text-muted');
        const fullTitle = await textSelector.evaluate(el => el.textContent);

        // take a screenshot!
        await page.screenshot({
            path: `./e2e/screenshots/init_test${Date.now()}.jpg`,
            fullpage: true,
            type: 'jpeg'
        });

        expect(fullTitle).toContain("Welcome to your new digital workplace!");
    }, 10000);
});
