var moduleName = 'commentsModule';
var module;

try {
    module = angular.module(moduleName);
} catch (err) {
    // named module does not exist, so create one
    module = angular.module(moduleName, ['ngResource', 'fileupload', 'doclink', 'link', 'cla.core.lmsg', 'cla.core.growl']);
}

module
    .controller('allCommentsControllerExtended',
        ['$scope',  '$timeout', '$http', 'Comment', 'growl.service', 'commentUpdateService', 'profileImageUrlService', 'commentWidthService', '$element', 'CommentsCollection', '$controller', 'AllCommentsComponentConfig', 'AllDiscussionTopicsConfig',
            function ($scope, $timeout, $http, Comment, growlService, commentService, profileService, commentWidthService, $element, CommentsCollection, $controller, AllCommentsComponentConfig, AllDiscussionTopicsConfig) {

                // Inherit parent controller into `this`
                var acc = this;

                acc.config = AllCommentsComponentConfig;
                acc.discussionTopics = AllDiscussionTopicsConfig;

                var objectIds = acc.discussionTopics.map(function (topic) {
                    return topic.id;
                });

                // comments collection
                acc.collection = new CommentsCollection(objectIds, 10, 0, acc.config.sortLatestTop);

                acc.selectedThreadId = null;
                acc.selectedThread = null;

                // Inherit from commentController
                var parent = $controller('commentController', {
                    $scope: $scope,
                    $timeout: $timeout,
                    $http: $http,
                    Comment: Comment,
                    'growl.service': growlService,
                    commentUpdateService: commentService,
                    profileImageUrlService: profileService,
                    commentWidthService: commentWidthService,
                    $element: $element
                }, acc);

                // now acc has parent methods and parameters
                angular.extend(acc, parent);

                // Load comments
                acc.init = function()
                {
                    acc.pageLoading = true;
                    acc.collection.loadPage(function(err, coll) {
                        if (err) {
                            console.error(err);

                            return;
                        }

                        acc.comments = coll.comments;
                        acc.paging = coll.paging;

                        acc.showMore = coll.comments.length !== coll.paging.total;
                        acc.pageLoading = false;
                    });

                    // The unique id won't exist until after the digest so run this after
                    $timeout(function () {
                        var elem = angular.element('#comments_' + acc.uniqueId);

                        elem.on('click', '.js-more-replies', function (e) {
                            e.preventDefault();
                            acc.loadMoreReplies(angular.element(this).data('id'));
                        });

                        // Find out how wide the comments are
                        commentWidthService.setWidth(elem.width());

                        // Monitor the container for resizing, via Pages or window
                        var tile = elem.closest('.js-tile');
                        tile.off('pages-tile-resize pages-tile-add');
                        tile.on('pages-tile-resize pages-tile-add', function () {
                            commentWidthService.setWidth(elem.width());
                        });

                        $(window).resize(function () {
                            commentWidthService.setWidth(elem.width());
                        });
                    }, 0);

                    // setup config
                    var compact_mode = false;

                    acc.config.user_photo_url = profileService.getProfileImageUrl();
                    acc.config.compact_mode = compact_mode;
                    acc.config.showFullInput = !compact_mode;
                }

                /**
                 * [public]
                 * Create a new comment
                 *
                 * @param e
                 */
                acc.new = function (e) {
                    if (this.new_comment === null)
                        this.new_comment = {text: ''};

                    var text = this.new_comment.text;
                    // use uniqueId in case there's multiple comment editors on page
                    var input = angular.element("#new_comment_" + this.uniqueId);

                    var files = acc.getAttachments();
                    // validate if no files have been uploaded
                    if (files.length === 0) {
                        if (!validate(input, text)) {
                            return false;
                        }
                    }

                    var comment = new Comment();
                    comment.load({
                        text: text,
                        object_id: this.selectedThreadId,
                        object_type: this.config.objectType,
                        files: files
                    });

                    var local = this.new_comment;
                    var context = this;

                    acc.can_save = false;
                    comment.save(
                        function (comment) // success
                        {
                            acc.can_save = true;
                            local.text = '';
                            var textarea = input.find('textarea');
                            textarea.height(20);

                            // add comment at the end
                            if (acc.config.sortLatestTop === 1)
                                context.comments.unshift(comment);
                            else
                                context.comments.push(comment);

                            commentService.addComment(comment.id);

                            acc.controlToken.resetFiles();
                            acc.controlToken.resetDocLink();
                            acc.controlToken.resetLink();
                            acc.tab = 0;

                            acc.new_comment.updateDisplay();

                            var message = 'common.cla_comments.comment_published';
                            growlService.showSuccess(lmsg(message));

                            if (acc.config.compact_mode)
                                acc.hideFullInput();

                            // Tell anybody listening that a comment was added
                            $scope.$root.$broadcast('cla.comments.comment_added', comment);
                        },
                        function (httpResponse) // error
                        {
                            acc.can_save = true;
                            var message = 'common.cla_comments.add_failed';
                            if (httpResponse && httpResponse.status === 401) {
                                message = 'common.cla_comments.log_in'
                            }

                            growlService.showError(lmsg(message));
                        }
                    );

                    e.preventDefault();
                };

                /**
                 * Clicked on the button load more comments
                 */
                acc.loadMoreComments = function () {
                    acc.pageLoading = true;

                    // acc.collection.setOffset(acc.comments.length);
                    acc.collection.loadNextPage(function(errorCallback, coll) {
                        if (errorCallback) {
                            console.error(errorCallback);
                            acc.pageLoading = false;

                            return;
                        }

                        // coll.comments is an array of Comment instances
                        // coll.paging has offset, limit, total, prev, next
                        acc.comments = coll.comments;
                        acc.paging   = coll.paging;

                        // no next page hide button show more
                        if (!coll.paging.next) {
                            acc.showMore = false;
                        }

                        acc.pageLoading = false;
                    });
                };

                /**
                 * Load replies from the comment
                 *
                 * @param id
                 */
                acc.loadMoreReplies = function(id) {
                    var comment = null;
                    for (var i = 0 ; i < acc.comments.length; i++)
                    {
                        if (acc.comments[i].id == id)
                            comment = acc.comments[i];
                    }

                    comment.getAllReplies(function (comment_id, replies)
                    {
                        comment.loadingReplies = false;
                        fetchRepliesCallback(comment, replies);
                    }, {id: id, object_type: comment.object_type, object_id: comment.object_id});
                };

                /**
                 * [public]
                 * Reply to a comment
                 *
                 * @param e
                 * @param item
                 */
                acc.add = function (e, item) {
                    var root = acc.getRootComment(item);
                    var comment = new Comment();
                    comment.load({
                        text: item.new_reply.text,
                        mentioned: item.new_reply.mentioned,
                        object_id: item.object_id,
                        object_type: item.object_type,
                        parent_id: item.id
                    });

                    acc.can_save = false;

                    comment.save(
                        function (reply) // success
                        {
                            item.reply_mode = false;
                            item.new_reply.text = "";
                            item.new_reply.mentioned = [];
                            item.new_reply.updateDisplay();
                            root.addReply(reply);
                            commentService.addComment(reply.id);

                            root.reply_count++;
                            acc.can_save = true;

                            var message = 'common.cla_comments.reply_published';
                            growlService.showSuccess(lmsg(message));

                            // Tell anybody listening that a reply was added
                            $scope.$root.$broadcast('cla.comments.reply_added', reply);
                        },
                        function (d) // error
                        {
                            var message = 'common.cla_comments.reply.add_failed';
                            if (d && d.status == 401) {
                                message = 'common.cla_comments.log_in';
                            }

                            acc.can_save = true;
                            growlService.showError(lmsg(message));
                        }
                    );

                    e.preventDefault();
                };

                /**
                 * [private]
                 * Executed when getAll has retrieved all the data from the REST request
                 *
                 * @param comment
                 * @param replies
                 */
                var fetchRepliesCallback = function (comment, replies) {
                    comment.replies = [];

                    for (var i in replies) {
                        var reply = new Comment();
                        reply.load(replies[i]);

                        comment.replies.push(reply);
                    }

                    for (i in comment.replies) {
                        commentService.addComment(comment.replies[i].id);
                        commentService.updateComment(comment.replies[i].id);
                    }
                };

                /**
                 * [private]
                 * Show a validation warning
                 *
                 * @param input
                 * @param text
                 */
                var validate = function (input, text) {
                    if (!input) {
                        return false;
                    }

                    // check for whitespace
                    if ((text.length <= 0 || new RegExp(/^\s+$/).test(text))) {
                        input.addClass("input-empty");
                        setTimeout(function () {
                            input.removeClass("input-empty");
                        }, 3000);

                        return false;
                    }

                    return true;
                };

            }
        ]
    );
