require('../../node_modules/select2/dist/css/select2.css');
require('../css/components/custom/select2.scss');

var select2 = require('select2/dist/js/select2.full');
var jQuery = require('jquery');


// TODO: the select2 library in node_modules that we now use has a different system for handling i18n. Our own usage of it will need to be updated.
jQuery.fn.select2.defaults.set('formatNoMatches', function () { return lmsg('common.select2.no_matches_found'); });
jQuery.fn.select2.defaults.set('formatInputTooShort', function (input, min) { return lmsg('common.select2.input_too_short', min - input.length); });
jQuery.fn.select2.defaults.set('formatSelectionTooBig', function (limit) { return lmsg('common.select2.select_less', limit); });
jQuery.fn.select2.defaults.set('formatLoadMore', function (pageNumber) { return lmsg('common.select2.loading_more'); });
jQuery.fn.select2.defaults.set('formatSearching', function () { return "Searching..."; });

jQuery.fn.select2.defaults.defaults.language.searching = function () {
    if (lmsg_key_exist('common.select2.searching')) {
	    return lmsg('common.select2.searching');
    }
    return "Searching...";
};
jQuery.fn.select2.defaults.defaults.language.errorLoading = function () {
	return '';
};
jQuery.fn.select2.defaults.defaults.language.noResults = function () {
    if (lmsg_key_exist('common.select2.no_results_found')) {
        return lmsg('common.select2.no_results_found');
    }
    return "No results found";
};
jQuery.fn.select2.defaults.defaults.language.inputTooShort = function (args) {
	var remainingChars = args.minimum - args.input.length;
    if (lmsg_key_exist('common.select2.input_too_short')) {
        return lmsg('common.select2.input_too_short', remainingChars);
    }
    return "Please enter " + remainingChars + " more character" + (remainingChars === 1? "" : "s");
};
jQuery.fn.select2.defaults.defaults.language.formatLoadMore = function () {
    if (lmsg_key_exist('common.select2.loading_more')) {
        return lmsg('common.select2.loading_more');
    }
    return "Loading more results...";
};
jQuery.fn.select2.defaults.defaults.language.formatSelectionTooBig = function (limit) {
    if (lmsg_key_exist('common.select2.select_less')) {
        return lmsg('common.select2.select_less', limit);
    }
    return "You can only select " + limit + " item" + (limit === 1 ? "" : "s");
};

jQuery.fn.select2.defaults.set('dropdownCss', function (el) {
    var z_index = null;
    el.parentsUntil('body').each(function (idx, el2) {
        var z = jQuery(el2).css('z-index');
        if (z !== 'auto' && z !== '0') {
            z_index = parseInt(z);
            return false;
        }
    });
    if (isNaN(z_index) || z_index === null)
        return {};
    return { 'z-index': z_index };
});

/**
 * BT-3593 A hopefully temporary fix for autofocusing the dropdown search field for Select2.
 *
 * Upgrading jQuery (to 3.6.1) and select2 (to 4.1.0-rc) does not solve the issue currently.
 * - Select2 PR: https://github.com/select2/select2/pull/6044
 */
$(function () {
    $('#main_container').on('select2:open', 'select', function () {
        $('.select2-container--open .select2-search__field').last().get(0).focus();
    });
});

module.exports = select2;
