var moduleName = 'commentsModule';
var module;

try {
	module = angular.module(moduleName);
} catch(err) {
	// named module does not exist, so create one
	module = angular.module(moduleName, ['ngResource', 'fileupload', 'doclink', 'link']);
}

angular.module(moduleName)
	.factory('Comment', ['$resource', function ($resource) {

	    var Comment = function(type, id, thread_id, offset, limit)
	    {
	        // initialize ng-resource, CRUD operations
	        this.resource = $resource(
                this.rest,
                {
	                'all':
	                { method: 'GET', params: { offset: offset, limit: limit } },
	            },
                {
                    stripTrailingSlashes: false
                }
            );

	        this.replies = [];
	    };

	    Comments.prototype =
	    {
	        comments: [],

            rest: "/api/comments/:action",
	        resource: null,

	        id: 0,
	        text: "",
			mentioned: [],
	        object_id: 0,
	        object_type: '',
            object_name: '',
	        parent_id: 0,
	        ancillary: null,

	        like_count: 0,
			have_i_liked: false,
	        reply_count: 0,
			loadingReplies: false,

	        timestamp: {},
	        user: {},
	        permissions: {},

	        replies: [],
	        new_reply: {text: "", mentioned: []},

	        files: [],

	        edit_mode: false,
	        reply_mode: false,

	        copy: null, // this holds a copy of the object for editing.


	        /**
	         * Load a Comment from REST data
	         *
	         * @param data
	         */
	        load: function(data)
	        {
	            // if any properties are not present, don't overwrite the content.
	            this.id = data.id || this.id;
	            this.text = data.text || this.text;
				this.mentioned = data.mentioned || this.mentioned;
	            this.object_id = data.object_id || this.object_id;
	            this.object_type = data.object_type || this.object_type;
	            this.object_name = data.object_name || this.object_name;
	            this.parent_id = data.parent_id || this.parent_id;
	            this.ancillary = data.ancillary || this.ancillary;

	            this.user = data.user || this.user;
	            this.permissions = data.permissions || this.permissions;
	            this.timestamp = data.timestamp || this.timestamp;

	            this.new_reply = {text: "", mentioned: []};

	            this.reply_count = data.reply_count || this.reply_count;

	            //the javascript || operator is NOT a null coalescing operator. If the new values are falsey,
				// they won't be saved. Because these properties might be 0 or false, we use a way that always works.
	            this.like_count = (data.like_count !== undefined) ? data.like_count : this.like_count;
				this.have_i_liked = (data.have_i_liked !== undefined) ? data.have_i_liked : this.have_i_liked;

				this.files = data.files || this.files;
	        },

	        /**
	         * Get all comments from REST
	         *
	         * @param successCallback
	         * @param failCallback
			 * @param options
	         */
	        getAll: function (successCallback, failCallback, options)
	        {
	        	if (!options.isThreaded)
		        {
		            this.resource.read(options, function (r)
		            {
		                successCallback(r.data, r.options, r.paging);
		            }, function(r)
		            {
		            	failCallback(r);
		            });
		        } else
		        {
			        this.resource.thread(options, function (r)
			        {
				        successCallback(r.data, r.options, r.paging);
			        }, function(r)
			        {
				        failCallback(r);
			        });
		        }
	        },

			getShowMoreLabel: function()
            {
                return lmsg('common.cla_comments.view_more_replies', this.reply_count - this.replies.length);
			}
	    };

	    return Comment;
	}]);
