$(document).ready(function () {
    // Basic get JSON function
    var getJSON = function (url, callback) {
        var xhr = new XMLHttpRequest();
        xhr.open('GET', url, true);
        xhr.responseType = 'json';
        xhr.onload = function () {
            var status = xhr.status;
            if (status === 200) {
                callback(null, xhr.response);
            } else {
                callback(status, xhr.response);
            }
        };
        xhr.send();
    };

    getJSON('/assets/components/docs.json', function (err, data) {
        console.log('data:', data);
        if (err !== null) {
            console.error('Something went wrong: ' + err + ' ' + data);
        } else {
            var results = [];
            // search field to link components to their info
            var searchField = "tag";
            // Selects all .prop divs to gather/enter info
            var properties = document.querySelectorAll(".props");
            // counts number of .prop divs
            var propertiesCount = properties.length;
            var i = 0;
            // loops through all .prop divs
            for (var i = 0; i < propertiesCount; i++) {
                // get's ID of .prop divs one after the other
                var getID = properties[i].id;
                // sets search variable as .prop ID
                var searchVal = getID;
                // selects .prop divs by ID
                var comp = document.getElementById(searchVal);
                var j = 0;
                for (var j = 0; j < data.components.length; j++) {
                    if (data.components[j][searchField] == searchVal) {
                        var k;
                        for (k = 0; k < data.components[j].props.length; k++) {
                            // Adds Attributes title to top of attr list
                            if (k === 0) {
                                var attrTitle = document.createElement("p");
                                attrTitleInner = document.createElement("span");
                                attrTitleInner.appendChild(document.createTextNode("Attributes"));
                                attrTitle.setAttribute('class', 'attrTitle');
                                comp.appendChild(attrTitle);
                                attrTitle.appendChild(attrTitleInner);
                            }
                            // Adds attr name
                            var name = document.createElement("p");
                            name.appendChild(document.createTextNode("Name: " + data.components[j].props[k].name));
                            name.setAttribute('class', 'attrName');
                            comp.appendChild(name);
                            // Adds attr description
                            var docs = document.createElement("p");
                            docs.appendChild(document.createTextNode("Description: " + data.components[j].props[k].docs));
                            comp.appendChild(docs);
                            // Adds attr type
                            var type = document.createElement("p");
                            type.appendChild(document.createTextNode("Type: " + data.components[j].props[k].type));
                            comp.appendChild(type);
                            // Adds attr default value
                            var defaultType = document.createElement("p");
                            defaultType.appendChild(document.createTextNode("Default value: " + data.components[j].props[k].default));
                            comp.appendChild(defaultType);
                        }
                        var l;

                        for (l = 0; l < data.components[j].slots.length; l++) {
                            // Adds Slots title to top of attr list
                            if (l === 0) {
                                var slotTitle = document.createElement("p");
                                var slotTitleInner = document.createElement("span");
                                slotTitleInner.appendChild(document.createTextNode("Slots"));
                                slotTitle.setAttribute('class', 'slotTitle');
                                comp.appendChild(slotTitle);
                                slotTitle.appendChild(slotTitleInner);
                            }
                            // Adds slot name
                            var slotName = document.createElement("p");
                            slotName.appendChild(document.createTextNode("Slot name: " + data.components[j].slots[l].name));
                            slotName.setAttribute('class', 'slotName');
                            comp.appendChild(slotName);
                            // Adds slot description
                            var slotType = document.createElement("p");
                            slotType.appendChild(document.createTextNode(data.components[j].slots[l].docs));
                            comp.appendChild(slotType);
                        }

                    } else {
                        // if entries can't be found the for loop will continue looping
                        i + 1
                    }
                }
            }
        }
    });


    $('.props').on('click', '.more-btn, .less-btn', function () {
        $(this).parent().toggleClass('open');
    });

    $('.see-demo, .close-banner').on('click', function () {
        $('.demo-banner').toggleClass('open');
    });
});
