define(['jquery'], function ($) {
    return function () {
        // Interchanges more or less text on
        $('.main_menu__link').on('click', function() {
            if ( !$('#more').is(":checked") ) {
                $(this).text(lmsg('main_menu.progressive_collapse.collapse')).addClass('after');
            } else {
                $(this).text(lmsg('main_menu.progressive_collapse.expand')).removeClass('after');
            }
        });

        // Checks the total width of all list items
        function checkMenuWidth() {
            var totalMenuItemWidth = 0;
            $(".main_menu__list > li").each(function(){
                totalMenuItemWidth += $(this).outerWidth()
            });
            return totalMenuItemWidth;
        }

        // Finds last item in main menu
        var lastMenuItem = $('.main_menu__list > li').last();

        // Removes Progressive Menu button if needed
        function removeProgressiveToggle(listItemsWidth){

            // Allows for the 'more' button when calculating the difference between width of all list items and the wrapper
            var menuWrapperWidth = ($('.main_menu__inner').outerWidth() - 80);

            if (listItemsWidth < menuWrapperWidth) {
                $('.main_menu__link').addClass('hide').removeClass('show');
                // If the last menu item submenu can overflow it will be pulled left
                lastMenuItem.children('ul').css('margin-left', -lastMenuItem.outerWidth());
            } else {
                $('.main_menu__link').addClass('show').removeClass('hide');
                // Makes sure last menu item submenu doesn't pull to the left if it falls into the 'More' menu
                lastMenuItem.children('ul').attr('style', '');
            }
        }

        removeProgressiveToggle(checkMenuWidth());

        $( window ).on('resize', function() {
            removeProgressiveToggle(checkMenuWidth());
        })
    };
});
