<?php
namespace Claromentis\Console\Util;

$GLOBALS["__c64c9131dd01a7eb495d1a4f8a434" . "387"] = (@$GLOBALS["__c64c9131dd01a7eb495d1a4f8a43438" . "7"] ?: array()) + array("_5bcefc1eff68a2aa6ab8f3569" . "9a56d08" => base64_decode("RGF0YWJhc2UgaXMgbm90IGF2YWlsYWJ" . "sZTog"), "_3e09962b663b985bf8c2" . "60ac2e95edc0" => base64_decode("Y2" . "9y" . "ZQ" . "=="), "_7b2ca9a1" . "05acfcc08" . "8d2c15bfe" . "6458b6" => base64_decode("Q29yZSBpcyBub3QgaW5zdGFsbG" . "Vk"), "_9636e445f" . "beaa4bbfe5" . "694ed532de" . "0b1" => base64_decode("RGF0YWJhc2UgcGVybWl" . "zc2lvbnMgaW5zdWZmaW" . "NpZW50"), "_1094b976516d8df540" . "67d448e66e0297" => base64_decode("RGF0YWJhc2UgaXMgYX" . "ZhaWxhYmxl"), "_4c93d4c40f7ab1a488c387f7f91a6" . "496" => base64_decode("Q2hlY2tpbmcgaW5zdGF" . "sbGF0aW9uLi4u"), "_9810a2810274128200cb2" . "4f15909a3f2" => base64_decode("Q2hlY2tpbmcgZGF0YWJhc2UgcG" . "VybWlzc2lvbnMuLi4="), "_77713ce23" . "683636d057" . "3408c9a0d0" . "ddb" => base64_decode("RGF0YWJhc2UgcGVybWlzc2l" . "vbnMgYXJlIGFkZXF1YXRl"), "_a70083b91f8d" . "3b0237061e068" . "26958e8" => base64_decode("Q2hlY2tpbmcgZGF0YWJhc2UgYXZhaWxhY" . "mlsaXR5Li4u"));
use Claromentis\Core\Config\Config;
use Claromentis\Core\DAL\DbFactory;
use Claromentis\Setup\Exception\NotInstalledException;
use Claromentis\Setup\Task\DatabaseCheck;
use Psr\Log\LoggerAwareInterface;
use Psr\Log\LoggerAwareTrait;
use Psr\Log\NullLogger;
use RuntimeException;




class InstallationChecker implements LoggerAwareInterface
{
    use LoggerAwareTrait;
    
    
    
    
    protected $config;
    
    
    
    
    protected $factory;
    
    
    
    
    protected $locator;
    
    
    
    
    protected $registry;
    
    
    
    
    
    
    
    
    
    public function __construct(Config $_fd33b1a14db9a1eccfaaa3cb67b5336e, DbFactory $_c8ef295ed962a46e6246480731bf7b99, Locator $_958a49c0e9814c5c29eb8698e3fb6de2, ApplicationRegistry $_decc0934e98116e3ae7588cf6db5d1ae)
    {
        $this->config = $_fd33b1a14db9a1eccfaaa3cb67b5336e;
        $this->factory = $_c8ef295ed962a46e6246480731bf7b99;
        $this->locator = $_958a49c0e9814c5c29eb8698e3fb6de2;
        $this->registry = $_decc0934e98116e3ae7588cf6db5d1ae;
        $this->setLogger(new NullLogger());
    }
    
    
    
    
    
    
    public function isInstalled()
    {
        try {
            $this->logger->info($GLOBALS["__c64c9131dd01a7eb495d1a4f8" . "a434387"]["_4c93d4c40f7ab1a488c387f7f91a649" . "6"]);
            $this->verifyInstalled();
        } catch (\Exception $_c35473364fa7a050299058f332ec29c1) {
            return false;
        }
        return true;
    }
    
    
    
    
    
    
    public function checkDatabaseConnection()
    {
        try {
            $this->logger->info($GLOBALS["__c64c9131dd0" . "1a7eb495d1a4f" . "8a434387"]["_a70083b91f8d3b02370" . "61e06826958e8"]);
            $this->verifyDatabaseConnection();
            $this->logger->debug($GLOBALS["__c64c9131dd01a7eb495d1a4f8a43" . "4387"]["_1094b976516d8df54067d448" . "e66e0297"]);
        } catch (\Exception $_c35473364fa7a050299058f332ec29c1) {
            
            
            
            $this->logger->info($GLOBALS["__c64c9131dd01a7eb495d1a4f8a" . "434387"]["_5bcefc1eff68a2aa6ab8f35699a5" . "6d08"] . $_c35473364fa7a050299058f332ec29c1->getMessage());
            return false;
        }
        return true;
    }
    
    
    
    
    
    
    public function checkDatabasePermissions()
    {
        try {
            $this->logger->info($GLOBALS["__c64c9131dd01a7eb495d1a4f" . "8a434387"]["_9810a28102741" . "28200cb24f1590" . "9a3f2"]);
            $this->verifyDatabasePermissions();
            $this->logger->debug($GLOBALS["__c64c9131dd01a7eb495d1a4f8a43438" . "7"]["_77713ce23683" . "636d0573408c9" . "a0d0ddb"]);
        } catch (\Exception $_c35473364fa7a050299058f332ec29c1) {
            
            
            return false;
        }
        return true;
    }
    
    
    
    
    
    
    
    public function verifyInstalled()
    {
        $this->verifyDatabaseConnection();
        $this->verifyDatabasePermissions();
        if (!$this->registry->isInstalled($GLOBALS["__c64c9131dd01a7eb495d1a4f8" . "a434387"]["_3e09962b663b985bf8c260a" . "c2e95edc0"])) {
            throw new NotInstalledException($GLOBALS["__c64c9131dd01a7eb495d1a4f8a" . "434387"]["_7b2ca9a105acfcc088d2" . "c15bfe6458b6"]);
        }
    }
    
    
    
    
    
    
    
    public function verifyDatabaseConnection()
    {
        
        
        $_4504853ce5094b088c8bdc3d570a0a5d = $this->getDatabase();
        
        
        $this->registry->setDatabase($_4504853ce5094b088c8bdc3d570a0a5d);
    }
    
    
    
    
    
    
    
    public function verifyDatabasePermissions()
    {
        $_4504853ce5094b088c8bdc3d570a0a5d = $this->getDatabase();
        $_58bc0ced402c33be307fe4d3d5433ed1 = new DatabaseCheck($this->config, $_4504853ce5094b088c8bdc3d570a0a5d);
        $_58bc0ced402c33be307fe4d3d5433ed1->setLogger($this->logger);
        if (!$_58bc0ced402c33be307fe4d3d5433ed1->Check()) {
            foreach ($_58bc0ced402c33be307fe4d3d5433ed1->GetErrors() as $_ba3845cb79c005cf3269af8c83ddbe5e) {
                $this->logger->error($_ba3845cb79c005cf3269af8c83ddbe5e);
            }
            throw new RuntimeException($GLOBALS["__c64c9131dd01a7eb4" . "95d1a4f8a434387"]["_9636e445fbeaa4bbfe5694ed532de0" . "b1"]);
        }
    }
    
    
    
    
    
    
    
    protected function getDatabase()
    {
        return $this->factory->GetInstanceFromConfig($this->config);
    }
}