function blog_subscribe(channel_id, element)
{
	jQuery.ajax({
		url: '/intranet/rest/blog/subscription/' + channel_id,
		type: 'PUT',
		data: '',
		success: function() {
			jQuery(element).data('is-subscribed', 1);
			blog_show_subscription_status(element);
			cla.showMessage(lmsg("blog.channel.subscription_changed"), lmsg("blog.channels.subscribed"));
		}
	});
}

function blog_unsubscribe(channel_id, element)
{
	jQuery.ajax({
		url: '/intranet/rest/blog/subscription/' + channel_id,
		type: 'DELETE',
		data: '',
		success: function() {
			jQuery(element).data('is-subscribed', 0);
			blog_show_subscription_status(element);
			cla.showMessage(lmsg("blog.channel.subscription_changed"), lmsg("blog.channels.unsubscribed"));
		}
	});
}

function blog_show_subscription_status(element)
{
	if (jQuery(element).data('is-subscribed'))
	{
		jQuery('.js-subscribed-link', element).show();
		jQuery('.js-notsubscribed-link', element).hide();
	} else
	{
		jQuery('.js-subscribed-link', element).hide();
		jQuery('.js-notsubscribed-link', element).show();
	}
}

function blog_toggle_subscription(element)
{
	var channel_id = jQuery(element).data('channel-id');
	if (jQuery(element).data('is-subscribed'))
	{
		blog_unsubscribe(channel_id, element);
	} else
	{
		blog_subscribe(channel_id, element);
	}
	return false;
}

jQuery(function (){
	jQuery('.subscription_link').click(function (event) {
		var element = event.currentTarget;
		event.preventDefault();
		blog_toggle_subscription(element);
	}).each(function (idx, el) { blog_show_subscription_status(el); });
});
