//////////////////////////////////////////////////////////////////////
// Do NOT change this file!
// Put all custom settings into a new file named
//    ckconfig_custom.js
//
// The CKEditor config files are loaded in this order:
//   1. ckconfig.js
//   2. ckconfig_custom.js
//   3. ckconfig_{application}.js
//   4. ckconfig_{application}_custom.js
//////////////////////////////////////////////////////////////////////
if (typeof ck_application === 'undefined')
    ck_application = '';
config.filebrowserBrowseUrl =      '/lib/ckfinder/ckfinder.html?application='+ck_application;
config.filebrowserImageBrowseUrl = '/lib/ckfinder/ckfinder.html?application='+ck_application; // '/lib/ckfinder/ckfinder.html?type=Images';
config.filebrowserFlashBrowseUrl = '/lib/ckfinder/ckfinder.html?application='+ck_application;
config.filebrowserUploadUrl =      '/lib/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files&application='+ck_application;
config.filebrowserImageUploadUrl = '/lib/ckfinder/core/connector/php/connector.php?command=QuickUpload&type=Files&application='+ck_application;
config.filebrowserVideoBrowseUrl = '/lib/ckfinder/ckfinder.html?application='+ck_application;

config.extraPlugins = 'video,youtube,mediaembed,imagemaps,googlemaps,iframe,clafontsize';
config.autoParagraph = false;
config.forcePasteAsPlainText = true;

// Prevents CKE4 from removing certain HTML elements and attributes tag(classes)[attributes]{styles}
config.extraAllowedContent = 'video(*)[*]{*};source[*]{*};map[*]{*};area[*]{*};img[usemap];iframe[*]{*};link[*];';

config.toolbar_Full =
[
    { name: 'document',    items : [ 'Source','-','Save','Preview','Print','-','Templates' ] },
    { name: 'clipboard',   items : [ 'Cut','Copy','Paste','PasteText','PasteFromWord','-','Undo','Redo' ] },
    { name: 'editing',     items : [ 'Find','Replace'/*,'-','SpellChecker', 'Scayt'*/ ] },
    { name: 'links',       items : [ 'Link','Unlink','Anchor' ] },
/*    { name: 'forms',       items : [ 'Form', 'Checkbox', 'Radio', 'TextField', 'Textarea', 'Select', 'Button', 'ImageButton', 'HiddenField' ] }, */
    '/',
    { name: 'basicstyles', items : [ 'Bold','Italic','Underline','Strike','Subscript','Superscript','-','RemoveFormat' ] },
    { name: 'paragraph',   items : [ 'NumberedList','BulletedList','-','Outdent','Indent','-','Blockquote','CreateDiv','-','JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock'] },
    { name: 'insert',      items : [ 'Image', 'ImageMaps','Flash','Video','Youtube','MediaEmbed','Table','HorizontalRule','Smiley','SpecialChar','PageBreak', 'GoogleMaps' ] },
    '/',
    { name: 'styles',      items : [ 'Styles','Format','Font','clafontsize','TextColor','BGColor' ] },
    { name: 'tools',       items : [ 'Maximize', 'ShowBlocks'/*,'-','About'*/ ] }
];

config.toolbar_Basic =
[
    { name: 'document',    items : [ 'Source', 'Paste','PasteText','PasteFromWord','-','Undo','Redo' ] },
    { name: 'paragraph',   items : [ 'NumberedList','BulletedList','-','Outdent','Indent','-','Blockquote','-','JustifyLeft','JustifyCenter','JustifyRight','JustifyBlock'] },
    '/',
    { name: 'basicstyles', items : [ 'Bold','Italic','Underline','Strike','Subscript','Superscript','-','RemoveFormat' ] },
    { name: 'links',       items : [ 'Link','Unlink', 'Table','HorizontalRule' ] },
    { name: 'styles',      items : [ 'Format','Font','clafontsize', 'TextColor','BGColor' ] }
];

config.toolbar = 'Full';