@javascript @core @communication
Feature: Verify communication messages read and delete status are correctly handled across users.

  Background:
    Given I am on a Claromentis site
    And the following people exist:
      | username | password | surname  | firstname | email                | manager  |
      | manager1 | password | Manager1 | Dave1     | manager1@example.com |          |
      | project1 | password | Project1 | Maggie1   | project1@example.com |          |
      | user1    | password | User1    | Bob1      | user1@example.com    | manager1 |
      | user2    | password | User2    | Bob2      | user2@example.com    | manager1 |
      | user3    | password | User3    | Bob3      | user3@example.com    | manager1 |
    And the following "user" messages exist:
      | sender   | receiver    | subject         | date               | message |
      | user1    | user2       | Bananas         | 14:10 Jan 2nd 2019 | Did you know bananas are a herb?               |
      | user2    | user1       | Bananas         | 14:11 Jan 2nd 2019 | Shut. Up.                                      |
      | user1    | user2       | Bananas         | 14:12 Jan 2nd 2019 | It's true.                                     |
      | user2    | user1       | Bananas         | 14:13 Jan 2nd 2019 | [Slams front door]                             |
      | user1    | user2       | Tomatoes        | 14:14 Jan 2nd 2019 | Did you know tomatoes are a fruit?             |
      | admin    | user1,user2 | Login Passwords | 16:08 Jan 3rd 2019 | Please remember to reset your login passwords. |
      | user1    | admin,user2 | Login Passwords | 09:14 Jan 4th 2019 | Remind me why we're doing this again...?       |
      | admin    | user1,user2 | Login Passwords | 09:18 Jan 4th 2019 | Bob2 wrote his password on a post-it and left it on the fridge. |
      | user1    | admin,user2 | Login Passwords | 10:26 Jan 5th 2019 | Great idea! How embarrassing! Haha.            |
      | user2    | user1,admin | Login Passwords | 10:31 Jan 5th 2019 | I swear it wasn't me.                          |
      | admin    | user1,user2 | Login Passwords | 10:33 Jan 5th 2019 | We're resetting password as a precaution.      |
    And the following "user" messages exist:
      | sender   | receiver                | subject          | date                | message |
      | project1 | manager1,user1,user2    | Prototype update | 10:15 Jan 10th 2019 | Hi Dave1. Any news on the Communication prototype?                 |
      | manager1 | project1,user1,user2    |                  | 10:30 Jan 10th 2019 | Yes, one of the Bobs was working on it. I get an update.           |
      | user1    | manager1,project1,user2 |                  | 10:40 Jan 10th 2019 | Just sent it over.                                                 |
      | project1 | manager1,user1,user2    |                  | 11:25 Jan 11th 2019 | Great, thanks. Give me half and hour to look over it.              |
      | project1 | manager1,user1,user2    |                  | 11:50 Jan 11th 2019 | Looks great. Let's look at more options with the team.             |
      | manager1 | project1,user1,user2    |                  | 11:55 Jan 11th 2019 | Good idea.                                                         |
      | user1    | manager1,project1,user2 |                  | 12:00 Jan 11th 2019 | I had another idea about and improvement for the bobbins.          |
      | user1    | manager1,project1,user2 |                  | 12:05 Jan 11th 2019 | https://thisissomething.com                                        |
      | user2    | manager1,project1,user1 |                  | 12:20 Jan 11th 2019 | I was thinking about that too. I've got a slightly different idea. |
      | manager1 | project1,user1,user2    |                  | 12:30 Jan 11th 2019 | Great work guys. Let's discuss in the meeting later.               |

  Scenario: Verify a user can only see messages they are participating in.

    Given I login as user "user1" with password "password"
    When I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"
    And I should see message preview "Great work guys. Let's discuss in the meeting late..." is shown as "unread"
    And I should see message preview "We're resetting password as a precaution." is shown as "unread"
    And I should see message preview "Did you know tomatoes are a fruit?" is shown as "sent"
    And I logout

    When I login as user "user2" with password "password"
    And I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"
    And I should see message preview "Great work guys. Let's discuss in the meeting late..." is shown as "unread"
    And I should see message preview "We're resetting password as a precaution." is shown as "unread"
    And I should see message preview "Did you know tomatoes are a fruit?" is shown as "unread"
    And I logout

    When I login as an admin user
    And I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"
    And I should see message preview "We're resetting password as a precaution." is shown as "sent"
    But I should not see "Did you know tomatoes are a fruit?"
    And I should not see "Great work guys. Let's discuss in the meeting late..."
    And I logout

    When I login as user "user3" with password "password"
    And I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"
    And I should see "No messages found"
    But I should not see "Did you know tomatoes are a fruit?"
    And I should not see "We're resetting password as a precaution."
    And I should not see "Great work guys. Let's discuss in the meeting late..."
    And I logout

  Scenario: Verify when a user reads a message it affects only their message read status.

    Given I login as user "user1" with password "password"
    When I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"
    And I should see message preview "Great work guys. Let's discuss in the meeting late..." is shown as "unread"
    And I should see message preview "We're resetting password as a precaution." is shown as "unread"
    And I should see message preview "Did you know tomatoes are a fruit?" is shown as "sent"

    When I follow "We're resetting password as a precaution."
    Then I should see partial user message thread:
      | name                      | date         | message                                   |
      | Claromentis Administrator | Jan 5th 2019 | We're resetting password as a precaution. |

    When I move backward one page
    And I reload the page
    Then I should see message preview "Great work guys. Let's discuss in the meeting late..." is shown as "unread"
    And I should see message preview "We're resetting password as a precaution." is shown as "read"
    And I should see message preview "Did you know tomatoes are a fruit?" is shown as "sent"
    And I logout

    When I login as user "user2" with password "password"
    And I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"
    And I should see message preview "Great work guys. Let's discuss in the meeting late..." is shown as "unread"
    And I should see message preview "We're resetting password as a precaution." is shown as "unread"
    And I should see message preview "Did you know tomatoes are a fruit?" is shown as "unread"
    And I logout

    When I login as an admin user
    And I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"
    And I should see message preview "We're resetting password as a precaution." is shown as "sent"
    And I logout

  Scenario: Verify when a user marks a message as archived it affects only their message delete status.

    Given I login as user "user1" with password "password"
    When I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"
    And I should see message preview "Great work guys. Let's discuss in the meeting late..." is shown as "unread"
    And I should see message preview "We're resetting password as a precaution." is shown as "unread"
    And I should see message preview "Did you know tomatoes are a fruit?" is shown as "sent"

    When I click element with "//input[@name='selected[]']"
    And I press "Archive Selected"
    And I click element with "#confirm-table-delete" using jQuery
    Then I should see "Your message has been marked as archived"
    And I should see message preview "We're resetting password as a precaution." is shown as "unread"
    And I should see message preview "Did you know tomatoes are a fruit?" is shown as "sent"
    But I should not see "Great work guys. Let's discuss in the meeting late..."
    And I logout

    When I login as user "user2" with password "password"
    And I open the modules menu
    And I follow "Communication"
    Then I should see "Messages"
    And I should see message preview "Great work guys. Let's discuss in the meeting late..." is shown as "unread"
    And I should see message preview "We're resetting password as a precaution." is shown as "unread"
    And I should see message preview "Did you know tomatoes are a fruit?" is shown as "unread"
    And I logout
