@javascript @core @communication
Feature: Verify communication messages notifications.

  Background:
    Given I am on a Claromentis site
    And the following people exist:
      | username | password | surname  | firstname | email                | manager  |
      | manager1 | password | Manager1 | Dave1     | manager1@example.com |          |
      | project1 | password | Project1 | Maggie1   | project1@example.com |          |
      | user1    | password | User1    | Bob1      | user1@example.com    | manager1 |
      | user2    | password | User2    | Bob2      | user2@example.com    | manager1 |
      | user3    | password | User3    | Bob3      | user3@example.com    | manager1 |
      | user4    | password | User4    | Bob4      | user4@example.com    |          |
      | user5    | password | User5    | Bob5      | user5@example.com    |          |

  Scenario: Verify when a user sends a message the recipients receive a notification.

    Given I login as an admin user
    When I open the modules menu
    And I follow "Communication"
    And I pause for a second
    Then I should see "Messages"

    When I click element with "#compose-message"
    And I pause for a second
    And I click element with "Browse" to open a window and click the following:
      | Bob1 User1 |
      | Bob2 User2 |
    And I fill in "Subject" with "British Eurovision Winners"
    And I fill in field "new_message_text" with rich content:
    """
    <p>The best ones are, of course, Bucks Fizz.</p>
    """
    And I press "Send"
    Then I should see "Your message was sent"
    And I should see "Bob2" in the ".users" element
    And the "subject" field should contain "British Eurovision Winners"
    And I should see user message thread:
      | name       | subject                    | date  | message                                   |
      |            | British Eurovision Winners | today | The best ones are, of course, Bucks Fizz. |
    And I am on "/intranet/communication/messages.php"
    And I logout

    When I login as user "user1" with password "password"
    And I open the notifications menu
    Then I should see "You have 1 new message"
    And I should see a "communication" notification from "Claromentis Administrator" with subject "British Eurovision Winners" containing:
    """
    <p>The best ones are, of course, Bucks Fizz.</p>
    """

    When I follow "View message thread"
    Then I should see "Messages"
    And the "subject" field should contain "British Eurovision Winners"
    And I should see user message thread:
      | name                      | subject                    | date  | message                                   |
      | Claromentis Administrator | British Eurovision Winners | today | The best ones are, of course, Bucks Fizz. |
    And I am on "/intranet/communication/messages.php"
    And I logout

    When I login as user "user2" with password "password"
    And I open the notifications menu
    Then I should see "You have 1 new message"
    And I should see a "communication" notification from "Claromentis Administrator" with subject "British Eurovision Winners" containing:
    """
    <p>The best ones are, of course, Bucks Fizz.</p>
    """

    When I follow "View message thread"
    Then I should see "Messages"
    And the "subject" field should contain "British Eurovision Winners"
    And I should see user message thread:
      | name                      | subject                    | date  | message                                   |
      | Claromentis Administrator | British Eurovision Winners | today | The best ones are, of course, Bucks Fizz. |
    And I am on "/intranet/communication/messages.php"
    And I logout

  Scenario: Verify when a user can creates a calendar event notification they can start a conversation from it.

    Given I login as user "user1" with password "password"
    When I open the calendar
    And I click element with ".fc-today"
    And I follow "More options"
    Then I should see "Add/Edit event"

    When I fill in "Name" with "Meeting 1"
    And I fill in "Description" with "This is a description of Meeting 1"
    And I press "Add user"
    Then I should see "Pick user"

    When I check element "#pu_keyword_0" exists
    And I fill in "Keyword" with "User"
    Then I wait to see "Bob2 User2"

    When I select "Bob2 User2" from "pu_select_0"
    And I additionally select "Bob3 User3" from "pu_select_0"
    And I press "Add selected"
    And I press "Submit"
    Then I wait to see "Event saved successfully"
    And I wait to see "Meeting 1"
    And I am on "/intranet/communication/messages.php"
    And I logout

    When I login as user "user2" with password "password"
    And I open the notifications menu
    Then I should see "You have 1 new message"
    And I should see a "calendar" notification from "Bob1 User1" with subject "Calendar Event Invitation: Meeting 1 @ [[DATE('j F Y')]]"

    When I follow "Forward"
    And I wait to see "Compose New Message"
    And I press "Send"
    Then I should see "Your message was sent"
    And I should see user message thread:
      | name | date  | message part                                                                             |
      |      | today | Meeting 1 This is a description of Meeting 1 Time: [[DATE('j F Y')]] - [[DATE('j F Y')]] |
    And I am on "/intranet/communication/messages.php"
    And I logout

    When I login as user "user3" with password "password"
    And I open the notifications menu
    Then I should see "You have 1 new message"
    And I should see a "calendar" notification from "Bob1 User1" with subject "Calendar Event Invitation: Meeting 1 @ [[DATE('j F Y')]]"

    When I follow "Forward"
    And I wait to see "Compose New Message"
    And I press "Send"
    Then I should see "Your message was sent"
    And I should see user message thread:
      | name | date  | message part                                                                             |
      |      | today | Meeting 1 This is a description of Meeting 1 Time: [[DATE('j F Y')]] - [[DATE('j F Y')]] |
    And I am on "/intranet/communication/messages.php"
    And I logout

    When I login as user "user4" with password "password"
    And I open the notifications menu
    And I pause for a second
    Then I should see "No messages"
    And I logout

  Scenario: Verify a user can send a notification to a group a recipient can respond with a quoted message.

    Given the following user groups exist:
      | name    | parent  |
      | Group 1 |         |
    And the following users are assigned to these groups:
      | username | group   |
      | user1    | Group 1 |
      | user2    | Group 1 |
      | user3    | Group 1 |
      | user4    | Group 1 |
      | user5    | Group 1 |
    When I login as an admin user
    And I am on "/intranet/communication/admin.php"
    And I set permissions for "User: Bob1 User1"
    And I press "Apply permissions"
    Then I should see "Permissions Updated"
    And I am on "/intranet/communication/messages.php"
    And I logout

    When I login as user "user1" with password "password"
    And I open the modules menu
    And I follow "Communication"
    And I pause for a second
    Then I should see "Messages"

    When I click element with "#compose-message"
    And I wait to see "Compose New Message"
    And I press "Notification" radio button
    And I click element with "#pd_button_add" using jQuery
    And I switch windows
    And I click element with "//select//option[text()='Group 1']"
    And I press "Add"
    And I close the window
    And I switch windows
    And I fill in "Subject" with "Company Announcement"
    And I fill in field "new_message_text" with rich content:
    """
    <p>Unfortunately, due to cuts, the company will no longer provide biscuits.</p>
    """
    And I press "Send"
    Then I should see "Your message was sent"
    And I am on "/intranet/communication/messages.php"
    And I logout

    When I login as user "user2" with password "password"
    And I open the notifications menu
    Then I should see "You have 1 new message"
    And I should see a "communication" notification from "Bob1 User1" with subject "Company Announcement"

    When I open the modules menu
    And I follow "Communication"
    Then I should see "No messages found"

    When I am on "/intranet/communication/imessageread.php"
    And I follow "Company Announcement"
    And I follow "Forward"
    And I wait to see "Compose New Message"
    And I press "Send"
    Then I should see "Your message was sent"
    And the "subject" field should contain "Company Announcement"
    And I should see partial user message thread:
      | name | date  | message part                                                                  |
      |      | today | Unfortunately, due to cuts, the company will no longer provide biscuits. |

  Scenario: Verify a user can send a notification to their team and a team member can respond with a quotes message.

    Given I login as an admin user
    When I am on "/intranet/communication/admin.php"
    And I set permissions for "User: Dave1 Manager1"
    And I press "Apply permissions"
    Then I should see "Permissions Updated"
    And I am on "/intranet/communication/messages.php"
    And I logout

    When I login as user "manager1" with password "password"
    And I open the modules menu
    And I follow "Communication"
    And I pause for a second
    Then I should see "Messages"

    When I click element with "#compose-message"
    And I wait to see "Compose New Message"
    And I press "Notification" radio button
    And I click element with "#my-team" using jQuery
    And I fill in "Subject" with "Company Announcement"
    And I fill in field "new_message_text" with rich content:
    """
    <p>Unfortunately, due to cuts, the company will no longer provide paper-clips.</p>
    """
    And I press "Send"
    Then I should see "Your message was sent"
    And I am on "/intranet/communication/messages.php"
    And I logout

    When I login as user "user2" with password "password"
    And I open the notifications menu
    Then I should see "You have 1 new message"
    And I should see a "communication" notification from "Dave1 Manager1" with subject "Company Announcement"

    When I open the modules menu
    And I follow "Communication"
    Then I should see "No messages found"

    When I am on "/intranet/communication/imessageread.php"
    And I follow "Company Announcement"
    And I follow "Forward"
    And I wait to see "Compose New Message"
    And I press "Send"
    Then I should see "Your message was sent"
    And the "subject" field should contain "Company Announcement"
    And I should see partial user message thread:
      | name | date  | message part                                                                |
      |      | today | Unfortunately, due to cuts, the company will no longer provide paper-clips. |
