<?php
namespace Claromentis\Core\Acl\Simple;

$GLOBALS["__46425aa948c9932e4711e9e2f3c" . "6c52b"] = (@$GLOBALS["__46425aa948c9932e4711e9e2f3c" . "6c52b"] ?: array()) + array("_aed8da0f19091214b" . "78f80351048517c" => base64_decode("c3RybG" . "Vu"), "_c244a470df52d1d5a7085138e" . "c94e393" => base64_decode("dW5zZ" . "XJpYW" . "xpemU" . "="), "_d706c160e45bf74" . "34fff82a5976f0e1" . "9" => base64_decode("YXJyYXlfa2V5cw=" . "="), "_70809333a0f" . "254acf7a1ad0" . "c7dadd46b" => base64_decode("OiA" . "="), "_2b97c0ca1bb9e70cb77f4fbf2e523d8" . "d" => base64_decode("Q2FuJ3QgZGVsZXRlIHBlcm1pc3Npb246IHVzZXIgSU" . "QgaXMgbm90IHNwZWNpZmllZA=="), "_7f628626dd1d55c71" . "b1fc0932ffd1d2c" => base64_decode("aXNfYXJ" . "yYXk="), "_7e4946b30c25f9bccba6f7509" . "50330de" => base64_decode("Q2FuJ3QgZ2V0IHBlcm1pc" . "3Npb25zOiB1c2VyIElEIG" . "lzIG5vdCBzcGVjaWZpZWQ" . "="), "_96be32a6f44bf54e635e1736acf" . "7a96c" => base64_decode("c2VyaWFsaX" . "pl"));
use Claromentis\Core\Acl\Exception\InvalidSubjectException;
use Claromentis\Core\Acl\PermOClass;






class SimpleAcl
{
    const STANDARD = 1;
    protected $object_code;
    protected $rights;
    
    
    
    
    
    
    public function __construct(string $_65c616d6ef3c21352d2d44595fdf776b = '')
    {
        $this->object_code = $_65c616d6ef3c21352d2d44595fdf776b;
        $this->Clear();
    }
    public function SetObjectCode(string $_65c616d6ef3c21352d2d44595fdf776b)
    {
        $this->object_code = $_65c616d6ef3c21352d2d44595fdf776b;
    }
    public function GetObjectCode() : string
    {
        return $this->object_code;
    }
    
    
    
    
    public function Clear()
    {
        $this->Hydrate(array());
    }
    
    
    
    
    
    
    public function Hydrate(array $rights)
    {
        $this->rights = $rights;
    }
    
    
    
    
    
    
    
    
    
    public function Grant(int $user_id, int $perms = self::STANDARD)
    {
        if (empty($perms)) {
            return true;
        }
        if (!isset($this->rights[$user_id])) {
            $this->rights[$user_id] = $perms;
        } else {
            $this->rights[$user_id] |= $perms;
        }
        return true;
    }
    
    
    
    
    
    
    
    
    
    public function Permits(int $user_id, int $perms = 0)
    {
        if ($perms === 0) {
            return !empty($this->rights[$user_id]);
        }
        $p = $this->Get($user_id);
        return $p & $perms == $perms;
    }
    
    
    
    
    
    
    
    
    
    public function Set(int $user_id, int $perms = self::STANDARD)
    {
        if (empty($perms)) {
            unset($this->rights[$user_id]);
        } else {
            $this->rights[$user_id] = $perms;
        }
        return true;
    }
    
    
    
    
    
    
    
    public function SetMany(array $_5882c836e9757b405d08e77f1fd2a18b, int $perms = self::STANDARD)
    {
        foreach ($_5882c836e9757b405d08e77f1fd2a18b as $user_id) {
            $this->Set($user_id, $perms);
        }
    }
    
    
    
    
    
    
    
    
    public function Get(int $user_id) : int
    {
        if (empty($user_id)) {
            throw new InvalidSubjectException($GLOBALS["__46425aa948c9932e4711e9e2f3c6" . "c52b"]["_7e4946b" . "30c25f9b" . "ccba6f75" . "0950330d" . "e"]);
        }
        if (!isset($this->rights[$user_id])) {
            return 0;
        }
        return $this->rights[$user_id];
    }
    
    
    
    
    
    
    
    public function Delete(int $user_id, int $perms = 0)
    {
        if (empty($user_id)) {
            throw new InvalidSubjectException($GLOBALS["__46425aa948c9932e4711e9e2f3c6c5" . "2b"]["_2b97c0c" . "a1bb9e70" . "cb77f4fb" . "f2e523d8" . "d"]);
        }
        if ($perms === 0) {
            unset($this->rights[$user_id]);
        }
        $this->Set($this->Get($user_id) & ~$perms, $user_id);
    }
    
    
    
    
    
    
    
    
    public function CreateCopy(string $_65c616d6ef3c21352d2d44595fdf776b) : SimpleAcl
    {
        $acl = new SimpleAcl($_65c616d6ef3c21352d2d44595fdf776b);
        $acl->Hydrate($this->GetRights());
        return $acl;
    }
    
    
    
    
    
    
    
    
    public function GetRights(int $perms = 0) : array
    {
        if ($perms === 0) {
            return $this->rights;
        }
        $_1f24efd4735b7a11b391147435e7d35d = [];
        foreach ($this->rights as $user_id => $p) {
            if (($p & $perms) == $perms) {
                $_1f24efd4735b7a11b391147435e7d35d[$user_id] = $p;
            }
        }
        return $_1f24efd4735b7a11b391147435e7d35d;
    }
    
    
    
    
    
    
    
    
    public function GetIndividualsList(int $perms = 0)
    {
        if ($perms === 0) {
            return $GLOBALS["__46425aa948c9932e4711e9e2f" . "3c6c52b"]["_d706c160e45bf7434fff82a" . "5976f0e19"]($this->rights);
        }
        $_1f24efd4735b7a11b391147435e7d35d = [];
        foreach ($this->rights as $user_id => $p) {
            if (($p & $perms) == $perms) {
                $_1f24efd4735b7a11b391147435e7d35d[] = $user_id;
            }
        }
        return $_1f24efd4735b7a11b391147435e7d35d;
    }
    
    
    
    
    
    
    
    public function AsTextStrings() : array
    {
        $_a91f531562c56061228ba02b34c36a79 = [];
        $_5882c836e9757b405d08e77f1fd2a18b = $this->GetIndividualsList();
        foreach ($_5882c836e9757b405d08e77f1fd2a18b as $user_id) {
            $_a91f531562c56061228ba02b34c36a79[] = PermOClass::GetName(PermOClass::INDIVIDUAL) . $GLOBALS["__46425aa948c99" . "32e4711e9e2f3c6" . "c52b"]["_7080933" . "3a0f254a" . "cf7a1ad0" . "c7dadd46" . "b"] . \User::GetNameById($user_id);
        }
        return $_a91f531562c56061228ba02b34c36a79;
    }
    
    
    
    
    public function Serialize() : string
    {
        return $GLOBALS["__46425aa948c99" . "32e4711e9e2f3c6" . "c52b"]["_96be32a6f44bf54e635e1" . "736acf7a96c"]($this->rights);
    }
    
    
    
    
    public function Unserialize(string $_34460bffd3af92da81e46ee15e9e66e3)
    {
        if ($GLOBALS["__46425aa948c9932e4711e9e" . "2f3c6c52b"]["_aed8da0f19091214b78f8035104" . "8517c"]($_34460bffd3af92da81e46ee15e9e66e3) > 0) {
            $rights = $GLOBALS["__46425aa948c9932e4711e9e2f3c6" . "c52b"]["_c244a470" . "df52d1d5a" . "7085138ec" . "94e393"]($_34460bffd3af92da81e46ee15e9e66e3);
            if ($GLOBALS["__46425aa948c993" . "2e4711e9e2f3c6c5" . "2b"]["_7f628626dd1d55c71b1fc0932f" . "fd1d2c"]($rights)) {
                $this->Hydrate($rights);
            }
        }
    }
}