<?php
namespace Claromentis\Core\Admin;

$GLOBALS["__8e51e5290f422" . "8162ce1cf57ba14" . "26d4"] = (@$GLOBALS["__8e51e5290f4228162ce1cf57ba1426" . "d4"] ?: array()) + array();
use Claromentis\Core\Acl\Exception\AclException;
use Claromentis\Core\Acl\Simple\SimpleAcl;
use Claromentis\Core\Acl\Simple\SimpleAclRepository;
use Claromentis\Core\Security\SecurityContext;







trait SimpleAclTrait
{
    protected ?SimpleAcl $acl = null;
    protected ?SimpleAclRepository $acl_repo;
    
    
    
    
    public abstract function GetCode();
    public function SetAclRepository(?SimpleAclRepository $acl_repo) : void
    {
        $this->acl_repo = $acl_repo;
    }
    
    
    
    
    public function GetSimpleAcl() : SimpleAcl
    {
        if ($this->acl === null) {
            $this->acl = $this->acl_repo->Get($this->GetCode());
        }
        return $this->acl;
    }
    
    
    
    
    
    public function SetSimpleAcl(SimpleAcl $acl) : void
    {
        $this->acl = $acl;
        $this->acl_repo->Save($acl);
    }
    
    
    
    
    
    public function GetAdmins()
    {
        return $this->GetSimpleAcl()->GetIndividualsList();
    }
    
    
    
    
    
    
    public function IsAccessible(SecurityContext $context)
    {
        try {
            return $this->GetSimpleAcl()->Permits($context->GetUserId());
        } catch (AclException $e) {
            return false;
        }
    }
}