<?php
namespace Claromentis\Core\Filesystem;

$GLOBALS["__1d130a090d3a1ad900ac34d12317f6" . "2a"] = (@$GLOBALS["__1d130a090d3a1ad900ac34d1" . "2317f62a"] ?: array()) + array("_1f7075c649da9359" . "1cae2f4eb31f83fe" => base64_decode("RXJyb3Igd3JpdGluZy" . "BmaWxlIGZyb20gc3Ry" . "ZWFt"), "_18c93a32ba5faf9509389a94787" . "e6798" => base64_decode("bW9kaWZpZ" . "WQ="), "_8aa39710a39f226efce78e97c7b" . "cd786" => base64_decode("X" . "C" . "8" . "="), "_32b8fa1ca330a0685321a379" . "e5b9687d" => base64_decode("YmFzZ" . "W5hbW" . "U="), "_9463ea5f1a4c73607" . "f2c69eeee2b6ede" => base64_decode("RXJyb3IgZG" . "VsZXRpbmcg" . "ZmlsZQ=="), "_e134836f6369409efa4f2cad26" . "1365c8" => base64_decode("RXJyb3IgdXBkYXRp" . "bmcgZmlsZSBmcm9t" . "IHN0cmVhbQ=="), "_a67b2f1eec9b2bac90112c5" . "d6723ab41" => base64_decode("JHN0cmVhbSBtdXN0IGJlIGE" . "gcmVzb3VyY2U="), "_a606a2dcd236a549db" . "0574a9c1675927" => base64_decode("c" . "g" . "=" . "="), "_87daa84e346f6420a3f3426e05d16a7" . "b" => base64_decode("Lw" . "=="), "_554a9169138240019acb" . "d1502642f16a" => base64_decode("ZGlyb" . "mFtZQ" . "=="), "t" . "y" . "p" . "e" => base64_decode("dH" . "lw" . "ZQ" . "=="), "pat" . "h" => base64_decode("cGF0" . "aA=="), "s" . "i" . "z" . "e" => base64_decode("c2l" . "6ZQ" . "=="), "_563b15b92a77c8" . "69e85edf9569b4d" . "025" => base64_decode("ZmNsb3N" . "l"), "_c91b0ff19f81a8873a4593a23719472" . "c" => base64_decode("cn" . "Ry" . "aW" . "0="), "_5febae03" . "aa5407c29" . "1b5c61a87" . "2cc1fd" => base64_decode("aXNfc" . "mVzb3" . "VyY2U" . "="), "_01713acbc1c314b61bfbd8dc10" . "a810bd" => base64_decode("RXJyb3Igd3" . "JpdGluZyBm" . "aWxl"), "_e46a1b6a2fd927d616377ae1762" . "0d766" => base64_decode("dmlzaWJpbGl" . "0eQ=="), "_1cc5aa2f679b575f" . "82786a73f0da28f8" => base64_decode("c3RyZW" . "Ft"), "_6ae3783b9ad544a6c31a979683fed" . "870" => base64_decode("ZmlsZQ=" . "="), "_c4f3321d131869e51a8844b6bcd8fb" . "86" => base64_decode("Z" . "G" . "l" . "y"), "_6108a04b8350bfd2b7f2b23" . "65703eaec" => base64_decode("Zm9wZW" . "4="), "_f2646618c9dcad1" . "56a41241eacc4c3f" . "7" => base64_decode("Z2V0X3Jlc291cmNlX3" . "R5cGU="), "_9905761f4393d1" . "05cadfe7282a8c5" . "18d" => base64_decode("bWl" . "tZX" . "R5c" . "GU="), "_179055b98e140c4d418bcd5a903c7b7" . "c" => base64_decode("RXJyb3IgdXBkYXR" . "pbmcgZmlsZQ=="));
use BadMethodCallException;
use Claromentis\Core\Filesystem\Exception\FileExistsException;
use Claromentis\Core\Filesystem\Exception\FileNotFoundException;
use Claromentis\Core\Filesystem\Exception\FilesystemException;
use Exception;
use InvalidArgumentException;
use League\Flysystem;




class Filesystem implements FilesystemInterface
{
    
    
    
    
    
    
    protected Flysystem\FilesystemInterface $flysystem;
    
    
    
    
    
    
    protected string $charset;
    
    
    
    
    
    
    
    public function __construct(Flysystem\FilesystemInterface $_f623c94181cfb84b7b1ab3b650f57e44, string $_1ecc621b9902a7c9b8f2055fad2a3ead = 'UTF-8')
    {
        $this->flysystem = $_f623c94181cfb84b7b1ab3b650f57e44;
        $this->charset = $_1ecc621b9902a7c9b8f2055fad2a3ead;
    }
    
    
    
    
    public function Read(string $path) : string
    {
        try {
            return $this->flysystem->read($path);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function GetStream(string $path)
    {
        try {
            return $this->flysystem->readStream($path);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function WriteFromFile(string $path, string $_9211dd0bbcae0c7133030df599ff9ef5, array $config = []) : void
    {
        $_1cc5aa2f679b575f82786a73f0da28f8 = $GLOBALS["__1d130a090d3a1ad900ac34d1231" . "7f62a"]["_6108a04b8350bfd2b7f2b236570" . "3eaec"]($_9211dd0bbcae0c7133030df599ff9ef5, $GLOBALS["__1d130a090d3a1ad900" . "ac34d12317f62a"]["_a606a2dcd236a549db0574a9c16759" . "27"]);
        try {
            $this->WriteFromStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
        } finally {
            $this->CloseStream($_1cc5aa2f679b575f82786a73f0da28f8);
        }
    }
    
    
    
    
    public function WriteFromStream(string $path, $_1cc5aa2f679b575f82786a73f0da28f8, array $config = []) : void
    {
        if (!$GLOBALS["__1d130a090d3a1ad90" . "0ac34d12317f62a"]["_5febae03aa5407c291b5c61a872cc" . "1fd"]($_1cc5aa2f679b575f82786a73f0da28f8)) {
            throw new InvalidArgumentException($GLOBALS["__1d130a090d3a1ad900ac34d1" . "2317f62a"]["_a67b2f1eec9b2bac90112c5" . "d6723ab41"]);
        }
        try {
            $_1f24efd4735b7a11b391147435e7d35d = $this->flysystem->writeStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
        } catch (Flysystem\FileExistsException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileExistsException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
        if ($_1f24efd4735b7a11b391147435e7d35d === false) {
            throw new FilesystemException($GLOBALS["__1d130a090d3a1ad" . "900ac34d12317f62a"]["_1f7075c649da93591cae2f4eb31f" . "83fe"]);
        }
    }
    
    
    
    
    public function Write(string $path, string $_d34599daeb8cca374d3adb38b245839c, array $config = []) : void
    {
        try {
            $_1f24efd4735b7a11b391147435e7d35d = $this->flysystem->write($path, $_d34599daeb8cca374d3adb38b245839c, $config);
        } catch (Flysystem\FileExistsException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileExistsException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
        if ($_1f24efd4735b7a11b391147435e7d35d === false) {
            throw new FilesystemException($GLOBALS["__1d130a090d3a1ad900" . "ac34d12317f62a"]["_01713acbc1" . "c314b61bfbd" . "8dc10a810bd"]);
        }
    }
    
    
    
    
    public function UpdateFromFile(string $path, string $_9211dd0bbcae0c7133030df599ff9ef5, array $config = []) : void
    {
        $_1cc5aa2f679b575f82786a73f0da28f8 = $GLOBALS["__1d130a09" . "0d3a1ad900" . "ac34d12317" . "f62a"]["_6108a04b8350bfd2b7f" . "2b2365703eaec"]($_9211dd0bbcae0c7133030df599ff9ef5, $GLOBALS["__1d130a090d3a1ad900ac34d12317f62" . "a"]["_a606a2dcd236a54" . "9db0574a9c167592" . "7"]);
        try {
            $this->UpdateFromStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
        } finally {
            $this->CloseStream($_1cc5aa2f679b575f82786a73f0da28f8);
        }
    }
    
    
    
    
    public function UpdateFromStream(string $path, $_1cc5aa2f679b575f82786a73f0da28f8, array $config = []) : void
    {
        if (!$GLOBALS["__1d130a090d3a1ad900" . "ac34d12317f62a"]["_5febae03aa5407c" . "291b5c61a872cc1f" . "d"]($_1cc5aa2f679b575f82786a73f0da28f8)) {
            throw new InvalidArgumentException($GLOBALS["__1d130a090d3a1ad900ac34d" . "12317f62a"]["_a67b2f1eec9b2" . "bac90112c5d672" . "3ab41"]);
        }
        try {
            $_1f24efd4735b7a11b391147435e7d35d = $this->flysystem->updateStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
        if ($_1f24efd4735b7a11b391147435e7d35d === false) {
            throw new FilesystemException($GLOBALS["__1d130a090" . "d3a1ad900ac" . "34d12317f62" . "a"]["_e134836f6369409efa4f2cad2613" . "65c8"]);
        }
    }
    
    
    
    
    public function Update(string $path, string $_d34599daeb8cca374d3adb38b245839c, array $config = []) : void
    {
        try {
            $_1f24efd4735b7a11b391147435e7d35d = $this->flysystem->update($path, $_d34599daeb8cca374d3adb38b245839c, $config);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
        if ($_1f24efd4735b7a11b391147435e7d35d === false) {
            throw new FilesystemException($GLOBALS["__1d130a090d3a1ad" . "900ac34d12317f62a"]["_179055b98" . "e140c4d418" . "bcd5a903c7" . "b7c"]);
        }
    }
    
    
    
    
    public function PutFromFile(string $path, string $_9211dd0bbcae0c7133030df599ff9ef5, array $config = []) : void
    {
        try {
            if ($this->flysystem->has($path)) {
                $this->UpdateFromFile($path, $_9211dd0bbcae0c7133030df599ff9ef5, $config);
            } else {
                $this->WriteFromFile($path, $_9211dd0bbcae0c7133030df599ff9ef5, $config);
            }
        } catch (Exception $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function PutFromStream(string $path, $_1cc5aa2f679b575f82786a73f0da28f8, array $config = []) : void
    {
        try {
            if ($this->flysystem->has($path)) {
                $this->UpdateFromStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
            } else {
                $this->WriteFromStream($path, $_1cc5aa2f679b575f82786a73f0da28f8, $config);
            }
        } catch (Exception $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    public function Put(string $path, string $_d34599daeb8cca374d3adb38b245839c, array $config = []) : void
    {
        $_1f24efd4735b7a11b391147435e7d35d = $this->flysystem->put($path, $_d34599daeb8cca374d3adb38b245839c, $config);
        if ($_1f24efd4735b7a11b391147435e7d35d === false) {
            throw new FilesystemException($GLOBALS["__1d130a090d3a1ad900ac34d123" . "17f62a"]["_01713acbc1c314b61bfbd8dc10a81" . "0bd"]);
        }
    }
    
    
    
    
    public function Copy(string $path, string $_d074d7b344040d95fcad55b4694d9fec) : void
    {
        try {
            $this->flysystem->copy($path, $_d074d7b344040d95fcad55b4694d9fec);
        } catch (Flysystem\FileExistsException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileExistsException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        } catch (Exception $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function Rename(string $path, string $_d074d7b344040d95fcad55b4694d9fec) : void
    {
        if ($this->IsDir($path)) {
            $this->RenameDir($path, $_d074d7b344040d95fcad55b4694d9fec);
        } else {
            $this->RenameFile($path, $_d074d7b344040d95fcad55b4694d9fec);
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    public function RenameFile(string $path, string $_d074d7b344040d95fcad55b4694d9fec) : void
    {
        try {
            $this->flysystem->rename($path, $_d074d7b344040d95fcad55b4694d9fec);
        } catch (Flysystem\FileExistsException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileExistsException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        } catch (Exception $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    
    
    
    
    
    
    
    
    
    public function RenameDir(string $path, string $_d074d7b344040d95fcad55b4694d9fec) : void
    {
        $path = $GLOBALS["__1d130a090d3a1ad900ac34d1" . "2317f62a"]["_c91b0ff19f81a8873a4593a2371" . "9472c"]($path, $GLOBALS["__1d130a090d3a1ad9" . "00ac34d12317f62a"]["_8aa39710a39f226efc" . "e78e97c7bcd786"]);
        $_d074d7b344040d95fcad55b4694d9fec = $GLOBALS["__1d130a090d3a1ad900ac34d123" . "17f62a"]["_c91b0ff19f81a8" . "873a4593a237194" . "72c"]($_d074d7b344040d95fcad55b4694d9fec, $GLOBALS["__1d130a090d3a1ad900ac34d" . "12317f62a"]["_8aa39710a39f226efce78e97c7bcd7" . "86"]);
        $_414bd78c344503f4d9a81c17a1e0b473 = $this->ListDirs($path);
        $_00f2055c7cbd408ef56949f35c62b721 = $this->ListFiles($path);
        foreach ($_414bd78c344503f4d9a81c17a1e0b473 as $_c4f3321d131869e51a8844b6bcd8fb86) {
            $this->RenameDir($path . $GLOBALS["__1d130a090d3a1ad900ac34d12317" . "f62a"]["_87daa84e346f6420a3f3426e05" . "d16a7b"] . $_c4f3321d131869e51a8844b6bcd8fb86, $_d074d7b344040d95fcad55b4694d9fec . $GLOBALS["__1d130a090d3a1ad900ac34d1" . "2317f62a"]["_87daa84e346f6420" . "a3f3426e05d16a7b"] . $_c4f3321d131869e51a8844b6bcd8fb86);
        }
        foreach ($_00f2055c7cbd408ef56949f35c62b721 as $_6ae3783b9ad544a6c31a979683fed870) {
            $this->RenameFile($path . $GLOBALS["__1d130a090d3a1a" . "d900ac34d12317f6" . "2a"]["_87daa84e346f6420a3f3426e05d" . "16a7b"] . $_6ae3783b9ad544a6c31a979683fed870, $_d074d7b344040d95fcad55b4694d9fec . $GLOBALS["__1d130a090" . "d3a1ad900ac" . "34d12317f62" . "a"]["_87daa84e346f" . "6420a3f3426e0" . "5d16a7b"] . $_6ae3783b9ad544a6c31a979683fed870);
        }
        
        
        $this->Delete($path);
    }
    
    
    
    
    public function Delete(string $path) : void
    {
        try {
            $_fd5a3a643834299cbdadfc3540ba0bcb = true;
            if ($this->IsDir($path)) {
                $_fd5a3a643834299cbdadfc3540ba0bcb = $this->flysystem->deleteDir($path);
            } else {
                $_fd5a3a643834299cbdadfc3540ba0bcb = $this->flysystem->delete($path);
            }
        } catch (Flysystem\FileNotFoundException|Flysystem\RootViolationException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            
            
            
        }
        if ($_fd5a3a643834299cbdadfc3540ba0bcb === false) {
            throw new FilesystemException($GLOBALS["__1d130a090d3a1ad900ac34" . "d12317f62a"]["_9463ea5f1a4c73607f2c69eeee2b6ed" . "e"]);
        }
    }
    
    
    
    
    
    
    
    
    protected function ListContentsOfType(string $type, string $path)
    {
        $_d34599daeb8cca374d3adb38b245839c = $this->flysystem->listContents($path, false);
        $_c00c0eb73f04b4a4ca0678ce86138b81 = [];
        foreach ($_d34599daeb8cca374d3adb38b245839c as $_6aead4bff5639b251aebcf8a630e43a7) {
            if ($_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__1d130a090d3a1ad900ac34d123" . "17f62a"]["t" . "y" . "p" . "e"]] === $type) {
                $_c00c0eb73f04b4a4ca0678ce86138b81[] = $_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__1d130a090" . "d3a1ad900ac" . "34d12317f62" . "a"]["_32b8fa1ca330a068" . "5321a379e5b9687d"]];
            }
        }
        return $_c00c0eb73f04b4a4ca0678ce86138b81;
    }
    
    
    
    
    public function ListContents(string $path) : array
    {
        $_d34599daeb8cca374d3adb38b245839c = $this->flysystem->listContents($path, false);
        $_c00c0eb73f04b4a4ca0678ce86138b81 = [];
        foreach ($_d34599daeb8cca374d3adb38b245839c as $_6aead4bff5639b251aebcf8a630e43a7) {
            $_c00c0eb73f04b4a4ca0678ce86138b81[] = $_6aead4bff5639b251aebcf8a630e43a7[$GLOBALS["__1d130a090d3a1ad900ac34d1231" . "7f62a"]["_32b8fa1ca330a0685321a3" . "79e5b9687d"]];
        }
        return $_c00c0eb73f04b4a4ca0678ce86138b81;
    }
    public function ListContentsInfo(string $path) : array
    {
        $_6aead4bff5639b251aebcf8a630e43a7 = $this->flysystem->listContents($path, false);
        foreach ($_6aead4bff5639b251aebcf8a630e43a7 as &$_8043af106ba13a0ca9b53aa5c2df0e85) {
            unset($_8043af106ba13a0ca9b53aa5c2df0e85[$GLOBALS["__1d130a090d3a1ad900ac3" . "4d12317f62a"]["_554a9169138" . "240019acbd15" . "02642f16a"]]);
            unset($_8043af106ba13a0ca9b53aa5c2df0e85[$GLOBALS["__1d130a090d3a1ad900a" . "c34d12317f62a"]["pa" . "th"]]);
        }
        return $_6aead4bff5639b251aebcf8a630e43a7;
    }
    
    
    
    
    public function ListContentsRecursive(string $path) : array
    {
        return $this->flysystem->listContents($path, true);
    }
    
    
    
    
    public function ListFiles(string $path) : array
    {
        return $this->ListContentsOfType($GLOBALS["__1d130a090d3a1ad" . "900ac34d12317f62a"]["_6ae3783b9ad544a6c" . "31a979683fed870"], $path);
    }
    
    
    
    
    public function ListDirs(string $path) : array
    {
        return $this->ListContentsOfType($GLOBALS["__1d130a090d3a1ad900ac34d1" . "2317f62a"]["_c4f3321d13186" . "9e51a8844b6bcd" . "8fb86"], $path);
    }
    
    
    
    
    public function GetMetadata(string $path) : array
    {
        try {
            $_97ea09a7faf27c52c6eff69773df1d8a = $this->flysystem->getTimestamp($path);
            $size = $this->flysystem->getSize($path);
            $_9905761f4393d105cadfe7282a8c518d = $this->flysystem->getMimetype($path);
            $_e46a1b6a2fd927d616377ae17620d766 = $this->flysystem->getVisibility($path);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
        return [$GLOBALS["__1d130a090d3a1ad900a" . "c34d12317f62a"]["s" . "i" . "z" . "e"] => $size, $GLOBALS["__1d130a090d3a1ad900a" . "c34d12317f62a"]["_9905761f4393d105cadfe72" . "82a8c518d"] => $_9905761f4393d105cadfe7282a8c518d, $GLOBALS["__1d130a090d3a1ad900ac" . "34d12317f62a"]["_18c93a3" . "2ba5faf9" . "509389a9" . "4787e679" . "8"] => $_97ea09a7faf27c52c6eff69773df1d8a, $GLOBALS["__1d130a090d3a1ad900ac34d12317f" . "62a"]["_e46a1b6a" . "2fd927d61" . "6377ae176" . "20d766"] => $_e46a1b6a2fd927d616377ae17620d766];
    }
    
    
    
    
    public function Exists(string $path) : bool
    {
        return $this->flysystem->has($path) && !$this->IsDir($path);
    }
    
    
    
    
    public function IsDir(string $path) : bool
    {
        if (!$this->flysystem->has($path)) {
            return false;
        }
        try {
            $_b255ebafd5b8bb45110cd2db0604fa44 = $this->flysystem->getMetadata($path);
            $type = $_b255ebafd5b8bb45110cd2db0604fa44[$GLOBALS["__1d130a090d3a1ad900ac34d12317f6" . "2a"]["ty" . "pe"]] ?? null;
            return $type === $GLOBALS["__1d130a090d3a1ad900ac34" . "d12317f62a"]["_c4f3321d131869e5" . "1a8844b6bcd8fb86"];
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            return false;
        }
    }
    
    
    
    
    public function GetLocalPath(string $path) : string
    {
        try {
            
            
            
            
            
            
            return $this->flysystem->getLocalPath($path);
        } catch (BadMethodCallException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function GetUrl(string $path) : ?string
    {
        try {
            
            
            
            
            
            
            return $this->flysystem->getUrl($path);
        } catch (BadMethodCallException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    public function GetUsedSpace() : string
    {
        try {
            
            
            
            
            
            
            return $this->flysystem->getUsedSpace();
        } catch (BadMethodCallException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FilesystemException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    
    
    public function addPlugin(Flysystem\PluginInterface $_38198dbb7190fed0f875632ecef1ac6f)
    {
        $this->flysystem->addPlugin($_38198dbb7190fed0f875632ecef1ac6f);
    }
    
    
    
    
    public function RegisterProtocol(string $_21f5dd11309da4af2e51660e6f110a91) : void
    {
        StreamWrapper::register($_21f5dd11309da4af2e51660e6f110a91, $this->flysystem);
    }
    
    
    
    
    public function SetVisibility(string $path, string $_e46a1b6a2fd927d616377ae17620d766) : void
    {
        try {
            $this->flysystem->setVisibility($path, $_e46a1b6a2fd927d616377ae17620d766);
        } catch (Flysystem\FileNotFoundException $_fe441aa3ef350bfb1a1a1ad8520dd530) {
            throw new FileNotFoundException($_fe441aa3ef350bfb1a1a1ad8520dd530->getMessage(), $_fe441aa3ef350bfb1a1a1ad8520dd530->getCode(), $_fe441aa3ef350bfb1a1a1ad8520dd530);
        }
    }
    
    
    
    
    
    
    
    
    protected function CloseStream($_1cc5aa2f679b575f82786a73f0da28f8) : void
    {
        if ($GLOBALS["__1d130a090" . "d3a1ad900ac" . "34d12317f62" . "a"]["_5febae03aa" . "5407c291b5c" . "61a872cc1fd"]($_1cc5aa2f679b575f82786a73f0da28f8) && $GLOBALS["__1d130a090d3a1ad" . "900ac34d12317f62a"]["_f2646618c9dca" . "d156a41241eacc" . "4c3f7"]($_1cc5aa2f679b575f82786a73f0da28f8) === $GLOBALS["__1d130a090d3a1ad900ac34d123" . "17f62a"]["_1cc5aa2f679b575f82786a73f0d" . "a28f8"]) {
            $GLOBALS["__1d130a090d3a1" . "ad900ac34d12317" . "f62a"]["_563b15b92a77c" . "869e85edf9569b" . "4d025"]($_1cc5aa2f679b575f82786a73f0da28f8);
        }
    }
}