define(
    [
        'custom-protocol-detection',
        'platform',
        'jquery'
    ],
    function (protocolCheck, platform, $) {

        return function() {
            this.appDownloadBaseUrl = 'https://apps.claromentis.net/checkout/';

            this.getCheckoutUri = function(data){
                var documentId = data.doc_id;
                var parentId = data.parent_id;
                var documentName = data.doc_name;
                var chooseEditor = data.choose_editor;
                var clasid = data.clasid;
                var cookies = 'PHPSESSID=' + clasid + ';';

                return 'claromentis:&action=Edit&documentId=' + encodeURIComponent(documentId)
                    + '&parentId=' + encodeURIComponent(parentId)
                    + '&documentName=' + encodeURIComponent(documentName)
                    + (chooseEditor ? ('&chooseEditor=' + chooseEditor) : '')
                    + '&baseUrl=' + encodeURIComponent(window.location.origin)
                    + '&cookies=' + encodeURIComponent(cookies);
            };

            this.init = function(element_id, document_params) {
                var element = $(element_id);
                var self = this;
                element.on('click', function (e) {
                    var uri = self.getCheckoutUri(document_params);
                    protocolCheck(uri,
                        function (q) {
                            // protocol was not found, offer download
                            if (!confirm(lmsg('documents.util.errors.install_util')))
                                return;
                            var os = platform.os.family + ' ' + platform.os.version;
                            var downloadUrl;
                            if (os.match(/windows/i))
                                downloadUrl = 'ClaromentisCheckOutUtility.Setup.exe';
                            else if (platform.os.family === 'OS X')
                                downloadUrl = 'ClaromentisCheckOutUtility.pkg';
                            else {
                                alert(lmsg('documents.util.errors.os_unsupported'));
                                return;
                            }
                            downloadUrl = self.appDownloadBaseUrl + downloadUrl;
                            document.location = downloadUrl;
                        },
                        function (q) {
                            // protocol was found, open the checkout utility
                            window.location = uri;
                        }
                    );
                    e.preventDefault ? e.preventDefault() : e.returnValue = false;
                });
             };
        };
    }
);
