jQuery(function ($) {


  var didScroll = false,
      lastScrollTop = 0,
      delta = 5
      navbarHeight = $('.claro-navbar').outerHeight();

	// show/hide menu animation on scroll
	$(window).scroll(didWindowScroll);

	function didWindowScroll() {
		didScroll = true;
	}


	setInterval(function() {

	  if ( didScroll ) {
	    hasScrolled();
	    didScroll = false;
	  }

	}, 250);


	function hasScrolled() {

	  var st = $(this).scrollTop();

	  // Make sure they scroll more than delta
	  if ( Math.abs(lastScrollTop - st) <= delta ){
	    return;
    }

    //collapse progressive menu
    $('.head_nav .toggle').prop( "checked", false );
    $('.main_menu__link').text("More").removeClass('after');

    // If they scrolled down and are past the navbar, add class .hide-header.
    if (st > lastScrollTop && st > navbarHeight) {

    // scroll down
    $('body').removeClass('show-header').addClass('hide-header');
	  } else {

      // scroll up
	    if ( st + $(window).height() < $(document).height() ) {
	      $('body').removeClass('hide-header').addClass('show-header');
	    }
    }



    lastScrollTop = st;
  }


});
