document.pg_array = {};

pg_toggle_window = function(id, uniq_code){
	var div = jq_$(id);
	popup_wrap_window(div);
	//if (!div.hasClass('d-none'))
//		return div.addClass('d-none');

	document.pg_array[uniq_code] = {};
	jQuery(document.body).append(div);
//	pg_position_window(div, uniq_code);

	div.removeClass('d-none');
	pg_keyword_change(uniq_code);
//	if ($defined(jq_$('pg_keyword_'+uniq_code))) $('pg_keyword_'+uniq_code).focus();
};

pg_position_window = function(div, uniq_code){
	var el = jq_$('pg_button_' + uniq_code);
	var coord = el.offset();
	div.css({
		top: coord.top + el.height(),
		left: coord.left
	});
};

pg_keyword_change = function (uniq_code)
{
	if (document.pg_array[uniq_code].timer)
		clearTimeout(document.pg_array[uniq_code].timer);
	document.pg_array[uniq_code].timer = null;
	document.pg_array[uniq_code].timer = setTimeout(function() { pg_start_search(uniq_code); }, 300);
};

pg_start_search = function(uniq_code)
{
	if (document.pg_array[uniq_code].timer)
		clearTimeout(document.pg_array[uniq_code].timer);
	document.pg_array[uniq_code].timer = null;

	var select = jq_$('pg_select_'+uniq_code);
	select.empty().append('<option value="0">...LOADING...</option>');
//	pg_group_get_result.delay(10, this, [$('pg_keyword_'+this.uniq_code).value, this.uniq_code, $('pg_allowed_'+this.uniq_code).value, $('pg_not_allowed_'+this.uniq_code).value] );
	setTimeout(function() { pg_group_get_result(jq_$('pg_keyword_'+uniq_code).val(), uniq_code, jq_$('pg_allowed_'+uniq_code).val(), jq_$('pg_not_allowed_'+uniq_code).val()); }, 10);
};

pg_finish_search = function(group_arr, uniq_code){
	var select = jq_$('pg_select_'+uniq_code);
	select.empty();
	select.dblclick(function(e){pg_add(uniq_code);});

	jQuery(group_arr).each(function(idx, group){
		select.append(jQuery('<option value="'+group[0]+'">'+group[1]+'</option>'));
	});

	if (jQuery(group_arr).length < 1){
		select.append(jQuery('<option value="" disabled="disabled">...no results...</option>'));
	}
};

pg_add = function(uniq_code){
	var arr = [];
	jQuery('#pg_select_'+uniq_code+' option').each(function(idx, option){
		if (option.selected){
			arr.push({'id': option.value, 'name': option.innerHTML, 'can_edit': true});
		}
	});
	window[jq_$('pg_callback_'+uniq_code).val()](arr, uniq_code);
};

pg_add_all = function(uniq_code){
	var arr = [];
	jQuery('#pg_select_'+uniq_code+' option').each(function(idx, option){
		if (!option.disabled){
			arr.push({'id': option.value, 'name': option.innerHTML, 'can_edit': true});
		}
	});
	window[jq_$('pg_callback_'+uniq_code).val()](arr, uniq_code);
};

pg_group_add = function(arr, uniq_code, only_read) {
	jQuery(arr.reverse()).each(function (index, group){
		var el = document.getElementById(uniq_code);
		var group_ids = el.value;
		var arr = group_ids.split(",");
		if (arr && jQuery.inArray(group.id, arr) == -1) {
			if (el.value !== undefined) {
				if (!el.value)
					el.value = group.id;
				else
					el.value += "," + group.id;
			}

			var row = jq_$(uniq_code + '_template_row').clone();
			row.attr('id', uniq_code + "_" + group.id);

			jq_$(uniq_code + '_template_row').after(row);

			jQuery('td:first', row).text(group.name);

			if (!group.can_edit)
				$('.js-delete', row).hide();

			if (!only_read)
			{
				jQuery('.js-delete', row).click(function (e) {
					pg_group_remove(group.id,uniq_code,this);
					e.preventDefault();
				});
			}
			row.removeClass('d-none');
		}
	});
};

pg_group_remove = function(id,uniq_code,el) {
	var group_ids = document.getElementById(uniq_code).value;
	var arr = group_ids.split(",");
	var new_arr = new Array();
	for (i=0;i<arr.length;i++)
	{
	    if (arr[i] != id)
	    {
			new_arr.push(arr[i]);
	    }
	}
	document.getElementById(uniq_code).value = new_arr.toString();
	jq_$(uniq_code + "_" + id).remove();
};

pg_init = function (uniq_code, only_read) {
	if (typeof(only_read) === 'undefined') only_read = 0;
	if (document.getElementById(uniq_code + "_data"))
	{
		var g_arr = eval(document.getElementById(uniq_code + "_data").value);
		pg_group_add(g_arr, uniq_code, only_read);
	}
};
