require(['domReady','jquery'], function (domReady, $) {
  domReady(function(){
    $.fn.orderChildren = function(order) {
      this.each(function() {
        var el = $(this);
        for(var i = order.length; i >= 0; i--) {
          el.prepend(el.children(order[i]));
        }
      });
      return this;
    };

    function rearrangeNav() {
      if($(window).width() <= 767){
        $('#claroNav').orderChildren(['#head_searchbox', '.navbar-nav']);
        $('.navbar-nav')
        .orderChildren(['.nav-item-profile', '.nav-item-calendar', '.nav-item-company-links', '.nav-item-bookmarks', '.nav-item-applications', '.nav-item-whos-logged-in']);

      }
      else if ($(window).width() >= 767){

        $('#claroNav').orderChildren(['#head_searchbox', '.navbar-nav']);
        $('.navbar-nav')
        .orderChildren(['.nav-item-calendar', '.nav-item-company-links', '.nav-item-bookmarks', '.nav-item-applications',  '.nav-item-notifications', '.nav-item-whos-logged-in', '.nav-item-profile']);
      }
    }

    //remove transition on window resize
    $(window).resize(function(){
      $(".nav-toggle, .claro-nav-items").addClass('no-transition');
    })

    //restore transition after window resize
    $(window).resize(_.debounce(function(){
      $(".nav-toggle, .claro-nav-items").removeClass('no-transition');
    }, 1000));

    $(document).ready(function () {

      rearrangeNav();
      mobiletitles();
      desktopSidemenu();
      openSubs();


      var $window = $(window);
      var lastWindowWidth = $window.width();

      $window.resize(function () {
        var windowWidth = $window.width();
        if (lastWindowWidth !== windowWidth) {
          rearrangeNav();
          mobiletitles();
          desktopSidemenu();
          openSubs();
          lastWindowWidth = windowWidth;
        }
      });


      // Fix to stop tooltip sticking when navbar items are opened
      $('.navbar-nav .nav-item .nav-link').on('focus', function () {
          $(this).blur()
      });

      // Navbar navigation, notification and application menu buttons
      $(".nav-toggle, .mobile-notification .notification-toggle, .mobile-applications .application-toggle").click(function(){
        $("li").removeClass("open-mobile");
        $("html").toggleClass("no-scroll");
        $(".back-close").toggleClass("in");
      });

      // Opens navigation menu
      $(".nav-toggle").click(function(){
        $(".nav-toggle, .claro-nav-items").toggleClass("in");
        $(".mobile-applications, .mobile-notification").toggleClass("fade-out");
      });

      // Opens notifications
      $(".mobile-notification .notification-toggle").click(function(){
        $(".nav-toggle, .claro-nav-items").removeClass("in");
        $(".nav-toggle, .mobile-applications").toggleClass("fade-out");
        $("#notifications").toggleClass("show");
      });

      // Opens applications
      $(".mobile-applications .application-toggle").click(function(){
        $(".nav-toggle, .claro-nav-items").removeClass("in");
        $(".navbar-applications").toggleClass("show");
        $(".nav-toggle, .mobile-notification").toggleClass("fade-out");
      });

      // Opens sub menus
      function openSubs() {
        if($(window).width() <= 767){
          $( ".claro-nav-items > ul > li a, .claro-nav-items > .header-menu-container > .main_menu__inner > ul > li a" ).click(function() {
            $(this).parent("li").addClass( "open-mobile" );
          });
        }

      }

      // Adds top title li placeholder to sub menus
      $(".claro-nav-items ul ul").prepend($('<li class="submenu-header d-block d-md-none"><span class="submenu-header-back-button"></span><span class="submenu-header-link-wrap"></span></li>'));

      function mobiletitles() {

        if($(window).width() <= 767){
          $("li").removeClass("open-mobile");
          // Adds title of previously clicked item to submenu title
          var menu = $('.claro-nav-items ul');
          $('a', menu).on('click', function(){
            var menutitle = $(this).text();
            var menulink = $(this).attr('href');
            var menuappend = $(this).next('ul').children('li').first('.submenu-header').children('.submenu-header-link-wrap');

            menuappend.html('<a class="submenu-header-link" href="' + menulink + '"' + '>'  + menutitle + '</a>');

          });
          $('ul > li.has-sub > a').click(function (event) {
            event.preventDefault();
          });
        }
      }

      function desktopSidemenu() {

        if($(window).width() >= 767){
          if (! $('button').hasClass('desktop-toggle')){
            $(".desktop-sideview .header-menu-container li.has-sub, .header-menu-container ul.main_menu__list ul li.has-sub").prepend('<button class="desktop-toggle d-none d-md-block"></button>');
          }
        }
      }

      $('.desktop-sideview .header-menu-container li.has-sub > button, .header-menu-container ul.main_menu__list ul li.has-sub > button').on('click', function(){
        $(this).parent('.has-sub').toggleClass('open-mobile');
      });

      // Closes sub-menus individually
      $( ".submenu-header-back-button" ).click(function() {
        $(this).parent('.submenu-header').parent("ul").parent("li").removeClass("open-mobile");
      });




      // Back fade out
      $(".back-close").click(function(){
        $(".nav-toggle, .claro-nav-items, .back-close, #notifications, .navbar-applications").removeClass("in");
        $("li").removeClass("open-mobile");
        $(".nav-toggle, .notification-toggle, .navbar-applications").removeClass("fade-out");
        $("html").removeClass("no-scroll");
      });


    });

    $(".nav-toggle").click(function(){
      $(".head_nav").toggleClass("open");
    });

    $(".back-close").click(function(){

      $(".head_nav").removeClass("open");
    });

  });
});
