<?php
/**
 * This will contain the main configuration for the SimpleSAML library.
 *
 * As this library is installed by composer into vendor_core, and these files
 * must be contained within the library's config directory. We are creating
 * them here so they are in our respository, but instead of being used from here
 * they will instead be copied into the library's directory when a composer install
 * or update occurs.
 *
 * NOTE: if you're investigating a problem with SimpleSAML config
 */

// todo: this code is currently copied directly from the Loginhandler 2 custom module and needs updating

//use Monolog\Logger;


//include_once(__DIR__."/../config-templates/config.php"); // this is no longer needed, included in the simplesaml config file instead
include_once(__DIR__."/../../core/bootstrap.php");

global $g_application;
$app = $g_application;

$logger = $app->getLogger('sso');

{
	/**
	 * The line bellow allows the Login Handler to work behind a load balancer, using Redis, by setting Claromentis' session
	 * storage handler as SimpleSAML's so sessions can be shared between the two applications.Please, do not remove the
	 * warning suppressor from the call otherwise users will enter an infinite loop.
	 * For more info check this https://simplesamlphp.org/docs/stable/simplesamlphp-sp
	 */
	@session_set_save_handler($app['session.storage.handler'], false);
}

{
	/**
	 * This is a workaround the fact that PATH_INFO may not be set in IIS, which prevents the logins handler from working
	 */
	$WIN32 = (DIRECTORY_SEPARATOR == '\\');
	$IS_IIS = $WIN32 && stripos(@$_SERVER['SERVER_SOFTWARE'], 'Microsoft-IIS') !== false;
	if ($IS_IIS) {
		$request_uri = $_SERVER['REQUEST_URI'];
		$needle = '/simplesaml/module.php';
		if (strpos($_SERVER['PHP_SELF'], $needle) === 0) {
			$path_info = substr($_SERVER['PHP_SELF'], strlen($needle));
			if (strlen($path_info)) {
				$old_script_name = $_SERVER['SCRIPT_NAME'];
				$_SERVER['SCRIPT_NAME'] = $needle;
				$logger->debug("Changed \$_SERVER['SCRIPT_NAME'] from {$old_script_name} to {$needle}");
			}
		}
	}
}

/** @var \Claromentis\Core\Config\CombinedConfig $loginhandler_config */
$config_options = $app['loginhandler.config']->GetAll();
$settings = $config_options['simplesaml']['config'] ?? [];

$config['baseurlpath'] = $app['loginhandler.config']['baseurlpath'];
$config['tempdir'] = $app['loginhandler.config']['tempdir'];
$config['session.phpsession.cookiename'] = $app['loginhandler.config']['session_phpsession_cookiename'];

$config['metadata.sign.privatekey'] = $app['loginhandler.config']['saml_privatekey'];
$config['metadata.sign.certificate'] = $app['loginhandler.config']['saml_certificate'];

$config['certdir'] = $app['loginhandler.config']['certdir'];
$config['loggingdir'] = $app['loginhandler.config']['loggingdir'];
$config['datadir'] = $app['loginhandler.config']['datadir'];
$config['metadatadir'] = $app['loginhandler.config']['metadatadir'];

$config['admin.protectindexpage'] = $app['loginhandler.config']['admin_protectindexpage'];
$config['admin.protectmetadata'] = $app['loginhandler.config']['admin_protectmetadata'];

$config['session.cookie.samesite'] = $app['loginhandler.config']['session_cookie_samesite'];

$configurable_variables = [
	'technicalcontact_name',
	'technicalcontact_email',
	'secretsalt',
	'auth.adminpassword',
];

foreach ($configurable_variables as $variable) {
	if (isset($settings[$variable]) && strlen($settings[$variable])) {
		$config[$variable] = $settings[$variable];
	}
	else {
		$logger->error("simplesaml/config.php: Config variable {$variable} not set.");
	}
}

if (Psr\Log\LogLevel::DEBUG == $app['loginhandler.config']['cfg_log_level']) {
	$config['logging.level'] = SimpleSAML\Logger::DEBUG;
	$config['logging.handler'] = 'file';
}

//$logger->debug(json_encode($config, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
//print(json_encode($config, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));
